/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views.problemview;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.open.AbstractOpenHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private static Logger log = LoggerFactory.getLogger(JBMarkerResolutionGenerator.class);

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            Object reasonInt = marker.getAttribute("jbReason");
            if (!(reasonInt instanceof Integer) || reasonInt == null) {
                return new IMarkerResolution[0];
            }
            ProblemType type = ProblemType.values()[(Integer)reasonInt];
            String objectName = (String)marker.getAttribute("jbObjectName");
            String nodeGUID = (String)marker.getAttribute("jbNodeGUID");
            return this.getResolutions(type, objectName, nodeGUID);
        }
        catch (CoreException ce) {
            log.info(Messages.ErrorOccurredWhileFindingResolutionsForProblemMarker, (Throwable)ce);
            return new IMarkerResolution[0];
        }
    }

    private IMarkerResolution[] getResolutions(ProblemType type, String objectName, String nodeGUID) {
        switch (type) {
            case REASON_NO_COMPTYPE: 
            case REASON_DEPRECATED_ACTION: 
            case REASON_DEPRECATED_COMP: 
            case REASON_EMPTY_TESTSUITE: 
            case REASON_TD_INCOMPLETE: 
            case REASON_MISSING_SPEC_TC: 
            case REASON_UNUSED_TESTDATA: {
                return this.getOpenNodeInEditorResolutions(objectName, nodeGUID);
            }
            case REASON_NO_AUT_FOR_PROJECT_EXISTS: 
            case REASON_NO_AUTCONFIG_FOR_SERVER_EXIST: 
            case REASON_NO_JAR_FOR_AUTCONFIG: 
            case REASON_NO_SERVER_FOR_AUTCONFIG: {
                return this.getNoAUTResolutions();
            }
            case REASON_NO_TESTSUITE: {
                return this.getNoTestSuiteResolutions();
            }
            case REASON_OM_INCOMPLETE: {
                return this.getOMIncompleteResolutions(objectName);
            }
            case REASON_NO_SERVER_DEFINED: {
                return this.getNoServerDefinedResolutions();
            }
            case REASON_PROJECT_DOES_NOT_EXIST: {
                return this.getMissingProjectResolutions();
            }
        }
        return new IMarkerResolution[0];
    }

    private IMarkerResolution[] getMissingProjectResolutions() {
        return new IMarkerResolution[]{new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewOpenReusedProjectSettings;
            }

            public void run(IMarker marker) {
                Command projectPropertiesCommand = CommandHelper.getCommandService().getCommand("org.eclipse.jubula.client.ui.rcp.commands.ProjectProperties");
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("org.eclipse.jubula.client.ui.rcp.commands.ProjectProperties.parameter.sectionToOpen", "org.eclipse.jubula.client.ui.projectProperties.ReusedProjectPropertyPage");
                CommandHelper.executeParameterizedCommand((ParameterizedCommand)ParameterizedCommand.generateCommand((Command)projectPropertiesCommand, parameters));
            }
        }};
    }

    private IMarkerResolution[] getNoAUTResolutions() {
        return new IMarkerResolution[]{new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewOpenAutSettings;
            }

            public void run(IMarker marker) {
                Command projectPropertiesCommand = CommandHelper.getCommandService().getCommand("org.eclipse.jubula.client.ui.rcp.commands.ProjectProperties");
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("org.eclipse.jubula.client.ui.rcp.commands.ProjectProperties.parameter.sectionToOpen", "org.eclipse.jubula.client.ui.projectProperties.AUTPropertyPage");
                CommandHelper.executeParameterizedCommand((ParameterizedCommand)ParameterizedCommand.generateCommand((Command)projectPropertiesCommand, parameters));
            }
        }};
    }

    private IMarkerResolution[] getNoServerDefinedResolutions() {
        return new IMarkerResolution[]{new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewOpenAutStarterPreferences;
            }

            public void run(IMarker marker) {
                PreferenceManager pm = Plugin.getDefault().getWorkbench().getPreferenceManager();
                for (Object obj : pm.getElements(0)) {
                    PreferenceNode node = (PreferenceNode)obj;
                    if (!node.getId().equals("org.eclipse.jubula.client.ui.rcp.preferences.AutAgentPrefPage")) continue;
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.jubula.client.ui.rcp.preferences.AutAgentPrefPage", null, null);
                    DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
                    dialog.open();
                    break;
                }
            }
        }};
    }

    private IMarkerResolution[] getOMIncompleteResolutions(String nodeName) {
        return new IMarkerResolution[]{new OpenOMEditorMarkerResolution(nodeName)};
    }

    private IMarkerResolution[] getOpenNodeInEditorResolutions(String nodeName, String nodeGUID) {
        return new IMarkerResolution[]{new OpenNodeInEditorMarkerResolution(nodeName, nodeGUID)};
    }

    private IMarkerResolution[] getNoTestSuiteResolutions() {
        return new IMarkerResolution[]{new IMarkerResolution(){

            public String getLabel() {
                return Messages.GDProblemViewCreateTestSuite;
            }

            public void run(IMarker marker) {
                CommandHelper.executeCommand((String)"org.eclipse.jubula.client.ui.rcp.commands.NewTestSuiteCommand");
            }
        }};
    }

    private static class OpenNodeInEditorMarkerResolution
    implements IMarkerResolution {
        private String m_nodeName;
        private String m_nodeGUID;

        public OpenNodeInEditorMarkerResolution(String nodeName, String nodeGUID) {
            this.m_nodeName = nodeName;
            this.m_nodeGUID = nodeGUID;
        }

        public String getLabel() {
            return NLS.bind((String)Messages.GDProblemViewOpenEditor, (Object)this.m_nodeName);
        }

        public void run(IMarker marker) {
            INodePO node = NodePM.getNode((Long)GeneralStorage.getInstance().getProject().getId(), (String)this.m_nodeGUID);
            if (node != null) {
                while (!NodeBP.isEditable((IPersistentObject)node) || !(node instanceof ITestSuitePO) && !(node instanceof ITestJobPO) && !(node instanceof ISpecTestCasePO)) {
                    node = node.getParentNode();
                }
                AbstractOpenHandler.openEditor((IPersistentObject)node);
            }
        }
    }

    private static class OpenOMEditorMarkerResolution
    implements IMarkerResolution {
        private String m_autName;

        public OpenOMEditorMarkerResolution(String autName) {
            this.m_autName = autName;
        }

        public String getLabel() {
            return NLS.bind((String)Messages.GDProblemViewOpenObjectMappingEditor, (Object)this.m_autName);
        }

        public void run(IMarker marker) {
            List tsList = TestSuiteBP.getListOfTestSuites();
            for (ITestSuitePO ts : tsList) {
                if (!ts.getAut().getName().equals(this.m_autName)) continue;
                ObjectMappingMultiPageEditor editor = (ObjectMappingMultiPageEditor)AbstractOpenHandler.openEditor((IPersistentObject)ts.getAut());
                editor.getSite().getPage().activate((IWorkbenchPart)editor);
                break;
            }
        }
    }
}

