/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.communication.parser;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.MessageHeader;
import org.eclipse.jubula.tools.exception.SerialisationException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.serialisation.IXmlSerializer;

public class MessageSerializer {
    private IXmlSerializer m_serializer = IXmlSerializer.Factory.create();

    private void checkParseParameters(MessageHeader header, String message) throws IllegalArgumentException {
        Validate.notNull((Object)header, (String)"header must not be null");
        Validate.notNull((Object)message, (String)"message must not be null");
        Validate.notNull((Object)header.getMessageClassName(), (String)"given header contains no class information");
    }

    public String serialize(Message message) throws SerialisationException {
        Validate.notNull((Object)message, (String)"message must not be null");
        return this.m_serializer.serialize((Object)message, true);
    }

    public Message deserialize(MessageHeader header, String message) throws SerialisationException {
        this.checkParseParameters(header, message);
        try {
            Class<?> messageClass = Class.forName(header.getMessageClassName());
            return (Message)this.m_serializer.deserialize(message, messageClass);
        }
        catch (ClassCastException cce) {
            throw new SerialisationException(cce.getMessage(), MessageIDs.E_SERILIZATION_FAILED);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SerialisationException(cnfe.getMessage(), MessageIDs.E_SERILIZATION_FAILED);
        }
    }
}

