/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderByClause
extends AbstractExpression {
    private boolean hasSpaceAfterOrderBy;
    private AbstractExpression orderByItems;

    OrderByClause(AbstractExpression parent) {
        super(parent, "ORDER BY");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getOrderByItems().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getOrderByItems());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression("ORDER BY"));
        if (this.hasSpaceAfterOrderBy) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.orderByItems != null) {
            children.add(this.orderByItems);
        }
    }

    public CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getOrderByItems());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, spaces, commas, true);
    }

    public Expression getOrderByItems() {
        if (this.orderByItems == null) {
            this.orderByItems = this.buildNullExpression();
        }
        return this.orderByItems;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return OrderByClause.queryBNF("orderby_clause");
    }

    public boolean hasOrderByItems() {
        return this.orderByItems != null && !this.orderByItems.isNull();
    }

    public boolean hasSpaceAfterOrderBy() {
        return this.hasSpaceAfterOrderBy;
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward("ORDER BY");
        this.hasSpaceAfterOrderBy = wordParser.skipLeadingWhitespace() > 0;
        this.orderByItems = this.parse(wordParser, (JPQLQueryBNF)OrderByClause.queryBNF("orderby_item"), tolerant);
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append("ORDER BY");
        if (this.hasSpaceAfterOrderBy) {
            writer.append(' ');
        }
        if (this.orderByItems != null) {
            this.orderByItems.toParsedText(writer, includeVirtual);
        }
    }
}

