/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.eclipse.jubula.client.core.businessprocess.GuidNameCache;
import org.eclipse.jubula.client.core.businessprocess.INameMapper;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITcParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamNameBPDecorator
extends GuidNameCache<IParamNamePO>
implements IParamNameMapper,
INameMapper {
    private static Logger log = LoggerFactory.getLogger(ParamNameBPDecorator.class);
    private IParamNameMapper m_paramNameBP = null;
    private Set<ITcParamDescriptionPO> m_paramDescriptions = new HashSet<ITcParamDescriptionPO>();
    private List<ITestDataPO> m_testDataToUpdate = new ArrayList<ITestDataPO>();

    public ParamNameBPDecorator(IParamNameMapper paramNameBP) {
        this.m_paramNameBP = paramNameBP;
    }

    public ParamNameBPDecorator(IParamNameMapper paramNameBP, IPersistentObject obj) {
        this(paramNameBP);
        if (obj instanceof ISpecTestCasePO) {
            ISpecTestCasePO specTc = (ISpecTestCasePO)obj;
            this.cacheParamNames(specTc);
        }
    }

    private void cacheParamNames(ISpecTestCasePO specTc) {
        List<IParamDescriptionPO> descs = specTc.getParameterList();
        for (IParamDescriptionPO desc : descs) {
            String name = this.m_paramNameBP.getName(desc.getUniqueId(), specTc.getParentProjectId());
            this.addNameToCache(desc.getUniqueId(), name);
        }
    }

    @Override
    public String getName(String guid, Long rootProjId) {
        String name = "";
        name = super.getName(guid) != null ? super.getName(guid) : this.m_paramNameBP.getName(guid, rootProjId);
        return name;
    }

    @Override
    public void addParamNamePO(IParamNamePO namePO) {
        this.addNameToInsert(namePO);
    }

    public void addTestDataPO(ITestDataPO testData) {
        this.m_testDataToUpdate.add(testData);
    }

    @Override
    public void persist(EntityManager s, Long rootProjId) throws PMException {
        this.saveParamNames(s, rootProjId);
    }

    private void updateStandardMapper(Long rootProjId) {
        for (IParamNamePO paramName : this.getNamesToInsert()) {
            ParamNameBP.getInstance().addParamNamePO(paramName);
        }
        List<String> guids = this.getNameGuidsToUpdate();
        EntityManager s = GeneralStorage.getInstance().getMasterSession();
        if (!guids.isEmpty()) {
            Query q = s.createQuery("select p from ParamNamePO as p where p.parentProjectId = :projId AND p.hbmGuid in :guidList");
            q.setParameter("projId", (Object)rootProjId);
            q.setParameter("guidList", guids);
            List paramNames = q.getResultList();
            for (IParamNamePO paramName : paramNames) {
                s.refresh((Object)paramName);
                ParamNameBP.getInstance().addParamNamePO(paramName);
            }
        }
        for (String guid : this.getNameGuidsToDelete()) {
            ParamNameBP.getInstance().removeParamNamePO(guid);
        }
    }

    private synchronized void saveParamNames(EntityManager s, Long rootProjId) throws PMSaveException {
        Query q;
        for (IParamNamePO paramName : this.getNamesToInsert()) {
            paramName.setParentProjectId(rootProjId);
            try {
                s.persist((Object)paramName);
            }
            catch (PersistenceException e) {
                StringBuilder msgbuid = new StringBuilder();
                msgbuid.append(Messages.CouldNotSaveParameter);
                msgbuid.append(" ");
                msgbuid.append(paramName.getName());
                msgbuid.append(" ");
                msgbuid.append(Messages.AndGUID);
                msgbuid.append(" ");
                msgbuid.append(paramName.getGuid());
                msgbuid.append(".");
                String msg = msgbuid.toString();
                log.error(msg, (Throwable)e);
                throw new PMSaveException(msg, MessageIDs.E_DB_SAVE);
            }
        }
        for (ITestDataPO testData : this.m_testDataToUpdate) {
            testData.setParentProjectId(rootProjId);
            try {
                s.merge((Object)testData);
            }
            catch (PersistenceException e) {
                StringBuilder msgbuid = new StringBuilder();
                msgbuid.append(Messages.CouldNotSaveParameter);
                msgbuid.append(" ");
                msgbuid.append(testData.getName());
                msgbuid.append(".");
                String msg = msgbuid.toString();
                log.error(msg, (Throwable)e);
                throw new PMSaveException(msg, MessageIDs.E_DB_SAVE);
            }
        }
        List<String> guids = this.getNameGuidsToUpdate();
        if (!guids.isEmpty()) {
            q = s.createQuery("select p from ParamNamePO as p where p.hbmGuid in :guidList AND p.parentProjectId = :projId");
            q.setParameter("guidList", guids);
            q.setParameter("projId", (Object)rootProjId);
            List paramNames = q.getResultList();
            for (IParamNamePO paramName : paramNames) {
                String name = this.getNameToUpdate(paramName.getGuid());
                if (name == null) continue;
                paramName.setName(name);
            }
        }
        try {
            if (!this.getNameGuidsToDelete().isEmpty()) {
                q = s.createQuery("delete from ParamNamePO p where p.hbmGuid in :guidList AND p.parentProjectId = :projId");
                q.setParameter("guidList", this.getNameGuidsToDelete());
                q.setParameter("projId", (Object)rootProjId);
                q.executeUpdate();
            }
        }
        catch (PersistenceException e) {
            String msg = String.valueOf(Messages.CouldNotDeleteAllParameters) + ".";
            log.error(msg, (Throwable)e);
            throw new PMSaveException(msg, MessageIDs.E_DB_SAVE);
        }
        this.updateLocalCache();
    }

    public void registerParamDescriptions(ITcParamDescriptionPO desc) {
        this.m_paramDescriptions.add(desc);
    }

    private void deregisterAllParamDescriptions() {
        for (ITcParamDescriptionPO desc : this.m_paramDescriptions) {
            desc.setParamNameMapper(ParamNameBP.getInstance());
        }
        this.m_paramDescriptions.clear();
    }

    @Override
    public void removeParamNamePO(String guid) {
        this.removeNamePO(guid);
    }

    @Override
    public void updateStandardMapperAndCleanup(Long rootProjId) {
        this.updateStandardMapper(rootProjId);
        this.deregisterAllParamDescriptions();
        this.clearAllNames();
    }
}

