/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.html;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.State;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.communication.BaseConnection;
import org.eclipse.jubula.client.ui.rcp.utils.HTMLAutWindowManager;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.html.OMSelectWindowMessage;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMChooseWindow
extends AbstractHandler
implements IElementUpdater {
    private static final String WINDOW_TITLE_PARAMETER = "org.eclipse.jubula.client.ui.rcp.commands.html.ChooseAuTWindow.parameter.openWindow";
    private static final String LAST_SELECTED_WINDOW = "org.eclipse.jubula.client.ui.rcp.commands.html.ChooseAuTWindow.state.lastSelectedWindow";
    private static final Logger LOG = LoggerFactory.getLogger(OMChooseWindow.class);

    public Object execute(ExecutionEvent event) {
        block6: {
            State lastSelectedWindowState = event.getCommand().getState(LAST_SELECTED_WINDOW);
            Map map = event.getParameters();
            String name = (String)map.get(WINDOW_TITLE_PARAMETER);
            if (lastSelectedWindowState != null && name == null) {
                name = (String)lastSelectedWindowState.getValue();
            }
            lastSelectedWindowState.setValue((Object)name);
            HTMLAutWindowManager.getInstance().setLastSelectedWindow(name);
            OMSelectWindowMessage message = new OMSelectWindowMessage();
            message.setWindowTitle(name);
            try {
                if (name != null) {
                    AUTConnection.getInstance().send((Message)message);
                }
            }
            catch (BaseConnection.NotConnectedException nce) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(nce.getLocalizedMessage(), (Throwable)nce);
                }
            }
            catch (CommunicationException ce) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error(ce.getLocalizedMessage(), (Throwable)ce);
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        String name = (String)parameters.get(WINDOW_TITLE_PARAMETER);
        String lastTitle = HTMLAutWindowManager.getInstance().getLastSelectedWindow();
        boolean checked = false;
        if (name != null && lastTitle != null && name.equals(lastTitle)) {
            checked = true;
        }
        element.setChecked(checked);
    }
}

