/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.registration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.registration.IRegisterAut;
import org.eclipse.jubula.tools.exception.JBVersionException;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.jubula.tools.utils.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentRegisterAut
implements IRegisterAut {
    private static final Logger LOG;
    private InetSocketAddress m_agentAddr;
    private AutIdentifier m_autIdentifier;
    private Socket m_agentConn;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.common.registration.AgentRegisterAut");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LoggerFactory.getLogger((Class)clazz);
    }

    public AgentRegisterAut(InetSocketAddress agentAddr, AutIdentifier autIdentifier) {
        this.m_agentAddr = agentAddr;
        this.m_autIdentifier = autIdentifier;
        this.m_agentConn = null;
    }

    public void register() throws IOException, JBVersionException {
        if (LOG.isInfoEnabled()) {
            LOG.info("Registering AUT '" + this.m_autIdentifier.getExecutableName() + "' with agent at " + this.m_agentAddr.getHostName() + ":" + this.m_agentAddr.getPort());
        }
        this.m_agentConn = new Socket(this.m_agentAddr.getAddress(), this.m_agentAddr.getPort());
        long waitForServer = 10000L;
        long waitTime = 0L;
        boolean success = false;
        InputStream inputStream = this.m_agentConn.getInputStream();
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream));
        PrintStream outputStream = new PrintStream(this.m_agentConn.getOutputStream());
        while (!success && waitTime <= waitForServer) {
            if (inputStream.available() > 0) {
                String line = inputReader.readLine();
                if (line != null) {
                    line = line.substring(0, line.indexOf("/"));
                }
                success = true;
                if ("ClientTypeRequest".equals(line)) {
                    outputStream.println("ClientType.Aut");
                    outputStream.flush();
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                StringBuffer errBuf = new StringBuffer();
                errBuf.append("Received invalid request from server. Expected '").append("ClientTypeRequest").append("' but received '").append(line).append("'.");
                LOG.warn(errBuf.toString());
                continue;
            }
            TimeUtil.delay((long)500L);
            waitTime += 500L;
        }
        outputStream.println(this.m_autIdentifier.encode());
        outputStream.flush();
        String communicatorHostName = inputReader.readLine();
        String communicatorPort = inputReader.readLine();
        try {
            AUTServer.getInstance().initAutAgentCommunicator(InetAddress.getByName(communicatorHostName), Integer.parseInt(communicatorPort));
        }
        catch (NumberFormatException nfe) {
            LOG.error("Error occurred while connecting to AUT Agent.", (Throwable)nfe);
        }
        catch (SecurityException se) {
            LOG.error("Error occurred while connecting to AUT Agent.", (Throwable)se);
        }
    }
}

