/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.commands.AbstractStartJavaAut;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.utils.MonitoringUtil;

public class StartRcpAutServerCommand
extends AbstractStartJavaAut {
    private static final String NL = "-nl";

    private void createDirectAutJavaCallParameter(String pathSeparator, List cmds, Map parameters) {
        StringBuffer autClassPath = new StringBuffer();
        String autClassPathValue = (String)parameters.get("CLASSPATH");
        if (autClassPathValue != null && !"".equals(autClassPathValue)) {
            autClassPath.append(this.convertClientSeparator(autClassPathValue));
        }
        if (autClassPath.length() > 0) {
            autClassPath.append(pathSeparator);
        }
        String autJar = (String)parameters.get("JAR_FILE");
        String manifestClassPath = this.getClassPathFromManifest(parameters);
        if (manifestClassPath.length() > 0) {
            autClassPath.append(manifestClassPath).append(pathSeparator);
        }
        if (autClassPath.toString() != null && !"".equals(autClassPath.toString())) {
            cmds.add("-classpath");
            cmds.add(autClassPath.toString());
        }
        cmds.add("-jar");
        cmds.add(autJar);
        String autArgs = (String)parameters.get("AUT_ARGUMENTS");
        if (autArgs != null) {
            StringTokenizer args = new StringTokenizer(autArgs, " ");
            while (args.hasMoreTokens()) {
                String arg = args.nextToken();
                cmds.add(arg);
            }
        }
    }

    private void createDirectAutExeCallParameter(List cmds, Map parameters) {
        String autArgs = (String)parameters.get("AUT_ARGUMENTS");
        if (autArgs != null) {
            StringTokenizer args = new StringTokenizer(autArgs, " ");
            while (args.hasMoreTokens()) {
                String arg = args.nextToken();
                cmds.add(arg);
            }
        }
    }

    private List createDirectAutJavaCall(Map parameters) {
        Vector<String> cmds = new Vector<String>();
        this.addLocale(cmds, (Locale)parameters.get("LOCALE"));
        String jreParams = (String)parameters.get("JRE_PARAMETER");
        if (jreParams != null && jreParams.length() > 0) {
            StringTokenizer tok = new StringTokenizer(jreParams, " ");
            while (tok.hasMoreTokens()) {
                cmds.add(tok.nextToken());
            }
        }
        this.addDebugParams(cmds, true);
        return cmds;
    }

    @Override
    protected String getServerClassName() {
        return "org.eclipse.jubula.rc.swt.SwtAUTServer";
    }

    @Override
    protected String[] createCmdArray(String baseCmd, Map parameters) {
        Vector<String> cmds;
        if (!this.isRunningFromExecutable(parameters)) {
            cmds = this.createDirectAutJavaCall(parameters);
            cmds.add(0, baseCmd);
            this.createDirectAutJavaCallParameter(PATH_SEPARATOR, cmds, parameters);
            this.addLocale(cmds, (Locale)parameters.get("LOCALE"));
        } else {
            Locale locale;
            cmds = new Vector<String>();
            cmds.add(0, baseCmd);
            this.createDirectAutExeCallParameter(cmds, parameters);
            if (!cmds.contains(NL) && (locale = (Locale)parameters.get("LOCALE")) != null && (locale.getCountry() != null && locale.getCountry().length() > 0 || locale.getLanguage() != null && locale.getLanguage().length() > 0)) {
                cmds.add(1, NL);
                cmds.add(2, locale.toString());
            }
            this.addDebugParams(cmds, true);
        }
        String[] cmdArray = cmds.toArray(new String[cmds.size()]);
        return cmdArray;
    }

    @Override
    protected String[] createEnvArray(Map parameters, boolean isAgentSet) {
        String monAgent;
        String[] envArray = super.createEnvArray(parameters, isAgentSet);
        if (envArray == null) {
            envArray = EnvironmentUtils.propToStrArray((Properties)EnvironmentUtils.getProcessEnvironment(), (String)"=");
        }
        Vector<String> envList = new Vector<String>(Arrays.asList(envArray));
        envList.addAll(this.getConnectionProperties(parameters, "", "="));
        if (MonitoringUtil.shouldAndCanRunWithMonitoring((Map)parameters) && (monAgent = this.getMonitoringAgent(parameters)) != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("_JAVA_OPTIONS=");
            sb.append(monAgent);
            envList.add(sb.toString());
            envArray = super.createEnvArray(parameters, true);
        }
        envArray = envList.toArray(new String[envList.size()]);
        return envArray;
    }

    private List<String> getConnectionProperties(Map parameters, String propPrefix, String valueSeparator) {
        ArrayList<String> props = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        if (AutStarter.getInstance().getAutCommunicator() != null) {
            sb = new StringBuffer();
            sb.append(propPrefix).append("gdlocalport").append(valueSeparator).append(String.valueOf(AutStarter.getInstance().getAutCommunicator().getLocalPort()));
            props.add(sb.toString());
        }
        sb = new StringBuffer();
        sb.append(propPrefix).append("GD_KEYBOARD_LAYOUT").append(valueSeparator).append((String)parameters.get("KEYBOARD_LAYOUT"));
        props.add(sb.toString());
        sb = new StringBuffer();
        sb.append(propPrefix).append("com.bredexsw.guidancer.aut.register.autAgentHost").append(valueSeparator).append((String)parameters.get("com.bredexsw.guidancer.aut.register.autAgentHost"));
        props.add(sb.toString());
        sb = new StringBuffer();
        sb.append(propPrefix).append("com.bredexsw.guidancer.aut.register.autAgentPort").append(valueSeparator).append((String)parameters.get("com.bredexsw.guidancer.aut.register.autAgentPort"));
        props.add(sb.toString());
        sb = new StringBuffer();
        sb.append(propPrefix).append("com.bredexsw.guidancer.aut.register.autName").append(valueSeparator).append((String)parameters.get("com.bredexsw.guidancer.aut.register.autName"));
        props.add(sb.toString());
        return props;
    }
}

