/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.core.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ALMAccess {
    private static final Logger LOG = LoggerFactory.getLogger(ALMAccess.class);

    private ALMAccess() {
    }

    private static TaskRepository getRepositoryByLabel(String repoLabel) {
        IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
        List allRepositories = repositoryManager.getAllRepositories();
        for (TaskRepository repo : allRepositories) {
            if (!repo.getRepositoryLabel().equals(repoLabel)) continue;
            return repo;
        }
        return null;
    }

    private static TaskData getTaskDataByID(TaskRepository repo, String taskId) throws CoreException {
        TaskData taskData = null;
        if (repo != null && !repo.isOffline()) {
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)repo.getConnectorKind());
            taskData = connector.getTaskData(repo, taskId, (IProgressMonitor)new NullProgressMonitor());
        }
        return taskData;
    }

    public static boolean createComment(String repoLabel, String taskId, String comment) {
        boolean succeeded = false;
        TaskRepository repo = ALMAccess.getRepositoryByLabel(repoLabel);
        try {
            TaskData taskData = ALMAccess.getTaskDataByID(repo, taskId);
            if (taskData != null) {
                AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)repo.getConnectorKind());
                AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
                TaskAttribute root = taskData.getRoot();
                TaskAttribute newComment = root.createMappedAttribute("task.common.comment.new");
                newComment.setValue(comment);
                RepositoryResponse response = taskDataHandler.postTaskData(repo, taskData, null, (IProgressMonitor)new NullProgressMonitor());
                succeeded = RepositoryResponse.ResponseKind.TASK_UPDATED.equals((Object)response.getReposonseKind());
            }
        }
        catch (CoreException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return succeeded;
    }

    public static String getTaskAttributeValue(String repoLabel, String taskId, String taskAttributeId) {
        String value = null;
        TaskRepository repo = ALMAccess.getRepositoryByLabel(repoLabel);
        try {
            TaskData taskData = ALMAccess.getTaskDataByID(repo, taskId);
            if (taskData != null) {
                TaskAttribute root = taskData.getRoot();
                TaskAttributeMapper attributeMapper = taskData.getAttributeMapper();
                TaskAttribute mappedAttribute = root.getMappedAttribute(taskAttributeId);
                if (mappedAttribute != null) {
                    value = attributeMapper.getValue(mappedAttribute);
                }
            }
        }
        catch (CoreException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return value;
    }

    public static boolean createNewTask(String repoLabel, String product, String summary, String description) {
        boolean succeeded = false;
        TaskRepository repo = ALMAccess.getRepositoryByLabel(repoLabel);
        AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)repo.getConnectorKind());
        AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
        if (taskDataHandler == null) {
            return succeeded;
        }
        TaskAttributeMapper attributeMapper = taskDataHandler.getAttributeMapper(repo);
        TaskData newTask = new TaskData(attributeMapper, repo.getConnectorKind(), repo.getRepositoryUrl(), "");
        ALMDefaultTaskMapping taskMapping = new ALMDefaultTaskMapping();
        try {
            TaskAttribute newTaskRoot = newTask.getRoot();
            TaskAttribute summaryAttribute = newTaskRoot.createMappedAttribute("task.common.summary");
            TaskAttribute descriptionAttribute = newTaskRoot.createMappedAttribute("task.common.description");
            newTaskRoot.createMappedAttribute("task.common.kind");
            newTaskRoot.createMappedAttribute("task.common.status");
            TaskAttribute productAttribute = newTaskRoot.createMappedAttribute("task.common.product");
            taskDataHandler.initializeTaskData(repo, newTask, (ITaskMapping)taskMapping, (IProgressMonitor)new NullProgressMonitor());
            attributeMapper.setValue(descriptionAttribute, description);
            attributeMapper.setValue(summaryAttribute, summary);
            attributeMapper.setValue(productAttribute, product);
            RepositoryResponse response = taskDataHandler.postTaskData(repo, newTask, null, (IProgressMonitor)new NullProgressMonitor());
            succeeded = RepositoryResponse.ResponseKind.TASK_CREATED.equals((Object)response.getReposonseKind());
        }
        catch (CoreException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return succeeded;
    }

    public static class ALMDefaultTaskMapping
    extends TaskMapping {
        private Map<String, String> m_values = new HashMap<String, String>();

        public String getDescription() {
            return this.m_values.get("task.common.description");
        }

        public String getSummary() {
            return this.m_values.get("task.common.summary");
        }

        public String getProduct() {
            return this.m_values.get("task.common.product");
        }

        public String getTaskKind() {
            return this.m_values.get("task.common.kind");
        }
    }
}

