/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.EventListenerList;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jubula.client.core.AUTEvent;
import org.eclipse.jubula.client.core.AUTServerEvent;
import org.eclipse.jubula.client.core.AutAgentEvent;
import org.eclipse.jubula.client.core.IAUTEventListener;
import org.eclipse.jubula.client.core.IAUTServerEventListener;
import org.eclipse.jubula.client.core.IClientTest;
import org.eclipse.jubula.client.core.IServerEventListener;
import org.eclipse.jubula.client.core.UnknownMessageException;
import org.eclipse.jubula.client.core.businessprocess.AbstractXMLReportGenerator;
import org.eclipse.jubula.client.core.businessprocess.CompleteXMLReportGenerator;
import org.eclipse.jubula.client.core.businessprocess.ErrorsOnlyXMLReportGenerator;
import org.eclipse.jubula.client.core.businessprocess.FileXMLReportWriter;
import org.eclipse.jubula.client.core.businessprocess.ITestExecutionEventListener;
import org.eclipse.jubula.client.core.businessprocess.ITestresultSummaryEventListener;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.businessprocess.TestExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.TestResultBP;
import org.eclipse.jubula.client.core.businessprocess.TestresultSummaryBP;
import org.eclipse.jubula.client.core.commands.CAPRecordedCommand;
import org.eclipse.jubula.client.core.commands.DisconnectFromAutAgentResponseCommand;
import org.eclipse.jubula.client.core.commands.GetAutConfigMapResponseCommand;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.communication.AutAgentConnection;
import org.eclipse.jubula.client.core.communication.BaseConnection;
import org.eclipse.jubula.client.core.communication.ConnectionException;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.MonitoringReportPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.TestResult;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.TestResultPM;
import org.eclipse.jubula.client.core.persistence.TestResultSummaryPM;
import org.eclipse.jubula.communication.message.BuildMonitoringReportMessage;
import org.eclipse.jubula.communication.message.ChangeAUTModeMessage;
import org.eclipse.jubula.communication.message.DisconnectFromAutAgentMessage;
import org.eclipse.jubula.communication.message.GetAutConfigMapMessage;
import org.eclipse.jubula.communication.message.GetMonitoringDataMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.StartAUTServerMessage;
import org.eclipse.jubula.communication.message.StopAUTServerMessage;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.monitoring.MonitoringAttribute;
import org.eclipse.jubula.toolkit.common.monitoring.MonitoringRegistry;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.constants.MonitoringConstants;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.JBVersionException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.objects.IMonitoringValue;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.jubula.tools.utils.MonitoringUtil;
import org.eclipse.jubula.tools.utils.TimeUtil;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientTest
implements IClientTest {
    public static final int TEST_SUITE_EXECUTION_RELATIVE_WORK_AMOUNT = 1000;
    private static Logger log = LoggerFactory.getLogger(ClientTest.class);
    private static final String XML_FILE_EXT = ".xml";
    private static final String TEST_SUCCESSFUL = "ok";
    private static final String TEST_FAILED = "failed";
    private static final int BUILD_REPORT_TIMEOUT = 1200000;
    private static final int REQUEST_CONFIG_MAP_TIMEOUT = 10000;
    private static EventListenerList eventListenerList = new EventListenerList();
    private Date m_testsuiteStartTime = null;
    private Date m_testjobStartTime = null;
    private Date m_endTime = null;
    private String m_logStyle = null;
    private String m_logPath = null;
    private ITestResultSummaryPO m_summary;
    private boolean m_relevant = true;
    private boolean m_xmlScrennshot = true;
    private boolean m_pauseOnError = false;

    public ClientTest() {
        ComponentBuilder.getInstance().getCompSystem();
    }

    @Override
    public void connectToAutAgent(String serverName, String port) {
        try {
            if (!this.initServerConnection(serverName, port)) {
                this.fireAutAgentStateChanged(new AutAgentEvent(3));
                return;
            }
        }
        catch (JBVersionException jBVersionException) {
            this.fireAutAgentStateChanged(new AutAgentEvent(4));
        }
    }

    @Override
    public void disconnectFromAutAgent() {
        DisconnectFromAutAgentResponseCommand command = new DisconnectFromAutAgentResponseCommand();
        DisconnectFromAutAgentMessage message = new DisconnectFromAutAgentMessage();
        try {
            AutAgentConnection.getInstance().request((Message)message, command, 10000);
        }
        catch (BaseConnection.NotConnectedException e) {
            log.info(Messages.ClosingTheConnectionsFailed, (Throwable)((Object)e));
        }
        catch (CommunicationException e) {
            log.info(Messages.ClosingTheConnectionsFailed, (Throwable)e);
        }
    }

    @Override
    public void startAut(IAUTMainPO aut, IAUTConfigPO conf, Locale locale) throws ToolkitPluginException {
        String autToolkit = aut.getToolkit();
        if (!ComponentBuilder.getInstance().getLevelToolkitIds().contains(autToolkit) && "toolkit".equals(ToolkitSupportBP.getToolkitLevel((String)autToolkit))) {
            throw new ToolkitPluginException(Messages.ErrorMessageAUT_TOOLKIT_NOT_AVAILABLE);
        }
        try {
            Map<String, String> autConfigMap = this.createAutConfigMap(conf);
            StartAUTServerMessage startAUTServerMessage = new StartAUTServerMessage(InetAddress.getLocalHost().getCanonicalHostName(), AUTConnection.getInstance().getCommunicator().getLocalPort(), autConfigMap, autToolkit, aut.isGenerateNames());
            startAUTServerMessage.setLocale(locale);
            AutAgentConnection.getInstance().send((Message)startAUTServerMessage);
            if (log.isDebugEnabled()) {
                log.debug(Messages.StartAUTServerMessageSend);
            }
        }
        catch (BaseConnection.NotConnectedException nce) {
            log.info(nce.getLocalizedMessage(), (Throwable)((Object)nce));
        }
        catch (ConnectionException ce) {
            log.info(ce.getLocalizedMessage(), (Throwable)((Object)ce));
        }
        catch (CommunicationException cce) {
            log.error(cce.getLocalizedMessage(), (Throwable)cce);
            try {
                this.closeConnections();
            }
            catch (ConnectionException ce) {
                log.error(Messages.ClosingTheConnectionsFailed, (Throwable)((Object)ce));
            }
        }
        catch (UnknownHostException uhe) {
            log.error(uhe.getLocalizedMessage(), (Throwable)uhe);
            try {
                AUTConnection.getInstance().close();
                AutAgentConnection.getInstance().close();
            }
            catch (ConnectionException ce) {
                log.error(Messages.ClosingTheConnectionsFailed, (Throwable)((Object)ce));
            }
        }
    }

    private Map<String, String> createAutConfigMap(IAUTConfigPO autConfig) {
        IConfigurationElement monitoringExtension;
        Set<String> autConfigKeys = autConfig.getAutConfigKeys();
        HashMap<String, String> mapToSend = new HashMap<String, String>(autConfigKeys.size());
        for (String key : autConfigKeys) {
            String value = autConfig.getValue(key, null);
            mapToSend.put(key, value);
        }
        String monitoringID = (String)mapToSend.get("MONITORING_AGENT_ID");
        if (!StringUtils.isEmpty((String)monitoringID) && (monitoringExtension = MonitoringRegistry.getElement((String)monitoringID)) != null) {
            List attributeList = MonitoringRegistry.getAttributes((IConfigurationElement)monitoringExtension);
            for (MonitoringAttribute monitoringAttribute : attributeList) {
                if (monitoringAttribute.isRender()) continue;
                mapToSend.put(monitoringAttribute.getId(), monitoringAttribute.getDefaultValue());
            }
        }
        try {
            mapToSend.put("com.bredexsw.guidancer.aut.register.autAgentPort", String.valueOf(AutAgentConnection.getInstance().getCommunicator().getPort()));
            mapToSend.put("com.bredexsw.guidancer.aut.register.autAgentHost", AutAgentConnection.getInstance().getCommunicator().getHostName());
            mapToSend.put("com.bredexsw.guidancer.aut.register.autName", (String)mapToSend.get("AUT_ID"));
        }
        catch (ConnectionException connectionException) {
            log.error(Messages.UnableToAppendAUTAgent);
        }
        return mapToSend;
    }

    private void closeConnections() throws ConnectionException {
        AutAgentConnection.getInstance().close();
        AUTConnection.getInstance().close();
    }

    @Override
    public void stopAut(AutIdentifier autId) {
        if (log.isInfoEnabled()) {
            log.info(Messages.StoppingTest);
        }
        try {
            AutAgentConnection.getInstance().getCommunicator().send((Message)new StopAUTServerMessage(autId));
        }
        catch (ConnectionException ce) {
            if (log.isInfoEnabled()) {
                log.info(Messages.ClosingTheConnectionsFailed, (Throwable)((Object)ce));
            }
        }
        catch (CommunicationException e) {
            log.error(Messages.ErrorOccurredWhileTryingToStopAUT, (Throwable)e);
        }
        TestExecution te = TestExecution.getInstance();
        ITestSuitePO startedTestSuite = te.getStartedTestSuite();
        if (startedTestSuite != null && startedTestSuite.isStarted()) {
            startedTestSuite.setStarted(false);
        }
        te.setStartedTestSuite(null);
        if (te.getStartedTestSuite() != null && te.getStartedTestSuite().isStarted()) {
            this.fireEndTestExecution();
        }
    }

    @Override
    public void startObjectMapping(AutIdentifier autId, int mod, int inputCode, int inputType) throws ConnectionException, BaseConnection.NotConnectedException, CommunicationException {
        log.info(Messages.StartingObjectMapping);
        if (AUTConnection.getInstance().connectToAut(autId, (IProgressMonitor)new NullProgressMonitor())) {
            ChangeAUTModeMessage message = new ChangeAUTModeMessage();
            message.setMode(2);
            message.setKeyModifier(mod);
            switch (inputType) {
                case 2: {
                    message.setMouseButton(inputCode);
                    message.setKey(-1);
                    break;
                }
                default: {
                    message.setKey(inputCode);
                    message.setMouseButton(-1);
                }
            }
            AUTConnection.getInstance().send((Message)message);
        }
    }

    @Override
    public void startRecordTestCase(ISpecTestCasePO spec, IWritableComponentNameMapper compNamesMapper, int recordCompMod, int recordCompKey, int recordApplMod, int recordApplKey, int checkModeKeyMod, int checkModeKey, int checkCompKeyMod, int checkCompKey, boolean dialogOpen, SortedSet<String> singleLineTrigger, SortedSet<String> multiLineTrigger, Locale locale) {
        log.info(Messages.StartingRecordModus);
        try {
            ChangeAUTModeMessage message = new ChangeAUTModeMessage();
            message.setMode(3);
            message.setKeyModifier(recordCompMod);
            message.setKey(recordCompKey);
            message.setKey2Modifier(recordApplMod);
            message.setKey2(recordApplKey);
            message.setCheckModeKeyModifier(checkModeKeyMod);
            message.setCheckModeKey(checkModeKey);
            message.setCheckCompKeyModifier(checkCompKeyMod);
            message.setCheckCompKey(checkCompKey);
            message.setRecordDialogOpen(dialogOpen);
            message.setSingleLineTrigger(singleLineTrigger);
            message.setMultiLineTrigger(multiLineTrigger);
            message.setToolkit(GeneralStorage.getInstance().getProject().getToolkit());
            ObjectMappingEventDispatcher.setCategoryToCreateIn(null);
            AUTConnection.getInstance().send((Message)message);
            CAPRecordedCommand.setRecSpecTestCase(spec);
            CAPRecordedCommand.setCompNamesMapper(compNamesMapper);
            CAPRecordedCommand.setRecordLocale(locale);
        }
        catch (UnknownMessageException ume) {
            this.fireAUTServerStateChanged(new AUTServerEvent(ume.getErrorId()));
        }
        catch (BaseConnection.NotConnectedException nce) {
            log.error(nce.getLocalizedMessage(), (Throwable)((Object)nce));
        }
        catch (CommunicationException ce) {
            log.error(ce.getLocalizedMessage(), (Throwable)ce);
        }
    }

    @Override
    public void resetToTesting() {
        block6: {
            log.info("setting mode to test");
            CAPRecordedCommand.setRecordListener(null);
            try {
                if (!AUTConnection.getInstance().isConnected()) break block6;
                try {
                    ChangeAUTModeMessage message = new ChangeAUTModeMessage();
                    message.setMode(1);
                    AUTConnection.getInstance().send((Message)message);
                }
                catch (UnknownMessageException ume) {
                    this.fireAUTServerStateChanged(new AUTServerEvent(ume.getErrorId()));
                }
                catch (BaseConnection.NotConnectedException nce) {
                    log.error(nce.getLocalizedMessage(), (Throwable)((Object)nce));
                }
                catch (CommunicationException ce) {
                    log.error(ce.getLocalizedMessage(), (Throwable)ce);
                }
                AUTConnection.getInstance().close();
            }
            catch (ConnectionException e) {
                log.error("Error occurred while closing connection to AUT.", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public void startTestSuite(final ITestSuitePO execTestSuite, final Locale locale, final AutIdentifier autId, final boolean autoScreenshot, final Map<String, String> externalVars) {
        final String jobName = NLS.bind((String)Messages.ExecutingTestSuite, (Object)execTestSuite.getName());
        Job runningTestSuite = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(jobName, 1000);
                TestExecution.getInstance().setStartedTestSuite(execTestSuite);
                execTestSuite.setStarted(true);
                ClientTest.this.m_testsuiteStartTime = new Date();
                ClientTest.this.setTestresultSummary(PoMaker.createTestResultSummaryPO());
                TestExecution.getInstance().executeTestSuite(execTestSuite, locale, autId, autoScreenshot, externalVars, ClientTest.this.getTestresultSummary(), monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        runningTestSuite.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().matches(8)) {
                    ClientTest.this.stopTestExecution();
                }
            }
        });
        runningTestSuite.schedule();
    }

    @Override
    public void startTestJob(ITestJobPO testJob, Locale locale, boolean autoScreenshot) {
        TestExecution.getInstance().setStartedTestJob(testJob);
        this.m_testjobStartTime = new Date();
        try {
            final AtomicBoolean isTestExecutionFailed = new AtomicBoolean(false);
            final AtomicInteger testExecutionMessageId = new AtomicInteger(0);
            final AtomicInteger testExecutionState = new AtomicInteger(0);
            final AtomicBoolean isTestExecutionFinished = new AtomicBoolean(false);
            ITestExecutionEventListener executionListener = new ITestExecutionEventListener(){

                public void stateChanged(TestExecutionEvent event) {
                    testExecutionState.set(event.getState());
                    if (event.getState() == 3) {
                        if (event.getException() instanceof JBException) {
                            JBException e = (JBException)((Object)event.getException());
                            testExecutionMessageId.set(e.getErrorId());
                        }
                        isTestExecutionFailed.set(true);
                        this.testExecutionFinished();
                    }
                }

                public void endTestExecution() {
                    this.testExecutionFinished();
                }

                private void testExecutionFinished() {
                    isTestExecutionFinished.set(true);
                    ClientTest.this.removeTestExecutionEventListener(this);
                }
            };
            List<INodePO> refTestSuiteList = testJob.getUnmodifiableNodeList();
            for (INodePO node : refTestSuiteList) {
                IRefTestSuitePO refTestSuite = (IRefTestSuitePO)node;
                isTestExecutionFailed.set(false);
                isTestExecutionFinished.set(false);
                this.addTestExecutionEventListener(executionListener);
                AutIdentifier autId = new AutIdentifier(refTestSuite.getTestSuiteAutID());
                String testSuiteGuid = refTestSuite.getTestSuiteGuid();
                ITestSuitePO testSuite = NodePM.getTestSuite(testSuiteGuid);
                this.startTestSuite(testSuite, locale, autId, autoScreenshot, null);
                while (!isTestExecutionFinished.get()) {
                    TimeUtil.delay((long)500L);
                }
                if (this.continueTestJobExecution(testExecutionState, testExecutionMessageId)) continue;
                break;
            }
        }
        finally {
            TestExecution.getInstance().setStartedTestJob(null);
        }
    }

    private boolean continueTestJobExecution(AtomicInteger testExecutionState, AtomicInteger testExecutionMessageId) {
        if (testExecutionMessageId.get() == MessageIDs.E_NO_AUT_CONNECTION_ERROR.intValue()) {
            return false;
        }
        return testExecutionState.get() != 2;
    }

    @Override
    public void stopTestExecution() {
        this.fireTestExecutionChanged(new TestExecutionEvent(2));
        TestExecution.getInstance().stopExecution();
    }

    @Override
    public void pauseTestExecution(TestExecution.PauseMode pm) {
        TestExecution.getInstance().pauseExecution(pm);
    }

    @Override
    public void addTestEventListener(IAUTEventListener listener) {
        if (log.isInfoEnabled()) {
            log.info(String.valueOf(Messages.AddingIAUTEventListener) + " " + listener.getClass().getName() + ":" + listener.toString());
        }
        eventListenerList.add(IAUTEventListener.class, listener);
    }

    @Override
    public void removeTestEventListener(IAUTEventListener listener) {
        if (log.isInfoEnabled()) {
            log.info(String.valueOf(Messages.RemovingIAUTEventListener) + " " + listener.getClass().getName() + ":" + listener.toString());
        }
        eventListenerList.remove(IAUTEventListener.class, listener);
    }

    @Override
    public void addAutAgentEventListener(IServerEventListener listener) {
        eventListenerList.add(IServerEventListener.class, listener);
    }

    @Override
    public void removeAutAgentEventListener(IServerEventListener listener) {
        eventListenerList.remove(IServerEventListener.class, listener);
    }

    @Override
    public void addAUTServerEventListener(IAUTServerEventListener listener) {
        eventListenerList.add(IAUTServerEventListener.class, listener);
    }

    @Override
    public void removeAUTServerEventListener(IAUTServerEventListener listener) {
        eventListenerList.remove(IAUTServerEventListener.class, listener);
    }

    @Override
    public void addTestExecutionEventListener(ITestExecutionEventListener listener) {
        eventListenerList.add(ITestExecutionEventListener.class, listener);
    }

    @Override
    public void removeTestExecutionEventListener(ITestExecutionEventListener listener) {
        eventListenerList.remove(ITestExecutionEventListener.class, listener);
    }

    @Override
    public void addTestresultSummaryEventListener(ITestresultSummaryEventListener listener) {
        eventListenerList.add(ITestresultSummaryEventListener.class, listener);
    }

    @Override
    public void removeTestresultSummaryEventListener(ITestresultSummaryEventListener listener) {
        eventListenerList.remove(ITestresultSummaryEventListener.class, listener);
    }

    @Override
    public void fireAUTStateChanged(AUTEvent event) {
        if (log.isInfoEnabled()) {
            log.info(String.valueOf(Messages.FiringAUTStateChanged) + ":" + String.valueOf(event.getState()));
        }
        Object[] listeners = eventListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == IAUTEventListener.class) {
                ((IAUTEventListener)listeners[i + 1]).stateChanged(event);
            }
            i -= 2;
        }
    }

    @Override
    public void fireAutAgentStateChanged(AutAgentEvent event) {
        if (log.isInfoEnabled()) {
            log.info(String.valueOf(Messages.FiringAUTStateChanged) + ":" + String.valueOf(event.getState()));
        }
        Object[] listeners = eventListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == IServerEventListener.class) {
                ((IServerEventListener)listeners[i + 1]).stateChanged(event);
            }
            i -= 2;
        }
    }

    @Override
    public void fireAUTServerStateChanged(AUTServerEvent event) {
        if (log.isInfoEnabled()) {
            log.info(String.valueOf(Messages.FiringAUTStateChanged) + ":" + String.valueOf(event.getState()));
        }
        Object[] listeners = eventListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == IAUTServerEventListener.class) {
                ((IAUTServerEventListener)listeners[i + 1]).stateChanged(event);
            }
            i -= 2;
        }
    }

    @Override
    public void fireTestExecutionChanged(TestExecutionEvent event) {
        Object[] listeners = eventListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ITestExecutionEventListener.class) {
                ((ITestExecutionEventListener)listeners[i + 1]).stateChanged(event);
            }
            i -= 2;
        }
    }

    public void getMonitoringData() {
        GetMonitoringDataMessage message = new GetMonitoringDataMessage(TestExecution.getInstance().getConnectedAutId().getExecutableName());
        try {
            AutAgentConnection.getInstance().send((Message)message);
        }
        catch (BaseConnection.NotConnectedException nce) {
            log.error(nce.getLocalizedMessage(), (Throwable)((Object)nce));
        }
        catch (CommunicationException ce) {
            log.error(ce.getLocalizedMessage(), (Throwable)ce);
        }
    }

    public void buildMonitoringReport() {
        BuildMonitoringReportMessage message = new BuildMonitoringReportMessage(TestExecution.getInstance().getConnectedAutId().getExecutableName());
        try {
            AutAgentConnection.getInstance().send((Message)message);
        }
        catch (BaseConnection.NotConnectedException nce) {
            log.error(nce.getLocalizedMessage(), (Throwable)((Object)nce));
        }
        catch (CommunicationException ce) {
            log.error(ce.getLocalizedMessage(), (Throwable)ce);
        }
    }

    @Override
    public Map<String, String> requestAutConfigMapFromAgent(String autId) {
        Map<String, String> autConfigMap = null;
        GetAutConfigMapMessage message = new GetAutConfigMapMessage(autId);
        GetAutConfigMapResponseCommand response = new GetAutConfigMapResponseCommand();
        try {
            AutAgentConnection.getInstance().request((Message)message, response, 10000);
            final AtomicBoolean timeoutFlag = new AtomicBoolean(true);
            final Timer timerTimeout = new Timer();
            timerTimeout.schedule(new TimerTask(){

                public void run() {
                    timeoutFlag.set(false);
                    timerTimeout.cancel();
                }
            }, 10000L);
            while (!response.hasReceivedResponse() && timeoutFlag.get()) {
                TimeUtil.delay((long)200L);
                log.info(Messages.WaitingForAutConfigMapFromAgent);
            }
            autConfigMap = response.getAutConfigMap();
        }
        catch (BaseConnection.NotConnectedException nce) {
            log.error(nce.getLocalizedMessage(), (Throwable)((Object)nce));
        }
        catch (CommunicationException ce) {
            log.error(ce.getLocalizedMessage(), (Throwable)ce);
        }
        return autConfigMap;
    }

    @Override
    public void fireEndTestExecution() {
        this.m_endTime = new Date();
        TestResult result = TestResultBP.getInstance().getResultTestModel();
        if (result != null) {
            this.createReportJob(result);
        }
        Object[] listeners = eventListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ITestExecutionEventListener.class) {
                ((ITestExecutionEventListener)listeners[i + 1]).endTestExecution();
            }
            i -= 2;
        }
    }

    private void createReportJob(TestResult results) {
        final TestResult result = results;
        final AtomicBoolean ab = new AtomicBoolean(false);
        final Job job = new Job(Messages.ClientCollectingInformation){
            private String m_jobFamily;
            {
                super($anonymous0);
                this.m_jobFamily = this.getName();
            }

            public boolean belongsTo(Object family) {
                return this.m_jobFamily.equals(family);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.ClientWritingReportToDB, -1);
                    ClientTest.this.writeTestresultToDB();
                    monitor.beginTask(Messages.ClientWritingReport, -1);
                    ClientTest.this.writeReport();
                    if (ClientTest.this.isRunningWithMonitoring()) {
                        monitor.setTaskName(Messages.ClientCalculating);
                        ClientTest.this.getMonitoringData();
                        while (result.getMonitoringValues() == null || result.getMonitoringValues().isEmpty()) {
                            TimeUtil.delay((long)500L);
                            if (result.getMonitoringValues() != null) break;
                            if (!monitor.isCanceled()) continue;
                            return Status.CANCEL_STATUS;
                        }
                        monitor.setTaskName(Messages.ClientBuildingReport);
                        ClientTest.this.buildMonitoringReport();
                        while (result.getReportData() == null) {
                            TimeUtil.delay((long)500L);
                            if (result.getReportData() == MonitoringConstants.EMPTY_REPORT) break;
                            if (!monitor.isCanceled()) continue;
                            return Status.CANCEL_STATUS;
                        }
                        ClientTest.this.writeMonitoringResults(result);
                    }
                    ClientTest.this.fireTestresultSummaryChanged();
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (Throwable t) {
                    log.error(Messages.ClientWritingReportError, t);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ab.set(true);
            }
        });
        final Timer timerTimeout = new Timer();
        timerTimeout.schedule(new TimerTask(){

            public void run() {
                job.cancel();
                timerTimeout.cancel();
            }
        }, 1200000L);
        job.setPriority(30);
        job.schedule();
        while (!ab.get()) {
            TimeUtil.delay((long)200L);
        }
    }

    public void writeMonitoringResults(TestResult result) {
        ITestResultSummaryPO currentSummary = this.getTestresultSummary();
        currentSummary.setMonitoringValues(result.getMonitoringValues());
        IMonitoringValue significantValue = this.findSignificantValue(result.getMonitoringValues());
        if (significantValue == null) {
            currentSummary.setMonitoringValue(null);
        } else {
            currentSummary.setMonitoringValue(significantValue.getValue());
            currentSummary.setMonitoringValueType(significantValue.getType());
        }
        currentSummary.setInternalMonitoringId(result.getMonitoringId());
        if (result.getReportData() == MonitoringConstants.EMPTY_REPORT) {
            currentSummary.setReportWritten(false);
        } else {
            currentSummary.setMonitoringReport(new MonitoringReportPO(result.getReportData()));
            currentSummary.setReportWritten(true);
        }
        TestResultSummaryPM.mergeTestResultSummaryInDB(currentSummary);
        result.setReportData(null);
    }

    public IMonitoringValue findSignificantValue(Map<String, IMonitoringValue> map) {
        for (IMonitoringValue value : map.values()) {
            if (!value.isSignificant().booleanValue()) continue;
            return value;
        }
        return null;
    }

    private boolean isRunningWithMonitoring() {
        Map<String, String> m;
        AutIdentifier autID = TestExecution.getInstance().getConnectedAutId();
        return autID != null && (m = this.requestAutConfigMapFromAgent(autID.getExecutableName())) != null && MonitoringUtil.shouldAndCanRunWithMonitoring(m);
    }

    @Override
    public void fireTestresultSummaryChanged() {
        Object[] listeners = eventListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ITestresultSummaryEventListener.class) {
                ((ITestresultSummaryEventListener)listeners[i + 1]).testresultSummaryChanged();
            }
            i -= 2;
        }
    }

    @Override
    public void writeTestresultToDB() {
        TestResult result = TestResultBP.getInstance().getResultTestModel();
        if (result != null) {
            TestresultSummaryBP.getInstance().populateTestResultSummary(result, this.getTestresultSummary());
            if (this.getTestresultSummary() != null) {
                TestResultSummaryPM.storeTestResultSummaryInDB(this.getTestresultSummary());
                TestResultPM.storeTestResult(TestresultSummaryBP.getInstance().createTestResultDetailsSession(result, this.getTestresultSummary().getId()));
            }
        }
    }

    @Override
    public void writeReport() {
        if (TestResultBP.getInstance().getResultTestModel() != null && this.m_logPath != null) {
            AbstractXMLReportGenerator generator = null;
            generator = Messages.TestResultViewPreferencePageStyleErrorsOnly.equalsIgnoreCase(this.m_logStyle) ? new ErrorsOnlyXMLReportGenerator(TestResultBP.getInstance().getResultTestModel()) : new CompleteXMLReportGenerator(TestResultBP.getInstance().getResultTestModel());
            this.writeReport(generator);
        }
    }

    private void writeReport(AbstractXMLReportGenerator generator) {
        Document document = generator.generateXmlReport();
        String fileName = this.createFilename(TestResultBP.getInstance().getResultTestModel());
        try {
            new FileXMLReportWriter(fileName).write(document);
        }
        catch (IOException e) {
            log.error(Messages.ClientWritingReportError, (Throwable)e);
        }
    }

    private String createFilename(TestResult result) {
        StringBuilder sb = new StringBuilder(this.m_logPath);
        sb.append("/");
        sb.append(Messages.ExecutionLog);
        sb.append("-");
        sb.append(result.getProjectName());
        sb.append("-");
        TestResultNode testSuiteNode = result.getRootResultNode();
        sb.append(testSuiteNode.getName());
        sb.append("-");
        if (testSuiteNode.getStatus() == 1) {
            sb.append(TEST_SUCCESSFUL);
        } else {
            sb.append(TEST_FAILED);
        }
        if (new File(String.valueOf(sb.toString()) + XML_FILE_EXT).exists()) {
            int postfix = 1;
            sb.append("-");
            while (new File(String.valueOf(sb.toString()) + postfix + XML_FILE_EXT).exists()) {
                ++postfix;
            }
            sb.append(postfix);
        }
        return sb.toString();
    }

    private boolean initServerConnection(String serverName, String port) throws JBVersionException {
        try {
            AutAgentConnection.createInstance(serverName, port);
            AutAgentConnection.getInstance().run();
            if (log.isDebugEnabled()) {
                log.debug(Messages.ConnectedToTheServer);
            }
        }
        catch (ConnectionException ce) {
            log.error(ce.getLocalizedMessage(), (Throwable)((Object)ce));
            return false;
        }
        catch (BaseConnection.AlreadyConnectedException ae) {
            if (log.isDebugEnabled()) {
                log.debug(ae.getLocalizedMessage(), (Throwable)((Object)ae));
            }
            return false;
        }
        return true;
    }

    @Override
    public Date getEndTime() {
        return this.m_endTime;
    }

    @Override
    public Date getTestsuiteStartTime() {
        return this.m_testsuiteStartTime;
    }

    @Override
    public Date getTestjobStartTime() {
        return this.m_testjobStartTime;
    }

    @Override
    public void setLogPath(String logPath) {
        this.m_logPath = logPath;
    }

    @Override
    public void setLogStyle(String logStyle) {
        this.m_logStyle = logStyle;
    }

    private ITestResultSummaryPO getTestresultSummary() {
        return this.m_summary;
    }

    private void setTestresultSummary(ITestResultSummaryPO summary) {
        this.m_summary = summary;
    }

    @Override
    public void setRelevantFlag(boolean relevant) {
        this.m_relevant = relevant;
    }

    @Override
    public boolean isRelevant() {
        return this.m_relevant;
    }

    @Override
    public boolean isPauseTestExecutionOnError() {
        return this.m_pauseOnError;
    }

    @Override
    public void pauseTestExecutionOnError(boolean pauseOnError) {
        this.m_pauseOnError = pauseOnError;
    }

    @Override
    public void setScreenshotXMLFlag(boolean screenshotXml) {
        this.m_xmlScrennshot = screenshotXml;
    }

    @Override
    public boolean isScreenshotForXML() {
        return this.m_xmlScrennshot;
    }
}

