/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.commands;

import java.util.Set;
import org.eclipse.jubula.client.core.AUTEvent;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.IAUTInfoListener;
import org.eclipse.jubula.client.core.IClientTest;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.AUTStartStateMessage;
import org.eclipse.jubula.communication.message.AUTStateMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.ConcreteComponent;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUTStartedCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(AUTStartedCommand.class);
    private IAUTInfoListener m_listener;
    private AUTStartStateMessage m_message;
    private AUTStateMessage m_stateMessage;
    private boolean m_wasExecuted = false;

    public AUTStartedCommand() {
    }

    public AUTStartedCommand(IAUTInfoListener listener) {
        this.setListener(listener);
    }

    public void setStateMessage(AUTStateMessage stateMessage) {
        this.m_stateMessage = stateMessage;
    }

    private void fireAutStateChanged() {
        int state = this.m_stateMessage.getState();
        IClientTest clientTest = ClientTestFactory.getClientTest();
        switch (state) {
            case 1: {
                log.info(Messages.AUTIsRunning);
                clientTest.fireAUTStateChanged(new AUTEvent(1));
                break;
            }
            case 2: {
                log.error(String.valueOf(Messages.AUTCouldNotStarted) + this.m_stateMessage.getDescription());
                clientTest.fireAUTStateChanged(new AUTEvent(6));
            }
        }
    }

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (AUTStartStateMessage)message;
    }

    private String getLogicalName(Component comp) {
        ConcreteComponent cc;
        String logicalName = null;
        if (comp.isConcrete() && (cc = (ConcreteComponent)comp).hasDefaultMapping()) {
            String logicalNameKey = cc.getDefaultMapping().getLogicalName();
            String name = CompSystemI18n.getString((String)logicalNameKey);
            logicalName = name != null ? name : logicalNameKey;
        }
        return logicalName;
    }

    public Message execute() {
        ObjectMappingEventDispatcher.clearObjMapTransient();
        IObjectMappingPO transientObjMap = ObjectMappingEventDispatcher.getObjMapTransient();
        IObjectMappingCategoryPO oldCategory = ObjectMappingEventDispatcher.getCategoryToCreateIn();
        ObjectMappingEventDispatcher.setCategoryToCreateIn(transientObjMap.getMappedCategory());
        for (IComponentIdentifier id : this.m_message.getCompIds()) {
            Component comp = ComponentBuilder.getInstance().getCompSystem().findComponent(id.getComponentClassName());
            Set allSyntheticComponents = comp.getAllRealized();
            allSyntheticComponents.add(comp);
            for (Component sComponent : allSyntheticComponents) {
                String logicalName = this.getLogicalName(sComponent);
                if (logicalName != null) {
                    transientObjMap.addObjectMappingAssoziation(logicalName, id);
                    continue;
                }
                if (!log.isErrorEnabled()) continue;
                log.error(NLS.bind((String)Messages.NoLogicalNameForDefaultMapping, (Object)sComponent));
            }
        }
        ObjectMappingEventDispatcher.setCategoryToCreateIn(oldCategory);
        this.fireAutStateChanged();
        this.m_wasExecuted = true;
        return null;
    }

    public boolean wasExecuted() {
        return this.m_wasExecuted;
    }

    public void timeout() {
        log.warn(String.valueOf(this.getClass().getName()) + ".timeout() called");
        IAUTInfoListener listener = this.getListener();
        if (listener != null) {
            listener.error(1);
        }
    }

    public IAUTInfoListener getListener() {
        return this.m_listener;
    }

    private void setListener(IAUTInfoListener listener) {
        this.m_listener = listener;
    }
}

