/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.businessprocess.db.TestJobBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractNewHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.swt.widgets.Control;

public class NewTestJobHandler
extends AbstractNewHandler {
    public Object executeImpl(ExecutionEvent event) {
        this.newTestJob(event);
        return null;
    }

    private void newTestJob(ExecutionEvent event) {
        INodePO parent = this.getParentNode(event);
        InputDialog dialog = this.newTestJobPopUp();
        if (dialog.getReturnCode() == 1) {
            return;
        }
        try {
            ITestJobPO testJob = NodeMaker.createTestJobPO((String)dialog.getName());
            NodePM.AbstractCmdHandleChild cmd = NodePM.getCmdHandleChild((INodePO)parent, (INodePO)testJob);
            NodePM.addAndPersistChildNode((INodePO)parent, (INodePO)testJob, null, (NodePM.AbstractCmdHandleChild)cmd);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)testJob, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
        }
    }

    private InputDialog newTestJobPopUp() {
        final IProjectPO project = GeneralStorage.getInstance().getProject();
        int testJobCount = TestJobBP.getListOfTestJobs((IProjectPO)project).size();
        String str = "";
        if (testJobCount > 0) {
            str = String.valueOf(str) + testJobCount;
        }
        str = "New Test Job" + str;
        InputDialog dialog = new InputDialog(this.getActiveShell(), Messages.NewTestJobTJTitle, str, Messages.NewTestJobTJMessage, Messages.NewTestJobTJLabel, Messages.NewTestJobTJError, Messages.NewTestJobDoubleTJName, "newTestJobDialog.gif", Messages.NewTestJobTJShell, false){

            protected boolean isInputAllowed() {
                String newName = this.getInputFieldText();
                return !ProjectPM.doesTestJobExists((Long)project.getId(), (String)newName);
            }
        };
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogTestJobNewContextId");
        dialog.open();
        return dialog;
    }
}

