/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.communication;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.AbortingExceptionHandler;
import org.eclipse.jubula.communication.CommandFactory;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.IConnectionInitializer;
import org.eclipse.jubula.communication.IExceptionHandler;
import org.eclipse.jubula.communication.UnknownCommandException;
import org.eclipse.jubula.communication.connection.Connection;
import org.eclipse.jubula.communication.connection.DefaultServerSocket;
import org.eclipse.jubula.communication.connection.DefaultSocket;
import org.eclipse.jubula.communication.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.listener.IErrorHandler;
import org.eclipse.jubula.communication.listener.IMessageHandler;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.MessageHeader;
import org.eclipse.jubula.communication.message.MessageIdentifier;
import org.eclipse.jubula.communication.parser.MessageSerializer;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.exception.AssertException;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.exception.JBVersionException;
import org.eclipse.jubula.tools.exception.SerialisationException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Communicator {
    private static final int DEFAULT_CONNECTING_TIMEOUT = 10;
    private static final int DEFAULT_REQUEST_TIMEOUT = 10;
    private static final int THOUSAND = 1000;
    private static Logger log;
    private int m_port = 0;
    private InetAddress m_inetAddress = null;
    private ClassLoader m_classLoader = null;
    private DefaultServerSocket m_serverSocket = null;
    private int m_localPort;
    private Connection m_connection;
    private ConnectionListener m_connectionListener;
    private ErrorListener m_errorListener;
    private Map m_awaitingCommands;
    private LinkedHashSet m_errorListeners;
    private ConnectionManager m_connectionManager;
    private IExceptionHandler m_exceptionHandler = new AbortingExceptionHandler();
    private MessageSerializer m_serializer;
    private int m_initConnectionTimeout = 10;
    private boolean m_accepting = false;
    private int m_requestTimeout = 10;
    private Map m_responseToInitializer;
    private CommandFactory m_commandFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.communication.Communicator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public Communicator(InetAddress inetAddress, int port, ClassLoader cl, CommandFactory cf) {
        this(inetAddress, port, cl);
        this.m_commandFactory = cf;
    }

    public Communicator(InetAddress inetAddress, int port, ClassLoader cl) throws AssertException {
        Assert.verify((inetAddress != null ? 1 : 0) != 0, (String)"inetAddress must not be null");
        Assert.verify((port >= 0 ? 1 : 0) != 0, (String)"port must not be negativ");
        Assert.verify((cl != null ? 1 : 0) != 0, (String)"no class loader for creation of command object available");
        this.m_inetAddress = inetAddress;
        this.m_port = port;
        this.m_classLoader = cl;
        this.init();
    }

    public Communicator(int port, ClassLoader cl) throws IOException, SecurityException, AssertException {
        this(port, cl, null);
    }

    public Communicator(int port, ClassLoader cl, Map responseToInitializer) throws IOException, SecurityException, AssertException {
        Assert.verify((port >= 0 ? 1 : 0) != 0, (String)"port must not be negativ");
        Assert.verify((cl != null ? 1 : 0) != 0, (String)"no class loader for creation of command object available");
        this.m_serverSocket = new DefaultServerSocket(port);
        this.m_serverSocket.setSoTimeout(0);
        this.m_localPort = this.m_serverSocket.getLocalPort();
        this.m_classLoader = cl;
        this.m_responseToInitializer = new HashMap();
        if (responseToInitializer != null) {
            this.m_responseToInitializer.putAll(responseToInitializer);
        }
        Set set = this.m_responseToInitializer.keySet();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Validate.allElementsOfType(set, (Class)clazz);
        Collection collection = this.m_responseToInitializer.values();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.jubula.communication.IConnectionInitializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Validate.allElementsOfType(collection, (Class)clazz2);
        this.init();
    }

    private void init() {
        this.m_serializer = new MessageSerializer();
        this.m_connection = null;
        this.setConnectionManager(new DefaultConnectionManager());
        this.m_awaitingCommands = new HashMap();
        this.m_errorListeners = new LinkedHashSet();
        this.m_connectionListener = new ConnectionListener();
        this.m_errorListener = new ErrorListener();
        this.m_commandFactory = new CommandFactory(this.m_classLoader);
    }

    public synchronized Thread run() throws SecurityException, JBVersionException {
        AcceptingThread acceptingThread = null;
        if (this.m_serverSocket != null && !this.isAccepting()) {
            this.setAccepting(true);
            acceptingThread = new AcceptingThread();
            acceptingThread.start();
        } else if (this.m_inetAddress != null) {
            try {
                DefaultSocket socket = new DefaultSocket(this.m_inetAddress, this.m_port, this.m_initConnectionTimeout * 1000);
                if (socket.isConnectionEstablished()) {
                    this.setup(socket);
                } else {
                    log.info("connecting failed with server state: " + String.valueOf(socket.getState()));
                    this.fireConnectingFailed(this.m_inetAddress, this.m_port);
                }
            }
            catch (IllegalArgumentException iae) {
                log.debug(iae.getLocalizedMessage(), (Throwable)iae);
                this.fireConnectingFailed(this.m_inetAddress, this.m_port);
            }
            catch (IOException ioe) {
                log.debug(ioe.getLocalizedMessage(), (Throwable)ioe);
                this.fireConnectingFailed(this.m_inetAddress, this.m_port);
            }
            catch (SecurityException se) {
                log.debug(se.getLocalizedMessage(), (Throwable)se);
                this.fireConnectingFailed(this.m_inetAddress, this.m_port);
                throw se;
            }
        }
        return acceptingThread;
    }

    private ICommand createCommand(Message msg) throws UnknownCommandException {
        String commandClassName = msg.getCommandClass();
        ICommand result = this.m_commandFactory.createCommandObject(commandClassName);
        result.setMessage(msg);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommunicationErrorListener(ICommunicationErrorListener listener) {
        if (listener != null) {
            LinkedHashSet linkedHashSet = this.m_errorListeners;
            synchronized (linkedHashSet) {
                this.m_errorListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommunicationErrorListener(ICommunicationErrorListener listener) {
        if (listener != null) {
            LinkedHashSet linkedHashSet = this.m_errorListeners;
            synchronized (linkedHashSet) {
                this.m_errorListeners.remove(listener);
            }
        }
    }

    public int getRequestTimeout() {
        return this.m_requestTimeout;
    }

    public void setRequestTimeout(int defaultTimeOut) {
        this.m_requestTimeout = defaultTimeOut;
    }

    public int getInitConnectionTimeout() {
        return this.m_initConnectionTimeout;
    }

    public void setInitConnectionTimeout(int initConnectionTimeout) {
        this.m_initConnectionTimeout = initConnectionTimeout;
    }

    public synchronized ConnectionManager getConnectionManager() {
        return this.m_connectionManager;
    }

    public synchronized void setConnectionManager(ConnectionManager connectionManager) {
        this.m_connectionManager = connectionManager;
    }

    public synchronized IExceptionHandler getExceptionHandler() {
        return this.m_exceptionHandler;
    }

    public synchronized void setExceptionHandler(IExceptionHandler exceptionHandler) {
        this.m_exceptionHandler = exceptionHandler;
    }

    private synchronized boolean isAccepting() {
        return this.m_accepting;
    }

    private synchronized void setAccepting(boolean accepting) {
        this.m_accepting = accepting;
    }

    public int getLocalPort() {
        return this.m_localPort;
    }

    private void checkConnectionState(String methodName) throws CommunicationException {
        if (this.m_connection == null) {
            log.debug("method " + methodName + " called to an unconnected " + "communicator");
            throw new CommunicationException("Communicator not connected", MessageIDs.E_COMMUNICATOR_CONNECTION);
        }
    }

    public void send(Message message) throws CommunicationException {
        this.checkConnectionState("send()");
        if (message == null) {
            log.debug("method send() with null parameter called");
            throw new CommunicationException("no message to send", MessageIDs.E_NO_MESSAGE_TO_SEND);
        }
        try {
            message.setMessageId(new MessageIdentifier(this.m_connection.getNextSequenceNumber()));
            String messageToSend = this.m_serializer.serialize(message);
            this.m_connection.send(new MessageHeader(2, message), messageToSend);
        }
        catch (SerialisationException se) {
            log.error(se.getLocalizedMessage(), (Throwable)se);
            throw new CommunicationException("could not send message:" + se.getMessage(), MessageIDs.E_MESSAGE_NOT_SEND);
        }
        catch (IOException ioe) {
            log.error(ioe.getLocalizedMessage(), (Throwable)ioe);
            throw new CommunicationException("io error occured during sending a message:" + ioe.getMessage(), MessageIDs.E_MESSAGE_SEND);
        }
        catch (IllegalArgumentException iae) {
            log.error(iae.getLocalizedMessage(), (Throwable)iae);
            throw new CommunicationException("message could not send", MessageIDs.E_MESSAGE_NOT_SEND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(Message message, ICommand command, int timeout) throws CommunicationException {
        this.checkConnectionState("request()");
        if (message == null) {
            log.debug("method request with null for parametermessage called.");
            throw new CommunicationException("no message to send as request", MessageIDs.E_MESSAGE_NOT_TO_REQUEST);
        }
        if (command == null) {
            log.debug("method request with null for parameter command called");
            throw new CommunicationException("no command for receiving response", MessageIDs.E_NO_RECEIVING_COMMAND);
        }
        int timeoutToUse = this.m_requestTimeout;
        if (timeout <= 0) {
            log.debug("invalid timeout given to request: using default timeout");
        } else {
            timeoutToUse = timeout;
        }
        MessageIdentifier messageIdentifier = new MessageIdentifier(this.m_connection.getNextSequenceNumber());
        try {
            message.setMessageId(messageIdentifier);
            String messageToSend = this.m_serializer.serialize(message);
            AwaitingCommand awaitingCommand = new AwaitingCommand(command, timeoutToUse);
            Map map = this.m_awaitingCommands;
            synchronized (map) {
                this.m_awaitingCommands.put(messageIdentifier, awaitingCommand);
            }
            this.m_connection.send(new MessageHeader(3, message), messageToSend);
            awaitingCommand.start();
        }
        catch (SerialisationException se) {
            log.error(se.getLocalizedMessage(), (Throwable)se);
            throw new CommunicationException("could not send message as request:" + se.getMessage(), MessageIDs.E_MESSAGE_NOT_TO_REQUEST);
        }
        catch (IOException ioe) {
            log.error(ioe.getLocalizedMessage(), (Throwable)ioe);
            Map map = this.m_awaitingCommands;
            synchronized (map) {
                this.m_awaitingCommands.remove(messageIdentifier);
            }
            throw new CommunicationException("io error occured during requesting a message: " + ioe.getMessage(), MessageIDs.E_MESSAGE_REQUEST);
        }
        catch (IllegalArgumentException iae) {
            log.error(iae.getLocalizedMessage(), (Throwable)iae);
            Map map = this.m_awaitingCommands;
            synchronized (map) {
                this.m_awaitingCommands.remove(messageIdentifier);
            }
            log.debug(iae.getLocalizedMessage(), (Throwable)iae);
            throw new CommunicationException("message could not send as a request", MessageIDs.E_MESSAGE_NOT_TO_REQUEST);
        }
    }

    public synchronized void close() {
        if (this.m_connection != null) {
            Connection toClose = this.m_connection;
            this.m_connection = null;
            toClose.removeErrorHandler(this.m_errorListener);
            toClose.close();
            this.getConnectionManager().remove(toClose);
            this.m_errorListener.shutDown();
        } else if (log.isDebugEnabled()) {
            log.debug("close() called for an unconnected communicator");
        }
    }

    private synchronized void fireSendFailed(MessageHeader header, String message) {
        if (log.isInfoEnabled()) {
            log.info("firing sendFailed, message=" + message);
        }
        try {
            Message data = this.m_serializer.deserialize(header, message);
            Iterator iter = ((HashSet)this.m_errorListeners.clone()).iterator();
            while (iter.hasNext()) {
                try {
                    ((ICommunicationErrorListener)iter.next()).sendFailed(data);
                }
                catch (Throwable t) {
                    log.error("Exception while calling listener", t);
                }
            }
        }
        catch (SerialisationException se) {
            log.error("deserialisation of\n" + message + "\nduring notifying " + "CommunicationErrorListeners " + "with sendFailed() failed", (Throwable)se);
        }
    }

    private synchronized void fireShutDown() {
        log.info("firing shutDown");
        Iterator iter = ((HashSet)this.m_errorListeners.clone()).iterator();
        while (iter.hasNext()) {
            try {
                ((ICommunicationErrorListener)iter.next()).shutDown();
            }
            catch (Throwable t) {
                log.error("Exception while calling listener", t);
            }
        }
        this.getConnectionManager().remove(this.m_connection);
    }

    private synchronized void fireAcceptingFailed(int port) {
        if (log.isInfoEnabled()) {
            log.info("firing acceptingFailed");
        }
        Iterator iter = ((HashSet)this.m_errorListeners.clone()).iterator();
        while (iter.hasNext()) {
            try {
                ((ICommunicationErrorListener)iter.next()).acceptingFailed(port);
            }
            catch (Throwable t) {
                log.error("Exception while calling listener", t);
            }
        }
    }

    private synchronized void fireConnectingFailed(InetAddress inetAddress, int port) {
        if (log.isDebugEnabled()) {
            log.debug("firing connectingFailed");
        }
        Iterator iter = ((HashSet)this.m_errorListeners.clone()).iterator();
        while (iter.hasNext()) {
            try {
                ((ICommunicationErrorListener)iter.next()).connectingFailed(inetAddress, port);
            }
            catch (Throwable t) {
                log.error("Exception while calling listener", t);
            }
        }
    }

    private synchronized void fireConnectionGained(InetAddress inetAddress, int port) {
        log.info("firing connectionGained");
        Iterator iter = ((HashSet)this.m_errorListeners.clone()).iterator();
        while (iter.hasNext()) {
            try {
                ((ICommunicationErrorListener)iter.next()).connectionGained(inetAddress, port);
            }
            catch (Throwable t) {
                log.error("Exception while calling listener", t);
            }
        }
    }

    private void setup(DefaultSocket socket) throws IOException {
        this.m_connection = new Connection(socket);
        this.setup(this.m_connection, socket);
    }

    private void setup(Socket socket, BufferedReader bufferedReader) {
        this.m_connection = new Connection(socket, bufferedReader);
        this.setup(this.m_connection, socket);
    }

    private void setup(Connection conn, Socket socket) {
        conn.addMessageHandler(this.m_connectionListener);
        conn.addErrorHandler(this.m_errorListener);
        conn.setExceptionHandler(this.getExceptionHandler());
        String id = socket.toString();
        conn.startReading(id);
        this.fireConnectionGained(socket.getInetAddress(), socket.getPort());
    }

    public void interruptAllTimeouts() {
        Set keys = new HashMap(this.m_awaitingCommands).keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            AwaitingCommand cmd = (AwaitingCommand)this.m_awaitingCommands.get(key);
            cmd.commandReceived();
            this.m_awaitingCommands.remove(key);
        }
    }

    public int getPort() {
        return this.m_port;
    }

    public String getHostName() {
        return this.m_inetAddress.getHostName();
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public void clearListeners() {
        this.m_errorListeners.clear();
        if (this.m_connection != null) {
            this.m_connection.clearListeners();
        }
    }

    private class AcceptingThread
    extends Thread {
        public AcceptingThread() {
            super("Accepting Thread - listening on port " + Communicator.this.m_serverSocket.getLocalPort());
        }

        public void run() {
            while (Communicator.this.isAccepting() && !Thread.currentThread().isInterrupted()) {
                try {
                    Socket socket = Communicator.this.m_serverSocket.accept();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF8"));
                    String response = DefaultServerSocket.requestClientType(socket, reader, 10000L);
                    if (response != null) {
                        IConnectionInitializer initializer = (IConnectionInitializer)Communicator.this.m_responseToInitializer.get(response);
                        if (initializer != null) {
                            initializer.initConnection(socket, reader);
                            continue;
                        }
                        int nextState = Communicator.this.getConnectionManager().getNextState();
                        DefaultServerSocket.send(socket, nextState);
                        if (nextState != 0) continue;
                        Communicator.this.setup(socket, reader);
                        Communicator.this.getConnectionManager().add(Communicator.this.m_connection);
                        continue;
                    }
                    socket.close();
                }
                catch (IOException ioe) {
                    log.debug(ioe.getLocalizedMessage(), (Throwable)ioe);
                    Communicator.this.fireAcceptingFailed(Communicator.this.m_serverSocket.getLocalPort());
                    Communicator.this.setAccepting(false);
                }
                catch (Throwable t) {
                    log.error(t.getLocalizedMessage(), t);
                    Communicator.this.setAccepting(false);
                }
            }
        }
    }

    private static class AwaitingCommand
    extends Thread {
        private boolean m_timeoutExpired;
        private ICommand m_command;
        private long m_timeout;
        private boolean m_wasCommandReceived;

        public AwaitingCommand(ICommand command, int timeout) {
            super("Awaiting command: " + command.getClass());
            this.m_command = command;
            this.m_timeout = timeout;
            this.m_wasCommandReceived = false;
            this.setTimeoutExpired(false);
        }

        public ICommand getCommand() {
            return this.m_command;
        }

        public synchronized boolean isTimeoutExpired() {
            return this.m_timeoutExpired;
        }

        private synchronized void setTimeoutExpired(boolean timeoutExpired) {
            this.m_timeoutExpired = timeoutExpired;
        }

        public void run() {
            if (!this.wasCommandReceived()) {
                long startTime = System.currentTimeMillis();
                while (!this.wasCommandReceived() && startTime + this.m_timeout >= System.currentTimeMillis()) {
                    try {
                        AwaitingCommand.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.wasCommandReceived()) {
                    this.setTimeoutExpired(true);
                    try {
                        this.m_command.timeout();
                    }
                    catch (Exception e) {
                        log.error("catched exception from '" + this.m_command.getClass().getName() + ".timeout()'", (Throwable)e);
                    }
                }
            }
        }

        public synchronized void commandReceived() {
            this.m_wasCommandReceived = true;
            this.interrupt();
        }

        public synchronized boolean wasCommandReceived() {
            return this.m_wasCommandReceived;
        }
    }

    private class ConnectionListener
    implements IMessageHandler {
        private ConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void received(MessageHeader header, String message) {
            if (log.isDebugEnabled()) {
                log.debug("received message:" + message);
            }
            try {
                Map map;
                Message data = Communicator.this.m_serializer.deserialize(header, message);
                MessageIdentifier receivedMessageId = data.getMessageId();
                MessageIdentifier boundedId = data.getBindId();
                ICommand command = null;
                AwaitingCommand awaitingCommand = null;
                if (boundedId != null) {
                    map = Communicator.this.m_awaitingCommands;
                    synchronized (map) {
                        awaitingCommand = (AwaitingCommand)Communicator.this.m_awaitingCommands.get(boundedId);
                    }
                }
                if (awaitingCommand != null) {
                    map = Communicator.this.m_awaitingCommands;
                    synchronized (map) {
                        Communicator.this.m_awaitingCommands.remove(boundedId);
                    }
                    if (!data.getCommandClass().equals(awaitingCommand.getCommand().getClass().getName())) {
                        log.error("answer is of wrong type");
                        return;
                    }
                    if (awaitingCommand.isTimeoutExpired()) {
                        log.warn("Received response " + awaitingCommand.getCommand() + " *after* timeout expired.");
                        return;
                    }
                    log.debug("Received command response for " + awaitingCommand.getCommand());
                    awaitingCommand.commandReceived();
                    command = awaitingCommand.getCommand();
                }
                if (command == null) {
                    command = Communicator.this.createCommand(data);
                } else {
                    command.setMessage(data);
                }
                Message response = null;
                try {
                    response = command.execute();
                }
                catch (Throwable t) {
                    log.error("catched exception from '" + command.getClass().getName() + ".execute()'", t);
                }
                if (response != null) {
                    log.debug("Sending response: " + response);
                    response.setBindId(receivedMessageId);
                    Communicator.this.send(response);
                }
            }
            catch (ClassCastException cce) {
                log.error("wrong type in the map of awaiting responses", (Throwable)cce);
            }
            catch (SerialisationException se) {
                log.error("deserialisation of a received message failed", (Throwable)se);
            }
            catch (UnknownCommandException uce) {
                log.error("received message with unknown command", (Throwable)((Object)uce));
            }
            catch (CommunicationException ce) {
                log.error("could not send answer ", (Throwable)ce);
            }
        }
    }

    public static interface ConnectionManager {
        public int getNextState();

        public void add(Connection var1);

        public void remove(Connection var1);
    }

    private static class DefaultConnectionManager
    implements ConnectionManager {
        private static final int BACKLOG = 1;
        private List m_connections = new ArrayList(1);

        public int getNextState() {
            if (this.m_connections.size() < 1) {
                return 0;
            }
            return 1;
        }

        public void add(Connection connection) {
            this.m_connections.add(connection);
        }

        public void remove(Connection connection) {
            this.m_connections.remove(connection);
        }
    }

    private class ErrorListener
    implements IErrorHandler {
        private ErrorListener() {
        }

        public void sendFailed(MessageHeader header, String message) {
            Communicator.this.fireSendFailed(header, message);
        }

        public void shutDown() {
            Communicator.this.fireShutDown();
        }
    }
}

