/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.communication.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.IExceptionHandler;
import org.eclipse.jubula.communication.connection.DefaultSocket;
import org.eclipse.jubula.communication.connection.UnexpectedEofException;
import org.eclipse.jubula.communication.listener.IErrorHandler;
import org.eclipse.jubula.communication.listener.IMessageHandler;
import org.eclipse.jubula.communication.message.MessageHeader;
import org.eclipse.jubula.communication.parser.MessageHeaderSerializer;
import org.eclipse.jubula.communication.writer.MessageWriter;
import org.eclipse.jubula.tools.exception.SerialisationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    public static final String IO_STREAM_ENCODING = "UTF8";
    private static final long SEQUENCE_START = 1L;
    private static Logger log;
    private long m_sequenceNumber;
    private Socket m_socket;
    private BufferedReader m_inputStreamReader;
    private OutputStream m_outputStream;
    private Set m_messageHandlers;
    private Set m_errorHandlers;
    private IExceptionHandler m_exceptionHandler = null;
    private ReaderThread m_readerThread = null;
    private boolean m_shutDownFired;
    private MessageHeaderSerializer m_headerSerializer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.communication.connection.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public Connection(DefaultSocket socket) throws IOException, IllegalArgumentException {
        this(socket, socket.getInputStreamReader());
    }

    public Connection(Socket socket, BufferedReader socketInputStreamReader) throws IllegalArgumentException {
        Validate.notNull((Object)socket, (String)"socket must not be null");
        try {
            this.m_socket = socket;
            this.m_outputStream = this.m_socket.getOutputStream();
            this.m_inputStreamReader = socketInputStreamReader;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("socket must be connected");
        }
        this.m_shutDownFired = false;
        this.m_sequenceNumber = 1L;
        this.m_messageHandlers = new HashSet();
        this.m_errorHandlers = new HashSet();
        this.m_headerSerializer = new MessageHeaderSerializer();
    }

    public synchronized String getNextSequenceNumber() {
        if (this.m_sequenceNumber == Long.MAX_VALUE) {
            this.m_sequenceNumber = 1L;
        }
        String result = String.valueOf(this.m_sequenceNumber);
        ++this.m_sequenceNumber;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReading(String id) {
        ReaderThread readerThread = this.m_readerThread;
        if (readerThread == null) {
            readerThread = new ReaderThread("Connection.ReaderThread:" + id);
            readerThread.setDaemon(true);
        }
        ReaderThread readerThread2 = readerThread;
        synchronized (readerThread2) {
            if (!readerThread.isAlive()) {
                readerThread.start();
            }
        }
        this.m_readerThread = readerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.m_readerThread != null) {
            ReaderThread readerThread = this.m_readerThread;
            synchronized (readerThread) {
                if (this.m_readerThread.isAlive()) {
                    this.m_readerThread.interrupt();
                }
            }
        }
        try {
            this.m_socket.close();
        }
        catch (IOException ioe) {
            log.debug("io error closing a socket", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageHandler(IMessageHandler messageHandler) {
        if (messageHandler != null) {
            Set set = this.m_messageHandlers;
            synchronized (set) {
                this.m_messageHandlers.add(messageHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(IMessageHandler messageHandler) {
        if (messageHandler != null) {
            Set set = this.m_messageHandlers;
            synchronized (set) {
                this.m_messageHandlers.remove(messageHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorHandler(IErrorHandler errorHandler) {
        if (errorHandler != null) {
            Set set = this.m_errorHandlers;
            synchronized (set) {
                this.m_errorHandlers.add(errorHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorHandler(IErrorHandler errorHandler) {
        if (errorHandler != null) {
            Set set = this.m_errorHandlers;
            synchronized (set) {
                this.m_errorHandlers.remove(errorHandler);
            }
        }
    }

    public synchronized IExceptionHandler getExceptionHandler() {
        return this.m_exceptionHandler;
    }

    public synchronized void setExceptionHandler(IExceptionHandler exceptionHandler) {
        this.m_exceptionHandler = exceptionHandler;
    }

    public InetAddress getAddress() {
        return this.m_socket.getInetAddress();
    }

    public synchronized void send(MessageHeader header, String message) throws IOException, IllegalArgumentException {
        Validate.notNull((Object)header, (String)"Message header must not be null");
        Validate.notNull((Object)message, (String)"Message must not be null");
        try {
            header.setMessageLength(message.length());
            String serializedHeader = this.m_headerSerializer.serialize(header);
            MessageWriter writer = new MessageWriter(new OutputStreamWriter(this.m_outputStream, IO_STREAM_ENCODING));
            writer.write(35);
            writer.write("" + serializedHeader.length());
            writer.newLine();
            writer.write(serializedHeader);
            writer.write(message);
            writer.flush();
            if (log.isInfoEnabled()) {
                log.info("sent to " + this.m_socket.getRemoteSocketAddress() + " message with header: " + serializedHeader);
            }
            if (log.isDebugEnabled()) {
                log.debug("sent message: " + message);
            }
        }
        catch (IOException ioe) {
            log.error("send failed", (Throwable)ioe);
            this.fireSendFailed(message, header);
            this.fireShutDown();
            throw ioe;
        }
        catch (SerialisationException se) {
            log.error("serialisation of " + header.toString() + "failed", (Throwable)se);
            this.fireSendFailed(message, header);
        }
    }

    private synchronized void fireSendFailed(String message, MessageHeader header) {
        if (log.isDebugEnabled()) {
            log.debug("firing send failed, message=" + message);
        }
        Iterator iter = ((HashSet)((HashSet)this.m_errorHandlers).clone()).iterator();
        while (iter.hasNext()) {
            try {
                ((IErrorHandler)iter.next()).sendFailed(header, message);
            }
            catch (Throwable t) {
                log.error("Exception while calling listener", t);
            }
        }
    }

    private synchronized void fireShutDown() {
        if (!this.m_shutDownFired) {
            log.debug("firing shutdown");
            Iterator iter = ((HashSet)((HashSet)this.m_errorHandlers).clone()).iterator();
            while (iter.hasNext()) {
                try {
                    ((IErrorHandler)iter.next()).shutDown();
                }
                catch (Throwable t) {
                    log.error("Exception while calling listener", t);
                }
            }
            this.m_shutDownFired = true;
        } else {
            log.debug("shutdown already fired");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void fireMessageReceived(MessageHeader header, String message) {
        if (Connection.log.isDebugEnabled()) {
            Connection.log.debug("firing message received, message=" + message);
        }
        var4_3 = this;
        synchronized (var4_3) {
            iter = ((HashSet)((HashSet)this.m_messageHandlers).clone()).iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var4_3
            if (true) ** GOTO lbl17
        }
        do {
            try {
                ((IMessageHandler)iter.next()).received(header, message);
            }
            catch (Throwable t) {
                Connection.log.error("Exception while calling listener", t);
            }
lbl17:
            // 3 sources

        } while (iter.hasNext());
    }

    public void clearListeners() {
        this.m_errorHandlers.clear();
        this.m_messageHandlers.clear();
    }

    private class ReaderThread
    extends Thread {
        public ReaderThread(String name) {
            super(name);
        }

        public void run() {
            while (!this.isInterrupted()) {
                String headerLengthToken = null;
                try {
                    if (!this.waitForInput()) {
                        return;
                    }
                    headerLengthToken = Connection.this.m_inputStreamReader.readLine();
                    int headerLength = Integer.parseInt(headerLengthToken);
                    String headerString = this.readString(Connection.this.m_inputStreamReader, headerLength);
                    if (log.isInfoEnabled()) {
                        log.info("read header: " + headerString);
                    }
                    MessageHeader header = Connection.this.m_headerSerializer.deserialize(headerString);
                    header.validateVersion();
                    String message = this.readString(Connection.this.m_inputStreamReader, header.getMessageLength());
                    if (log.isDebugEnabled()) {
                        log.debug("read message: " + message);
                    }
                    Connection.this.fireMessageReceived(header, message);
                }
                catch (IOException ioe) {
                    log.debug("stopping reading either due to io exception or stopped AUT", (Throwable)ioe);
                    this.fireShutDownAndFinish();
                }
                catch (UnexpectedEofException e) {
                    log.error("unexpected end of file while reading message", (Throwable)((Object)e));
                    Connection.this.close();
                    this.fireShutDownAndFinish();
                }
                catch (NumberFormatException e) {
                    log.error("invalid header length token: " + headerLengthToken, (Throwable)e);
                }
                catch (MessageHeader.InvalidHeaderVersionException ihve) {
                    log.error(ihve.getLocalizedMessage(), (Throwable)((Object)ihve));
                }
                catch (Throwable t) {
                    log.error("exception raised", t);
                    IExceptionHandler exceptionHandler = Connection.this.getExceptionHandler();
                    if (exceptionHandler == null || exceptionHandler.handle(t)) continue;
                    Connection.this.close();
                    this.fireShutDownAndFinish();
                }
            }
            Connection.this.fireShutDown();
        }

        private String readString(BufferedReader reader, int length) throws IOException, UnexpectedEofException {
            if (log.isDebugEnabled()) {
                log.debug("readString len " + length);
            }
            char[] headerChars = new char[length];
            int required = length;
            int filled = 0;
            while (required > 0) {
                int nread = reader.read(headerChars, filled, required);
                if (nread == -1) {
                    log.error("received message part before unexpected eof: " + String.valueOf(headerChars));
                    throw new UnexpectedEofException("after reading " + filled + " bytes of expected " + length + " bytes of string");
                }
                filled += nread;
                required -= nread;
            }
            return String.valueOf(headerChars);
        }

        private boolean waitForInput() throws IOException {
            int character = this.nextChar();
            boolean createLogMessage = log.isDebugEnabled();
            StringWriter logMessage = new StringWriter();
            while (!this.isInterrupted() && character != 35) {
                if (character == -1) {
                    this.fireShutDownAndFinish();
                    if (this.isInterrupted()) {
                        return false;
                    }
                }
                character = this.nextChar();
                if (!createLogMessage) continue;
                logMessage.write(character);
            }
            if (createLogMessage) {
                logMessage.flush();
                log.debug("received a portion of a message:" + logMessage.toString());
            }
            return true;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int nextChar() throws SocketException, IOException {
            int oldTimeout = Connection.this.m_socket.getSoTimeout();
            Connection.this.m_socket.setSoTimeout(5000);
            boolean loop = false;
            int character = -1;
            try {
                do {
                    try {
                        loop = false;
                        character = Connection.this.m_inputStreamReader.read();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        loop = true;
                    }
                } while (loop && !this.isInterrupted());
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                Connection.this.m_socket.setSoTimeout(oldTimeout);
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            Connection.this.m_socket.setSoTimeout(oldTimeout);
            return character;
        }

        private void fireShutDownAndFinish() {
            this.interrupt();
            Connection.this.fireShutDown();
        }
    }
}

