/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.components.AUTHierarchy;
import org.eclipse.jubula.rc.common.components.IComponentFactory;
import org.eclipse.jubula.rc.common.exception.ComponentNotManagedException;
import org.eclipse.jubula.rc.common.exception.UnsupportedComponentException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swing.SwingAUTServer;
import org.eclipse.jubula.rc.swing.components.FindSwingComponentBP;
import org.eclipse.jubula.rc.swing.components.SwingComponent;
import org.eclipse.jubula.rc.swing.components.SwingHierarchyContainer;
import org.eclipse.jubula.rc.swing.listener.ComponentHandler;
import org.eclipse.jubula.rc.swing.utils.WorkerRunnable;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;

public class AUTSwingHierarchy
extends AUTHierarchy
implements ContainerListener,
ComponentListener {
    private static final String ENV_VAR_SYNC_REGISTER_LISTENERS = "JB_SYNC_REG_SWING_LISTENERS";
    private static AutServerLogger log;
    private static FindSwingComponentBP findBP;
    private WorkerRunnable m_listenerRegistrationWorker = new WorkerRunnable();
    private boolean m_syncListenerRegistration = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.components.AUTSwingHierarchy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
        findBP = new FindSwingComponentBP();
    }

    public AUTSwingHierarchy() {
        String syncListenersRegistrationValue = EnvironmentUtils.getProcessOrSystemProperty((String)ENV_VAR_SYNC_REGISTER_LISTENERS);
        this.m_syncListenerRegistration = Boolean.valueOf(syncListenersRegistrationValue);
        if (!this.m_syncListenerRegistration) {
            Thread registrationThread = new Thread((Runnable)this.m_listenerRegistrationWorker, "Jubula Listener Registration");
            registrationThread.setDaemon(true);
            registrationThread.start();
        }
    }

    public void add(Window window) {
        if (this.getRealMap().get(window) == null || this.getHierarchyContainer(window) == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("adding window " + window));
            }
            SwingComponent componentID = new SwingComponent(window);
            SwingHierarchyContainer hierarchyWindow = new SwingHierarchyContainer(componentID);
            this.addToHierachyMap(hierarchyWindow);
            this.registerAsWindowListener(window);
            Container parent = window.getParent();
            if (parent != null) {
                SwingHierarchyContainer hierarchyParent = this.getHierarchyContainer(parent);
                if (hierarchyParent == null) {
                    hierarchyParent = new SwingHierarchyContainer(new SwingComponent(parent));
                }
                this.name(hierarchyParent);
                hierarchyParent.add(hierarchyWindow);
                hierarchyWindow.setParent(hierarchyParent);
                this.name(hierarchyWindow);
                this.addToHierachyMap(hierarchyParent);
                this.addToHierarchyUp(hierarchyParent, parent);
            }
        }
        this.addToHierarchyDown(this.getHierarchyContainer(window), window);
    }

    public void addToHierarchy(IComponentFactory factory, String componentName, String technicalName) throws UnsupportedComponentException {
        Component component = (Component)factory.createComponent(componentName);
        if (this.getRealMap().get(component) != null) {
            return;
        }
        if (this.getHierarchyContainer(component) != null) {
            return;
        }
        SwingComponent comp = new SwingComponent(component);
        SwingHierarchyContainer container = new SwingHierarchyContainer(comp);
        container.setName(technicalName, true);
        this.addToHierachyMap(container);
    }

    private void remove(Window window) {
        if (this.getRealMap().get(window) != null) {
            SwingHierarchyContainer windowContainer = (SwingHierarchyContainer)((Object)this.getHierarchyMap().get(this.getRealMap().get(window)));
            if (windowContainer != null) {
                SwingHierarchyContainer parentContainer = windowContainer.getParent();
                if (parentContainer != null) {
                    parentContainer.remove(windowContainer);
                }
                this.removeFromHierarchy(windowContainer);
            } else {
                log.error((Object)("an unmanaged window was closed: " + window));
            }
        }
    }

    public IComponentIdentifier getComponentIdentifier(Component component) throws ComponentNotManagedException {
        this.checkDispatchThread();
        ComponentIdentifier result = new ComponentIdentifier();
        try {
            result.setComponentClassName(component.getClass().getName());
            result.setSupportedClassName(AUTServerConfiguration.getInstance().getTestableClass(component.getClass()).getName());
            List hierarchy = this.getPathToRoot(component);
            result.setHierarchyNames(hierarchy);
            result.setNeighbours(this.getComponentContext(component));
            SwingHierarchyContainer container = this.getHierarchyContainer(component);
            this.setAlternativeDisplayName(container, component, (IComponentIdentifier)result);
            if (component.equals(findBP.findComponent((IComponentIdentifier)result, ComponentHandler.getAutHierarchy()))) {
                result.setEqualOriginalFound(true);
            }
            return result;
        }
        catch (IllegalArgumentException iae) {
            log.error((Object)iae);
            throw new ComponentNotManagedException("getComponentIdentifier() called for an unmanaged component: " + component, MessageIDs.E_COMPONENT_NOT_MANAGED);
        }
    }

    protected List getComponentContext(Object component) {
        SwingHierarchyContainer parent;
        Component comp = (Component)component;
        ArrayList<String> context = new ArrayList<String>();
        if (comp.getParent() != null && (parent = this.getHierarchyContainer(comp.getParent())) != null) {
            SwingHierarchyContainer[] comps = parent.getComponents();
            int i = 0;
            while (i < comps.length) {
                Component child = comps[i].getComponentID().getRealComponent();
                if (!child.equals(comp)) {
                    String toAdd = String.valueOf(child.getClass().getName()) + "_" + 1;
                    while (context.contains(toAdd)) {
                        int lastCount = Integer.valueOf(toAdd.substring(toAdd.lastIndexOf("_") + 1));
                        toAdd = String.valueOf(child.getClass().getName()) + "_" + (lastCount + 1);
                    }
                    context.add(toAdd);
                }
                ++i;
            }
        }
        return context;
    }

    public IComponentIdentifier[] getAllComponentId() {
        this.checkDispatchThread();
        Vector<IComponentIdentifier> result = new Vector<IComponentIdentifier>();
        Set keys = this.getHierarchyMap().keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Component component = ((SwingComponent)((Object)iter.next())).getRealComponent();
            try {
                if (!AUTServerConfiguration.getInstance().isSupported((Object)component)) continue;
                result.add(this.getComponentIdentifier(component));
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)"hierarchy map contains null values", (Throwable)iae);
            }
            catch (ComponentNotManagedException e) {
                log.error((Object)("component '" + component.getName() + "' not found!"), (Throwable)e);
            }
        }
        return result.toArray(new IComponentIdentifier[result.size()]);
    }

    public Component findComponent(IComponentIdentifier componentIdentifier) throws IllegalArgumentException, ComponentNotManagedException, InvalidDataException {
        Component comp = (Component)findBP.findComponent(componentIdentifier, ComponentHandler.getAutHierarchy());
        if (comp != null && comp.isShowing()) {
            Window window = SwingUtilities.getWindowAncestor(comp);
            if (window != null && window.isShowing() && !window.isActive()) {
                window.toFront();
            }
            return comp;
        }
        throw new ComponentNotManagedException("unmanaged component with identifier: '" + componentIdentifier.toString() + "'.", MessageIDs.E_COMPONENT_NOT_MANAGED);
    }

    public List getPathToRoot(Component component) throws IllegalArgumentException, ComponentNotManagedException {
        if (log.isInfoEnabled()) {
            log.info((Object)("pathToRoot called for " + component));
        }
        Validate.notNull((Object)component, (String)"The component must not be null");
        ArrayList<String> hierarchy = new ArrayList<String>();
        SwingHierarchyContainer autContainer = this.getHierarchyContainer(component);
        if (autContainer != null) {
            hierarchy.add(autContainer.getName());
            String className = component.getClass().getName();
            if ("com.bredexsw.guidancer.autserver.swing.implclasses.GraphicApplication".equals(className) || "com.bredexsw.guidancer.autserver.swing.implclasses.JMenuBarDefaultMapping".equals(className) || "javax.swing.JMenuBar".equals(className)) {
                return hierarchy;
            }
            SwingHierarchyContainer parent = this.getHierarchyContainer(component.getParent());
            autContainer.setParent(parent);
            while (parent != null) {
                hierarchy.add(0, parent.getName());
                Component compo = parent.getComponentID().getRealComponent();
                parent = parent.getParent();
                if (parent != null || compo == null || compo.getParent() == null) continue;
                SwingComponent comp = new SwingComponent(compo.getParent());
                SwingHierarchyContainer container = new SwingHierarchyContainer(comp);
                this.name(container);
                parent = container;
                this.addToHierachyMap(container);
            }
        } else {
            log.error((Object)("component '" + component + "' is not managed by this hierarchy"));
            throw new ComponentNotManagedException("unmanaged component " + component.toString(), MessageIDs.E_COMPONENT_NOT_MANAGED);
        }
        return hierarchy;
    }

    public void componentAdded(ContainerEvent event) {
        this.checkDispatchThread();
        this.addComponent(event.getChild());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addComponent(Component toAdd) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            SwingHierarchyContainer hierarchyContainer;
            block10: {
                block9: {
                    block8: {
                        if (toAdd.isShowing()) break block8;
                        break block9;
                    }
                    Container container = toAdd.getParent();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("component '" + toAdd + "' added to '" + container + "'"));
                    }
                    hierarchyContainer = null;
                    hierarchyContainer = toAdd instanceof Window ? this.getHierarchyContainer(toAdd) : this.getHierarchyContainer(container);
                    if (hierarchyContainer != null && this.getHierarchyContainer(toAdd) == null) break block10;
                }
                Object var7_3 = null;
                Thread.currentThread().setContextClassLoader(originalCL);
                return;
            }
            SwingHierarchyContainer hierarchyChild = new SwingHierarchyContainer(new SwingComponent(toAdd));
            hierarchyContainer.add(hierarchyChild);
            hierarchyChild.setParent(hierarchyContainer);
            this.name(hierarchyChild);
            this.addToHierachyMap(hierarchyChild);
            if (toAdd instanceof Container) {
                Container cont = (Container)toAdd;
                this.addToHierarchyDown(hierarchyChild, cont);
            }
            Object var7_5 = null;
            Thread.currentThread().setContextClassLoader(originalCL);
            return;
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            Thread.currentThread().setContextClassLoader(originalCL);
            throw throwable;
        }
    }

    public void componentRemoved(ContainerEvent event) {
        this.checkDispatchThread();
        this.removeComponent(event.getChild(), event.getContainer());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeComponent(Component toRemove, Container parent) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            SwingHierarchyContainer hierarchyChild;
            if (log.isDebugEnabled()) {
                log.debug((Object)("component '" + toRemove + "' removed from '" + parent + "'"));
            }
            if (toRemove instanceof Container) {
                this.deregisterAsContainerListener((Container)toRemove);
            }
            if ((hierarchyChild = this.getHierarchyContainer(toRemove)) != null) {
                SwingHierarchyContainer hierarchyParent = hierarchyChild.getParent();
                if (hierarchyParent != null) {
                    hierarchyParent.remove(hierarchyChild);
                } else {
                    log.error((Object)("hierarchy structure corrupted, child has no parent: " + (Object)((Object)hierarchyChild)));
                }
                this.removeFromHierarchy(hierarchyChild);
            } else {
                log.debug((Object)("an unmanaged component was removed: " + toRemove));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Thread.currentThread().setContextClassLoader(originalCL);
            throw throwable;
        }
        {
            Object var6_8 = null;
            Thread.currentThread().setContextClassLoader(originalCL);
            return;
        }
    }

    private void registerAsContainerListener(final Container container) {
        Runnable registrationRunnable = new Runnable(){

            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)("registering as listener to container " + container));
                }
                ContainerListener[] listener = container.getContainerListeners();
                int i = 0;
                while (i < listener.length) {
                    if (listener[i] instanceof AUTSwingHierarchy) {
                        return;
                    }
                    ++i;
                }
                container.addContainerListener(AUTSwingHierarchy.this);
            }
        };
        this.registerListener(registrationRunnable);
    }

    private void registerListener(Runnable registrationRunnable) {
        if (this.m_syncListenerRegistration) {
            registrationRunnable.run();
        } else {
            this.m_listenerRegistrationWorker.addWork(registrationRunnable);
        }
    }

    private void deregisterAsContainerListener(final Container container) {
        Runnable deregistrationRunnable = new Runnable(){

            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)("deregistering as listener from container " + container));
                }
                container.removeContainerListener(AUTSwingHierarchy.this);
            }
        };
        this.registerListener(deregistrationRunnable);
    }

    private void registerAsWindowListener(final Window window) {
        Runnable registrationRunnable = new Runnable(){

            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)("registering window listener to window " + window));
                }
                WindowListener[] listener = window.getWindowListeners();
                int i = 0;
                while (i < listener.length) {
                    if (listener[i] instanceof WindowClosingListener) {
                        return;
                    }
                    ++i;
                }
                window.addWindowListener(new WindowClosingListener());
            }
        };
        this.registerListener(registrationRunnable);
    }

    private void addToHierarchyUp(SwingHierarchyContainer hierarchyContainer, Container container) {
        SwingHierarchyContainer hierarchyParent;
        this.checkDispatchThread();
        if (log.isInfoEnabled()) {
            log.info((Object)("addToHierarchyUp: " + (Object)((Object)hierarchyContainer) + "," + container));
        }
        this.registerAsContainerListener(container);
        Container parent = container.getParent();
        if (parent != null && (hierarchyParent = this.getHierarchyContainer(container)) == null) {
            hierarchyParent = new SwingHierarchyContainer(new SwingComponent(parent));
            hierarchyParent.add(hierarchyContainer);
            hierarchyContainer.setParent(hierarchyParent);
            this.name(hierarchyParent);
            this.addToHierachyMap(hierarchyParent);
            this.addToHierarchyUp(hierarchyParent, parent);
        }
    }

    private void addToHierarchyDown(SwingHierarchyContainer hierarchyContainer, Container container) {
        this.checkDispatchThread();
        if (log.isInfoEnabled()) {
            log.info((Object)("addToHierarchyDown: " + (Object)((Object)hierarchyContainer) + "," + container));
        }
        this.registerAsContainerListener(container);
        Collection collection = this.getComponents(container);
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Component comp = (Component)iter.next();
            if (this.getHierarchyContainer(comp) != null || !comp.isShowing()) continue;
            if (comp instanceof Window) {
                this.add((Window)comp);
                continue;
            }
            SwingHierarchyContainer newHierarchyContainer = new SwingHierarchyContainer(new SwingComponent(comp));
            this.name(newHierarchyContainer);
            newHierarchyContainer.setParent(hierarchyContainer);
            hierarchyContainer.add(newHierarchyContainer);
            this.addToHierachyMap(newHierarchyContainer);
            if (!(comp instanceof Container)) continue;
            this.addToHierarchyDown(newHierarchyContainer, (Container)comp);
        }
        this.name(hierarchyContainer);
    }

    private void removeFromHierarchy(SwingHierarchyContainer container) {
        if (container == null) {
            return;
        }
        SwingComponent autCompID = container.getComponentID();
        Component autComp = autCompID.getRealComponent();
        if (autComp == null) {
            log.error((Object)("invalid component for removal:" + autCompID.toString()));
        }
        this.removeFromHierachyMap(container);
        if (autComp instanceof Container) {
            this.deregisterAsContainerListener((Container)autComp);
        }
        Collection childs = this.getComponents(autComp);
        Iterator iter = childs.iterator();
        while (iter.hasNext()) {
            this.removeFromHierarchy(this.getHierarchyContainer((Component)iter.next()));
        }
    }

    public SwingHierarchyContainer getHierarchyContainer(Component component) throws IllegalArgumentException {
        Validate.notNull((Object)component, (String)"The component must not be null");
        SwingHierarchyContainer result = null;
        try {
            SwingComponent compID = (SwingComponent)((Object)this.getRealMap().get(component));
            if (compID != null) {
                result = (SwingHierarchyContainer)((Object)this.getHierarchyMap().get((Object)compID));
            }
        }
        catch (ClassCastException cce) {
            log.error((Object)cce);
        }
        catch (NullPointerException npe) {
            log.error((Object)npe);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void name(SwingHierarchyContainer hierarchyContainer) {
        block8: {
            block9: {
                this.checkDispatchThread();
                if (hierarchyContainer == null) break block8;
                component = hierarchyContainer.getComponentID().getRealComponent();
                compName = component.getName();
                if (component instanceof Dialog && compName != null && compName.startsWith("dialog")) {
                    compName = null;
                } else if (component instanceof JToolBar && compName != null && compName.startsWith("Tool Bar ")) {
                    compName = null;
                }
                hierarchyParent = null;
                parent = component.getParent();
                if (parent != null) {
                    hierarchyParent = this.getHierarchyContainer(parent);
                }
                if (hierarchyContainer.getName() != null && hierarchyContainer.getName().length() != 0) {
                    return;
                }
                count = 1;
                originalName = null;
                newName = null;
                v0 = newNameGenerated = compName == null;
                if (compName != null) {
                    originalName = compName;
                    newName = compName;
                }
                if (newName != null) ** GOTO lbl30
                while (!this.isUniqueName(hierarchyParent, newName, component)) {
                    newName = this.createName(component, count);
                    ++count;
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    newName = this.createName(originalName, ++count);
lbl30:
                    // 2 sources

                    ** while (!this.isUniqueName((SwingHierarchyContainer)hierarchyParent, (String)newName, (Component)component))
                }
            }
            hierarchyContainer.setName(newName, newNameGenerated);
        }
    }

    private boolean isUniqueName(SwingHierarchyContainer parent, String name, Component swingComponent) {
        if (name == null) {
            return false;
        }
        if (parent == null) {
            return true;
        }
        SwingHierarchyContainer[] compIDs = parent.getComponents();
        int length = compIDs.length;
        int index = 0;
        while (index < length) {
            Component childComponent = compIDs[index].getComponentID().getRealComponent();
            String childName = childComponent.getName();
            if (name.equals(childName) && childComponent != swingComponent) {
                return false;
            }
            ++index;
        }
        index = 0;
        while (index < length) {
            if (name.equals(compIDs[index].getName())) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private Collection getComponents(Component c) {
        if (c instanceof Container) {
            Container cont = (Container)c;
            ArrayList<Component> list = new ArrayList<Component>();
            list.addAll(Arrays.asList(cont.getComponents()));
            if (c instanceof JMenu) {
                list.add(((JMenu)c).getPopupMenu());
            } else if (c instanceof Window) {
                list.addAll(Arrays.asList(((Window)c).getOwnedWindows()));
            } else if (c instanceof JDesktopPane) {
                int count = cont.getComponentCount();
                int i = 0;
                while (i < count) {
                    JInternalFrame frame;
                    Component child = cont.getComponent(i);
                    if (child instanceof JInternalFrame.JDesktopIcon && (frame = ((JInternalFrame.JDesktopIcon)child).getInternalFrame()) != null) {
                        list.add(frame);
                    }
                    ++i;
                }
            }
            return list;
        }
        return new ArrayList();
    }

    public void componentHidden(ComponentEvent e) {
        this.checkDispatchThread();
        if (e.getComponent() instanceof Window) {
            this.remove((Window)e.getComponent());
        } else {
            this.removeComponent(e.getComponent(), e.getComponent().getParent());
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        this.checkDispatchThread();
        if (e.getComponent() instanceof Window) {
            this.add((Window)e.getComponent());
        } else {
            this.addComponent(e.getComponent());
        }
    }

    private void checkDispatchThread() {
        if (!EventQueue.isDispatchThread()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                log.error((Object)"Method called outside of the dispatch thread. This may indicate a potential error in the AUT.", (Throwable)e);
            }
        }
    }

    private class WindowClosingListener
    extends WindowAdapter {
        private WindowClosingListener() {
        }

        public void windowOpened(WindowEvent e) {
            this.windowActivated(e);
        }

        public void windowClosed(WindowEvent event) {
            Runnable deregistrationRunnable = new Runnable(this, event){
                final /* synthetic */ WindowClosingListener this$1;
                private final /* synthetic */ WindowEvent val$event;
                {
                    this.this$1 = windowClosingListener;
                    this.val$event = windowEvent;
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(((Object)((Object)((SwingAUTServer)AUTServer.getInstance()))).getClass().getClassLoader());
                    try {
                        Window window = this.val$event.getWindow();
                        AUTSwingHierarchy.access$0(WindowClosingListener.access$1(this.this$1), window);
                        if (AUTSwingHierarchy.access$1().isInfoEnabled()) {
                            AUTSwingHierarchy.access$1().info((Object)("deregistering window listener from window " + window));
                        }
                        window.removeWindowListener(this.this$1);
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        Thread.currentThread().setContextClassLoader(originalCL);
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                        Thread.currentThread().setContextClassLoader(originalCL);
                        return;
                    }
                }
            };
            AUTSwingHierarchy.this.registerListener(deregistrationRunnable);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void windowDeactivated(WindowEvent e) {
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)((SwingAUTServer)AUTServer.getInstance()))).getClass().getClassLoader());
            try {
                Window window = e.getWindow();
                if (!window.isVisible()) {
                    AUTSwingHierarchy.this.remove(window);
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                Thread.currentThread().setContextClassLoader(originalCL);
                throw throwable;
            }
            {
                Object var4_6 = null;
                Thread.currentThread().setContextClassLoader(originalCL);
                return;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void windowActivated(WindowEvent e) {
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)((SwingAUTServer)AUTServer.getInstance()))).getClass().getClassLoader());
            try {
                Window window = e.getWindow();
                if (window.isVisible() && AUTSwingHierarchy.this.getHierarchyContainer(window) == null) {
                    AUTSwingHierarchy.this.add(window);
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                Thread.currentThread().setContextClassLoader(originalCL);
                throw throwable;
            }
            {
                Object var4_6 = null;
                Thread.currentThread().setContextClassLoader(originalCL);
                return;
            }
        }

        static /* synthetic */ AUTSwingHierarchy access$1(WindowClosingListener windowClosingListener) {
            return windowClosingListener.AUTSwingHierarchy.this;
        }
    }
}

