/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComboComponent;
import org.eclipse.jubula.rc.swt.tester.adapter.ControlAdapter;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractComboBoxAdapter
extends ControlAdapter
implements IComboComponent {
    public static final int CLICK_COUNT_FOR_SELECTING_NONE = 3;
    private static AutServerLogger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.tester.adapter.AbstractComboBoxAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    protected AbstractComboBoxAdapter(Object objectToAdapt) {
        super(objectToAdapt);
    }

    public void select(int index) {
        int comboItemCount = this.getItemCount();
        if (index >= comboItemCount || index < 0) {
            throw new StepExecutionException("Combo Box index '" + index + "' is out of range", EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
        if (this.isComboEnabled()) {
            this.openDropdownList();
            this.selectImpl(index);
        }
    }

    protected abstract boolean isComboEnabled();

    protected abstract void selectImpl(int var1);

    protected abstract void openDropdownList();

    protected abstract int getItemCount();

    public void input(String text, boolean replace) throws StepExecutionException, IllegalArgumentException {
        Validate.notNull((Object)text, (String)"text must not be null");
        Control editor = (Control)this.getRealComponent();
        if (editor == null) {
            throw new StepExecutionException("could not find editor", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        if (replace) {
            this.selectAll();
        } else {
            this.selectNone();
        }
        this.getRobot().type((Object)editor, text);
        this.getRobot().keyType(null, 0x1000050);
    }

    public void click(Integer count) {
        Control editor = (Control)this.getRealComponent();
        if (editor == null) {
            throw new StepExecutionException("no editor found", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        this.getRobot().click((Object)editor, null, ClickOptions.create().setClickCount(count.intValue()));
    }

    public void selectNone() {
        this.click(new Integer(3));
    }

    protected void toggleDropdownList() {
        Rectangle r = this.findArrowIconArea();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Toggling dropdown by clicking on rectangle: " + r + "within component: " + this.getRealComponent()));
        }
        this.getRobot().click(this.getRealComponent(), (Object)r, ClickOptions.create().setScrollToVisible(true).setConfirmClick(false));
    }

    protected Rectangle findArrowIconArea() {
        final Control editor = (Control)this.getRealComponent();
        Rectangle r = null;
        if (editor == null) {
            throw new StepExecutionException("could not find editor", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        IEventThreadQueuer iEventThreadQueuer = this.getEventThreadQueuer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.tester.adapter.AbstractComboBoxAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        r = (Rectangle)iEventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + "findArrowIconArea", new IRunnable(){

            public Object run() throws StepExecutionException {
                return SwtUtils.getRelativeWidgetBounds((Widget)editor, editor);
            }
        });
        r.x += r.width - r.height;
        r.width = r.height;
        return r;
    }

    private boolean isComboEditable() {
        Integer comboStyle;
        IEventThreadQueuer iEventThreadQueuer = this.getEventThreadQueuer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.tester.adapter.AbstractComboBoxAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ((comboStyle = (Integer)iEventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + "isComboEditable", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(((Widget)AbstractComboBoxAdapter.this.getRealComponent()).getStyle());
            }
        })) & 8) == 0;
    }

    public boolean isEditable() {
        return this.isComboEditable();
    }
}

