/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.commands.AbstractStartPseudoJavaAUT;
import org.eclipse.jubula.autagent.commands.AbstractStartToolkitAut;

public class StartHtmlAutServerCommand
extends AbstractStartPseudoJavaAUT {
    private static final String DEFAULT_AUT_ID_ATTRIBUTE_NAME = "id";
    private static final Map BROWSER_TO_CMD_MAP = new HashMap();

    static {
        BROWSER_TO_CMD_MAP.put("Firefox", "*firefox");
        BROWSER_TO_CMD_MAP.put("InternetExplorer", "*iexplore");
        BROWSER_TO_CMD_MAP.put("Safari", "*safari");
        BROWSER_TO_CMD_MAP.put("Chrome", "*googlechrome");
    }

    @Override
    protected String[] createCmdArray(String baseCmd, Map parameters) {
        String[] bundlesToAddToClasspath;
        Vector<String> commands = new Vector<String>();
        commands.add(baseCmd);
        this.addDebugParams(commands, false);
        StringBuilder serverClasspath = new StringBuilder();
        String[] stringArray = bundlesToAddToClasspath = this.getBundlesForClasspath();
        int n = bundlesToAddToClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleId = stringArray[n2];
            serverClasspath.append(AbstractStartToolkitAut.getClasspathForBundleId(bundleId));
            serverClasspath.append(PATH_SEPARATOR);
            ++n2;
        }
        commands.add("-classpath");
        commands.add(serverClasspath.toString());
        commands.add("com.bredexsw.jubula.rc.html.WebAUTServer");
        commands.add(String.valueOf(AutStarter.getInstance().getAutCommunicator().getLocalPort()));
        commands.add(String.valueOf(parameters.get("AUT_ARGUMENTS")));
        commands.add(this.getBrowserString(parameters.get("BROWSER_PATH"), parameters.get("BROWSER")));
        commands.add("AUT");
        commands.add(String.valueOf(parameters.get("com.bredexsw.guidancer.aut.register.autAgentHost")));
        commands.add(String.valueOf(parameters.get("com.bredexsw.guidancer.aut.register.autAgentPort")));
        commands.add(String.valueOf(parameters.get("AUT_ID")));
        Object idAttribute = parameters.get("WEB_ID_TAG");
        if (idAttribute != null) {
            commands.add(String.valueOf(idAttribute));
        } else {
            commands.add(DEFAULT_AUT_ID_ATTRIBUTE_NAME);
        }
        Object singleWindowMode = parameters.get("SINGLE_WINDOW_MODE");
        if (singleWindowMode != null) {
            commands.add(String.valueOf(singleWindowMode));
        } else {
            commands.add(String.valueOf(true));
        }
        return commands.toArray(new String[commands.size()]);
    }

    protected String[] getBundlesForClasspath() {
        return new String[]{"com.bredexsw.jubula.rc.html", "org.eclipse.jubula.tools", "org.eclipse.jubula.communication", "org.eclipse.jubula.rc.common", "com.bredexsw.jubula.rc.common", "org.slf4j.jcl", "org.slf4j.jul", "org.slf4j.api", "ch.qos.logback.classic", "ch.qos.logback.core", "ch.qos.logback.slf4j", "org.apache.commons.lang", "org.apache.oro", "org.apache.commons.collections"};
    }

    private String getBrowserString(Object browserPath, Object browserType) {
        Object browser = BROWSER_TO_CMD_MAP.get(browserType);
        if (browser == null) {
            throw new IllegalArgumentException("Unsupported browser type: " + browserType);
        }
        String browserString = String.valueOf(browser);
        if (browserPath != null) {
            browserString = String.valueOf(browserString) + " " + String.valueOf(browserPath);
        }
        return browserString;
    }
}

