/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.businessprocess.CompNameResult;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.ConcreteComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompNamesBP {
    private void addPropagatedPairs(Map<String, ICompNamesPairPO> pairs, IExecTestCasePO execNode) {
        for (ICompNamesPairPO pair : execNode.getCompNamesPairs()) {
            String type;
            String name;
            if (!pair.isPropagated() || pairs.containsKey(name = pair.getSecondName())) continue;
            String string = type = pair.getType() == null || pair.getType().equals("") ? "" : pair.getType();
            if (pair.getType() == null) {
                for (INodePO o : execNode.getSpecTestCase().getUnmodifiableNodeList()) {
                    ICapPO cap;
                    INodePO node = o;
                    if (!(node instanceof ICapPO) || !(cap = (ICapPO)node).getComponentName().equals(pair.getName())) continue;
                    type = cap.getComponentType();
                    pair.setType(type);
                    break;
                }
            }
            pairs.put(name, PoMaker.createCompNamesPairPO(name, type));
        }
    }

    private void addCapComponentName(Map<String, ICompNamesPairPO> pairs, ICapPO capNode) {
        Component component = capNode.getMetaComponentType();
        if (component instanceof ConcreteComponent && ((ConcreteComponent)component).hasDefaultMapping()) {
            return;
        }
        String name = capNode.getComponentName();
        String type = capNode.getComponentType();
        if (!pairs.containsKey(name)) {
            ICompNamesPairPO pair = PoMaker.createCompNamesPairPO(name, type);
            pairs.put(name, pair);
        }
    }

    public List<ICompNamesPairPO> getAllCompNamesPairs(IExecTestCasePO execNode) {
        HashMap<String, ICompNamesPairPO> pairs = new HashMap<String, ICompNamesPairPO>();
        for (ICompNamesPairPO pair : execNode.getCompNamesPairs()) {
            pairs.put(pair.getFirstName(), pair);
        }
        ISpecTestCasePO specNode = execNode.getSpecTestCase();
        if (specNode != null) {
            Iterator<INodePO> it = specNode.getNodeListIterator();
            while (it.hasNext()) {
                INodePO child = it.next();
                if (child instanceof IExecTestCasePO) {
                    this.addPropagatedPairs(pairs, (IExecTestCasePO)child);
                    continue;
                }
                if (!(child instanceof ICapPO)) continue;
                this.addCapComponentName(pairs, (ICapPO)child);
            }
        }
        ArrayList<ICompNamesPairPO> pairList = new ArrayList<ICompNamesPairPO>(pairs.values());
        Collections.sort(pairList, new Comparator<ICompNamesPairPO>(){

            @Override
            public int compare(ICompNamesPairPO o1, ICompNamesPairPO o2) {
                return o1.getFirstName().compareTo(o2.getFirstName());
            }
        });
        return pairList;
    }

    private List<IExecTestCasePO> findExecNodes(ISpecTestCasePO specNode, IExecTestCasePO execNode) {
        ArrayList<IExecTestCasePO> nodes = new ArrayList<IExecTestCasePO>();
        List<IExecTestCasePO> execTestCases = NodePM.getInternalExecTestCases(specNode.getGuid(), specNode.getParentProjectId());
        for (IExecTestCasePO execTc : execTestCases) {
            Iterator<INodePO> itNodes = execTc.getNodeListIterator();
            while (itNodes.hasNext()) {
                INodePO child = itNodes.next();
                if (child != execNode) continue;
                nodes.add(execTc);
            }
        }
        return nodes;
    }

    private boolean updateCompNamesPair(IExecTestCasePO execNode, ICompNamesPairPO pair, IUpdater updater) {
        boolean update;
        INodePO execParent = execNode.getParentNode();
        if (execParent instanceof ISpecTestCasePO) {
            ISpecTestCasePO parent = (ISpecTestCasePO)execParent;
            for (IExecTestCasePO parentExec : this.findExecNodes(parent, execNode)) {
                updater.updateParentExecTestCase(parentExec, pair);
            }
        }
        if ((update = updater.updateCompNamesPair(pair)) && execNode.getCompNamesPair(pair.getFirstName()) == null) {
            execNode.addCompNamesPair(pair);
        }
        return update;
    }

    public boolean updateCompNamesPair(IExecTestCasePO execNode, ICompNamesPairPO pair, boolean propagated) {
        return this.updateCompNamesPair(execNode, pair, new PropagatedUpdater(propagated));
    }

    public boolean updateCompNamesPair(IExecTestCasePO execNode, ICompNamesPairPO pair, String secondCompName, IWritableComponentNameMapper compMapper) throws IncompatibleTypeException, PMException {
        if (secondCompName == null || "".equals(secondCompName)) {
            return false;
        }
        String secondName = compMapper.getCompNameCache().getGuidForName(secondCompName);
        if (StringUtils.equals((String)secondName, (String)pair.getSecondName())) {
            return false;
        }
        if (secondName == null) {
            IComponentNamePO newComponentNamePO = compMapper.getCompNameCache().createComponentNamePO(secondCompName, pair.getType(), ComponentNamesBP.CompNameCreationContext.OVERRIDDEN_NAME);
            newComponentNamePO.setParentProjectId(execNode.getParentProjectId());
            secondName = newComponentNamePO.getGuid();
        }
        compMapper.changeReuse(pair, pair.getSecondName(), secondName);
        return this.updateCompNamesPair(execNode, pair, new SecondNameUpdater(secondName));
    }

    public static boolean searchCompType(ICompNamesPairPO pair, Object node) {
        if (node instanceof IExecTestCasePO) {
            ISpecTestCasePO specTc = ((IExecTestCasePO)node).getSpecTestCase();
            if (specTc == null) {
                return false;
            }
            for (INodePO childNode : specTc.getUnmodifiableNodeList()) {
                ICapPO cap;
                if (childNode instanceof IExecTestCasePO) {
                    IExecTestCasePO exec = (IExecTestCasePO)childNode;
                    for (ICompNamesPairPO cnp : exec.getCompNamesPairs()) {
                        if (!cnp.getSecondName().equals(pair.getFirstName()) || !cnp.isPropagated()) continue;
                        pair.setType(cnp.getType());
                        if (CompNamesBP.isValidCompNamePair(pair)) {
                            return true;
                        }
                        boolean retVal = CompNamesBP.searchCompType(cnp, exec);
                        pair.setType(cnp.getType());
                        return retVal;
                    }
                    continue;
                }
                if (!(childNode instanceof ICapPO) || (cap = (ICapPO)childNode).getComponentName() == null || !cap.getComponentName().equals(pair.getFirstName())) continue;
                pair.setType(cap.getComponentType());
                return true;
            }
        }
        return false;
    }

    public CompNameResult findCompName(List<INodePO> treePath, INodePO compNameDefiner, String compNameGuid, IComponentNameCache compNameCache) {
        String currentName = compNameGuid;
        IComponentNamePO currentNamePo = compNameCache.getCompNamePo(currentName);
        if (currentNamePo != null) {
            currentName = currentNamePo.getGuid();
        }
        return this.findCompName(treePath, compNameCache, currentName, compNameDefiner);
    }

    private CompNameResult findCompName(List<INodePO> treePath, IComponentNameCache compNameCache, String originalName, INodePO originalCompNameDefiner) {
        String currentName = originalName;
        INodePO compNameDefiner = originalCompNameDefiner;
        ListIterator<INodePO> it = treePath.listIterator(treePath.size());
        while (it.hasPrevious()) {
            INodePO node = it.previous();
            if (!(node instanceof IExecTestCasePO)) continue;
            IExecTestCasePO execNode = (IExecTestCasePO)node;
            ICompNamesPairPO pair = null;
            if (!StringUtils.isEmpty((String)currentName)) {
                pair = execNode.getCompNamesPair(currentName);
            }
            if (pair == null) continue;
            currentName = pair.getSecondName();
            IComponentNamePO currentNamePo = compNameCache.getCompNamePo(currentName);
            if (currentNamePo != null) {
                currentName = currentNamePo.getGuid();
            }
            if (pair.isPropagated()) {
                int index = it.previousIndex();
                if (index <= -1) continue;
                compNameDefiner = treePath.get(index);
                continue;
            }
            compNameDefiner = execNode;
            break;
        }
        return new CompNameResult(currentName, compNameDefiner);
    }

    public static void removeIncorrectCompNamePairs(INodePO node) {
        for (INodePO o : node.getUnmodifiableNodeList()) {
            if (!(o instanceof IExecTestCasePO)) continue;
            IExecTestCasePO exec = (IExecTestCasePO)o;
            for (ICompNamesPairPO pair : new LinkedList<ICompNamesPairPO>(exec.getCompNamesPairs())) {
                CompNamesBP.searchCompType(pair, exec);
                if (CompNamesBP.isValidCompNamePair(pair)) continue;
                exec.removeCompNamesPair(pair.getFirstName());
            }
        }
    }

    public static boolean isValidCompNamePair(ICompNamesPairPO pair) {
        return pair.getType().length() != 0;
    }

    private static interface IUpdater {
        public void updateParentExecTestCase(IExecTestCasePO var1, ICompNamesPairPO var2);

        public boolean updateCompNamesPair(ICompNamesPairPO var1);
    }

    private static class PropagatedUpdater
    implements IUpdater {
        private boolean m_propagated;

        public PropagatedUpdater(boolean propagated) {
            this.m_propagated = propagated;
        }

        public boolean updateCompNamesPair(ICompNamesPairPO pair) {
            boolean oldValue = pair.isPropagated();
            pair.setPropagated(this.m_propagated);
            return oldValue ^ this.m_propagated;
        }

        public void updateParentExecTestCase(IExecTestCasePO parentExec, ICompNamesPairPO pair) {
            String name = pair.getSecondName();
            if (!this.m_propagated) {
                parentExec.removeCompNamesPair(name);
            }
        }
    }

    private static class SecondNameUpdater
    implements IUpdater {
        private String m_secondNameGuid;

        public SecondNameUpdater(String secondName) {
            this.m_secondNameGuid = secondName;
        }

        public boolean updateCompNamesPair(ICompNamesPairPO pair) {
            pair.setSecondName(this.m_secondNameGuid);
            return true;
        }

        public void updateParentExecTestCase(IExecTestCasePO parentExec, ICompNamesPairPO pair) {
            Validate.noNullElements((Object[])new Object[]{parentExec, pair});
            ICompNamesPairPO parentPair = parentExec.getCompNamesPair(pair.getSecondName());
            if (parentPair != null) {
                parentExec.removeCompNamesPair(parentPair.getFirstName());
                String type = parentExec.getCompNamesPair(pair.getFirstName()).getType();
                parentExec.addCompNamesPair(PoMaker.createCompNamesPairPO(this.m_secondNameGuid, parentPair.getSecondName(), type));
            }
        }
    }
}

