/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.treeoperations;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindNodesForComponentNameOp
extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
    private Set<INodePO> m_nodes = new HashSet<INodePO>();
    private String m_compNameGuid;

    public FindNodesForComponentNameOp(String compNameGuid) {
        this.setCompNameGuid(compNameGuid);
    }

    @Override
    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        if (Persistor.isPoSubclass(node, ICapPO.class)) {
            ICapPO cap = (ICapPO)node;
            if (this.getCompNameGuid().equals(cap.getComponentName())) {
                this.getNodes().add(cap);
            }
        } else if (Persistor.isPoSubclass(node, IExecTestCasePO.class)) {
            IExecTestCasePO execTc = (IExecTestCasePO)node;
            for (ICompNamesPairPO pair : execTc.getCompNamesPairs()) {
                if (!pair.getFirstName().equals(this.getCompNameGuid()) && !pair.getSecondName().equals(this.getCompNameGuid())) continue;
                this.getNodes().add(execTc);
            }
        }
        return true;
    }

    public Set<INodePO> getNodes() {
        return this.m_nodes;
    }

    protected void setNodes(Set<INodePO> nodes) {
        this.m_nodes = nodes;
    }

    protected void setCompNameGuid(String compNameGuid) {
        this.m_compNameGuid = compNameGuid;
    }

    protected String getCompNameGuid() {
        return this.m_compNameGuid;
    }
}

