/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.propertytester;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.propertytester.AbstractBooleanPropertyTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodePropertyTester
extends AbstractBooleanPropertyTester {
    public static final String EDITABLE_PROP = "isEditable";
    public static final String HAS_TASK_ID_PROP = "hasTaskId";
    private static final String[] PROPERTIES = new String[]{"isEditable", "hasTaskId"};

    @Override
    public boolean testImpl(Object receiver, String property, Object[] args) {
        IPersistentObject po = (IPersistentObject)receiver;
        if (property.equals(EDITABLE_PROP)) {
            return this.testIsEditable(po);
        }
        if (property.equals(HAS_TASK_ID_PROP)) {
            return this.hasTaskIdSet(po);
        }
        return false;
    }

    private boolean testIsEditable(IPersistentObject node) {
        if (node instanceof IObjectMappingCategoryPO) {
            return true;
        }
        return NodeBP.isEditable(node);
    }

    private boolean hasTaskIdSet(IPersistentObject po) {
        if (po instanceof INodePO) {
            INodePO node = (INodePO)po;
            return StringUtils.isNotEmpty((String)NodePropertyTester.getTaskIdforNode(node));
        }
        return false;
    }

    public static String getTaskIdforNode(INodePO node) {
        IExecTestCasePO execTC;
        ISpecTestCasePO specTestCase;
        if (node == null) {
            return null;
        }
        String taskId = node.getTaskId();
        if (node instanceof IRefTestSuitePO) {
            IRefTestSuitePO refTS = (IRefTestSuitePO)node;
            taskId = refTS.getTestSuite().getTaskId();
        } else if (node instanceof IExecTestCasePO && (specTestCase = (execTC = (IExecTestCasePO)node).getSpecTestCase()) != null) {
            taskId = specTestCase.getTaskId();
        }
        return taskId;
    }

    @Override
    public Class<? extends Object> getType() {
        return IPersistentObject.class;
    }

    @Override
    public String[] getProperties() {
        return PROPERTIES;
    }
}

