/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.properties;

import java.util.Map;
import javax.persistence.EntityManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.model.ICheckConfContPO;
import org.eclipse.jubula.client.core.model.ICheckConfPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.teststyle.ExtensionHelper;
import org.eclipse.jubula.client.teststyle.TeststyleHandler;
import org.eclipse.jubula.client.teststyle.checks.BaseCheck;
import org.eclipse.jubula.client.teststyle.checks.Severity;
import org.eclipse.jubula.client.teststyle.i18n.Messages;
import org.eclipse.jubula.client.teststyle.properties.PropUtils;
import org.eclipse.jubula.client.teststyle.properties.dialogs.attributes.EditAttributeDialog;
import org.eclipse.jubula.client.teststyle.properties.dialogs.contexts.EditContextDialog;
import org.eclipse.jubula.client.teststyle.properties.nodes.CategoryNode;
import org.eclipse.jubula.client.teststyle.properties.nodes.CheckNode;
import org.eclipse.jubula.client.teststyle.properties.nodes.INode;
import org.eclipse.jubula.client.teststyle.properties.provider.TeststyleBoxProvider;
import org.eclipse.jubula.client.teststyle.properties.provider.TeststyleContentProvider;
import org.eclipse.jubula.client.teststyle.properties.provider.TeststyleLabelProvider;
import org.eclipse.jubula.client.ui.rcp.properties.AbstractProjectPropertyPage;
import org.eclipse.jubula.client.ui.rcp.properties.ProjectGeneralPropertyPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class TeststyleProjectPropertyPage
extends AbstractProjectPropertyPage
implements ProjectGeneralPropertyPage.IOkListener {
    private static final int TREE_STYLE = 67588;
    private static final String TS_GROUP = Messages.PropertyFullGroup;
    private static final String CHK_ENABLED = Messages.PropertyEnableRadio;
    private static final String GRP_TXT = Messages.PropertyEditGroup;
    private static final String BTN_ATTR = Messages.PropertyButtonAttribute;
    private static final String BTN_CONT = Messages.PropertyButtonContext;
    private static final String BTN_SELECT_ALL = Messages.PropertyButtonSelectAll;
    private static final String BTN_DESELECT_ALL = Messages.PropertyButtonDeselectAll;
    private static final String LBL_DESCRIPTION = Messages.PropertyLabelDescription;
    private static final String TESTSTYLE_PROPERTY_PAGE = "org.eclipse.jubula.client.ua.help.testStylePropertyPageContextId";
    private Composite m_composite;
    private Button m_enabledCheckbox;
    private Group m_fullGroup;
    private CheckboxTreeViewer m_treeView;
    private Composite m_treeComposite;
    private Button m_selectAllBtn;
    private Button m_deselectAllBtn;
    private Button m_editAttrBtn;
    private Button m_editContBtn;
    private Combo m_editSeverity;
    private StyledText m_descriptionText;
    private TeststyleContentProvider m_treeContentProvider;
    private TeststyleLabelProvider m_treeLabelProvider;
    private TeststyleBoxProvider m_treeCheckProvider;
    private boolean m_enabled;

    protected Control createContents(Composite parent) {
        this.m_composite = PropUtils.createCustomComposite(parent);
        this.m_enabled = TeststyleHandler.getInstance().isEnabled();
        this.createProvider();
        this.createEnabledCheckbox();
        this.createFullGroup();
        this.createTreeComposite();
        this.createGroup();
        this.createDescriptionField();
        this.setTreeEvents();
        this.setGrpEvents();
        this.setTeststyleEnabled(this.m_enabled);
        return parent;
    }

    private void createDescriptionField() {
        Label lbl = new Label((Composite)this.m_fullGroup, 0);
        lbl.setText(LBL_DESCRIPTION);
        GridData lblData = new GridData();
        lblData.horizontalSpan = 2;
        lblData.grabExcessHorizontalSpace = true;
        lbl.setLayoutData((Object)lblData);
        this.m_descriptionText = new StyledText((Composite)this.m_fullGroup, 2122);
        this.m_descriptionText.setCursor(this.getShell().getDisplay().getSystemCursor(0));
        this.m_descriptionText.setCaret(null);
        GridData txtData = new GridData(-1, 55);
        txtData.horizontalSpan = 2;
        txtData.grabExcessHorizontalSpace = true;
        txtData.horizontalAlignment = 4;
        this.m_descriptionText.setBackground(this.getShell().getDisplay().getSystemColor(22));
        this.m_descriptionText.setLayoutData((Object)txtData);
    }

    private void createEnabledCheckbox() {
        this.m_enabledCheckbox = new Button(this.m_composite, 32);
        this.m_enabledCheckbox.setText(CHK_ENABLED);
        this.m_enabledCheckbox.setSelection(this.m_enabled);
        this.m_enabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeststyleProjectPropertyPage.this.m_enabled = TeststyleProjectPropertyPage.this.m_enabledCheckbox.getSelection();
                TeststyleProjectPropertyPage.this.setTeststyleEnabled(TeststyleProjectPropertyPage.this.m_enabled);
                TeststyleProjectPropertyPage.this.getApplyButton().setEnabled(true);
            }
        });
    }

    private void createFullGroup() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 200;
        this.m_fullGroup = new Group(this.m_composite, 0);
        this.m_fullGroup.setText(TS_GROUP);
        this.m_fullGroup.setLayout((Layout)layout);
        this.m_fullGroup.setLayoutData((Object)data);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getApplyButton().setEnabled(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, TESTSTYLE_PROPERTY_PAGE);
    }

    private void createProvider() {
        this.m_treeContentProvider = new TeststyleContentProvider();
        this.m_treeLabelProvider = new TeststyleLabelProvider();
        this.m_treeCheckProvider = new TeststyleBoxProvider();
    }

    private void createTreeComposite() {
        GridData compGridData = new GridData(4, 4, true, true);
        GridData treeGridData = new GridData(4, 4, true, true);
        treeGridData.horizontalSpan = 2;
        GridData btn1GridData = new GridData(0x1000008, 4, true, false);
        GridData btn2GridData = new GridData(0x1000008, 4, false, false);
        this.m_treeComposite = new Composite((Composite)this.m_fullGroup, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        this.m_treeComposite.setLayout((Layout)layout);
        this.m_treeComposite.setLayoutData((Object)compGridData);
        this.m_treeView = new CheckboxTreeViewer(this.m_treeComposite, 67588);
        this.m_treeView.getTree().setLayoutData((Object)treeGridData);
        this.m_selectAllBtn = new Button(this.m_treeComposite, 8);
        this.m_selectAllBtn.setText(BTN_SELECT_ALL);
        this.m_selectAllBtn.setLayoutData((Object)btn1GridData);
        this.m_deselectAllBtn = new Button(this.m_treeComposite, 8);
        this.m_deselectAllBtn.setText(BTN_DESELECT_ALL);
        this.m_deselectAllBtn.setLayoutData((Object)btn2GridData);
        this.m_treeView.setContentProvider((IContentProvider)this.m_treeContentProvider);
        this.m_treeView.setLabelProvider((IBaseLabelProvider)this.m_treeLabelProvider);
        this.m_treeView.setCheckStateProvider((ICheckStateProvider)this.m_treeCheckProvider);
        this.m_treeView.setInput((Object)PropUtils.getCategoriesAsNodes());
        this.m_treeView.setAutoExpandLevel(2);
        this.m_treeView.expandToLevel(2);
    }

    private void createGroup() {
        Composite cmp = new Composite((Composite)this.m_fullGroup, 0);
        cmp.setLayoutData((Object)new GridData(0, 4, false, false));
        cmp.setLayout((Layout)new FillLayout(512));
        Group grp = new Group(cmp, 0);
        grp.setText(GRP_TXT);
        grp.setLayout((Layout)new GridLayout(1, false));
        this.m_editAttrBtn = new Button((Composite)grp, 8);
        this.m_editAttrBtn.setText(BTN_ATTR);
        this.m_editAttrBtn.setEnabled(false);
        this.m_editContBtn = new Button((Composite)grp, 8);
        this.m_editContBtn.setText(BTN_CONT);
        this.m_editContBtn.setEnabled(false);
        this.m_editSeverity = new Combo((Composite)grp, 12);
        String[] items = new String[Severity.values().length];
        int i = 0;
        while (i < items.length) {
            items[i] = Severity.values()[i].toString();
            ++i;
        }
        this.m_editSeverity.setItems(items);
        this.m_editSeverity.setEnabled(false);
    }

    public void setTreeEvents() {
        this.m_treeView.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                INode node = (INode)event.getElement();
                if (event.getChecked()) {
                    node.setState(INode.TreeState.CHECKED);
                } else {
                    node.setState(INode.TreeState.EMPTY);
                }
                if (node instanceof CategoryNode) {
                    INode[] iNodeArray = node.getChildren();
                    int n = iNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        INode child = iNodeArray[n2];
                        TeststyleProjectPropertyPage.this.m_treeView.refresh((Object)child);
                        ++n2;
                    }
                    TeststyleProjectPropertyPage.this.m_treeView.refresh((Object)node);
                } else if (node instanceof CheckNode) {
                    TeststyleProjectPropertyPage.this.m_treeView.refresh((Object)node.getParent());
                }
                TeststyleProjectPropertyPage.this.m_treeView.setSelection((ISelection)new StructuredSelection((Object)node));
                TeststyleProjectPropertyPage.this.getApplyButton().setEnabled(true);
            }
        });
        this.m_treeView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection treeSel = (ITreeSelection)event.getSelection();
                boolean empty = treeSel.isEmpty();
                INode selected = (INode)treeSel.getFirstElement();
                boolean isEditable = !empty && selected.isEditable();
                boolean hasSeverity = !empty && selected.hasSeverity();
                TeststyleProjectPropertyPage.this.m_editAttrBtn.setEnabled(isEditable);
                TeststyleProjectPropertyPage.this.m_editContBtn.setEnabled(isEditable);
                TeststyleProjectPropertyPage.this.m_editSeverity.setEnabled(hasSeverity);
                if (hasSeverity) {
                    TeststyleProjectPropertyPage.this.m_editSeverity.setText(((CheckNode)selected).getSeverity().name());
                }
                TeststyleProjectPropertyPage.this.m_descriptionText.setText(selected.getTooltip());
            }
        });
        this.m_selectAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeststyleProjectPropertyPage.this.selectAll();
            }
        });
        this.m_deselectAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeststyleProjectPropertyPage.this.deselectAll();
            }
        });
    }

    void selectAll() {
        INode[] categories;
        INode[] iNodeArray = categories = (INode[])this.m_treeContentProvider.getElements(null);
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            INode category = iNodeArray[n2];
            category.setState(INode.TreeState.CHECKED);
            ++n2;
        }
        this.m_treeView.refresh();
        this.getApplyButton().setEnabled(true);
    }

    void deselectAll() {
        INode[] categories;
        INode[] iNodeArray = categories = (INode[])this.m_treeContentProvider.getElements(null);
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            INode category = iNodeArray[n2];
            category.setState(INode.TreeState.EMPTY);
            ++n2;
        }
        this.m_treeView.refresh();
        this.getApplyButton().setEnabled(true);
    }

    public void setGrpEvents() {
        this.m_editAttrBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITreeSelection sel = (ITreeSelection)TeststyleProjectPropertyPage.this.m_treeView.getSelection();
                CheckNode node = (CheckNode)sel.getFirstElement();
                BaseCheck check = node.getCheck();
                EditAttributeDialog dlg = new EditAttributeDialog(TeststyleProjectPropertyPage.this.getShell(), check);
                int status = dlg.open();
                if (status == 0) {
                    TeststyleProjectPropertyPage.this.getApplyButton().setEnabled(true);
                }
            }
        });
        this.m_editContBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITreeSelection sel = (ITreeSelection)TeststyleProjectPropertyPage.this.m_treeView.getSelection();
                CheckNode node = (CheckNode)sel.getFirstElement();
                BaseCheck check = node.getCheck();
                EditContextDialog dlg = new EditContextDialog(TeststyleProjectPropertyPage.this.getShell(), check);
                int status = dlg.open();
                if (status == 0) {
                    TeststyleProjectPropertyPage.this.getApplyButton().setEnabled(true);
                }
            }
        });
        this.m_editSeverity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Severity newSev = Severity.valueOf(TeststyleProjectPropertyPage.this.m_editSeverity.getText());
                ITreeSelection sel = (ITreeSelection)TeststyleProjectPropertyPage.this.m_treeView.getSelection();
                CheckNode node = (CheckNode)sel.getFirstElement();
                node.setSeverity(newSev);
                TeststyleProjectPropertyPage.this.getApplyButton().setEnabled(true);
            }
        });
    }

    protected void performApply() {
        this.okPressed();
        this.getApplyButton().setEnabled(false);
    }

    public void okPressed() {
        if (this.m_treeContentProvider != null) {
            EntityManager s = this.getEditSupport().getSession();
            IProjectPO project = GeneralStorage.getInstance().getProject();
            ICheckConfContPO cfg = (ICheckConfContPO)s.merge((Object)project.getProjectProperties().getCheckConfCont());
            cfg.setEnabled(this.m_enabled);
            this.m_treeContentProvider.save(s);
        }
    }

    public void applyData(Object data) {
        super.applyData(data);
        if (data instanceof String) {
            Object[] allExpandedElements;
            CheckNode nodeToSelect = null;
            String checkstyleID = (String)data;
            Object[] objectArray = allExpandedElements = this.m_treeView.getExpandedElements();
            int n = allExpandedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof CategoryNode) {
                    CategoryNode catNode = (CategoryNode)o;
                    INode[] iNodeArray = catNode.getChildren();
                    int n3 = iNodeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        CheckNode cn;
                        INode node = iNodeArray[n4];
                        if (node instanceof CheckNode && (cn = (CheckNode)node).getCheck().getId().equals(checkstyleID)) {
                            nodeToSelect = cn;
                            break;
                        }
                        ++n4;
                    }
                    if (nodeToSelect != null) break;
                }
                ++n2;
            }
            this.m_treeView.setSelection((ISelection)new StructuredSelection(nodeToSelect), true);
        }
    }

    protected void performDefaults() {
        INode[] categories;
        Map<String, ICheckConfPO> defaults = ExtensionHelper.getDefaults();
        INode[] iNodeArray = categories = (INode[])this.m_treeContentProvider.getElements(null);
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            INode category = iNodeArray[n2];
            INode[] iNodeArray2 = category.getChildren();
            int n3 = iNodeArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                INode child = iNodeArray2[n4];
                CheckNode checkNode = (CheckNode)child;
                ICheckConfPO defaultCfg = defaults.get(checkNode.getCheck().getId());
                ICheckConfPO currentCfg = checkNode.getCheck().getConf();
                currentCfg.setActive(defaultCfg.isActive());
                currentCfg.setSeverity(defaultCfg.getSeverity());
                currentCfg.setAttr(defaultCfg.getAttr());
                currentCfg.setContexts(defaultCfg.getContexts());
                if (checkNode.hasSeverity()) {
                    this.m_editSeverity.setText(checkNode.getSeverity().name());
                }
                ++n4;
            }
            ++n2;
        }
        this.m_treeView.refresh();
        this.getApplyButton().setEnabled(true);
    }

    private void setTeststyleEnabled(boolean enabled) {
        PropUtils.setEnabledRecursive((Control)this.m_fullGroup, enabled);
        this.m_editAttrBtn.setEnabled(false);
        this.m_editContBtn.setEnabled(false);
        this.m_editSeverity.setEnabled(false);
        this.m_treeView.getTree().setSelection(new TreeItem[0]);
    }
}

