/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import javax.persistence.EntityManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.events.InteractionEventDispatcher;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.Persistor;

public class UINodeBP {
    private UINodeBP() {
    }

    public static void setFocusAndSelection(ISelection sel, TreeViewer tv) {
        tv.getTree().setFocus();
        tv.setSelection(sel, true);
    }

    public static ISpecTestCasePO getSpecTC(IStructuredSelection structuredSel) {
        IExecTestCasePO execTc = null;
        if (structuredSel.getFirstElement() instanceof IExecTestCasePO) {
            execTc = (IExecTestCasePO)structuredSel.getFirstElement();
        } else if (structuredSel.getFirstElement() instanceof TestResultNode) {
            TestResultNode trNode = (TestResultNode)structuredSel.getFirstElement();
            INodePO nodePO = trNode.getNode();
            while (!Persistor.isPoSubclass((IPersistentObject)nodePO, IExecTestCasePO.class)) {
                if ((trNode = trNode.getParent()) == null) {
                    return null;
                }
                nodePO = trNode.getNode();
            }
            execTc = (IExecTestCasePO)nodePO;
        }
        if (execTc != null) {
            return execTc.getSpecTestCase();
        }
        return null;
    }

    public static INodePO selectNodeInTree(Long id, TreeViewer tv, EntityManager em) {
        return (INodePO)UINodeBP.selectNodeInTree(em.find(NodeMaker.getNodePOClass(), (Object)id), (AbstractTreeViewer)tv);
    }

    public static Object selectNodeInTree(Object o, AbstractTreeViewer tv) {
        ISelection oldSelection = tv.getSelection();
        if (o != null) {
            tv.refresh();
            tv.expandToLevel(o, 0);
            tv.reveal(o);
            StructuredSelection newSelection = new StructuredSelection(o);
            tv.setSelection((ISelection)newSelection);
            InteractionEventDispatcher.getDefault().fireProgammableSelectionEvent((IStructuredSelection)newSelection);
            ISelection currSelection = tv.getSelection();
            if (currSelection instanceof StructuredSelection) {
                Object currObj = ((StructuredSelection)currSelection).getFirstElement();
                IElementComparer comparer = tv.getComparer();
                if (comparer != null ? comparer.equals(o, currObj) : o.equals(currObj)) {
                    return o;
                }
            }
        }
        tv.setSelection(oldSelection);
        return null;
    }
}

