/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.propertysources;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.IntegerTextPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.JBPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractNodePropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.ExecTestCaseGUIPropertySource;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.DisabledLabelProvider;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class EventExecTestCaseGUIPropertySource
extends ExecTestCaseGUIPropertySource {
    private static final String P_EVHANDLER_DISPLAY_NAME = Messages.EventExecTestCaseGUIPropertySourceEventHandlerName;
    private static final String P_ELEMENT_DISPLAY_EVENTTYPE = Messages.EventExecTestCaseGUIPropertySourceEventType;
    private static final String P_ELEMENT_DISPLAY_REENTRYTYPE = Messages.EventExecTestCaseGUIPropertySourceReentryType;
    private static final String P_ELEMENT_DISPLAY_MAXRETRIES = Messages.EventExecTestCaseGUIPropertySourceMaxRetries;
    private static final String[] EVENT_TYPES = EventExecTestCaseGUIPropertySource.initEventTypes();
    private static String[] reentryTypes = EventExecTestCaseGUIPropertySource.initReentryTypes();
    private IPropertyDescriptor m_namePropDesc = null;
    private IPropertyDescriptor m_specNamePropDesc = null;
    private IPropertyDescriptor m_eventTypePropDesc = null;
    private IPropertyDescriptor m_reentryTypePropDesc = null;
    private IPropertyDescriptor m_maxRetriesPropDesc = null;
    private IPropertyDescriptor m_commentPropDesc = null;

    public EventExecTestCaseGUIPropertySource(IEventExecTestCasePO eventExTestCase) {
        super((IExecTestCasePO)eventExTestCase);
    }

    private static String[] initEventTypes() {
        Set mapKeySet = ComponentBuilder.getInstance().getCompSystem().getEventTypes().keySet();
        String[] eventTypes = new String[mapKeySet.size()];
        int i = 0;
        Map stringHelperMap = StringHelper.getInstance().getMap();
        for (Object object : mapKeySet) {
            eventTypes[i] = (String)stringHelperMap.get(object.toString());
            ++i;
        }
        return eventTypes;
    }

    static String[] initReentryTypes() {
        ReentryProperty[] reentryProperties = ReentryProperty.REENTRY_PROP_ARRAY;
        int reentryPropertiesLength = reentryProperties.length;
        reentryTypes = new String[reentryPropertiesLength];
        int i = 0;
        while (i < reentryPropertiesLength) {
            EventExecTestCaseGUIPropertySource.reentryTypes[i] = reentryProperties[i].toString();
            ++i;
        }
        return reentryTypes;
    }

    protected void initPropDescriptor() {
        JBPropertyDescriptor cbpd;
        this.clearPropertyDescriptors();
        this.createNamePropertyDescriptor();
        this.createSpecNamePropertyDescriptor();
        this.createCommentPropertyDescriptor();
        this.createTaskIdPropertyDescriptor();
        if (this.m_eventTypePropDesc == null) {
            cbpd = new JBPropertyDescriptor(new EventTypeController(), P_ELEMENT_DISPLAY_EVENTTYPE);
            cbpd.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Integer) {
                        return EVENT_TYPES[(Integer)element];
                    }
                    Assert.notReached((String)(String.valueOf(Messages.WrongTypeOfElement) + "!"));
                    return String.valueOf(element);
                }
            });
            this.m_eventTypePropDesc = cbpd;
        }
        this.addPropertyDescriptor(this.m_eventTypePropDesc);
        if (this.m_reentryTypePropDesc == null) {
            cbpd = new ComboBoxPropertyDescriptor((Object)new ReentryTypeController(), P_ELEMENT_DISPLAY_REENTRYTYPE, reentryTypes);
            cbpd.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Integer) {
                        return reentryTypes[(Integer)element];
                    }
                    Assert.notReached((String)"Wrong element type!");
                    return String.valueOf(element);
                }
            });
            this.m_reentryTypePropDesc = cbpd;
        }
        this.addPropertyDescriptor(this.m_reentryTypePropDesc);
        if (this.m_maxRetriesPropDesc == null) {
            this.m_maxRetriesPropDesc = new IntegerTextPropertyDescriptor(new MaxRetriesController(), P_ELEMENT_DISPLAY_MAXRETRIES, false, 1, Integer.MAX_VALUE);
        }
        if (((IEventExecTestCasePO)this.getPoNode()).getReentryProp().equals((Object)ReentryProperty.RETRY)) {
            this.addPropertyDescriptor(this.m_maxRetriesPropDesc);
        }
        this.addPropertyDescriptor(super.createParamDescriptors());
    }

    private void createTaskIdPropertyDescriptor() {
        if (this.getTaskIdPropDesc() == null) {
            JBPropertyDescriptor taskIdPropDesc = new JBPropertyDescriptor(new AbstractNodePropertySource.ReadOnlyTaskIdController(this), Messages.AbstractGuiNodePropertySourceTaskId);
            taskIdPropDesc.setLabelProvider((ILabelProvider)new DisabledLabelProvider());
            this.setTaskIdPropDesc((IPropertyDescriptor)taskIdPropDesc);
        }
        this.addPropertyDescriptor(this.getTaskIdPropDesc());
    }

    private void createCommentPropertyDescriptor() {
        if (this.m_commentPropDesc == null) {
            this.m_commentPropDesc = new TextPropertyDescriptor((Object)new AbstractNodePropertySource.CommentController(this), P_ELEMENT_DISPLAY_COMMENT);
        }
        this.addPropertyDescriptor(this.m_commentPropDesc);
    }

    private void createSpecNamePropertyDescriptor() {
        if (this.m_specNamePropDesc == null) {
            JBPropertyDescriptor propDes = new JBPropertyDescriptor(new ExecTestCaseGUIPropertySource.SpecNameController(this), P_SPECNAME_DISPLAY_NAME);
            propDes.setLabelProvider((ILabelProvider)new DisabledLabelProvider());
            this.m_specNamePropDesc = propDes;
        }
        this.addPropertyDescriptor(this.m_specNamePropDesc);
    }

    private void createNamePropertyDescriptor() {
        if (this.m_namePropDesc == null) {
            this.m_namePropDesc = new TextPropertyDescriptor((Object)new ExecTestCaseGUIPropertySource.ExecNameController(this), P_EVHANDLER_DISPLAY_NAME);
        }
        this.addPropertyDescriptor(this.m_namePropDesc);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EventTypeController
    extends AbstractPropertySource.AbstractPropertyController {
        public boolean setProperty(Object value) {
            boolean propSet = false;
            IEventExecTestCasePO eventTc = (IEventExecTestCasePO)EventExecTestCaseGUIPropertySource.this.getPoNode();
            String oldType = eventTc.getEventType();
            ISpecTestCasePO specTc = (ISpecTestCasePO)eventTc.getParentNode();
            specTc.removeNode((INodePO)eventTc);
            String evType = EVENT_TYPES[(Integer)value];
            evType = (String)StringHelper.getInstance().getMap().get(evType);
            eventTc.setEventType(evType);
            try {
                specTc.addEventTestCase(eventTc);
                propSet = true;
            }
            catch (InvalidDataException e) {
                ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), null, null);
                eventTc.setEventType(oldType);
                try {
                    specTc.addEventTestCase(eventTc);
                }
                catch (InvalidDataException e1) {
                    ErrorHandlingUtil.createMessageDialog((JBException)((Object)e1), null, null);
                }
            }
            return propSet;
        }

        public Object getProperty() {
            return this.getIndexOfType();
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }

        private Integer getIndexOfType() {
            IEventExecTestCasePO eventTc = (IEventExecTestCasePO)EventExecTestCaseGUIPropertySource.this.getPoNode();
            int eventTypesLength = EVENT_TYPES.length;
            String ehEventType = (String)StringHelper.getInstance().getMap().get(eventTc.getEventType());
            int i = 0;
            while (i < eventTypesLength) {
                if (EVENT_TYPES[i].equals(ehEventType)) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MaxRetriesController
    extends AbstractPropertySource.AbstractPropertyController {
        private MaxRetriesController() {
        }

        public boolean setProperty(Object value) {
            IEventExecTestCasePO eventTc = (IEventExecTestCasePO)EventExecTestCaseGUIPropertySource.this.getPoNode();
            Integer intValue = null;
            if (value instanceof Integer) {
                intValue = (Integer)value;
            } else if (value instanceof String) {
                try {
                    intValue = Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            } else {
                return false;
            }
            if (intValue >= 1 && intValue <= Integer.MAX_VALUE) {
                if (intValue.equals(eventTc.getMaxRetries())) {
                    return false;
                }
                eventTc.setMaxRetries(intValue);
                return true;
            }
            return false;
        }

        public Object getProperty() {
            IEventExecTestCasePO eventTc = (IEventExecTestCasePO)EventExecTestCaseGUIPropertySource.this.getPoNode();
            return String.valueOf(eventTc.getMaxRetries());
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReentryTypeController
    extends AbstractPropertySource.AbstractPropertyController {
        public boolean setProperty(Object value) {
            IEventExecTestCasePO eventTc = (IEventExecTestCasePO)EventExecTestCaseGUIPropertySource.this.getPoNode();
            ReentryProperty prop = ReentryProperty.REENTRY_PROP_ARRAY[(Integer)value];
            ReentryProperty oldProp = eventTc.getReentryProp();
            eventTc.setReentryProp(prop);
            if (oldProp.equals((Object)ReentryProperty.RETRY) && !prop.equals((Object)ReentryProperty.RETRY)) {
                eventTc.setMaxRetries(null);
            } else if (!oldProp.equals((Object)ReentryProperty.RETRY) && prop.equals((Object)ReentryProperty.RETRY)) {
                eventTc.setMaxRetries(Integer.valueOf(1));
            }
            return true;
        }

        public Object getProperty() {
            return this.getIndexOfType();
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }

        private Integer getIndexOfType() {
            IEventExecTestCasePO eventTc = (IEventExecTestCasePO)EventExecTestCaseGUIPropertySource.this.getPoNode();
            int reentryTypesLength = reentryTypes.length;
            int i = 0;
            while (i < reentryTypesLength) {
                if (ReentryProperty.REENTRY_PROP_ARRAY[i].equals((Object)eventTc.getReentryProp())) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
    }
}

