/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jubula.client.core.businessprocess.CompNameResult;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IObjectMappingObserver;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.businessprocess.db.TimestampBP;
import org.eclipse.jubula.client.core.commands.AUTModeChangedCommand;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IComponentNameReuser;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IObjectMappingProfilePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.ITimestampPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.CompletenessBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.OMEditorBP;
import org.eclipse.jubula.client.ui.rcp.controllers.ComponentNameTreeViewerUpdater;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.LimitingDragSourceListener;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.OMDropTargetListener;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.OMEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.dialogs.NagDialog;
import org.eclipse.jubula.client.ui.rcp.editingsupport.AbstractObjectMappingEditingSupport;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingConfigComponent;
import org.eclipse.jubula.client.ui.rcp.editors.PersistableEditorInput;
import org.eclipse.jubula.client.ui.rcp.editors.PersistentObjectComparer;
import org.eclipse.jubula.client.ui.rcp.events.GuiEventDispatcher;
import org.eclipse.jubula.client.ui.rcp.filter.JBFilteredTree;
import org.eclipse.jubula.client.ui.rcp.filter.ObjectMappingEditorPatternFilter;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.objectmapping.OMEditorTableContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.objectmapping.OMEditorTreeContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.objectmapping.ObjectMappingRow;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.OMEditorTreeLabelProvider;
import org.eclipse.jubula.client.ui.rcp.provider.selectionprovider.SelectionProviderIntermediate;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.views.ColumnSortListener;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.client.ui.views.IMultiTreeViewerContainer;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.xml.businessmodell.ConcreteComponent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.swt.IFocusService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMappingMultiPageEditor
extends MultiPageEditorPart
implements IJBPart,
IJBEditor,
IObjectMappingObserver,
GuiEventDispatcher.IEditorDirtyStateListener,
IMultiTreeViewerContainer,
IPropertyListener {
    public static final String CLEANUP_ID = "org.eclipse.ui.CleanupSubMenu";
    private static final Logger LOG = LoggerFactory.getLogger(ObjectMappingMultiPageEditor.class);
    private static final String CAT_SEPARATOR = "/";
    private static final int SPLIT_PAGE_IDX = 0;
    private static final int TREE_PAGE_IDX = 1;
    private static final int TABLE_PAGE_IDX = 2;
    private JBEditorHelper m_editorHelper;
    private OMEditorBP m_omEditorBP;
    private TreeViewer m_compNameTreeViewer;
    private TreeViewer m_uiElementTreeViewer;
    private TreeViewer m_mappedComponentTreeViewer;
    private TreeViewer m_treeViewer;
    private TableViewer m_tableViewer;
    private ObjectMappingConfigComponent m_mappingConfigComponent;
    private ComponentNameTreeViewerUpdater m_treeViewerUpdater;
    private Map<Integer, ISelectionProvider> m_pageToSelectionProvider = new HashMap<Integer, ISelectionProvider>();
    private SelectionProviderIntermediate m_selectionProvider;
    private TreeViewer m_activeTreeViewer = null;
    private Text m_treeFilterText;
    private SelectionProviderIntermediate m_splitPaneSelectionProvider;

    protected void createPages() {
        if (this.m_editorHelper == null) {
            this.m_editorHelper = new JBEditorHelper(this);
        }
        this.m_omEditorBP = new OMEditorBP(this);
        IObjectMappingPO objMap = this.getAut().getObjMap();
        if (objMap == null) {
            objMap = PoMaker.createObjectMappingPO();
            this.getAut().setObjMap(objMap);
        }
        this.checkMasterSessionUpToDate();
        MenuManager menuMgr = this.createContextMenu();
        GuiEventDispatcher.getInstance().addEditorDirtyStateListener(this, true);
        this.getEditorHelper().addListeners();
        this.getOmEditorBP().collectNewLogicalComponentNames();
        int splitPaneViewIndex = this.addPage(this.createSplitPanePageControl(this.getContainer(), menuMgr));
        int treeViewIndex = this.addPage(this.createTreePageControl(this.getContainer(), menuMgr));
        int tableViewIndex = this.addPage(this.createTablePageControl(this.getContainer()));
        int configViewIndex = this.addPage(this.createConfigPageControl(this.getContainer()));
        this.setPageText(splitPaneViewIndex, Messages.ObjectMappingEditorSplitPaneView);
        this.setPageText(treeViewIndex, Messages.ObjectMappingEditorTreeView);
        this.setPageText(tableViewIndex, Messages.ObjectMappingEditorTableView);
        this.setPageText(configViewIndex, Messages.ObjectMappingEditorConfigView);
        this.m_pageToSelectionProvider.put(splitPaneViewIndex, (ISelectionProvider)this.m_splitPaneSelectionProvider);
        this.m_pageToSelectionProvider.put(treeViewIndex, (ISelectionProvider)this.m_treeViewer);
        this.m_pageToSelectionProvider.put(tableViewIndex, (ISelectionProvider)this.m_tableViewer);
        this.m_pageToSelectionProvider.put(configViewIndex, new NullSelectionProvider());
        this.m_selectionProvider = new SelectionProviderIntermediate();
        this.m_selectionProvider.setSelectionProviderDelegate(this.m_pageToSelectionProvider.get(this.getActivePage()));
        this.getSite().setSelectionProvider((ISelectionProvider)this.m_selectionProvider);
        this.getEditorSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_selectionProvider);
        ObjectMappingEventDispatcher.addObserver((IObjectMappingObserver)this);
        this.m_treeViewerUpdater = new ComponentNameTreeViewerUpdater(this.m_treeViewer);
        this.checkAndFixInconsistentData();
        this.m_treeViewer.expandToLevel(2);
    }

    private MenuManager createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        return menuMgr;
    }

    private void checkAndFixInconsistentData() {
        boolean isChanged = false;
        IObjectMappingPO objMap = this.getAut().getObjMap();
        IWritableComponentNameCache compNameCache = this.getEditorHelper().getEditSupport().getCompMapper().getCompNameCache();
        isChanged |= this.fixCompNameReferences(objMap, (IComponentNameCache)compNameCache);
        if (isChanged |= this.removeDeletedCompNames(objMap, (IComponentNameCache)compNameCache)) {
            try {
                EditSupport editSupport = this.m_editorHelper.getEditSupport();
                editSupport.lockWorkVersion();
                this.m_editorHelper.setDirty(true);
                this.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            catch (PMAlreadyLockedException pMAlreadyLockedException) {
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
        }
    }

    private boolean removeDeletedCompNames(IObjectMappingPO objectMap, IComponentNameCache compNameCache) {
        boolean isChanged = false;
        HashSet<IObjectMappingAssoziationPO> assocsToDelete = new HashSet<IObjectMappingAssoziationPO>();
        for (IObjectMappingAssoziationPO assoc : objectMap.getMappings()) {
            if (assoc.getTechnicalName() != null) continue;
            HashSet<String> compNamesToRemove = new HashSet<String>();
            for (String compNameGuid : assoc.getLogicalNames()) {
                if (compNameCache.getCompNamePo(compNameGuid) != null) continue;
                compNamesToRemove.add(compNameGuid);
            }
            for (String toRemove : compNamesToRemove) {
                assoc.removeLogicalName(toRemove);
                isChanged = true;
            }
            if (!assoc.getLogicalNames().isEmpty()) continue;
            isChanged = true;
            assocsToDelete.add(assoc);
        }
        for (IObjectMappingAssoziationPO assoc : assocsToDelete) {
            assoc.getCategory().removeAssociation(assoc);
            this.getEditorHelper().getEditSupport().getSession().remove((Object)assoc);
        }
        return isChanged;
    }

    private Control createConfigPageControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        Composite configComposite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        configComposite.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        configComposite.setLayout((Layout)layout);
        this.m_mappingConfigComponent = new ObjectMappingConfigComponent(configComposite, this.getAut().getObjMap(), this);
        this.createConfigContextMenu(configComposite);
        return configComposite;
    }

    private Control createTreePageControl(Composite parent, MenuManager contextMenuMgr) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        SashForm treeComp = new SashForm(parent, 2);
        GridLayout compLayout = new GridLayout(1, false);
        compLayout.marginWidth = 0;
        compLayout.marginHeight = 0;
        treeComp.setLayout((Layout)compLayout);
        GridData gridData = new GridData(1808);
        treeComp.setLayoutData((Object)gridData);
        JBFilteredTree ft = new JBFilteredTree((Composite)treeComp, 2818, (PatternFilter)new ObjectMappingEditorPatternFilter(), true);
        this.m_treeViewer = ft.getViewer();
        this.setTreeFilterText(ft.getFilterControl());
        ObjectMappingMultiPageEditor.setProviders((AbstractTreeViewer)this.m_treeViewer, this.getCompMapper());
        this.m_treeViewer.setUseHashlookup(true);
        this.m_treeViewer.setSorter((ViewerSorter)new ObjectMappingTreeSorter());
        this.m_treeViewer.setComparer((IElementComparer)new PersistentObjectComparer());
        int ops = 2;
        Transfer[] transfers = new Transfer[]{org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer.getInstance()};
        this.m_treeViewer.addDragSupport(ops, transfers, (DragSourceListener)new LimitingDragSourceListener((ISelectionProvider)this.m_treeViewer, this.getAut()));
        this.m_treeViewer.addDropSupport(ops, transfers, (DropTargetListener)new OMDropTargetListener(this, (Viewer)this.m_treeViewer));
        this.m_omEditorBP = new OMEditorBP(this);
        this.m_treeViewer.setAutoExpandLevel(2);
        this.m_treeViewer.setInput((Object)this.getAut().getObjMap());
        this.createTreeContextMenu(this.m_treeViewer, contextMenuMgr);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.objectMapEditorContextId");
        FocusAdapter activeTreeListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ObjectMappingMultiPageEditor.this.m_activeTreeViewer = ObjectMappingMultiPageEditor.this.m_treeViewer;
            }
        };
        this.m_treeViewer.getTree().addFocusListener((FocusListener)activeTreeListener);
        ft.getFilterControl().addFocusListener((FocusListener)activeTreeListener);
        return treeComp;
    }

    private Control createSplitPanePageControl(Composite parent, MenuManager contextMenuMgr) {
        this.m_splitPaneSelectionProvider = new SelectionProviderIntermediate();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        SashForm mainSash = new SashForm(parent, 512);
        SashForm topSash = new SashForm((Composite)mainSash, 256);
        this.m_compNameTreeViewer = this.createSplitPaneViewer((Composite)topSash, "ObjectMappingEditor.UnAssignedLogic", this.getAut().getObjMap().getUnmappedLogicalCategory(), contextMenuMgr);
        this.m_splitPaneSelectionProvider.setSelectionProviderDelegate((ISelectionProvider)this.m_compNameTreeViewer);
        this.m_uiElementTreeViewer = this.createSplitPaneViewer((Composite)topSash, "ObjectMappingEditor.UnAssignedTech", this.getAut().getObjMap().getUnmappedTechnicalCategory(), contextMenuMgr);
        this.m_mappedComponentTreeViewer = this.createSplitPaneViewer((Composite)mainSash, "ObjectMappingEditor.Assigned", this.getAut().getObjMap().getMappedCategory(), contextMenuMgr);
        this.linkSelection(new TreeViewer[]{this.m_compNameTreeViewer, this.m_uiElementTreeViewer, this.m_mappedComponentTreeViewer});
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.objectMapEditorContextId");
        return mainSash;
    }

    private void linkSelection(final TreeViewer[] treeViewersToLink) {
        TreeViewer[] treeViewerArray = treeViewersToLink;
        int n = treeViewersToLink.length;
        int n2 = 0;
        while (n2 < n) {
            final TreeViewer viewer = treeViewerArray[n2];
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                        ObjectMappingMultiPageEditor.this.m_splitPaneSelectionProvider.setSelectionProviderDelegate((ISelectionProvider)viewer);
                        TreeViewer[] treeViewerArray = treeViewersToLink;
                        int n = treeViewersToLink.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeViewer viewerToDeselect = treeViewerArray[n2];
                            if (viewer != viewerToDeselect) {
                                viewerToDeselect.setSelection((ISelection)StructuredSelection.EMPTY);
                            }
                            ++n2;
                        }
                    }
                }
            });
            ++n2;
        }
    }

    private TreeViewer createSplitPaneViewer(Composite parent, String title, IObjectMappingCategoryPO topLevelCategory, MenuManager contextMenuMgr) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(I18n.getString((String)title));
        titleLabel.setLayoutData((Object)GridDataFactory.defaultsFor((Control)titleLabel).create());
        final TreeViewer viewer = new TreeViewer(composite);
        viewer.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        ObjectMappingMultiPageEditor.setProviders((AbstractTreeViewer)viewer, this.getCompMapper());
        viewer.setUseHashlookup(true);
        viewer.setSorter((ViewerSorter)new ObjectMappingTreeSorter());
        viewer.setComparer((IElementComparer)new PersistentObjectComparer());
        viewer.setInput((Object)topLevelCategory);
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        viewer.addDragSupport(2, transfers, (DragSourceListener)new LimitingDragSourceListener((ISelectionProvider)viewer, this.getAut()));
        viewer.addDropSupport(2, transfers, (DropTargetListener)new OMDropTargetListener(this, (Viewer)viewer));
        this.createTreeContextMenu(viewer, contextMenuMgr);
        DialogUtils.setWidgetName((Widget)viewer.getTree(), (String)title);
        IFocusService focusService = (IFocusService)this.getSite().getService(IFocusService.class);
        focusService.addFocusTracker((Control)viewer.getTree(), title);
        viewer.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ObjectMappingMultiPageEditor.this.m_activeTreeViewer = viewer;
            }
        });
        return viewer;
    }

    public void setTreeFilterText(Text treeFilterText) {
        this.m_treeFilterText = treeFilterText;
    }

    public Text getTreeFilterText() {
        return this.m_treeFilterText;
    }

    private void createTreeContextMenu(TreeViewer viewer, MenuManager menuMgr) {
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    private void createConfigContextMenu(Composite configComposite) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectMappingMultiPageEditor.this.fillConfigContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)configComposite);
        this.setConfigContextMenu((Control)configComposite, menu);
    }

    private void setConfigContextMenu(Control control, Menu menu) {
        control.setMenu(menu);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setConfigContextMenu(child, menu);
                ++n2;
            }
        }
    }

    protected void fillConfigContextMenu(IMenuManager mgr) {
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.RevertChanges");
    }

    private void createTableContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectMappingMultiPageEditor.this.fillTableContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
    }

    protected void fillTableContextMenu(IMenuManager mgr) {
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.RevertChanges");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.ui.file.refresh");
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private Control createTablePageControl(Composite parent) {
        this.m_tableViewer = new TableViewer(parent, 68352);
        this.addLogicalNameColumn(this.m_tableViewer);
        this.addTechNameColumn(this.m_tableViewer);
        this.addCategoryColumn(this.m_tableViewer);
        this.addCompTypeColumn(this.m_tableViewer);
        TableViewerEditor.create((TableViewer)this.m_tableViewer, (ColumnViewerEditorActivationStrategy)new OMTableEditorActivationStrategy(this.m_tableViewer), (int)26);
        this.m_tableViewer.setContentProvider((IContentProvider)new OMEditorTableContentProvider());
        this.m_tableViewer.getTable().setLinesVisible(true);
        this.m_tableViewer.getTable().setHeaderVisible(true);
        TableColumn sortColumn = this.m_tableViewer.getTable().getColumn(0);
        this.m_tableViewer.getTable().setSortColumn(sortColumn);
        this.m_tableViewer.getTable().setSortDirection(1024);
        ColumnSortListener sortListener = new ColumnSortListener(this.m_tableViewer, sortColumn);
        TableColumn[] tableColumnArray = this.m_tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.addSelectionListener((SelectionListener)sortListener);
            ++n2;
        }
        this.m_tableViewer.setUseHashlookup(true);
        this.m_tableViewer.setInput((Object)this.getAut().getObjMap());
        this.createTableContextMenu();
        return this.m_tableViewer.getControl();
    }

    private TableViewerColumn addCompTypeColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(Messages.ObjectMappingEditorComponentType);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ObjectMappingRow row = (ObjectMappingRow)element;
                IObjectMappingAssoziationPO assoc = row.getAssociation();
                String text = "";
                if (row.getLogicalNameIndex() != -1) {
                    String compNameGuid = (String)assoc.getLogicalNames().get(row.getLogicalNameIndex());
                    IComponentNamePO compName = ObjectMappingMultiPageEditor.this.getCompMapper().getCompNameCache().getCompNamePo(compNameGuid);
                    text = compName != null ? CompSystemI18n.getString((String)compName.getComponentType()) : CompSystemI18n.getString((String)"CompNamesView.errorText");
                }
                return text;
            }
        });
        return column;
    }

    private TableViewerColumn addCategoryColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setImage(IconConstants.CATEGORY_IMAGE);
        column.getColumn().setText(Messages.ObjectMappingEditorCategory);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ObjectMappingRow row = (ObjectMappingRow)element;
                ArrayList<String> catPath = new ArrayList<String>();
                IObjectMappingCategoryPO category = row.getAssociation().getCategory();
                while (category != null) {
                    catPath.add(0, category.getName());
                    category = category.getParent();
                }
                StringBuilder sb = new StringBuilder();
                Iterator it = catPath.iterator();
                if (it.hasNext()) {
                    it.next();
                }
                while (it.hasNext()) {
                    sb.append(ObjectMappingMultiPageEditor.CAT_SEPARATOR).append((String)it.next());
                }
                return sb.toString();
            }
        });
        return column;
    }

    private TableViewerColumn addLogicalNameColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setImage(IconConstants.LOGICAL_NAME_IMAGE);
        column.getColumn().setText(Messages.ObjectMappingEditorLogicalName);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ObjectMappingRow row = (ObjectMappingRow)element;
                int logicalNameIndex = row.getLogicalNameIndex();
                if (logicalNameIndex < 0) {
                    return null;
                }
                return ObjectMappingMultiPageEditor.this.getCompMapper().getCompNameCache().getName((String)row.getAssociation().getLogicalNames().get(logicalNameIndex));
            }
        });
        column.setEditingSupport((EditingSupport)new ObjectMappingCompNameEditingSupport((IComponentNameMapper)this.getCompMapper(), tableViewer));
        return column;
    }

    private TableViewerColumn addTechNameColumn(final TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setImage(IconConstants.TECHNICAL_NAME_IMAGE);
        column.getColumn().setText(Messages.ObjectMappingEditorTechnicalName);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IObjectMappingAssoziationPO assoc = ((ObjectMappingRow)element).getAssociation();
                ICompIdentifierPO compId = assoc.getTechnicalName();
                return compId != null ? compId.getComponentName() : null;
            }

            public Color getBackground(Object element) {
                IObjectMappingAssoziationPO assoc = ((ObjectMappingRow)element).getAssociation();
                IComponentIdentifier compId = assoc.getCompIdentifier();
                switch (OMEditorTreeLabelProvider.getQualitySeverity(compId)) {
                    case 0: {
                        return tableViewer.getTable().getDisplay().getSystemColor(5);
                    }
                    case 2: {
                        return tableViewer.getTable().getDisplay().getSystemColor(7);
                    }
                    case 4: {
                        return tableViewer.getTable().getDisplay().getSystemColor(3);
                    }
                }
                return null;
            }
        });
        return column;
    }

    /*
     * Loose catch block
     */
    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask(Messages.EditorsSaveEditors, -1);
        boolean errorOccured = false;
        IObjectMappingPO objMap = this.getAut().getObjMap();
        TimestampBP.refreshTimestamp((ITimestampPO)objMap);
        try {
            try {
                if (this.getEditorHelper().isDirty()) {
                    EditSupport editSupport = this.getEditorHelper().getEditSupport();
                    IObjectMappingProfilePO origProfile = ((IAUTMainPO)editSupport.getOriginal()).getObjMap().getProfile();
                    IObjectMappingProfilePO workProfile = ((IAUTMainPO)editSupport.getWorkVersion()).getObjMap().getProfile();
                    IWritableComponentNameCache compNameCache = editSupport.getCompMapper().getCompNameCache();
                    HashSet<IComponentNamePO> renamedCompNames = new HashSet<IComponentNamePO>(compNameCache.getRenamedNames());
                    Set<IComponentNamePO> reuseChangedCompNames = this.getCompNamesWithChangedReuse(compNameCache);
                    this.fixCompNameReferences(this.getAut().getObjMap(), (IComponentNameCache)this.getEditorHelper().getEditSupport().getCompMapper().getCompNameCache());
                    editSupport.saveWorkVersion();
                    this.fireRenamedEvents(renamedCompNames);
                    this.fireReuseChangedEvents(reuseChangedCompNames);
                    if (this.getAut().equals(TestExecution.getInstance().getConnectedAut()) && !workProfile.equals(origProfile)) {
                        NagDialog.runNagDialog(Plugin.getActiveWorkbenchWindowShell(), "InfoNagger.ObjectMappingProfileChanged", "org.eclipse.jubula.client.ua.help.objectMapEditorContextId");
                    }
                }
                ComponentNamesBP.getInstance().init();
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForEditor(e, this);
                errorOccured = true;
                monitor.done();
                if (!errorOccured) {
                    try {
                        this.reOpenEditor(((PersistableEditorInput)this.getEditorInput()).getNode());
                    }
                    catch (PMException e2) {
                        PMExceptionHandler.handlePMExceptionForEditor(e2, this);
                    }
                }
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleProjectDeletedException();
                errorOccured = true;
                monitor.done();
                if (!errorOccured) {
                    try {
                        this.reOpenEditor(((PersistableEditorInput)this.getEditorInput()).getNode());
                    }
                    catch (PMException e) {
                        PMExceptionHandler.handlePMExceptionForEditor(e, this);
                    }
                }
            }
            catch (IncompatibleTypeException ite) {
                ErrorHandlingUtil.createMessageDialog((JBException)((Object)ite), (Object[])ite.getErrorMessageParams(), null);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                monitor.done();
                if (!errorOccured) {
                    try {
                        this.reOpenEditor(((PersistableEditorInput)this.getEditorInput()).getNode());
                    }
                    catch (PMException e) {
                        PMExceptionHandler.handlePMExceptionForEditor(e, this);
                    }
                }
            }
        }
        finally {
            monitor.done();
            if (!errorOccured) {
                try {
                    this.reOpenEditor(((PersistableEditorInput)this.getEditorInput()).getNode());
                }
                catch (PMException e) {
                    PMExceptionHandler.handlePMExceptionForEditor(e, this);
                }
            }
        }
    }

    private Set<IComponentNamePO> getCompNamesWithChangedReuse(IWritableComponentNameCache compNameCache) {
        HashSet<IComponentNamePO> reuseChangedCompNames = new HashSet<IComponentNamePO>();
        for (String compNameGuid : compNameCache.getReusedNames()) {
            IComponentNamePO compName = compNameCache.getCompNamePo(compNameGuid);
            if (compName == null) continue;
            reuseChangedCompNames.add(compName);
        }
        return reuseChangedCompNames;
    }

    private void fireReuseChangedEvents(Set<IComponentNamePO> reuseChangedCompNames) {
        ArrayList<DataChangedEvent> events = new ArrayList<DataChangedEvent>();
        for (IComponentNamePO compName : reuseChangedCompNames) {
            events.add(new DataChangedEvent((IPersistentObject)compName, DataEventDispatcher.DataState.ReuseChanged, DataEventDispatcher.UpdateState.all));
        }
        DataEventDispatcher.getInstance().fireDataChangedListener(events.toArray(new DataChangedEvent[0]));
    }

    private void fireRenamedEvents(Set<IComponentNamePO> renamedCompNames) {
        ArrayList<DataChangedEvent> events = new ArrayList<DataChangedEvent>();
        for (IComponentNamePO compName : renamedCompNames) {
            events.add(new DataChangedEvent((IPersistentObject)compName, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.all));
        }
        DataEventDispatcher.getInstance().fireDataChangedListener(events.toArray(new DataChangedEvent[0]));
    }

    private boolean fixCompNameReferences(IObjectMappingPO objectMap, IComponentNameCache compNameCache) {
        boolean isChanged = false;
        for (IObjectMappingAssoziationPO assoc : objectMap.getMappings()) {
            HashSet<String> guidsToRemove = new HashSet<String>();
            for (String compNameGuid : assoc.getLogicalNames()) {
                IComponentNamePO compNamePo = compNameCache.getCompNamePo(compNameGuid);
                if (compNamePo == null || compNamePo.getGuid().equals(compNameGuid)) continue;
                guidsToRemove.add(compNameGuid);
            }
            for (String toRemove : guidsToRemove) {
                isChanged = true;
                assoc.removeLogicalName(toRemove);
            }
        }
        if (isChanged) {
            CompNamePM.removeUnusedCompNames((Long)GeneralStorage.getInstance().getProject().getId(), (EntityManager)this.getEditorHelper().getEditSupport().getSession());
        }
        return isChanged;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public IAUTMainPO getAut() {
        return (IAUTMainPO)this.getEditorHelper().getEditSupport().getWorkVersion();
    }

    private void checkMasterSessionUpToDate() {
        IObjectMappingPO objMap = this.getAut().getObjMap();
        boolean isUpToDate = TimestampBP.refreshEditorNodeInMasterSession((ITimestampPO)objMap);
        if (!isUpToDate) {
            CompletenessBP.getInstance().completeProjectCheck();
        }
    }

    @Override
    public Image getDisabledTitleImage() {
        return IconConstants.DISABLED_OM_EDITOR_IMAGE;
    }

    @Override
    public Composite getParentComposite() {
        return this.getContainer().getParent();
    }

    @Override
    public void reOpenEditor(IPersistentObject obj) throws PMException {
        this.getEditorHelper().setDirty(false);
        Object[] expandedElements = this.m_treeViewer.getExpandedElements();
        this.getEditorHelper().getEditSupport().close();
        PersistableEditorInput input = new PersistableEditorInput(obj);
        try {
            this.init(this.getEditorSite(), input);
            this.m_selectionProvider.setSelectionProviderDelegate(this.m_pageToSelectionProvider.get(this.getActivePage()));
            this.getSite().setSelectionProvider((ISelectionProvider)this.m_selectionProvider);
            this.m_treeViewerUpdater = new ComponentNameTreeViewerUpdater(this.m_treeViewer);
            ObjectMappingMultiPageEditor.setProviders((AbstractTreeViewer)this.m_treeViewer, this.getCompMapper());
            IObjectMappingPO om = this.getAut().getObjMap();
            this.m_treeViewer.setInput((Object)om);
            this.m_treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            this.m_tableViewer.setInput((Object)om);
            this.m_treeViewer.setExpandedElements(expandedElements);
            this.m_treeViewer.expandToLevel(2);
            this.m_mappingConfigComponent.setInput(om);
            HashMap<TreeViewer, IObjectMappingCategoryPO> viewerToInput = new HashMap<TreeViewer, IObjectMappingCategoryPO>();
            viewerToInput.put(this.m_compNameTreeViewer, om.getUnmappedLogicalCategory());
            viewerToInput.put(this.m_uiElementTreeViewer, om.getUnmappedTechnicalCategory());
            viewerToInput.put(this.m_mappedComponentTreeViewer, om.getMappedCategory());
            for (TreeViewer splitViewer : viewerToInput.keySet()) {
                Object[] expandedSplitViewerElements = splitViewer.getExpandedElements();
                ObjectMappingMultiPageEditor.setProviders((AbstractTreeViewer)splitViewer, this.getCompMapper());
                splitViewer.setInput(viewerToInput.get(splitViewer));
                splitViewer.setExpandedElements(expandedSplitViewerElements);
                splitViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
        catch (PartInitException partInitException) {
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
        }
    }

    private static void setProviders(AbstractTreeViewer viewer, IWritableComponentNameMapper compNameMapper) {
        viewer.setLabelProvider((IBaseLabelProvider)new OMEditorTreeLabelProvider((IComponentNameMapper)compNameMapper));
        viewer.setContentProvider((IContentProvider)new OMEditorTreeContentProvider((IComponentNameMapper)compNameMapper));
    }

    public void setFocus() {
        if (this.getActivePage() == 0) {
            if (!this.m_compNameTreeViewer.getSelection().isEmpty()) {
                this.m_compNameTreeViewer.getControl().setFocus();
            } else if (!this.m_uiElementTreeViewer.getSelection().isEmpty()) {
                this.m_uiElementTreeViewer.getControl().setFocus();
            } else {
                this.m_mappedComponentTreeViewer.getControl().setFocus();
            }
        } else {
            super.setFocus();
        }
        Plugin.showStatusLine((IWorkbenchPart)this);
    }

    @Override
    public void fireDirtyProperty(boolean isDirty) {
        int i = 0;
        while (i < this.getPageCount()) {
            if (i != this.getActivePage()) {
                if (i == 1) {
                    Object[] expandedElements = this.m_treeViewer.getExpandedElements();
                    this.m_treeViewer.setInput((Object)this.getAut().getObjMap());
                    this.m_treeViewer.refresh();
                    this.m_treeViewer.setExpandedElements(expandedElements);
                }
                if (i == 2) {
                    this.m_tableViewer.setInput((Object)this.getAut().getObjMap());
                    this.m_tableViewer.refresh();
                }
            }
            ++i;
        }
        this.firePropertyChange(257);
        if (!isDirty) {
            this.firePropertyChange(258);
        }
    }

    public void logicalNameAdded() {
        int i = 0;
        while (i < this.getPageCount()) {
            if (i == this.getActivePage()) {
                if (i == 1) {
                    this.m_treeViewer.refresh();
                }
                if (i == 2) {
                    this.m_tableViewer.refresh();
                }
            }
            ++i;
        }
    }

    @Override
    public JBEditorHelper getEditorHelper() {
        return this.m_editorHelper;
    }

    @Override
    public String getEditorPrefix() {
        return Messages.ObjectMappingEditorEditor;
    }

    @Override
    public void initTextAndInput(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(String.valueOf(this.getEditorPrefix()) + input.getName());
        this.getEditorSite().getActionBars().getMenuManager();
    }

    public void update(final int event, final Object obj) {
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                ObjectMappingMultiPageEditor.this.switchEvent(event, obj);
            }
        });
    }

    private void createNewTechnicalNames(IComponentIdentifier[] components) {
        if (this.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return;
        }
        ArrayList<IObjectMappingAssoziationPO> alteredOMAs = new ArrayList<IObjectMappingAssoziationPO>();
        IObjectMappingPO objMap = this.getAut().getObjMap();
        IComponentIdentifier[] iComponentIdentifierArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentIdentifier component = iComponentIdentifierArray[n2];
            IObjectMappingAssoziationPO techNameAssoc = objMap.addTechnicalName(component, this.getAut());
            if (techNameAssoc != null) {
                IObjectMappingCategoryPO categoryToCreateIn = this.m_omEditorBP.getCategoryToCreateIn();
                if (categoryToCreateIn != null) {
                    categoryToCreateIn.addAssociation(techNameAssoc);
                } else {
                    objMap.getUnmappedTechnicalCategory().addAssociation(techNameAssoc);
                }
                alteredOMAs.add(techNameAssoc);
            } else {
                for (IObjectMappingAssoziationPO assoc : objMap.getMappings()) {
                    ICompIdentifierPO techName = assoc.getTechnicalName();
                    if (techName == null || !techName.equals(component)) continue;
                    techNameAssoc = assoc;
                    techNameAssoc.setCompIdentifier(component);
                    alteredOMAs.add(techNameAssoc);
                    break;
                }
            }
            ++n2;
        }
        for (IObjectMappingAssoziationPO alteredOMA : alteredOMAs) {
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)alteredOMA.getCategory(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
            StructuredSelection techNameSelection = new StructuredSelection((Object)alteredOMA);
            this.m_treeViewer.setSelection((ISelection)techNameSelection);
            this.m_uiElementTreeViewer.setSelection((ISelection)techNameSelection);
            this.m_mappedComponentTreeViewer.setSelection((ISelection)techNameSelection);
        }
        if (!alteredOMAs.isEmpty()) {
            this.getEditorHelper().setDirty(true);
            this.refreshAllViewer();
        }
    }

    private void refreshAllViewer() {
        this.m_treeViewer.refresh();
        this.m_uiElementTreeViewer.refresh();
        this.m_mappedComponentTreeViewer.refresh();
        this.m_tableViewer.refresh();
    }

    private void switchEvent(int event, Object obj) {
        switch (event) {
            case 1: {
                IAUTMainPO aut = (IAUTMainPO)obj;
                if (this.getAut() != aut) break;
                this.cleanupNames();
                break;
            }
            case 2: {
                IAUTMainPO connectedAut = TestExecution.getInstance().getConnectedAut();
                if (!this.getAut().equals(connectedAut)) break;
                IComponentIdentifier[] comp = (IComponentIdentifier[])obj;
                this.createNewTechnicalNames(comp);
            }
        }
    }

    @Override
    public void handleEditorDirtyStateChanged(IJBEditor gdEditor, boolean isDirty) {
        if (gdEditor == this) {
            IEvaluationService service = (IEvaluationService)this.getSite().getService(IEvaluationService.class);
            service.requestEvaluation("org.eclipse.jubula.client.ui.rcp.propertytester.EditorPart.isDirty");
        }
    }

    public TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    public TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    public OMEditorBP getOmEditorBP() {
        return this.m_omEditorBP;
    }

    public int cleanupNames() {
        int addedItems = 0;
        HashSet<IObjectMappingAssoziationPO> addedNodes = new HashSet<IObjectMappingAssoziationPO>();
        for (ITestSuitePO ts : TestSuiteBP.getListOfTestSuites()) {
            if (ts.getAut() == null || !ts.getAut().equals(this.getAut())) continue;
            CollectLogicalNamesOp op = new CollectLogicalNamesOp();
            TreeTraverser traverser = new TreeTraverser((INodePO)ts, (ITreeNodeOperation)op);
            traverser.traverse(true);
            addedItems += op.getAddedNodeCount();
            addedNodes.addAll(op.getAddedNodes());
        }
        if (addedItems > 0) {
            this.getEditorHelper().setDirty(true);
            if (this.getTreeViewer() != null) {
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection(addedNodes.toArray()));
            }
        }
        if (!this.isDirty()) {
            try {
                this.getEditorHelper().getEditSupport().reinitializeEditSupport();
                this.getEditorHelper().resetEditableState();
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForEditor(e, this);
            }
        }
        return addedItems;
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 257) {
            ((IEditorPart)source).isDirty();
        }
    }

    public boolean isDirty() {
        return super.isDirty() || this.getEditorHelper().isDirty();
    }

    public void dispose() {
        ObjectMappingEventDispatcher.removeObserver((IObjectMappingObserver)this);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), null);
        IAUTMainPO connectedAut = TestExecution.getInstance().getConnectedAut();
        if (AUTModeChangedCommand.getAutMode() == 2 && connectedAut != null && connectedAut.equals(this.getAut())) {
            TestExecutionContributor.getInstance().getClientTest().resetToTesting();
            DataEventDispatcher.getInstance().fireOMStateChanged(DataEventDispatcher.OMState.notRunning);
        }
        this.getSite().setSelectionProvider(null);
        GuiEventDispatcher.getInstance().removeEditorDirtyStateListener(this);
        this.m_treeViewerUpdater = null;
        if (this.m_editorHelper != null) {
            this.m_editorHelper.dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        Object superAdapter = super.getAdapter(adapter);
        if (superAdapter != null) {
            return superAdapter;
        }
        if (this.m_editorHelper != null) {
            return this.m_editorHelper.getAdapter(adapter);
        }
        return null;
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState());
            ++n2;
        }
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState) {
        this.getEditorHelper().handleDataChanged(po, dataState);
        if (this.m_treeViewerUpdater != null) {
            this.m_treeViewerUpdater.handleDataChanged(po, dataState);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (this.m_editorHelper == null) {
            this.m_editorHelper = new JBEditorHelper(this);
        }
        this.m_editorHelper.init(site, input);
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.m_selectionProvider.setSelectionProviderDelegate(this.m_pageToSelectionProvider.get(newPageIndex));
    }

    private IWritableComponentNameMapper getCompMapper() {
        return this.getEditorHelper().getEditSupport().getCompMapper();
    }

    public TreeViewer getActiveTreeViewer() {
        return this.m_activeTreeViewer;
    }

    public TreeViewer[] getTreeViewers() {
        return new TreeViewer[]{this.m_treeViewer, this.m_compNameTreeViewer, this.m_uiElementTreeViewer, this.m_mappedComponentTreeViewer};
    }

    public EntityManager getEntityManager() {
        return this.getEditorHelper().getEditSupport().getSession();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectLogicalNamesOp
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private int m_addedNodeCount = 0;
        private List<IObjectMappingAssoziationPO> m_addedNodes = new ArrayList<IObjectMappingAssoziationPO>();
        private CompNamesBP m_compNamesBP = new CompNamesBP();

        private CollectLogicalNamesOp() {
        }

        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (Persistor.isPoSubclass((IPersistentObject)node, ICapPO.class)) {
                ICapPO cap = (ICapPO)node;
                CompNameResult result = this.m_compNamesBP.findCompName(ctx.getCurrentTreePath(), (INodePO)cap, cap.getComponentName(), (IComponentNameCache)ObjectMappingMultiPageEditor.this.getCompMapper().getCompNameCache());
                IComponentNamePO compNamePo = ObjectMappingMultiPageEditor.this.getCompMapper().getCompNameCache().getCompNamePo(result.getCompName());
                if (!(compNamePo == null || cap.getMetaComponentType() instanceof ConcreteComponent && ((ConcreteComponent)cap.getMetaComponentType()).hasDefaultMapping() || ObjectMappingMultiPageEditor.this.m_omEditorBP.getAssociation(compNamePo.getGuid()) != null)) {
                    if (ObjectMappingMultiPageEditor.this.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                        return true;
                    }
                    IObjectMappingAssoziationPO assoc = PoMaker.createObjectMappingAssoziationPO(null, new ArrayList());
                    try {
                        ObjectMappingMultiPageEditor.this.getCompMapper().changeReuse((IComponentNameReuser)assoc, null, compNamePo.getGuid());
                        ObjectMappingMultiPageEditor.this.getAut().getObjMap().getUnmappedLogicalCategory().addAssociation(assoc);
                        this.m_addedNodes.add(assoc);
                        ++this.m_addedNodeCount;
                    }
                    catch (IncompatibleTypeException e) {
                        ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), (Object[])e.getErrorMessageParams(), null);
                    }
                    catch (PMException pme) {
                        LOG.error(String.valueOf(Messages.ErrorCollectingComponentNames) + ".", (Throwable)pme);
                    }
                }
            }
            return true;
        }

        public int getAddedNodeCount() {
            return this.m_addedNodeCount;
        }

        public List<IObjectMappingAssoziationPO> getAddedNodes() {
            return this.m_addedNodes;
        }
    }

    private static class NullSelectionProvider
    implements ISelectionProvider {
        private NullSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    private static class OMTableEditorActivationStrategy
    extends ColumnViewerEditorActivationStrategy {
        public OMTableEditorActivationStrategy(TableViewer viewer) {
            super((ColumnViewer)viewer);
        }

        protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            return event.eventType == 5 || event.eventType == 2 || event.eventType == 4;
        }
    }

    private class ObjectMappingCompNameEditingSupport
    extends AbstractObjectMappingEditingSupport {
        public ObjectMappingCompNameEditingSupport(IComponentNameMapper compNameMapper, TableViewer viewer) {
            super(compNameMapper, viewer);
        }

        protected Object getValue(Object element) {
            ObjectMappingRow row = (ObjectMappingRow)element;
            int logicalNameIndex = row.getLogicalNameIndex();
            if (logicalNameIndex < 0) {
                return "";
            }
            return ObjectMappingMultiPageEditor.this.getCompMapper().getCompNameCache().getName((String)row.getAssociation().getLogicalNames().get(logicalNameIndex));
        }

        protected void doSetValue(Object element, Object value) {
            boolean isSameValue;
            Object oldValue = this.getValue(element);
            boolean bl = oldValue == null ? value == null : (isSameValue = oldValue.equals(value));
            if (!isSameValue && value != null && value.toString().trim().length() > 0) {
                if (ObjectMappingMultiPageEditor.this.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                    return;
                }
                ObjectMappingRow row = (ObjectMappingRow)element;
                IWritableComponentNameMapper mapper = ObjectMappingMultiPageEditor.this.getCompMapper();
                String oldGuid = mapper.getCompNameCache().getGuidForName(String.valueOf(oldValue));
                String newGuid = mapper.getCompNameCache().getGuidForName(value.toString());
                if (newGuid == null) {
                    String compType = ComponentBuilder.getInstance().getCompSystem().getMostAbstractComponent().getType();
                    newGuid = mapper.getCompNameCache().createComponentNamePO(value.toString(), compType, ComponentNamesBP.CompNameCreationContext.OBJECT_MAPPING).getGuid();
                }
                OMEditorDndSupport.checkAndSwapComponentNames(row.getAssociation(), oldGuid, newGuid, ObjectMappingMultiPageEditor.this);
            }
        }
    }

    private static class ObjectMappingTreeSorter
    extends ViewerSorter {
        private ObjectMappingTreeSorter() {
        }

        public int category(Object element) {
            if (element instanceof IObjectMappingCategoryPO) {
                return 0;
            }
            if (element instanceof IObjectMappingAssoziationPO) {
                return 1;
            }
            if (element instanceof IComponentNamePO) {
                return 2;
            }
            return super.category(element);
        }
    }
}

