/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.archive.XmlStorage;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.ProjectComponentNameMapper;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.VersionDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.JBVersionException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.jarutils.IVersion;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateNewProjectVersionHandler
extends AbstractHandler {
    private static Logger log = LoggerFactory.getLogger(CreateNewProjectVersionHandler.class);

    private void fireReady() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.fireProjectLoadedListener((IProgressMonitor)new NullProgressMonitor());
        ded.fireProjectStateChanged(DataEventDispatcher.ProjectState.opened);
    }

    private IRunnableWithProgress createOperation(Integer majorVersionNumber, Integer minorVersionNumber) {
        return new NewVersionOperation(majorVersionNumber, minorVersionNumber);
    }

    private VersionDialog openVersionDialog() {
        String highestVersionString = "1.0";
        try {
            GeneralStorage.getInstance().validateProjectExists(GeneralStorage.getInstance().getProject());
            highestVersionString = ProjectPM.findHighestVersionNumber((String)GeneralStorage.getInstance().getProject().getGuid());
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
            return null;
        }
        catch (JBException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
            return null;
        }
        String[] versionNumbers = highestVersionString.split("\\.");
        Integer majNum = Integer.parseInt(versionNumbers[0]);
        Integer minNum = Integer.parseInt(versionNumbers[1]);
        VersionDialog dialog = new VersionDialog(this.getActiveShell(), Messages.CreateNewProjectVersionActionTitle, majNum, minNum, Messages.CreateNewProjectVersionActionMessage, Messages.CreateNewProjectVersionActionMajorLabel, Messages.CreateNewProjectVersionActionMinorLabel, Messages.CreateNewProjectVersionActionInvalidVersion, Messages.CreateNewProjectVersionActionDoubleVersion, "bigProject.gif", Messages.CreateNewProjectVersionActionShellTitle){

            protected boolean isInputAllowed() {
                return !ProjectPM.doesProjectVersionExist((String)GeneralStorage.getInstance().getProject().getGuid(), (Integer)this.getMajorFieldValue(), (Integer)this.getMinorFieldValue());
            }

            protected void okPressed() {
                if (ProjectPM.doesProjectVersionExist((String)GeneralStorage.getInstance().getProject().getGuid(), (Integer)this.getMajorFieldValue(), (Integer)this.getMinorFieldValue())) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_PROJECTVERSION_ALREADY_EXISTS, (Object[])new Object[]{this.getMajorFieldValue(), this.getMinorFieldValue()}, null);
                    return;
                }
                super.okPressed();
            }
        };
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogProjectCreateNewVersionContextId");
        dialog.open();
        return dialog;
    }

    public Object executeImpl(ExecutionEvent event) {
        Plugin.startLongRunning(Messages.SaveProjectAsActionWaitWhileSaving);
        VersionDialog dialog = this.openVersionDialog();
        if (dialog != null && dialog.getReturnCode() == 0) {
            Integer majorVersionNumber = dialog.getMajorVersionNumber();
            Integer minorVersionNumber = dialog.getMinorVersionNumber();
            IRunnableWithProgress op = this.createOperation(majorVersionNumber, minorVersionNumber);
            try {
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                progressService.busyCursorWhile(op);
                this.fireReady();
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                Utils.clearClient();
            }
        } else {
            Plugin.stopLongRunning();
        }
        return null;
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }

    private class NewVersionOperation
    implements IRunnableWithProgress {
        private static final int TOTAL_WORK = 100;
        private static final int WORK_GET_PROJECT_FROM_DB = 5;
        private static final int WORK_PROJECT_CREATION = 10;
        private static final int WORK_PROJECT_SAVE = 85;
        private Integer m_majorVersionNumber;
        private Integer m_minorVersionNumber;

        public NewVersionOperation(Integer majorVersionNumber, Integer minorVersionNumber) {
            this.m_majorVersionNumber = majorVersionNumber;
            this.m_minorVersionNumber = minorVersionNumber;
        }

        /*
         * Exception decompiling
         */
        public void run(IProgressMonitor monitor) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void createNewVersion(IProgressMonitor monitor, SubMonitor subMonitor, ParamNameBPDecorator paramNameMapper, IWritableComponentNameCache compNameCache) throws ProjectDeletedException, PMException, InterruptedException, PMReadException, JBVersionException {
            NodePM.getInstance().setUseCache(true);
            GeneralStorage.getInstance().validateProjectExists(GeneralStorage.getInstance().getProject());
            String serializedProject = XmlStorage.save((IProjectPO)GeneralStorage.getInstance().getProject(), null, (boolean)false, (IProgressMonitor)subMonitor.newChild(5));
            if (monitor.isCanceled() || serializedProject == null) {
                throw new InterruptedException();
            }
            StringBuilder result = new StringBuilder(serializedProject.length());
            result.append(serializedProject);
            String content = new XmlStorage().checkAndReduceXmlHeaderForSaveAs(result);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            IProjectPO duplicatedProject = XmlStorage.load((String)content, (boolean)false, (Integer)this.m_majorVersionNumber, (Integer)this.m_minorVersionNumber, (IParamNameMapper)paramNameMapper, (IWritableComponentNameCache)compNameCache, (IProgressMonitor)subMonitor.newChild(10));
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ProjectComponentNameMapper compNameMapper = new ProjectComponentNameMapper(compNameCache, duplicatedProject);
            try {
                duplicatedProject.setClientMetaDataVersion(IVersion.JB_CLIENT_METADATA_VERSION);
                this.attachProjectWithProgress((IProgressMonitor)subMonitor.newChild(85), paramNameMapper, (IWritableComponentNameMapper)compNameMapper, duplicatedProject);
            }
            catch (PMSaveException e) {
                Plugin.stopLongRunning();
                PMExceptionHandler.handlePMExceptionForMasterSession((PMException)((Object)new PMSaveException(e.getMessage(), MessageIDs.E_CREATE_NEW_VERSION_FAILED)));
            }
            catch (PMException e) {
                Plugin.stopLongRunning();
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
            catch (ProjectDeletedException projectDeletedException) {
                Plugin.stopLongRunning();
                PMExceptionHandler.handleProjectDeletedException();
            }
        }

        private void attachProjectWithProgress(IProgressMonitor monitor, ParamNameBPDecorator paramNameMapper, IWritableComponentNameMapper compNameMapper, IProjectPO project) throws PMException, ProjectDeletedException, InterruptedException {
            IProjectPO clearedProject = GeneralStorage.getInstance().getProject();
            if (clearedProject != null) {
                Utils.clearClient();
                GeneralStorage.getInstance().setProject(null);
                DataEventDispatcher ded = DataEventDispatcher.getInstance();
                ded.fireDataChangedListener((IPersistentObject)clearedProject, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all);
            }
            ArrayList<ParamNameBPDecorator> mapperList = new ArrayList<ParamNameBPDecorator>();
            ArrayList<IWritableComponentNameMapper> compNameCacheList = new ArrayList<IWritableComponentNameMapper>();
            mapperList.add(paramNameMapper);
            compNameCacheList.add(compNameMapper);
            ProjectPM.attachProjectToROSession((IProjectPO)project, (String)project.getName(), mapperList, compNameCacheList, (IProgressMonitor)monitor);
            Plugin.stopLongRunning();
        }
    }
}

