/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class SaveImageAsHandler
extends AbstractSelectionBasedHandler {
    private static final int MAX_FILE_NAME_LENGTH = 255;

    protected Object executeImpl(ExecutionEvent event) {
        IStructuredSelection structuredSelection = this.getSelection();
        Object selectedObject = structuredSelection.getFirstElement();
        if (selectedObject instanceof TestResultNode) {
            TestResultNode result;
            TestResultNode parent = result = (TestResultNode)selectedObject;
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String date = format.format(result.getTimeStamp());
            FileDialog saveDialog = new FileDialog(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), 8192);
            String fileName = "ErrorInTest_" + parent.getName() + "_" + result.getNode().getName();
            fileName = fileName.replaceAll("[\\s\\?\\\\/:|<>\\*\"]", "");
            String fileEnding = "_" + date + ".png";
            fileName = StringUtils.substring((String)fileName, (int)0, (int)(255 - fileEnding.length() - saveDialog.getFilterPath().length()));
            fileName = String.valueOf(fileName) + fileEnding;
            saveDialog.setFileName(fileName);
            saveDialog.setFilterExtensions(new String[]{"*.png"});
            saveDialog.setOverwrite(true);
            String path = saveDialog.open();
            if (path != null && result.getScreenshot() != null) {
                try {
                    File file = new File(path);
                    FileOutputStream out = new FileOutputStream(file);
                    ((OutputStream)out).write(result.getScreenshot());
                    out.flush();
                    ((OutputStream)out).close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_FILE_NO_PERMISSION);
                }
                catch (IOException iOException) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_IO_EXCEPTION);
                }
            }
        }
        return null;
    }
}

