/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.collections.ListUtils;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.AbstractDeleteBrowserTreeItemHandler;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTreeItemHandlerTCBrowser
extends AbstractDeleteBrowserTreeItemHandler {
    private static Object[] createLocOfUseArray(ISpecTestCasePO specTcPO, List<IExecTestCasePO> reusesSet, List<INodePO> nodesToDelete) {
        TreeSet<String> locations = new TreeSet<String>();
        for (IExecTestCasePO node : reusesSet) {
            INodePO parent = null;
            parent = Persistor.isPoSubclass((IPersistentObject)node, IEventExecTestCasePO.class) ? ((IEventExecTestCasePO)node).getParentNode() : node.getParentNode();
            if (parent == null || nodesToDelete.contains(parent)) continue;
            locations.add("- " + parent.getName() + "\n");
        }
        String list = "";
        for (String string : locations) {
            list = String.valueOf(list) + string;
        }
        return new Object[]{specTcPO.getName(), locations.size(), list};
    }

    @Override
    protected List<MultipleNodePM.AbstractCmdHandle> getDeleteCommands(List<INodePO> nodesToDelete) {
        ArrayList<MultipleNodePM.AbstractCmdHandle> cmds = new ArrayList<MultipleNodePM.AbstractCmdHandle>(nodesToDelete.size());
        ParamNameBPDecorator dec = new ParamNameBPDecorator((IParamNameMapper)ParamNameBP.getInstance());
        for (INodePO node : nodesToDelete) {
            this.closeOpenEditor((IPersistentObject)node);
            if (node instanceof ISpecTestCasePO) {
                ISpecTestCasePO specTcPO = (ISpecTestCasePO)node;
                List execTestCases = NodePM.getInternalExecTestCases((String)specTcPO.getGuid(), (long)specTcPO.getParentProjectId());
                if (!MultipleNodePM.allExecsFromList(nodesToDelete, (List)execTestCases)) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_REUSED_SPEC_TCS, (Object[])DeleteTreeItemHandlerTCBrowser.createLocOfUseArray(specTcPO, execTestCases, nodesToDelete), null);
                    return ListUtils.EMPTY_LIST;
                }
                dec.clearAllNames();
                cmds.add((MultipleNodePM.AbstractCmdHandle)new MultipleNodePM.DeleteTCHandle(specTcPO, dec));
            }
            if (node instanceof IEventExecTestCasePO) {
                cmds.add((MultipleNodePM.AbstractCmdHandle)new MultipleNodePM.DeleteEvHandle((IEventExecTestCasePO)node));
            }
            if (!(node instanceof ICategoryPO)) continue;
            cmds.add((MultipleNodePM.AbstractCmdHandle)new MultipleNodePM.DeleteCatHandle((ICategoryPO)node));
        }
        return cmds;
    }
}

