/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.labelprovider;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecObjContPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.constants.RcpIconConstants;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralLabelProvider
extends ColumnLabelProvider
implements IColorProvider,
ILabelProvider {
    protected static final String INACTIVE_PREFIX = "// ";
    protected static final String CLOSE_BRACKED = "]";
    protected static final String OPEN_BRACKED = " [";
    protected static final String SEPARATOR = "; ";
    private static final Logger LOG = LoggerFactory.getLogger(GeneralLabelProvider.class);
    private static final String UNNAMED_NODE = Messages.GeneralLabelProviderUnnamedNode;
    private static final String COMMENT_PREFIX = String.valueOf(Messages.AbstractGuiNodePropertySourceComment) + ":" + " ";
    private static final Color DISABLED_COLOR = LayoutUtil.GRAY_COLOR;
    private static final Color REUSED_PROJECTS_COLOR = Display.getDefault().getSystemColor(9);
    private static Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay());

    public void dispose() {
    }

    public String getText(Object element) {
        return GeneralLabelProvider.getTextImpl(element);
    }

    public Image getImage(Object element) {
        IStructuredSelection sel;
        Object cbContents;
        Image image = GeneralLabelProvider.getImageImpl(element);
        if (element instanceof INodePO && ((INodePO)element).isGenerated()) {
            image = IconConstants.getGeneratedImage((Image)image);
        }
        if ((cbContents = clipboard.getContents((Transfer)LocalSelectionClipboardTransfer.getInstance())) instanceof IStructuredSelection && (sel = (IStructuredSelection)cbContents).toList().contains(element)) {
            image = RcpIconConstants.getCutImage(image);
        }
        return image;
    }

    public String getToolTipText(Object element) {
        if (element instanceof INodePO) {
            INodePO node = (INodePO)element;
            StringBuilder toolTip = new StringBuilder();
            String comment = node.getComment();
            if (!StringUtils.isBlank((String)comment)) {
                toolTip.append(COMMENT_PREFIX);
                toolTip.append(ObjectUtils.toString((Object)comment));
                return toolTip.toString();
            }
        }
        return super.getToolTipText(element);
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 50;
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 5000;
    }

    public Image getToolTipImage(Object object) {
        INodePO node;
        if (object instanceof INodePO && ProblemFactory.hasProblem((INodePO)(node = (INodePO)object))) {
            switch (ProblemFactory.getWorstProblem((Set)node.getProblems()).getStatus().getSeverity()) {
                case 1: {
                    return IconConstants.INFO_IMAGE;
                }
                case 2: {
                    return IconConstants.WARNING_IMAGE;
                }
                case 4: {
                    return IconConstants.ERROR_IMAGE;
                }
            }
        }
        return super.getToolTipImage(object);
    }

    public static String getTextImpl(Object element) {
        if (element instanceof INodePO) {
            String prefix = "";
            String name = null;
            INodePO node = (INodePO)element;
            if (!node.isActive()) {
                prefix = INACTIVE_PREFIX;
            }
            name = node.getName() == null ? UNNAMED_NODE : (node instanceof ICapPO ? GeneralLabelProvider.getText((ICapPO)node) : (node instanceof IExecTestCasePO ? GeneralLabelProvider.getText((IExecTestCasePO)node) : (node instanceof ISpecTestCasePO ? GeneralLabelProvider.getText((ISpecTestCasePO)node) : (node instanceof IRefTestSuitePO ? GeneralLabelProvider.getText((IRefTestSuitePO)node) : node.getName()))));
            return prefix + name;
        }
        if (element instanceof IReusedProjectPO) {
            IReusedProjectPO reusedProject = (IReusedProjectPO)element;
            String projectName = reusedProject.getProjectName();
            if (projectName == null) {
                projectName = reusedProject.getProjectGuid();
            }
            return String.valueOf(projectName) + reusedProject.getVersionString();
        }
        if (element instanceof ISpecObjContPO) {
            return Messages.TreeBuilderTestCases;
        }
        if (element instanceof IExecObjContPO) {
            IProjectPO activeProject = GeneralStorage.getInstance().getProject();
            if (activeProject != null) {
                return activeProject.getName();
            }
            LOG.error(Messages.GeneralLabelProvier_NoActiveProject);
        }
        return element == null ? "" : element.toString();
    }

    public static Image getImageImpl(Object element) {
        if (element instanceof ITestSuitePO) {
            ITestSuitePO testSuite = (ITestSuitePO)element;
            Locale workLang = WorkingLanguageBP.getInstance().getWorkingLanguage();
            if (testSuite.getAut() != null && !WorkingLanguageBP.getInstance().isTestSuiteLanguage(workLang, testSuite)) {
                return IconConstants.TS_DISABLED_IMAGE;
            }
            return IconConstants.TS_IMAGE;
        }
        if (element instanceof ICapPO) {
            return IconConstants.CAP_IMAGE;
        }
        if (element instanceof IExecObjContPO) {
            return IconConstants.PROJECT_IMAGE;
        }
        if (element instanceof IEventExecTestCasePO) {
            return IconConstants.EH_IMAGE;
        }
        if (element instanceof IExecTestCasePO) {
            return IconConstants.TC_REF_IMAGE;
        }
        if (element instanceof ISpecTestCasePO) {
            return IconConstants.TC_IMAGE;
        }
        if (element instanceof ITestJobPO) {
            return IconConstants.TJ_IMAGE;
        }
        if (element instanceof ICategoryPO || element instanceof IReusedProjectPO) {
            return IconConstants.CATEGORY_IMAGE;
        }
        if (element instanceof IRefTestSuitePO) {
            return IconConstants.TS_REF_IMAGE;
        }
        if (element instanceof ITestDataCubePO) {
            return IconConstants.TDC_IMAGE;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof IExecTestCasePO || element instanceof ICapPO || element instanceof IRefTestSuitePO) {
            if (!((INodePO)element).isActive()) {
                return LayoutUtil.INACTIVE_COLOR;
            }
            return DISABLED_COLOR;
        }
        if (element instanceof ISpecTestCasePO) {
            return null;
        }
        if (element instanceof IReusedProjectPO || element instanceof INodePO && !NodeBP.isEditable((IPersistentObject)((INodePO)element))) {
            return REUSED_PROJECTS_COLOR;
        }
        return null;
    }

    private static String getText(ICapPO testStep) {
        if (Plugin.getDefault().getPreferenceStore().getBoolean("SHOWCAPINFO_PREF_KEY")) {
            StringBuilder nameBuilder = new StringBuilder(testStep.getName());
            nameBuilder.append(OPEN_BRACKED);
            Map map = StringHelper.getInstance().getMap();
            IComponentNameMapper compMapper = Plugin.getActiveCompMapper();
            nameBuilder.append(Messages.CapGUIType).append((String)map.get(testStep.getComponentType())).append(SEPARATOR).append(Messages.CapGUIName);
            String componentName = testStep.getComponentName();
            componentName = compMapper != null ? compMapper.getCompNameCache().getName(componentName) : ComponentNamesBP.getInstance().getName(componentName);
            if (componentName != null) {
                nameBuilder.append(componentName);
            }
            nameBuilder.append(SEPARATOR).append(Messages.CapGUIAction).append((String)map.get(testStep.getActionName())).append(CLOSE_BRACKED);
            return nameBuilder.toString();
        }
        return testStep.getName();
    }

    public static String getText(IExecTestCasePO testCaseRef) {
        StringBuilder nameBuilder = new StringBuilder();
        String realName = testCaseRef.getRealName();
        if (!StringUtils.isBlank((String)realName)) {
            nameBuilder.append(realName);
            if (Plugin.getDefault().getPreferenceStore().getBoolean("SHOWORIGINALNAME_PREF_KEY")) {
                ISpecTestCasePO testCase = testCaseRef.getSpecTestCase();
                String testCaseName = testCase != null ? testCase.getName() : "";
                nameBuilder.append(" ").append("(").append(testCaseName).append(")");
            }
        } else {
            ISpecTestCasePO testCase = testCaseRef.getSpecTestCase();
            String testCaseName = testCase != null ? testCase.getName() : "";
            nameBuilder.append("<").append(testCaseName).append(">");
        }
        nameBuilder.append(GeneralLabelProvider.getParameterString((IParamNodePO)testCaseRef));
        return nameBuilder.toString();
    }

    private static String getText(ISpecTestCasePO testCase) {
        return String.valueOf(testCase.getName()) + GeneralLabelProvider.getParameterString((IParamNodePO)testCase);
    }

    private static String getShortTypeName(IParamDescriptionPO paramDesc) {
        String typeName = paramDesc.getType();
        int i = typeName.lastIndexOf(46);
        return typeName.substring(i + 1);
    }

    public static String getTextWithType(IParamDescriptionPO paramDesc) {
        return String.valueOf(paramDesc.getName()) + OPEN_BRACKED + GeneralLabelProvider.getShortTypeName(paramDesc) + CLOSE_BRACKED;
    }

    private static String getParameterString(IParamNodePO paramNode) {
        StringBuilder nameBuilder = new StringBuilder();
        Iterator iter = paramNode.getParameterList().iterator();
        boolean parameterExist = false;
        if (iter.hasNext()) {
            parameterExist = true;
            nameBuilder.append(OPEN_BRACKED);
        }
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                IParamDescriptionPO descr = (IParamDescriptionPO)iter.next();
                nameBuilder.append(descr.getName());
                if (!iter.hasNext()) continue;
                nameBuilder.append(SEPARATOR);
            }
        }
        if (parameterExist) {
            nameBuilder.append(CLOSE_BRACKED);
        }
        return nameBuilder.toString();
    }

    private static String getText(IRefTestSuitePO testSuitRef) {
        StringBuilder nameBuilder = new StringBuilder();
        String testSuitRefName = testSuitRef != null ? testSuitRef.getName() : "";
        nameBuilder.append("<").append(testSuitRefName).append(">");
        return nameBuilder.toString();
    }
}

