/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.page;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.search.data.SearchOptions;
import org.eclipse.jubula.client.ui.rcp.search.data.TypeName;
import org.eclipse.jubula.client.ui.rcp.search.page.ButtonSelections;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractSearchPage
extends DialogPage
implements ISearchPage,
SelectionListener {
    private static final int NUM_COLUMNS = 4;
    private static final int VERTICAL_SPACING = 10;
    private Combo m_searchStringCombo;
    private Button m_useRegExCheck;
    private Button m_caseSensitivCheck;
    private Group m_groupUseSelection;
    private Button m_scopeTestSuitBrowserCheck;
    private Button m_scopeTestCaseBrowserCheck;
    private Button m_scopeWholeProjectRadio;
    private Button m_scopeSelectedNodesRadio;
    private Button m_scopeTestCaseBrowserMasterRadio;
    private Button m_scopeTestCaseBrowserAllRadio;
    private Button m_scopeSearchInReusedProjects;

    public void createControl(Composite parent) {
        this.getButtonSelections().reset();
        Composite pageContent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.verticalSpacing = 10;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        pageContent.setLayout((Layout)layout);
        Label findLabel = new Label(pageContent, 0);
        findLabel.setText(Messages.SimpleSearchPageSearch);
        this.m_searchStringCombo = new Combo(pageContent, 2048);
        this.m_searchStringCombo.setLayoutData((Object)this.createGridData(3, true));
        this.m_searchStringCombo.setItems(this.getSearchData().getRecent().toArray(new String[this.getSearchData().getRecent().size()]));
        if (this.m_searchStringCombo.getItemCount() == 0) {
            this.m_searchStringCombo.setText(Messages.SimpleSearchPagePhrase);
        } else {
            this.m_searchStringCombo.select(0);
        }
        this.m_searchStringCombo.setSelection(new Point(0, this.m_searchStringCombo.getTextLimit()));
        this.m_searchStringCombo.forceFocus();
        DataBindingContext dbc = new DataBindingContext();
        this.createSearchOptionsGroup(pageContent);
        this.createSearchInGroup(dbc, pageContent);
        this.createScopeGroup(dbc, pageContent);
        dbc.updateTargets();
        this.setControl((Control)pageContent);
        this.setEnabledButtons();
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.findDialogContextId");
    }

    private void createSearchOptionsGroup(Composite parent) {
        Group group = this.createGroup(parent, Messages.SimpleSearchPageOptionGroupHeader, 2);
        group.setLayoutData((Object)this.createGridData(4, true));
        this.m_caseSensitivCheck = this.createCheck((Composite)group, Messages.SimpleSearchPageCaseSen, false);
        this.m_useRegExCheck = this.createCheck((Composite)group, Messages.SimpleSearchPageRegEx, false);
    }

    private void createSearchInGroup(DataBindingContext dbc, Composite parent) {
        Group group = this.createGroup(parent, Messages.SimpleSearchPageSearchInGroupHeader, 3);
        group.setLayoutData((Object)this.createGridData(4, true));
        TypeName[] typeNameArray = this.getSearchData().getSearchableTypes();
        int n = typeNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeName searchableType = typeNameArray[n2];
            this.createTypeCheck(dbc, (Composite)group, searchableType);
            ++n2;
        }
    }

    private void createScopeGroup(DataBindingContext dbc, Composite parent) {
        Group group = this.createGroup(parent, Messages.SimpleSearchPageScope, 3);
        group.setLayoutData((Object)this.createGridData(4, true));
        this.m_scopeWholeProjectRadio = this.createRadio((Composite)group, Messages.SimpleSearchPageScopeWholeProject, true);
        this.m_scopeWholeProjectRadio.addSelectionListener((SelectionListener)this);
        this.m_scopeSelectedNodesRadio = this.createRadio((Composite)group, Messages.SimpleSearchPageScopeSelectedNodes, false);
        this.m_scopeSelectedNodesRadio.addSelectionListener((SelectionListener)this);
        this.m_scopeSearchInReusedProjects = this.createCheck((Composite)group, Messages.SimpleSearchPageScopeSearchInReusedProjects, false);
        this.m_groupUseSelection = this.createGroup((Composite)group, Messages.SimpleSearchPageScopeUseSelectionIn, 3);
        this.m_scopeTestSuitBrowserCheck = this.createCheck((Composite)this.m_groupUseSelection, Messages.SimpleSearchPageScopeTestSuiteBrowserCheck, true);
        this.m_scopeTestSuitBrowserCheck.setLayoutData((Object)this.createGridData(2, true));
        this.m_scopeTestCaseBrowserCheck = this.createCheck((Composite)this.m_groupUseSelection, Messages.SimpleSearchPageScopeTestCaseBrowserCheck, true);
        this.m_scopeTestCaseBrowserCheck.setLayoutData((Object)this.createGridData(3, true));
        this.m_scopeTestCaseBrowserCheck.addSelectionListener((SelectionListener)this);
        this.m_scopeTestSuitBrowserCheck.addSelectionListener((SelectionListener)this);
        this.m_scopeTestCaseBrowserMasterRadio = this.createRadio((Composite)this.m_groupUseSelection, Messages.SimpleSearchPageScopeTestCaseBrowserMainRadio, true);
        GridData gridData = this.createGridData(1, false);
        gridData.horizontalIndent = 20;
        this.m_scopeTestCaseBrowserMasterRadio.setLayoutData((Object)gridData);
        this.m_scopeTestCaseBrowserAllRadio = this.createRadio((Composite)this.m_groupUseSelection, Messages.SimpleSearchPageScopeTestCaseBrowserAllRadio, false);
    }

    private void createTypeCheck(DataBindingContext dbc, Composite parent, TypeName searchableType) {
        Button check = new Button(parent, 32);
        GridData gd = new GridData(768);
        check.setLayoutData((Object)gd);
        check.setText(searchableType.getName());
        ISWTObservableValue guiElement = SWTObservables.observeSelection((Control)check);
        IObservableValue modelElement = PojoObservables.observeValue((Object)searchableType, (String)"selected");
        dbc.bindValue((IObservableValue)guiElement, modelElement);
    }

    private GridData createGridData(int horizontalSpan, boolean grabHorizontal) {
        GridData gd = GridDataFactory.fillDefaults().create();
        gd.horizontalSpan = horizontalSpan;
        gd.grabExcessHorizontalSpace = grabHorizontal;
        return gd;
    }

    private Group createGroup(Composite parent, String header, int columns) {
        Group group = new Group(parent, 0);
        group.setText(header);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        layout.verticalSpacing = 10;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)this.createGridData(columns, true));
        return group;
    }

    private Button createRadio(Composite parent, String text, boolean isSelected) {
        return this.createButton(parent, 16, text, isSelected);
    }

    private Button createCheck(Composite parent, String text, boolean isSelected) {
        return this.createButton(parent, 32, text, isSelected);
    }

    private Button createButton(Composite parent, int style, String text, boolean isSelected) {
        Button button = new Button(parent, style);
        button.setText(text);
        this.getButtonSelections().next(button, isSelected);
        return button;
    }

    public void widgetSelected(SelectionEvent e) {
        if (!this.m_scopeTestSuitBrowserCheck.getSelection() && !this.m_scopeTestCaseBrowserCheck.getSelection()) {
            if (e.getSource() == this.m_scopeTestCaseBrowserCheck) {
                this.m_scopeTestSuitBrowserCheck.setSelection(true);
                AbstractSearchPage.notifySelectionListener(this.m_scopeTestSuitBrowserCheck);
            } else if (e.getSource() == this.m_scopeTestSuitBrowserCheck) {
                this.m_scopeTestCaseBrowserCheck.setSelection(true);
                AbstractSearchPage.notifySelectionListener(this.m_scopeTestCaseBrowserCheck);
            }
        }
        this.setEnabledButtons();
    }

    private static void notifySelectionListener(Button button) {
        Event event = new Event();
        event.type = 13;
        event.widget = button;
        button.notifyListeners(13, event);
    }

    private void setEnabledButtons() {
        this.setChildrenEnabled((Composite)this.m_groupUseSelection, this.m_scopeSelectedNodesRadio.getSelection());
        if (!this.m_scopeTestCaseBrowserCheck.getSelection()) {
            this.m_scopeTestCaseBrowserMasterRadio.setEnabled(false);
            this.m_scopeTestCaseBrowserAllRadio.setEnabled(false);
        }
    }

    private void setChildrenEnabled(Composite composite, boolean isEnabled) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(isEnabled);
            ++n2;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean performAction() {
        this.getButtonSelections().store();
        if (GeneralStorage.getInstance().getProject() != null) {
            SearchOptions searchData = this.getSearchData();
            searchData.setData(this.m_searchStringCombo.getText(), this.m_caseSensitivCheck.getSelection(), this.m_useRegExCheck.getSelection(), this.m_scopeSelectedNodesRadio.getSelection(), this.m_scopeTestSuitBrowserCheck.getSelection(), this.m_scopeTestCaseBrowserCheck.getSelection(), this.m_scopeTestCaseBrowserAllRadio.getSelection(), this.m_scopeSearchInReusedProjects.getSelection());
            List<String> recent = searchData.getRecent();
            this.m_searchStringCombo.setItems(recent.toArray(new String[recent.size()]));
            this.m_searchStringCombo.select(0);
            this.m_searchStringCombo.setFocus();
            NewSearchUI.runQueryInBackground((ISearchQuery)this.getNewQuery());
        }
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
    }

    protected abstract ButtonSelections getButtonSelections();

    protected abstract SearchOptions getSearchData();

    protected abstract ISearchQuery getNewQuery();
}

