/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers.propertysources;

import java.util.Date;
import java.util.Set;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.model.TestResultParameter;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.controllers.propertysources.IPropertyController;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.TestErrorEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class TestResultNodePropertySource
extends AbstractPropertySource {
    public static final String P_TESTSTEP_CAT = Messages.TestResultNodePropertySourceResultStep;
    public static final String P_ELEMENT_DISPLAY_STEPNAME = Messages.TestResultNodePropertySourceStepName;
    public static final String P_ELEMENT_DISPLAY_STEPTYPE = Messages.TestResultNodePropertySourceStepType;
    public static final String P_TESTRESULT_CAT = Messages.TestResultNodePropertySourceTestResult;
    public static final String P_ELEMENT_DISPLAY_TIMESTAMP = Messages.TestResultNodePropertySourceTimeStamp;
    public static final String P_ELEMENT_DISPLAY_STEPSTATUS = Messages.TestResultNodePropertySourceStepStatus;
    public static final String P_TESTERROR_CAT = Messages.TestResultNodePropertySourceErrorDetail;
    public static final String P_ELEMENT_DISPLAY_ERRORTYPE = Messages.TestResultNodePropertySourceErrorType;
    public static final String P_DATA_CAT = Messages.TestResultNodePropertySourceDataCat;
    public static final String P_CAP_CAT = Messages.TestResultNodePropertySourceCapDetail;
    public static final String P_ELEMENT_DISPLAY_CAPCOMMENT = Messages.TestResultNodePropertySourceComment;
    public static final String P_ELEMENT_DISPLAY_COMPNAME = Messages.CapGUIPropertySourceComponentName;
    public static final String P_ELEMENT_DISPLAY_ACTIONTYPE = Messages.CapGUIPropertySourceActionType;
    public static final String P_ELEMENT_DISPLAY_COMPTYPE = Messages.CapGUIPropertySourceCompType;
    public static final String P_ELEMENT_DISPLAY_PARAMETERNAME = Messages.CapGUIPropertySourceParamName;
    public static final String P_ELEMENT_DISPLAY_PARAMETERVALUE = Messages.CapGUIPropertySourceParamValue;
    private TestResultNode m_node;

    public TestResultNodePropertySource(TestResultNode node) {
        this.m_node = node;
        this.initPropDescriptor();
    }

    protected void initPropDescriptor() {
        this.clearPropertyDescriptors();
        final INodePO node = this.m_node.getNode();
        PropertyDescriptor propDes = new PropertyDescriptor((Object)new ComponentController(){

            public Object getProperty() {
                TestResultNode cap = TestResultNodePropertySource.this.m_node;
                Date time = cap.getTimeStamp();
                if (time != null) {
                    String timeStamp = time.toString();
                    return timeStamp;
                }
                return "";
            }
        }, P_ELEMENT_DISPLAY_TIMESTAMP);
        propDes.setCategory(P_TESTSTEP_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        propDes = new PropertyDescriptor((Object)new ComponentController(){

            public Object getProperty() {
                return TestResultNodePropertySource.this.m_node.getName();
            }
        }, P_ELEMENT_DISPLAY_STEPNAME);
        propDes.setCategory(P_TESTSTEP_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        propDes = new PropertyDescriptor((Object)new ComponentController(){

            public Object getProperty() {
                return TestResultNodePropertySource.this.m_node.getTypeOfNode();
            }

            public Image getImage() {
                return TestResultNodePropertySource.this.getImageForNode(node);
            }
        }, P_ELEMENT_DISPLAY_STEPTYPE);
        propDes.setCategory(P_TESTSTEP_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        propDes = new PropertyDescriptor((Object)new ComponentController(){

            public Object getProperty() {
                return node == null || node.getComment() == null ? "" : node.getComment();
            }
        }, P_ELEMENT_DISPLAY_CAPCOMMENT);
        propDes.setCategory(P_TESTSTEP_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        this.initResultDetailsPropDesc();
        if (Persistor.isPoSubclass((IPersistentObject)node, IEventExecTestCasePO.class)) {
            this.initEventTestCasePropDescriptor(node);
        }
        if (this.m_node.getEvent() != null) {
            this.initErrorEventPropDescriptor();
        }
        this.initComponentNameDetailsPropDescriptor(this.m_node);
        this.initActionDetailsPropDescriptor(this.m_node);
        this.initParameterDescriptor(this.m_node);
    }

    private void initParameterDescriptor(TestResultNode testResult) {
        for (final TestResultParameter parameter : testResult.getParameters()) {
            PropertyDescriptor propDesc = new PropertyDescriptor((Object)new ComponentController(){

                public Object getProperty() {
                    return parameter.getValue();
                }
            }, NLS.bind((String)Messages.TestResultNodePropertySourceDataParameter, (Object)parameter.getName()));
            propDesc.setCategory(P_DATA_CAT);
            this.addPropertyDescriptor((IPropertyDescriptor)propDesc);
        }
    }

    private Image getImageForNode(INodePO node) {
        Image image = null;
        if (Persistor.isPoSubclass((IPersistentObject)node, ITestSuitePO.class)) {
            image = IconConstants.TS_IMAGE;
        }
        if (Persistor.isPoSubclass((IPersistentObject)node, IExecTestCasePO.class)) {
            image = Persistor.isPoSubclass((IPersistentObject)node, IEventExecTestCasePO.class) ? IconConstants.RESULT_EH_IMAGE : IconConstants.TC_IMAGE;
        }
        if (Persistor.isPoSubclass((IPersistentObject)node, ICapPO.class)) {
            TestResultNode parent = this.m_node.getParent();
            image = Persistor.isPoSubclass((IPersistentObject)parent.getNode(), IEventExecTestCasePO.class) ? IconConstants.EH_CAP_IMAGE : IconConstants.CAP_IMAGE;
        }
        return image;
    }

    private void initResultDetailsPropDesc() {
        PropertyDescriptor propDes = new PropertyDescriptor((Object)new ComponentController(){

            public Object getProperty() {
                return TestResultNodePropertySource.this.m_node.getStatusString();
            }

            public Image getImage() {
                int status = TestResultNodePropertySource.this.m_node.getStatus();
                switch (status) {
                    case 1: {
                        return IconConstants.STEP_OK_IMAGE;
                    }
                    case 2: 
                    case 5: {
                        return IconConstants.STEP_NOT_OK_IMAGE;
                    }
                    case 7: {
                        return IconConstants.STEP_RETRY_IMAGE;
                    }
                    case 8: {
                        return IconConstants.STEP_RETRY_OK_IMAGE;
                    }
                    case 9: {
                        return IconConstants.STEP_NOT_OK_IMAGE;
                    }
                }
                return null;
            }
        }, P_ELEMENT_DISPLAY_STEPSTATUS);
        propDes.setCategory(P_TESTRESULT_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
    }

    private void initComponentNameDetailsPropDescriptor(TestResultNode testResult) {
        String componentType;
        PropertyDescriptor propDes;
        final String componentName = testResult.getComponentName();
        if (componentName != null) {
            propDes = new PropertyDescriptor((Object)new ComponentController(){

                public Object getProperty() {
                    return componentName;
                }
            }, P_ELEMENT_DISPLAY_COMPNAME);
            propDes.setCategory(P_CAP_CAT);
            this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        }
        if ((componentType = testResult.getComponentType()) != null) {
            propDes = new PropertyDescriptor((Object)new ComponentController(){

                public Object getProperty() {
                    return componentType;
                }
            }, P_ELEMENT_DISPLAY_COMPTYPE);
            propDes.setCategory(P_CAP_CAT);
            this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        }
    }

    private void initActionDetailsPropDescriptor(TestResultNode testResult) {
        final String actionName = testResult.getActionName();
        if (actionName != null) {
            PropertyDescriptor propDes = new PropertyDescriptor((Object)new ComponentController(){

                public Object getProperty() {
                    return actionName;
                }
            }, P_ELEMENT_DISPLAY_ACTIONTYPE);
            propDes.setCategory(P_CAP_CAT);
            this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        }
    }

    private void initErrorEventPropDescriptor() {
        PropertyDescriptor propDes = new PropertyDescriptor((Object)new ComponentController(){

            public Object getProperty() {
                return I18n.getString((String)TestResultNodePropertySource.this.m_node.getEvent().getId());
            }
        }, P_ELEMENT_DISPLAY_ERRORTYPE);
        propDes.setCategory(P_TESTERROR_CAT);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        final TestErrorEvent event = this.m_node.getEvent();
        if (event.getId().equals("TestErrorEvent.VerifyFailed")) {
            Set keys = event.getProps().keySet();
            for (final Object key : keys) {
                propDes = new PropertyDescriptor((Object)new ComponentController(){

                    public Object getProperty() {
                        return event.getProps().get(key);
                    }
                }, I18n.getString((String)((String)key)));
                propDes.setCategory(P_TESTERROR_CAT);
                this.addPropertyDescriptor((IPropertyDescriptor)propDes);
            }
        } else if (event.getProps().keySet().contains("guidancerErrorDescription")) {
            propDes = new PropertyDescriptor((Object)new ComponentController(){

                public Object getProperty() {
                    String key = (String)event.getProps().get("guidancerErrorDescription");
                    Object[] args = (Object[])event.getProps().get("guidancerErrorParameter");
                    if (args != null) {
                        return I18n.getString((String)key, (Object[])args);
                    }
                    return I18n.getString((String)key, (boolean)true);
                }
            }, I18n.getString((String)"guidancerErrorDescription"));
            propDes.setCategory(P_TESTERROR_CAT);
            this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        }
    }

    private void initEventTestCasePropDescriptor(INodePO node) {
        final IEventExecTestCasePO tc = (IEventExecTestCasePO)node;
        PropertyDescriptor propDes = new PropertyDescriptor((Object)new ComponentController(){

            public Object getProperty() {
                return I18n.getString((String)tc.getEventType());
            }
        }, Messages.TestResultNodePropertySourceErrorType);
        propDes.setCategory(Messages.TestResultNodeGUIPropertySourceEventhandler);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        propDes = new PropertyDescriptor((Object)new ComponentController(){

            public Object getProperty() {
                return tc.getReentryProp();
            }
        }, Messages.TestResultNodeGUIPropertySourceReentry);
        propDes.setCategory(Messages.TestResultNodeGUIPropertySourceEventhandler);
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
    }

    public Object getEditableValue() {
        return "noEditableValues";
    }

    public boolean isPropertySet(Object arg0) {
        return false;
    }

    public void resetPropertyValue(Object arg0) {
    }

    public void setPropertyValue(Object arg0, Object arg1) {
    }

    private abstract class ComponentController
    implements IPropertyController {
        private ComponentController() {
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public abstract Object getProperty();

        public Image getImage() {
            return null;
        }
    }
}

