/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.messagehandling;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.messagehandling.Message;

public class MessageIDs {
    public static final Integer E_FILE_IO = new Integer(1000);
    public static final Integer E_FILE_NOT_FOUND = new Integer(1001);
    public static final Integer E_PROPERTIES_FILE_NOT_FOUND = new Integer(1002);
    public static final Integer E_INVALID_WORKSPACE = new Integer(1003);
    public static final Integer E_CONFIG_ERROR = new Integer(1004);
    public static final Integer E_FILE_NO_PERMISSION = new Integer(1005);
    public static final Integer E_NO_DB_CONNECTION = new Integer(2000);
    public static final Integer E_PERSISTENCE_LOAD_FAILED = new Integer(2001);
    public static final Integer E_PERSISTENCE_CONFIG_PROBLEM = new Integer(2002);
    public static final Integer E_PERSISTENCE_CANT_CLOSE = new Integer(2003);
    public static final Integer E_PERSISTENCE_CANT_SETUP = new Integer(2004);
    public static final Integer E_PERSISTENCE_CANT_OPEN = new Integer(2005);
    public static final Integer E_CANT_READ_PROJECT = new Integer(2006);
    public static final Integer E_NO_DB_SESSION = new Integer(2007);
    public static final Integer E_START_TRANSACTION = new Integer(2008);
    public static final Integer E_ROLLBACK = new Integer(2009);
    public static final Integer E_ATTACH_PROJECT = new Integer(2010);
    public static final Integer E_DELETE_PROJECT = new Integer(2011);
    public static final Integer E_COMMIT_PROJECT = new Integer(2012);
    public static final Integer E_LOAD_PROJECT = new Integer(2013);
    public static final Integer E_READ_PROJECT = new Integer(2014);
    public static final Integer E_MAPPING_GENERAL = new Integer(2015);
    public static final Integer E_DATABASE_GENERAL = new Integer(2016);
    public static final Integer E_ALREADY_DELETED_PROJECT = new Integer(2017);
    public static final Integer E_DB_READ = new Integer(2018);
    public static final Integer E_MODIFIED_OBJECT = new Integer(2019);
    public static final Integer E_SAVE_TO_DB_FAILED = new Integer(2020);
    public static final Integer E_MASTER_REFRESH = new Integer(2021);
    public static final Integer E_OBJECT_IN_USE = new Integer(2022);
    public static final Integer E_STALE_OBJECT = new Integer(2023);
    public static final Integer E_COMMIT_FAILED = new Integer(2024);
    public static final Integer E_REFRESH_FAILED = new Integer(2025);
    public static final Integer E_REFRESH_REQUIRED = new Integer(2026);
    public static final Integer E_DB_SAVE = new Integer(2027);
    public static final Integer E_DB_IN_USE = new Integer(2028);
    public static final Integer E_TRANS_STARTED = new Integer(2029);
    public static final Integer E_EDITOR_REFRESH = new Integer(2030);
    public static final Integer E_INVALID_DB_VERSION = new Integer(2031);
    public static final Integer E_NOT_CHECKABLE_DB_VERSION = new Integer(2032);
    public static final Integer E_NO_DB_SCHEME = new Integer(2033);
    public static final Integer E_EDITOR_CLOSE = new Integer(2035);
    public static final Integer E_DELETED_TC = new Integer(2036);
    public static final Integer E_IMPORT_PROJECT_XML_FAILED = new Integer(2037);
    public static final Integer E_CANNOT_CHANGE_PARAMETER = new Integer(2038);
    public static final Integer E_SAVE_AS_PROJECT_FAILED = new Integer(2039);
    public static final Integer E_IMPORT_PROJECT_CONFIG_CONFLICT = new Integer(2040);
    public static final Integer E_LOAD_PROJECT_CONFIG_CONFLICT = new Integer(2041);
    public static final Integer E_CREATE_NEW_VERSION_FAILED = new Integer(2042);
    public static final Integer E_CREATE_NEW_PROJECT_FAILED = new Integer(2043);
    public static final Integer E_REVERT_EDITOR_CHANGES_FAILED = new Integer(2044);
    public static final Integer E_ADD_ATTACHMENTS_TO_MAIL_FAILED = new Integer(2045);
    public static final Integer E_OPEN_MAIL_CLIENT_FAILED = new Integer(2046);
    public static final Integer E_INVALID_PROJECT_VERSION = new Integer(2047);
    public static final Integer E_SCHEMA_LOAD_FAILED = new Integer(2058);
    public static final Integer E_ERROR_IN_SCHEMA_CONFIG = new Integer(2059);
    public static final Integer E_ERROR_IN_DB_CONFIG = new Integer(2060);
    public static final Integer E_DELETE_TESTRESULT = new Integer(2061);
    public static final Integer E_STORE_TESTRESULT = new Integer(2062);
    public static final Integer E_SQL_EXCEPTION = new Integer(2063);
    public static final Integer E_DB_PROFILE_NOT_EXIST = new Integer(2064);
    public static final Integer E_IMPORT_XML_FAILED = new Integer(2065);
    public static final Integer E_SERILIZATION_FAILED = new Integer(3001);
    public static final Integer E_UNSUPPORTED_LANGUAGE = new Integer(3002);
    public static final Integer E_DEPRECATED = new Integer(3003);
    public static final Integer E_UNEXPECTED_EXCEPTION = new Integer(3004);
    public static final Integer E_INVALID_GUI_STATE = new Integer(3005);
    public static final Integer E_UNKNOWN_DB_ERROR = new Integer(3006);
    public static final Integer E_UNKNOWN_OBJECT = new Integer(3007);
    public static final Integer E_ITEM_NOT_FOUND = new Integer(3008);
    public static final Integer E_NO_PERSPECTIVE = new Integer(3009);
    public static final Integer E_PROBLEM_VIEW_REFRESH = new Integer(3011);
    public static final Integer E_SYNCHRONIZATION = new Integer(3012);
    public static final Integer E_UNSUPPORTED_OS = new Integer(3013);
    public static final Integer E_SCRIPT_PARSING = new Integer(3014);
    public static final Integer E_NO_AUTCONFIG_DIALOG = new Integer(3015);
    public static final Integer E_CONVERTER_REUSED_PROJ_NOT_FOUND = new Integer(3016);
    public static final Integer E_AUT_TOOLKIT_NOT_AVAILABLE = new Integer(3017);
    public static final Integer E_NO_PARAMETER = new Integer(4000);
    public static final Integer E_DUPLICATE_ACTION = new Integer(4001);
    public static final Integer E_NO_ACTION = new Integer(4002);
    public static final Integer E_ABSTRACT_COMPONENT = new Integer(4003);
    public static final Integer E_MULTIPLE_COMPONENT = new Integer(4004);
    public static final Integer E_NO_COMPONENT = new Integer(4005);
    public static final Integer E_NO_ABSTRACT_COMPONENT = new Integer(4006);
    public static final Integer E_GENERAL_COMPONENT_ERROR = new Integer(4007);
    public static final Integer E_NO_TESTDATA = new Integer(4008);
    public static final Integer E_TYPE_SUPPORT = new Integer(4009);
    public static final Integer E_PO_NOT_FOUND = new Integer(4010);
    public static final Integer E_COMPONENT_NOT_FOUND = new Integer(4011);
    public static final Integer E_NO_REFERENCE = new Integer(4013);
    public static final Integer E_UNSUPPORTED_REENTRY = new Integer(4014);
    public static final Integer E_DOUBLE_EVENT = new Integer(4015);
    public static final Integer E_COMPONENT_NOT_MANAGED = new Integer(4016);
    public static final Integer E_COMPSYSTEM_PROBLEM = new Integer(4017);
    public static final Integer E_COMPONENT_ID_CREATION = new Integer(4019);
    public static final Integer E_NOT_SUPP_DATASOURCE = new Integer(4020);
    public static final Integer E_DATASOURCE_CONTAIN_EMPTY_DATA = new Integer(4021);
    public static final Integer E_DATASOURCE_MISSING_PARAMETER = new Integer(4022);
    public static final Integer E_NO_CAT_DELETE = new Integer(4023);
    public static final Integer E_DELETED_OBJECT = new Integer(4024);
    public static final Integer E_CURRENT_PROJ_DEL = new Integer(4025);
    public static final Integer E_DATASOURCE_FILE_IO = new Integer(4026);
    public static final Integer E_DATASOURCE_LOCALE_NOTSUPPORTED = new Integer(4027);
    public static final Integer E_DATASOURCE_MISSING_VALUES = new Integer(4028);
    public static final Integer E_OM_DUPLICATE_NAME = new Integer(4029);
    public static final Integer E_OM_WRONG_COMP_TYPE = new Integer(4030);
    public static final Integer E_PARAMETER_ERROR = new Integer(4031);
    public static final Integer E_RESERVED_COMP_NAME = new Integer(4032);
    public static final Integer E_CANNOT_SAVE_EDITOR = new Integer(4033);
    public static final Integer E_CANNOT_SAVE_EDITOR_TC_EX = new Integer(4034);
    public static final Integer E_CANNOT_SAVE_EDITOR_TC_SP = new Integer(4035);
    public static final Integer E_CANNOT_DELETE_AUT = new Integer(4036);
    public static final Integer E_CANNOT_DELETE_AUT_CONFIG = new Integer(4037);
    public static final Integer E_DELETE_PROJECT_LANG = new Integer(4038);
    public static final Integer E_ENOUGH_EVENT_HANDLER = new Integer(4039);
    public static final Integer E_PROJECTNAME_ALREADY_EXISTS = new Integer(4040);
    public static final Integer E_INCOMPATIBLE_COMP_TYPE = new Integer(4041);
    public static final Integer E_GENERAL_TOOLKIT_ERROR = new Integer(4042);
    public static final Integer E_PROJECTVERSION_ALREADY_EXISTS = new Integer(4043);
    public static final Integer E_PROJ_NAME_CONFLICT = new Integer(4045);
    public static final Integer E_PROJ_GUID_CONFLICT = new Integer(4046);
    public static final Integer E_LOAD_PROJECT_TOOLKIT_MAJOR_VERSION_ERROR = new Integer(4047);
    public static final Integer E_LOAD_PROJECT_XML_VERSION_ERROR = new Integer(4048);
    public static final Integer E_MOVE_TO_EXT_PROJ_ERROR_TOOLKITLEVEL = new Integer(4049);
    public static final Integer E_PROJ_CIRC_DEPEND = new Integer(4050);
    public static final Integer E_COMP_TYPE_INCOMPATIBLE = new Integer(4051);
    public static final Integer E_DATASOURCE_READ_ERROR = new Integer(4052);
    public static final Integer E_MOVE_TC_COMP_NAME_EXISTS = new Integer(4053);
    public static final Integer E_MOVE_TC_COMP_TYPE_INCOMPATIBLE = new Integer(4054);
    public static final Integer E_UNSUPPORTED_TOOLKIT = new Integer(4055);
    public static final Integer E_NO_FUNCTION = new Integer(4056);
    public static final Integer E_AUT_CONNECTION_INIT = new Integer(5000);
    public static final Integer E_CONNECTED_CONNECTION = new Integer(5001);
    public static final Integer E_UNCONNECTED_CONNECTION = new Integer(5002);
    public static final Integer E_GENERAL_CONNECTION = new Integer(5003);
    public static final Integer E_UNKNOWN_HOST = new Integer(5004);
    public static final Integer E_NO_SERVER_CONNECTION_INIT = new Integer(5005);
    public static final Integer E_TIMEOUT_CONNECTION = new Integer(5006);
    public static final Integer E_INTERRUPTED_CONNECTION = new Integer(5007);
    public static final Integer E_VERSION_ERROR = new Integer(5008);
    public static final Integer E_AUT_START = new Integer(5009);
    public static final Integer E_SERVER_ERROR = new Integer(5010);
    public static final Integer E_NO_AUT_CONNECTION_ERROR = new Integer(5011);
    public static final Integer E_INVALID_HEADER = new Integer(6000);
    public static final Integer E_COMPONENT_UNSUPPORTED = new Integer(6001);
    public static final Integer E_INTERFACE_UNIMPLEMENTED = new Integer(6002);
    public static final Integer E_LINKAGE = new Integer(6003);
    public static final Integer E_INSTANTIATION = new Integer(6004);
    public static final Integer E_ILLEGAL_ACCESS = new Integer(6005);
    public static final Integer E_SECURITY = new Integer(6006);
    public static final Integer E_CLASS_NOT_FOUND = new Integer(6007);
    public static final Integer E_COMPONENT_NOT_INSTANTIATED = new Integer(6008);
    public static final Integer E_COMMAND_NOT_CREATED = new Integer(6009);
    public static final Integer E_COMMAND_NOT_ASSIGNABLE = new Integer(6010);
    public static final Integer E_MESSAGE_NOT_TO_REQUEST = new Integer(6011);
    public static final Integer E_NO_MESSAGE_TO_SEND = new Integer(6012);
    public static final Integer E_MESSAGE_NOT_SEND = new Integer(6013);
    public static final Integer E_MESSAGE_SEND = new Integer(6014);
    public static final Integer E_MESSAGE_REQUEST = new Integer(6015);
    public static final Integer E_COMMUNICATOR_CONNECTION = new Integer(6016);
    public static final Integer E_NO_RECEIVING_COMMAND = new Integer(6017);
    public static final Integer E_MESSAGE_NOT_CREATED = new Integer(6018);
    public static final Integer E_MESSAGE_NOT_ASSIGNABLE = new Integer(6019);
    public static final Integer E_CANNOT_OPEN_EDITOR = new Integer(7000);
    public static final Integer E_NO_OPENED_EDITOR = new Integer(7001);
    public static final Integer E_UNSUPPORTED_NODE = new Integer(7002);
    public static final Integer E_CANNOT_OPEN_PERSPECTIVE = new Integer(7003);
    public static final Integer E_CANNOT_SAVE_UNLOCKED = new Integer(7004);
    public static final Integer E_CANNOT_SAVE_INVALID = new Integer(7005);
    public static final Integer E_NULL_SESSION = new Integer(7006);
    public static final Integer E_NON_RECOVERABLE = new Integer(7007);
    public static final Integer E_SESSION_FAILED = new Integer(7008);
    public static final Integer E_TEST_EXECUTION_ERROR = new Integer(7009);
    public static final Integer E_UNRESOLV_VAR_ERROR = new Integer(7010);
    public static final Integer E_SYNTAX_ERROR = new Integer(7011);
    public static final Integer E_TEST_STEP_NOT_CREATED = new Integer(7012);
    public static final Integer E_FUNCTION_EVAL_ERROR = new Integer(7013);
    public static final Integer E_EVENT_SUPPORT = new Integer(8000);
    public static final Integer E_ROBOT = new Integer(8001);
    public static final Integer E_STEP_EXEC = new Integer(8002);
    public static final Integer E_STEP_VERIFY = new Integer(8003);
    public static final Integer E_SCRIPT_NOT_FOUND = new Integer(9000);
    public static final Integer E_PROJECT_NOT_FOUND = new Integer(9001);
    public static final Integer E_REPOSITORY_NOT_FOUND = new Integer(9002);
    public static final Integer E_LOGIN_FAILED = new Integer(9003);
    public static final Integer E_COMMAND_ABORTED = new Integer(9004);
    public static final Integer E_AUTHENTICATION_FAILED = new Integer(9005);
    public static final Integer E_WORKING_DIRECTORY_NOT_FOUND = new Integer(9006);
    public static final Integer E_IO_EXCEPTION = new Integer(9007);
    public static final Integer E_GENERAL_PARSE_ERROR = new Integer(9501);
    public static final Integer E_PARSE_NAME_ERROR = new Integer(9502);
    public static final Integer E_MISSING_CLOSING_BRACE = new Integer(9503);
    public static final Integer E_INCOMPL_QUOTES = new Integer(9504);
    public static final Integer E_ONE_CHAR_PARSE_ERROR = new Integer(9506);
    public static final Integer E_NO_REF_FOR_SPEC_TC = new Integer(9507);
    public static final Integer E_INVALID_REF = new Integer(9508);
    public static final Integer E_MISSING_CONTENT = new Integer(9509);
    public static final Integer E_INVALID_REF_TYPE = new Integer(9510);
    public static final Integer E_INVALID_VAR_NAME = new Integer(9511);
    public static final Integer E_REF_IN_TS = new Integer(9512);
    public static final Integer E_BAD_INT = new Integer(9513);
    public static final Integer E_NEG_VAL = new Integer(9514);
    public static final Integer E_TOO_BIG_VALUE = new Integer(9515);
    public static final Integer E_TOO_SMALL_VALUE = new Integer(9516);
    public static final Integer E_NOT_SUPP_COMBO_ITEM = new Integer(9517);
    public static final Integer E_REF_IN_TDC = new Integer(9518);
    public static final Integer E_MISSING_FUNCTION_NAME = new Integer(9519);
    public static final Integer E_FUNCTION_NOT_REGISTERED = new Integer(9520);
    public static final Integer E_WRONG_NUM_FUNCTION_ARGS = new Integer(9521);
    public static final Integer E_WRONG_PARAMETER_VALUE = new Integer(9522);
    public static final Integer Q_DELETE_ACTUAL_PROJECT = new Integer(0);
    public static final Integer Q_DELETE_PROJECT = new Integer(1);
    public static final Integer Q_SAVE_AND_EXTRACT = new Integer(2);
    public static final Integer Q_TYPE_REFERENCE = new Integer(3);
    public static final Integer Q_MERGE_CATEGORY = new Integer(5);
    public static final Integer Q_EXCELDATA_INPUT = new Integer(6);
    public static final Integer Q_CLEAN_OM = new Integer(7);
    public static final Integer Q_REMOVE_PROJECT_LANGUAGES = new Integer(8);
    public static final Integer Q_LOAD_PROJECT_TOOLKIT_MINOR_VERSION_LOWER = new Integer(9);
    public static final Integer Q_CHANGE_INTERFACE_REMOVE_PARAM = new Integer(10);
    public static final Integer Q_CHANGE_INTERFACE_CHANGE_PARAM_TYPE = new Integer(11);
    public static final Integer Q_SAVE_AND_GENERATE = new Integer(12);
    public static final Integer Q_CHANGE_INTERFACE_CHANGE_PARAM_NAME = new Integer(13);
    public static final Integer W_OLD_GD_VERSION = new Integer(500);
    public static final Integer W_MAX_CHAR = new Integer(501);
    public static final Integer W_SCRIPT_WAS_PARSED = new Integer(502);
    public static final Integer W_PROJECT_TOOLKIT_NOT_AVAILABLE = new Integer(503);
    public static final Integer I_CONVERT_PREFS = new Integer(100);
    public static final Integer I_CVS_NOT_ENABLED = new Integer(101);
    public static final Integer I_OPEN_PROJECT = new Integer(102);
    public static final Integer I_DELETE_CATEGORY = new Integer(103);
    public static final Integer I_NO_VERSIONS_IN_HERE = new Integer(104);
    public static final Integer I_OLD_GD_VERSION = new Integer(105);
    public static final Integer I_SAVE_AND_REOPEN_EDITOR = new Integer(106);
    public static final Integer I_LOCK_OBJ_1 = new Integer(107);
    public static final Integer I_LOCK_OBJ_2 = new Integer(108);
    public static final Integer I_LOCK_OBJ_3 = new Integer(109);
    public static final Integer I_NO_PROJECT_IN_DB = new Integer(110);
    public static final Integer I_REUSED_SPEC_TCS = new Integer(111);
    public static final Integer I_EDITORS_TO_CLOSE = new Integer(112);
    public static final Integer I_EDITORS_TO_SAVE = new Integer(113);
    public static final Integer I_TOO_LONG_CLASSPATH = new Integer(114);
    public static final Integer I_WRONG_SERVER_PREFS = new Integer(115);
    public static final Integer I_NO_PARAM_AT_NODE_TO_PUT_DATA = new Integer(116);
    public static final Integer I_STARTED_AUT_CHANGED = new Integer(117);
    public static final Integer I_FILE_LOGGING_NOT_ENABLED = new Integer(118);
    public static final Integer I_COULD_NOT_REMOVE_REUSED_PROJECTS = new Integer(119);
    public static final Integer I_CANNOT_MOVE_TC = new Integer(120);
    public static final Integer I_SERVER_NAME_ADDED = new Integer(121);
    public static final Integer I_SAVE_EDITOR = new Integer(122);
    public static final Integer I_REUSED_TS = new Integer(123);
    public static final Integer I_SERVER_CANNOT_CONNECTED = new Integer(124);
    public static final Integer I_REUSED_TDC = new Integer(125);
    public static final Integer I_NON_EDITABLE_NODE = new Integer(126);
    public static final Integer I_DB_BACKGROUND_JOB = new Integer(127);
    public static final Integer I_NO_CLIENT_LOG_FOUND = new Integer(128);
    public static final Integer I_NO_PERSPECTIVE_CHANGE = new Integer(129);
    public static final Integer I_NOT_SAME_SPEC = new Integer(130);
    public static final Integer I_NO_EXEC = new Integer(131);
    public static final Integer I_ALL_TCS_MUST_USE_SAME_CTDS = new Integer(132);
    public static final Integer I_TCS_HAVE_NO_CHANGEABLE_PARAMETER_NAME = new Integer(133);
    private static MessageMap messageMap = null;

    private MessageIDs() {
    }

    public static String getMessage(Integer id) {
        MessageIDs.initErrorMap();
        if (id == null) {
            return I18n.getString("ErrorMessage.generalInternalError");
        }
        return ((Message)messageMap.get(id)).getMessage(null);
    }

    private static void initErrorMap() {
        if (messageMap == null) {
            messageMap = new MessageMap();
            MessageIDs.createIOErrorMessages();
            MessageIDs.createDatabaseErrorMessages();
            MessageIDs.createGeneralErrorMessages();
            MessageIDs.createDatamodelErrorMessages();
            MessageIDs.createConnectionErrorMessages();
            MessageIDs.createParamValueErrorMessages();
            MessageIDs.createServerErrorMessages();
            MessageIDs.createRuntimeErrorMessages();
            MessageIDs.createServerRuntimeErrorMessages();
            MessageIDs.createVersionControlErrorMessages();
            MessageIDs.createQuestionMessages();
            MessageIDs.createInfoMessages();
            MessageIDs.createWarningMessages();
        }
    }

    private static void createDatamodelErrorMessages() {
        int e = 4;
        messageMap.put(E_NO_PARAMETER, e, "ErrorMessage.NO_PARAMETER", null);
        messageMap.put(E_DUPLICATE_ACTION, e, "ErrorMessage.DUPLICATE_ACTION", null);
        messageMap.put(E_NO_ACTION, e, "ErrorMessage.NO_ACTION", null);
        messageMap.put(E_ABSTRACT_COMPONENT, e, "ErrorMessage.ABSTRACT_COMPONENT", null);
        messageMap.put(E_MULTIPLE_COMPONENT, e, "ErrorMessage.MULTIPLE_COMPONENT", null);
        messageMap.put(E_NO_COMPONENT, e, "ErrorMessage.NO_COMPONENT", new String[]{"ErrorDetail.NO_COMPONENT"});
        messageMap.put(E_NO_ABSTRACT_COMPONENT, e, "ErrorMessage.NO_ABSTRACT_COMPONENT", null);
        messageMap.put(E_GENERAL_COMPONENT_ERROR, e, "ErrorMessage.GENERAL_COMPONENT_ERROR", null);
        messageMap.put(E_NO_TESTDATA, e, "ErrorMessage.NO_TESTDATA", null);
        messageMap.put(E_TYPE_SUPPORT, e, "ErrorMessage.TYPE_SUPPORT", null);
        messageMap.put(E_PO_NOT_FOUND, e, "ErrorMessage.PO_NOT_FOUND", null);
        messageMap.put(E_COMPONENT_NOT_FOUND, e, "ErrorMessage.COMPONENT_NOT_FOUND", null);
        messageMap.put(E_NO_REFERENCE, e, "ErrorMessage.NO_REFERENCE", null);
        messageMap.put(E_UNSUPPORTED_REENTRY, e, "ErrorMessage.UNSUPPORTED_REENTRY", null);
        messageMap.put(E_DOUBLE_EVENT, e, "ErrorMessage.DOUBLE_EVENT", null);
        messageMap.put(E_COMPONENT_NOT_MANAGED, e, "ErrorMessage.COMPONENT_NOT_MANAGED", null);
        messageMap.put(E_COMPSYSTEM_PROBLEM, e, "ErrorMessage.COMPSYSTEM_PROBLEM", null);
        messageMap.put(E_COMPONENT_ID_CREATION, e, "ErrorMessage.COMPONENT_ID_CREATION", null);
        messageMap.put(E_NOT_SUPP_DATASOURCE, e, "ErrorMessage.NOT_SUPP_DATASOURCE", null);
        messageMap.put(E_DATASOURCE_CONTAIN_EMPTY_DATA, e, "ErrorMessage.DATASOURCE_CONTAIN_EMPTY_DATA", null);
        messageMap.put(E_DATASOURCE_FILE_IO, e, "ErrorMessage.DATASOURCE_FILE_IO", null);
        messageMap.put(E_DATASOURCE_MISSING_PARAMETER, e, "ErrorMessage.DATASOURCE_MISSING_PARAMETER", null);
        messageMap.put(E_NO_CAT_DELETE, e, "ErrorMessage.NO_CAT_DELETE", null);
        messageMap.put(E_DELETED_OBJECT, e, "ErrorMessage.DELETED_OBJECT", null);
        messageMap.put(E_CURRENT_PROJ_DEL, e, "ErrorMessage.CURRENT_PROJ_DEL", null);
        messageMap.put(E_DATASOURCE_LOCALE_NOTSUPPORTED, e, "ErrorMessage.DATASOURCE_LOCALE_NOTSUPPORTED", null);
        messageMap.put(E_DATASOURCE_READ_ERROR, e, "ErrorMessage.DATASOURCE_READ_ERROR", null);
        messageMap.put(E_DATASOURCE_MISSING_VALUES, e, "ErrorMessage.DATASOURCE_MISSING_VALUES", null);
        messageMap.put(E_OM_DUPLICATE_NAME, e, "ErrorMessage.OM_DUPLICATE_NAME", null);
        messageMap.put(E_OM_WRONG_COMP_TYPE, e, "ErrorMessage.OM_WRONG_COMP_TYPE", null);
        messageMap.put(E_PARAMETER_ERROR, e, "ErrorMessage.PARAMETER_ERROR", null);
        messageMap.put(E_RESERVED_COMP_NAME, e, "ErrorMessage.RESERVED_COMP_NAME", null);
        messageMap.put(E_CANNOT_SAVE_EDITOR, e, "ErrorMessage.CANNOT_SAVE_EDITOR", null);
        messageMap.put(E_CANNOT_SAVE_EDITOR_TC_EX, e, "ErrorMessage.CANNOT_SAVE_EDITOR_TC_EX", null);
        messageMap.put(E_CANNOT_SAVE_EDITOR_TC_SP, e, "ErrorMessage.CANNOT_SAVE_EDITOR_TC_SP", null);
        messageMap.put(E_CANNOT_DELETE_AUT, e, "ErrorMessage.CANNOT_DELETE_AUT", new String[]{"ErrorDetail.CANNOT_DELETE_AUT"});
        messageMap.put(E_CANNOT_DELETE_AUT_CONFIG, e, "ErrorMessage.CANNOT_DELETE_AUT_CONFIG", new String[]{"ErrorDetail.CANNOT_DELETE_AUT_CONFIG"});
        messageMap.put(E_DELETE_PROJECT_LANG, e, "ErrorMessage.DELETE_PROJECT_LANG", new String[]{"ErrorDetail.DELETE_PROJECT_LANG"});
        messageMap.put(E_ENOUGH_EVENT_HANDLER, e, "ErrorMessage.ENOUGH_EVENT_HANDLER", null);
        messageMap.put(E_PROJECTNAME_ALREADY_EXISTS, e, "ErrorMessage.PROJECTNAME_ALREADY_EXISTS", new String[]{"ErrorDetail.PROJECTNAME_ALREADY_EXISTS"});
        messageMap.put(E_INCOMPATIBLE_COMP_TYPE, e, "ErrorMessage.INCOMPATIBLE_COMP_TYPE", null);
        messageMap.put(E_GENERAL_TOOLKIT_ERROR, e, "ErrorMessage.GENERAL_TOOLKIT_ERROR", null);
        messageMap.put(E_PROJECTVERSION_ALREADY_EXISTS, e, "ErrorMessage.PROJECTVERSION_ALREADY_EXISTS", new String[]{"ErrorDetail.PROJECTVERSION_ALREADY_EXISTS"});
        messageMap.put(E_PROJ_NAME_CONFLICT, e, "ErrorMessage.PROJ_NAME_CONFLICT", new String[]{"ErrorDetail.PROJ_NAME_CONFLICT"});
        messageMap.put(E_PROJ_GUID_CONFLICT, e, "ErrorMessage.PROJ_GUID_CONFLICT", new String[]{"ErrorDetail.PROJ_GUID_CONFLICT"});
        messageMap.put(E_LOAD_PROJECT_TOOLKIT_MAJOR_VERSION_ERROR, e, "ErrorMessage.CANNOT_LOAD_PROJECT_TOOLKIT_VERSION_ERROR", null);
        messageMap.put(E_MOVE_TO_EXT_PROJ_ERROR_TOOLKITLEVEL, e, "ErrorMessage.MOVE_TO_EXT_PROJ_ERROR_TOOLKITLEVEL", null);
        messageMap.put(E_PROJ_CIRC_DEPEND, e, "ErrorMessage.PROJ_CIRC_DEPEND", new String[]{"ErrorDetail.PROJ_CIRC_DEPEND"});
        messageMap.put(E_COMP_TYPE_INCOMPATIBLE, e, "ErrorMessage.COMP_TYPE_INCOMPATIBLE", null);
        messageMap.put(E_MOVE_TC_COMP_NAME_EXISTS, e, "ErrorMessage.MOVE_TC_COMP_NAME_EXISTS", new String[]{"ErrorDetail.MOVE_TC_COMP_NAME_EXISTS"});
        messageMap.put(E_MOVE_TC_COMP_TYPE_INCOMPATIBLE, e, "ErrorMessage.MOVE_TC_COMP_TYPE_INCOMPATIBLE", new String[]{"ErrorDetail.MOVE_TC_COMP_TYPE_INCOMPATIBLE"});
    }

    private static void createGeneralErrorMessages() {
        int e = 4;
        messageMap.put(E_SERILIZATION_FAILED, e, "ErrorMessage.SERILIZATION_FAILED", null);
        messageMap.put(E_UNSUPPORTED_LANGUAGE, e, "ErrorMessage.UNSUPPORTED_LANGUAGE", null);
        messageMap.put(E_DEPRECATED, e, "ErrorMessage.DEPRECATED", null);
        messageMap.put(E_UNEXPECTED_EXCEPTION, e, "ErrorMessage.UNEXPECTED_EXCEPTION", new String[]{"ErrorDetail.UNEXPECTED_EXCEPTION"});
        messageMap.put(E_INVALID_GUI_STATE, e, "ErrorMessage.INVALID_GUI_STATE", null);
        messageMap.put(E_UNKNOWN_DB_ERROR, e, "ErrorMessage.UNKNOWN_DB_ERROR", new String[]{I18n.getString("ErrorDetail.UNKNOWN_DB_ERROR")});
        messageMap.put(E_UNKNOWN_OBJECT, e, "ErrorMessage.UNKNOWN_OBJECT", null);
        messageMap.put(E_ITEM_NOT_FOUND, e, "ErrorMessage.ITEM_NOT_FOUND", null);
        messageMap.put(E_NO_PERSPECTIVE, e, "ErrorMessage.NO_PERSPECTIVE", new String[]{"ErrorDetail.NO_PERSPECTIVE"});
        messageMap.put(I_NO_PERSPECTIVE_CHANGE, e, "ErrorMessage.NO_PERSPECTIVE_CHANGE", null);
        messageMap.put(E_PROBLEM_VIEW_REFRESH, e, "ErrorMessage.PROBLEM_VIEW_REFRESH", null);
        messageMap.put(E_SYNCHRONIZATION, e, "ErrorMessage.SYNCHRONIZATION", null);
        messageMap.put(E_UNSUPPORTED_OS, e, "ErrorMessage.UNSUPPORTED_OS", null);
        messageMap.put(E_SCRIPT_PARSING, e, "ErrorMessage.SCRIPT_PARSING", new String[]{"ErrorDetail.SCRIPT_PARSING"});
        messageMap.put(E_NO_AUTCONFIG_DIALOG, e, "ErrorMessage.NO_AUTCONFIG_DIALOG", new String[]{"ErrorDetail.MISSING_TOOLKIT"});
        messageMap.put(E_CONVERTER_REUSED_PROJ_NOT_FOUND, e, "ErrorMessage.CONVERTER_REUSED_PROJ_NOT_FOUND", null);
        messageMap.put(E_AUT_TOOLKIT_NOT_AVAILABLE, e, "ErrorMessage.AUT_TOOLKIT_NOT_AVAILABLE", new String[]{"ErrorDetail.MISSING_TOOLKIT"});
    }

    private static void createConnectionErrorMessages() {
        int e = 4;
        messageMap.put(E_AUT_CONNECTION_INIT, e, "ErrorMessage.AUT_CONNECTION_INIT", null);
        messageMap.put(E_CONNECTED_CONNECTION, e, "ErrorMessage.CONNECTED_CONNECTION", null);
        messageMap.put(E_UNCONNECTED_CONNECTION, e, "ErrorMessage.UNCONNECTED_CONNECTION", null);
        messageMap.put(E_GENERAL_CONNECTION, e, "ErrorMessage.GENERAL_CONNECTION", null);
        messageMap.put(E_NO_SERVER_CONNECTION_INIT, e, "ErrorMessage.NO_SERVER_CONNECTION_INIT", null);
        messageMap.put(E_UNKNOWN_HOST, e, "ErrorMessage.UNKNOWN_HOST", null);
        messageMap.put(E_TIMEOUT_CONNECTION, e, "ErrorMessage.TIMEOUT_CONNECTION", null);
        messageMap.put(E_INTERRUPTED_CONNECTION, e, "ErrorMessage.INTERRUPTED_CONNECTION", null);
        messageMap.put(E_VERSION_ERROR, e, "ErrorMessage.VERSION_ERROR", null);
        messageMap.put(E_AUT_START, e, "ErrorMessage.AUT_START", null);
        messageMap.put(E_SERVER_ERROR, e, "ErrorMessage.SERVER_ERROR", null);
        messageMap.put(E_NO_AUT_CONNECTION_ERROR, e, "ErrorMessage.NO_AUT_CONNECTION_ERROR", new String[]{"ErrorDetail.NO_AUT_CONNECTION_ERROR"});
    }

    private static void createServerErrorMessages() {
        int e = 4;
        messageMap.put(E_INVALID_HEADER, e, "ErrorMessage.INVALID_HEADER", null);
        messageMap.put(E_COMPONENT_UNSUPPORTED, e, "ErrorMessage.COMPONENT_UNSUPPORTED", null);
        messageMap.put(E_INTERFACE_UNIMPLEMENTED, e, "ErrorMessage.INTERFACE_UNIMPLEMENTED", null);
        messageMap.put(E_LINKAGE, e, "ErrorMessage.LINKAGE", null);
        messageMap.put(E_ILLEGAL_ACCESS, e, "ErrorMessage.ILLEGAL_ACCESS", null);
        messageMap.put(E_SECURITY, e, "ErrorMessage.SECURITY", null);
        messageMap.put(E_INSTANTIATION, e, "ErrorMessage.INSTANTIATION", null);
        messageMap.put(E_CLASS_NOT_FOUND, e, "ErrorMessage.CLASS_NOT_FOUND", null);
        messageMap.put(E_COMMAND_NOT_CREATED, e, "ErrorMessage.COMMAND_NOT_CREATED", new String[]{"ErrorDetail.SUPPORT"});
        messageMap.put(E_COMMAND_NOT_ASSIGNABLE, e, "ErrorMessage.COMMAND_NOT_ASSIGNABLE", new String[]{"ErrorDetail.SUPPORT"});
        messageMap.put(E_COMPONENT_NOT_INSTANTIATED, e, "ErrorMessage.COMPONENT_NOT_INSTANTIATED", null);
        messageMap.put(E_MESSAGE_NOT_TO_REQUEST, e, "ErrorMessage.MESSAGE_NOT_TO_REQUEST", null);
        messageMap.put(E_NO_MESSAGE_TO_SEND, e, "ErrorMessage.NO_MESSAGE_TO_SEND", null);
        messageMap.put(E_MESSAGE_SEND, e, "ErrorMessage.MESSAGE_SEND", null);
        messageMap.put(E_MESSAGE_NOT_SEND, e, "ErrorMessage.MESSAGE_NOT_SEND", null);
        messageMap.put(E_MESSAGE_REQUEST, e, "ErrorMessage.MESSAGE_REQUEST", null);
        messageMap.put(E_COMMUNICATOR_CONNECTION, e, "ErrorMessage.COMMUNICATOR_CONNECTION", null);
        messageMap.put(E_NO_RECEIVING_COMMAND, e, "ErrorMessage.NO_RECEIVING_COMMAND", null);
        messageMap.put(E_MESSAGE_NOT_CREATED, e, "ErrorMessage.MESSAGE_NOT_CREATED", new String[]{"ErrorDetail.SUPPORT"});
        messageMap.put(E_MESSAGE_NOT_ASSIGNABLE, e, "ErrorMessage.MESSAGE_NOT_ASSIGNABLE", new String[]{"ErrorDetail.SUPPORT"});
    }

    private static void createDatabaseErrorMessages() {
        int e = 4;
        messageMap.put(E_NO_DB_CONNECTION, e, "ErrorMessage.NO_DB_CONNECTION", null);
        messageMap.put(E_PERSISTENCE_LOAD_FAILED, e, "ErrorMessage.PERSISTENCE_LOAD_FAILED", null);
        messageMap.put(E_PERSISTENCE_CONFIG_PROBLEM, e, "ErrorMessage.PERSISTENCE_CONFIG_PROBLEM", null);
        messageMap.put(E_PERSISTENCE_CANT_CLOSE, e, "ErrorMessage.PERSISTENCE_CANT_CLOSE", null);
        messageMap.put(E_PERSISTENCE_CANT_SETUP, e, "ErrorMessage.PERSISTENCE_CANT_SETUP", null);
        messageMap.put(E_PERSISTENCE_CANT_OPEN, e, "ErrorMessage.PERSISTENCE_CANT_OPEN", null);
        messageMap.put(E_CANT_READ_PROJECT, e, "ErrorMessage.CANT_READ_PROJECT", null);
        messageMap.put(E_NO_DB_SESSION, e, "ErrorMessage.NO_DB_SESSION", null);
        messageMap.put(E_START_TRANSACTION, e, "ErrorMessage.START_TRANSACTION", null);
        messageMap.put(E_ROLLBACK, e, "ErrorMessage.ROLLBACK", null);
        messageMap.put(E_ATTACH_PROJECT, e, "ErrorMessage.ATTACH_PROJECT", null);
        messageMap.put(E_DELETE_PROJECT, e, "ErrorMessage.DELETE_PROJECT", null);
        messageMap.put(E_COMMIT_PROJECT, e, "ErrorMessage.COMMIT_PROJECT", null);
        messageMap.put(E_READ_PROJECT, e, "ErrorMessage.READ_PROJECT", null);
        messageMap.put(E_LOAD_PROJECT, e, "ErrorMessage.LOAD_PROJECT", null);
        messageMap.put(E_LOAD_PROJECT_CONFIG_CONFLICT, e, "ErrorMessage.LOAD_PROJECT_CONFIG_CONFLICT", null);
        messageMap.put(E_MAPPING_GENERAL, e, "ErrorMessage.MAPPING_GENERAL", null);
        messageMap.put(E_DATABASE_GENERAL, e, "ErrorMessage.DATABASE_GENERAL", null);
        messageMap.put(E_ALREADY_DELETED_PROJECT, e, "ErrorMessage.ALREADY_DELETED_PROJECT", null);
        messageMap.put(E_DB_READ, e, "ErrorMessage.DB_READ", null);
        messageMap.put(E_MODIFIED_OBJECT, e, "ErrorMessage.MODIFIED_OBJECT", null);
        messageMap.put(E_SAVE_TO_DB_FAILED, e, "ErrorMessage.SAVE_TO_DB_FAILED", null);
        messageMap.put(E_MASTER_REFRESH, e, "ErrorMessage.MASTER_REFRESH", null);
        messageMap.put(E_OBJECT_IN_USE, e, "ErrorMessage.OBJECT_IN_USE", null);
        messageMap.put(E_STALE_OBJECT, e, "ErrorMessage.STALE_OBJECT", null);
        messageMap.put(E_COMMIT_FAILED, e, "ErrorMessage.COMMIT_FAILED", null);
        messageMap.put(E_REFRESH_FAILED, e, "ErrorMessage.REFRESH_FAILED", null);
        messageMap.put(E_REFRESH_REQUIRED, e, "ErrorMessage.REFRESH_REQUIRED", null);
        messageMap.put(E_DB_SAVE, e, "ErrorMessage.DB_SAVE", null);
        messageMap.put(E_DB_IN_USE, e, "ErrorMessage.DB_IN_USE", null);
        messageMap.put(E_TRANS_STARTED, e, "ErrorMessage.TRANS_STARTED", null);
        messageMap.put(E_EDITOR_REFRESH, e, "ErrorMessage.EDITOR_REFRESH", null);
        messageMap.put(E_INVALID_DB_VERSION, e, "ErrorMessage.INVALID_DB_VERSION", null);
        messageMap.put(E_NOT_CHECKABLE_DB_VERSION, e, "ErrorMessage.NOT_CHECKABLE_DB_VERSION", null);
        messageMap.put(E_NO_DB_SCHEME, e, "ErrorMessage.NO_DB_SCHEME", new String[]{"ErrorDetail.NO_DB_SCHEME"});
        messageMap.put(E_EDITOR_CLOSE, e, "ErrorMessage.EDITOR_CLOSE", null);
        messageMap.put(E_DELETED_TC, e, "ErrorMessage.DELETED_TC", null);
        messageMap.put(E_IMPORT_PROJECT_XML_FAILED, e, "ErrorMessage.IMPORT_PROJECT_XML_FAILED", null);
        messageMap.put(E_IMPORT_XML_FAILED, e, "ErrorMessage.IMPORT_XML_FAILED", null);
        messageMap.put(E_IMPORT_PROJECT_CONFIG_CONFLICT, e, "ErrorMessage.IMPORT_PROJECT_CONFIG_CONFLICT", null);
        messageMap.put(E_CANNOT_CHANGE_PARAMETER, e, "ErrorMessage.CANNOT_CHANGE_PARAMETER", null);
        messageMap.put(E_SAVE_AS_PROJECT_FAILED, e, "ErrorMessage.SAVE_AS_PROJECT_FAILED", null);
        messageMap.put(E_CREATE_NEW_VERSION_FAILED, e, "ErrorMessage.CREATE_NEW_VERSION_FAILED", null);
        messageMap.put(E_CREATE_NEW_PROJECT_FAILED, e, "ErrorMessage.CREATE_NEW_PROJECT_FAILED", null);
        messageMap.put(E_REVERT_EDITOR_CHANGES_FAILED, e, "ErrorMessage.REVERT_EDITOR_CHANGES_FAILED", null);
        messageMap.put(E_ADD_ATTACHMENTS_TO_MAIL_FAILED, e, "ErrorMessage.ADD_ATTACHMENTS_TO_MAIL_FAILED", null);
        messageMap.put(E_OPEN_MAIL_CLIENT_FAILED, e, "ErrorMessage.OPEN_MAIL_CLIENT_FAILED", null);
        messageMap.put(E_INVALID_PROJECT_VERSION, e, "ErrorMessage.INVALID_PROJECT_VERSION", null);
        messageMap.put(E_SCHEMA_LOAD_FAILED, e, "ErrorMessage.SCHEMA_LOAD_FAILED", null);
        messageMap.put(E_ERROR_IN_SCHEMA_CONFIG, e, "ErrorMessage.ERROR_IN_SCHEMA_CONFIG", null);
        messageMap.put(E_ERROR_IN_DB_CONFIG, e, "ErrorMessage.ERROR_IN_DB_CONFIG", null);
        messageMap.put(E_DELETE_TESTRESULT, e, "ErrorMessage.DELETE_TESTRESULT", null);
        messageMap.put(E_STORE_TESTRESULT, e, "ErrorMessage.STORE_TESTRESULT", null);
        messageMap.put(E_SQL_EXCEPTION, e, "ErrorMessage.SQL_ERROR", null);
        messageMap.put(E_DB_PROFILE_NOT_EXIST, e, "ErrorMessage.DB_PROFILE_ERROR", null);
    }

    private static void createIOErrorMessages() {
        int e = 4;
        messageMap.put(E_FILE_IO, e, "ErrorMessage.FILE_IO", null);
        messageMap.put(E_FILE_NOT_FOUND, e, "ErrorMessage.FILE_NOT_FOUND", null);
        messageMap.put(E_PROPERTIES_FILE_NOT_FOUND, e, "ErrorMessage.PROPERTIES_FILE_NOT_FOUND", new String[]{"ErrorDetail.PROPERTIES_FILE_NOT_FOUND"});
        messageMap.put(E_INVALID_WORKSPACE, e, "ErrorMessage.INVALID_WORKSPACE", new String[]{"ErrorDetail.INVALID_WORKSPACE"});
        messageMap.put(E_CONFIG_ERROR, e, "ErrorMessage.CONFIG_ERROR", null);
        messageMap.put(E_FILE_NO_PERMISSION, e, "ErrorMessage.FILE_NO_PERMISSION", null);
    }

    private static void createParamValueErrorMessages() {
        int e = 4;
        messageMap.put(E_GENERAL_PARSE_ERROR, e, "ErrorMessage.GENERAL_PARSE_ERROR", null);
        messageMap.put(E_PARSE_NAME_ERROR, e, "ErrorMessage.PARSE_NAME_ERROR", null);
        messageMap.put(E_MISSING_CLOSING_BRACE, e, "ErrorMessage.MISSING_CLOSING_BRACE", null);
        messageMap.put(E_INCOMPL_QUOTES, e, "ErrorMessage.INCOMPL_QUOTES", null);
        messageMap.put(E_ONE_CHAR_PARSE_ERROR, e, "ErrorMessage.ONE_CHAR_PARSE_ERROR", null);
        messageMap.put(E_NO_REF_FOR_SPEC_TC, e, "ErrorMessage.NO_REF_FOR_SPEC_TC", null);
        messageMap.put(E_INVALID_REF, e, "ErrorMessage.INVALID_REF", null);
        messageMap.put(E_MISSING_CONTENT, e, "ErrorMessage.MISSING_CONTENT", null);
        messageMap.put(E_INVALID_REF_TYPE, e, "ErrorMessage.INVALID_REF_TYPE", null);
        messageMap.put(E_INVALID_VAR_NAME, e, "ErrorMessage.INVALID_VAR_NAME", null);
        messageMap.put(E_REF_IN_TS, e, "ErrorMessage.REF_IN_TS", null);
        messageMap.put(E_REF_IN_TDC, e, "ErrorMessage.REF_IN_TDC", null);
        messageMap.put(E_BAD_INT, e, "ErrorMessage.BAD_INT", null);
        messageMap.put(E_NEG_VAL, e, "ErrorMessage.NEG_VAL", null);
        messageMap.put(E_TOO_BIG_VALUE, e, "ErrorMessage.TOO_BIG_VALUE", null);
        messageMap.put(E_TOO_SMALL_VALUE, e, "ErrorMessage.TOO_SMALL_VALUE", null);
        messageMap.put(E_NOT_SUPP_COMBO_ITEM, e, "ErrorMessage.NOT_SUPP_COMBO_ITEM", null);
        messageMap.put(E_MISSING_FUNCTION_NAME, e, "ErrorMessage.MISSING_FUNCTION_NAME", null);
        messageMap.put(E_FUNCTION_NOT_REGISTERED, e, "ErrorMessage.FUNCTION_NOT_REGISTERED", null);
        messageMap.put(E_WRONG_NUM_FUNCTION_ARGS, e, "ErrorMessage.WRONG_NUM_FUNCTION_ARGS", null);
        messageMap.put(E_WRONG_PARAMETER_VALUE, e, "ErrorMessage.WRONG_PARAMETER_VALUE", null);
    }

    private static void createRuntimeErrorMessages() {
        int e = 4;
        messageMap.put(E_CANNOT_OPEN_EDITOR, e, "ErrorMessage.CANNOT_OPEN_EDITOR", null);
        messageMap.put(E_NO_OPENED_EDITOR, e, "ErrorMessage.NO_OPENED_EDITOR", null);
        messageMap.put(E_UNSUPPORTED_NODE, e, "ErrorMessage.UNSUPPORTED_NODE", null);
        messageMap.put(E_CANNOT_OPEN_PERSPECTIVE, e, "ErrorMessage.CANNOT_OPEN_PERSPECTIVE", null);
        messageMap.put(E_CANNOT_SAVE_UNLOCKED, e, "ErrorMessage.CANNOT_SAVE_UNLOCKED", null);
        messageMap.put(E_CANNOT_SAVE_INVALID, e, "ErrorMessage.CANNOT_SAVE_INVALID", null);
        messageMap.put(E_NULL_SESSION, e, "ErrorMessage.NULL_SESSION", null);
        messageMap.put(E_NON_RECOVERABLE, e, "ErrorMessage.NON_RECOVERABLE", null);
        messageMap.put(E_SESSION_FAILED, e, "ErrorMessage.SESSION_FAILED", null);
        messageMap.put(E_TEST_EXECUTION_ERROR, e, "ErrorMessage.TEST_EXECUTION_ERROR", null);
        messageMap.put(E_UNRESOLV_VAR_ERROR, e, "ErrorMessage.UNRESOLV_VAR_ERROR", null);
        messageMap.put(E_SYNTAX_ERROR, e, "ErrorMessage.SYNTAX_ERROR", null);
        messageMap.put(E_TEST_STEP_NOT_CREATED, e, "ErrorMessage.TEST_STEP_NOT_CREATED", null);
        messageMap.put(E_FUNCTION_EVAL_ERROR, e, "ErrorMessage.FUNCTION_EVAL_ERROR", null);
    }

    private static void createServerRuntimeErrorMessages() {
        int e = 4;
        messageMap.put(E_ROBOT, e, "ErrorMessage.ROBOT", null);
        messageMap.put(E_EVENT_SUPPORT, e, "ErrorMessage.EVENT_SUPPORT", null);
        messageMap.put(E_STEP_EXEC, e, "ErrorMessage.STEP_EXEC", null);
        messageMap.put(E_STEP_VERIFY, e, "ErrorMessage.STEP_VERIFY", null);
    }

    private static void createVersionControlErrorMessages() {
        int e = 4;
        messageMap.put(E_SCRIPT_NOT_FOUND, e, "ErrorMessage.SCRIPT_NOT_FOUND", null);
        messageMap.put(E_PROJECT_NOT_FOUND, e, "ErrorMessage.PROJECT_NOT_FOUND", null);
        messageMap.put(E_REPOSITORY_NOT_FOUND, e, "ErrorMessage.REPOSITORY_NOT_FOUND", null);
        messageMap.put(E_LOGIN_FAILED, e, "ErrorMessage.LOGIN_FAILED", null);
        messageMap.put(E_COMMAND_ABORTED, e, "ErrorMessage.COMMAND_ABORTED", null);
        messageMap.put(E_AUTHENTICATION_FAILED, e, "ErrorMessage.AUTHENTICATION_FAILED", null);
        messageMap.put(E_WORKING_DIRECTORY_NOT_FOUND, e, "ErrorMessage.WORKING_DIRECTORY_NOT_FOUND", null);
        messageMap.put(E_IO_EXCEPTION, e, "ErrorMessage.IO_EXCEPTION", null);
    }

    private static void createQuestionMessages() {
        int q = 0;
        messageMap.put(Q_DELETE_ACTUAL_PROJECT, q, "QuestionMessage.DELETE_ACTUAL_PROJECT", null);
        messageMap.put(Q_DELETE_PROJECT, q, "QuestionMessage.DELETE_PROJECT", null);
        messageMap.put(Q_SAVE_AND_EXTRACT, q, "QuestionMessage.SAVE_AND_EXTRACT", null);
        messageMap.put(Q_TYPE_REFERENCE, q, "QuestionMessage.TYPE_REFERENCE", null);
        messageMap.put(Q_MERGE_CATEGORY, q, "QuestionMessage.MERGE_CATEGORY", null);
        messageMap.put(Q_EXCELDATA_INPUT, q, "QuestionMessage.EXCELDATA_INPUT", null);
        messageMap.put(Q_CLEAN_OM, q, "QuestionMessage.CLEAN_OM", null);
        messageMap.put(Q_REMOVE_PROJECT_LANGUAGES, q, "QuestionMessage.REMOVE_PROJECT_LANGUAGES", null);
        messageMap.put(Q_LOAD_PROJECT_TOOLKIT_MINOR_VERSION_LOWER, q, "QuestionMessage.LOAD_PROJECT_TOOLKIT_MINOR_VERSION_LOWER", null);
        messageMap.put(Q_CHANGE_INTERFACE_REMOVE_PARAM, q, "QuestionMessage.CHANGE_INTERFACE_REMOVE_PARAM", null);
        messageMap.put(Q_CHANGE_INTERFACE_CHANGE_PARAM_TYPE, q, "QuestionMessage.CHANGE_INTERFACE_CHANGE_PARAM_TYPE", null);
        messageMap.put(Q_SAVE_AND_GENERATE, q, "QuestionMessage.Q_SAVE_AND_GENERATE", null);
        messageMap.put(Q_CHANGE_INTERFACE_CHANGE_PARAM_NAME, q, "QuestionMessage.Q_CHANGE_INTERFACE_CHANGE_PARAM_NAME", null);
    }

    private static void createInfoMessages() {
        int i = 1;
        messageMap.put(I_CONVERT_PREFS, i, "InfoMessage.CONVERT_PREFS", null);
        messageMap.put(I_OPEN_PROJECT, i, "InfoMessage.OPEN_PROJECT", null);
        messageMap.put(I_CVS_NOT_ENABLED, i, "InfoMessage.CVS_NOT_ENABLED", null);
        messageMap.put(I_DELETE_CATEGORY, i, "InfoMessage.DELETE_CATEGORY", null);
        messageMap.put(I_NO_VERSIONS_IN_HERE, i, "InfoMessage.NO_VERSIONS_IN_HERE", null);
        messageMap.put(I_OLD_GD_VERSION, i, "InfoMessage.OLD_GD_VERSION", null);
        messageMap.put(I_SAVE_AND_REOPEN_EDITOR, i, "InfoMessage.SAVE_AND_REOPEN_EDITOR", null);
        messageMap.put(I_LOCK_OBJ_1, i, "InfoMessage.LOCK_OBJ_1", null);
        messageMap.put(I_LOCK_OBJ_2, i, "InfoMessage.LOCK_OBJ_2", null);
        messageMap.put(I_LOCK_OBJ_3, i, "InfoMessage.LOCK_OBJ_3", null);
        messageMap.put(I_NO_PROJECT_IN_DB, i, "InfoMessage.NO_PROJECT_IN_DB", null);
        messageMap.put(I_REUSED_SPEC_TCS, i, "InfoMessage.REUSED_SPEC_TCS", null);
        messageMap.put(I_REUSED_TS, i, "InfoMessage.REUSED_TS", null);
        messageMap.put(I_EDITORS_TO_CLOSE, i, "InfoMessage.EDITORS_TO_CLOSE", null);
        messageMap.put(I_EDITORS_TO_SAVE, i, "InfoMessage.EDITORS_TO_SAVE", null);
        messageMap.put(I_TOO_LONG_CLASSPATH, i, "InfoMessage.TOO_LONG_CLASSPATH", null);
        messageMap.put(I_WRONG_SERVER_PREFS, i, "InfoMessage.WRONG_SERVER_PREFS", null);
        messageMap.put(I_NO_PARAM_AT_NODE_TO_PUT_DATA, i, "InfoMessage.NO_PARAM_AT_NODE_TO_PUT_DATA", null);
        messageMap.put(I_STARTED_AUT_CHANGED, i, "InfoMessage.STARTED_AUT_CHANGED", null);
        messageMap.put(I_FILE_LOGGING_NOT_ENABLED, i, "InfoMessage.FILE_LOGGING_NOT_ENABLED", null);
        messageMap.put(I_COULD_NOT_REMOVE_REUSED_PROJECTS, i, "InfoMessage.COULD_NOT_REMOVE_REUSED_PROJECTS", null);
        messageMap.put(I_CANNOT_MOVE_TC, i, "InfoMessage.CANNOT_MOVE_TC", new String[]{"InfoDetail.CANNOT_MOVE_TC"});
        messageMap.put(I_SERVER_NAME_ADDED, i, "InfoMessage.SERVER_NAME_ADDED", new String[]{"InfoDetail.SERVER_NAME_ADDED"});
        messageMap.put(I_SAVE_EDITOR, i, "InfoMessage.SAVE_EDITOR", null);
        messageMap.put(I_SERVER_CANNOT_CONNECTED, i, "InfoMessage.connGuiDancerServerFailed", null);
        messageMap.put(I_REUSED_TDC, i, "InfoMessage.I_REUSED_TDC", null);
        messageMap.put(I_NON_EDITABLE_NODE, i, "InfoMessage.I_NON_EDITABLE_NODE", null);
        messageMap.put(I_DB_BACKGROUND_JOB, i, "InfoMessage.DB_BACKGROUND_JOB", null);
        messageMap.put(I_NO_CLIENT_LOG_FOUND, i, "InfoMessage.NO_CLIENT_LOG_FOUND", null);
        messageMap.put(I_NO_PERSPECTIVE_CHANGE, i, "InfoMessage.NO_PERSPECTIVE_CHANGE", null);
        messageMap.put(I_NOT_SAME_SPEC, i, "InfoMessage.NOT_SAME_SPEC", null);
        messageMap.put(I_NO_EXEC, i, "InfoMessage.NO_EXEC", null);
        messageMap.put(I_ALL_TCS_MUST_USE_SAME_CTDS, i, "InfoMessage.ALL_TCS_MUST_USE_SAME_CTDS", null);
        messageMap.put(I_TCS_HAVE_NO_CHANGEABLE_PARAMETER_NAME, i, "InfoMessage.TCS_HAVE_NO_CHANGEABLE_PARAMETER_NAME", null);
    }

    private static void createWarningMessages() {
        int w = 2;
        messageMap.put(W_OLD_GD_VERSION, w, "WarnMessage.OLD_GD_VERSION", null);
        messageMap.put(W_MAX_CHAR, w, "WarnMessage.MAX_CHAR", null);
        messageMap.put(W_SCRIPT_WAS_PARSED, w, "WarnMessage.SCRIPT_WAS_PARSED", null);
        messageMap.put(W_PROJECT_TOOLKIT_NOT_AVAILABLE, w, "WarnMessage.PROJECT_TOOLKIT_NOT_AVAILABLE", new String[]{"ErrorDetail.MISSING_TOOLKIT"});
    }

    public static Message getMessageObject(Integer id) {
        MessageIDs.initErrorMap();
        return (Message)messageMap.get(id);
    }

    public static Map getMessageMap() {
        MessageIDs.initErrorMap();
        return messageMap;
    }

    private static class MessageMap
    extends HashMap {
        private MessageMap() {
        }

        public Object put(Integer id, int severity, String message, String[] details) {
            Message value = new Message(id, severity, message, details);
            return super.put(id, value);
        }

        public Object put(Object key, Object value) {
            return super.put(key, value);
        }
    }
}

