/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jubula.app.Activator;
import org.eclipse.jubula.app.core.JubulaActionBarAdvisor;
import org.eclipse.jubula.app.i18n.Messages;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.utils.DatabaseStateDispatcher;
import org.eclipse.jubula.client.core.utils.DatabaseStateEvent;
import org.eclipse.jubula.client.core.utils.IDatabaseStateListener;
import org.eclipse.jubula.client.ui.handlers.project.AbstractSelectDatabaseHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ProjectUIBP;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class JubulaWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final int AUTO_LOGON_JOB_SCHEDULE_DELAY = 1000;
    private static final String[] ACTION_SETS_TO_HIDE = new String[]{"org.eclipse.ui.actionSet.openFiles", "org.eclipse.ui.edit.text.actionSet.convertLineDelimitersTo", "org.eclipse.mylyn.tasks.ui.navigation", "org.eclipse.ui.edit.text.actionSet.navigation", "org.eclipse.ui.edit.text.actionSet.annotationNavigation"};
    private ApplicationWindowTitleUpdater m_updater;

    public JubulaWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new JubulaActionBarAdvisor(configurer, this.getWindowConfigurer());
    }

    public void preWindowOpen() {
        this.getWindowConfigurer().setTitle(Messages.JubulaWorkbenchWindowAdvisorWindowTitle);
        this.getWindowConfigurer().setShowMenuBar(true);
        this.getWindowConfigurer().setShowPerspectiveBar(true);
        this.getWindowConfigurer().setShowCoolBar(true);
        this.getWindowConfigurer().setShowStatusLine(true);
        this.getWindowConfigurer().setShowProgressIndicator(true);
        this.getWindowConfigurer().setShowFastViewBars(false);
    }

    public void postWindowOpen() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                String[] stringArray = ACTION_SETS_TO_HIDE;
                int n3 = ACTION_SETS_TO_HIDE.length;
                int n4 = 0;
                while (n4 < n3) {
                    String actionSetToHide = stringArray[n4];
                    page.hideActionSet(actionSetToHide);
                    ++n4;
                }
            }
            ++n2;
        }
        Activator plugin = Activator.getDefault();
        ImageRegistry imageRegistry = plugin.getImageRegistry();
        this.getWindowConfigurer().getWindow().getShell().setImages(new Image[]{imageRegistry.get("IMAGE_PNG_JB_16_16_ID"), imageRegistry.get("IMAGE_GIF_JB_32_32_ID"), imageRegistry.get("IMAGE_GIF_JB_48_48_ID"), imageRegistry.get("IMAGE_GIF_JB_64_64_ID"), imageRegistry.get("IMAGE_GIF_JB_128_128_ID"), imageRegistry.get("IMAGE_PNG_JB_16_16_ID"), imageRegistry.get("IMAGE_PNG_JB_32_32_ID"), imageRegistry.get("IMAGE_PNG_JB_48_48_ID"), imageRegistry.get("IMAGE_PNG_JB_64_64_ID"), imageRegistry.get("IMAGE_PNG_JB_128_128_ID")});
        Plugin.createStatusLineItems();
        Plugin.showStatusLine(null);
        this.addMainWindowTitleUpdater();
        this.checkAndPerformStartupHooks();
    }

    private void checkAndPerformStartupHooks() {
        boolean performAutoDBConnect = AbstractSelectDatabaseHandler.shouldAutoConnectToDB();
        boolean performAutoProjectLoad = ProjectUIBP.getInstance().shouldPerformAutoProjectLoad();
        if (performAutoDBConnect) {
            final String commandID = performAutoProjectLoad ? "org.eclipse.jubula.client.ui.rcp.commands.OpenProject" : "org.eclipse.jubula.client.ui.commands.SelectDatabase";
            JobUtils.executeJob((Job)new Job(Messages.AutoLogonJob){

                protected IStatus run(IProgressMonitor monitor) {
                    Plugin.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            CommandHelper.executeCommand((String)commandID);
                        }
                    });
                    return Status.OK_STATUS;
                }
            }, null, (long)1000L);
        }
    }

    protected void addMainWindowTitleUpdater() {
        this.m_updater = new ApplicationWindowTitleUpdater();
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this.m_updater, true);
        ded.addDataChangedListener((DataEventDispatcher.IDataChangedListener)this.m_updater, true);
        DatabaseStateDispatcher.addDatabaseStateListener((IDatabaseStateListener)this.m_updater);
    }

    public void postWindowRestore() throws WorkbenchException {
        super.postWindowRestore();
        Plugin.showStatusLine(null);
    }

    public void dispose() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.removeProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this.m_updater);
        ded.removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this.m_updater);
        DatabaseStateDispatcher.removeDatabaseStateListener((IDatabaseStateListener)this.m_updater);
    }

    private static class ApplicationWindowTitleUpdater
    implements DataEventDispatcher.IProjectLoadedListener,
    IDatabaseStateListener,
    DataEventDispatcher.IDataChangedListener {
        private ApplicationWindowTitleUpdater() {
        }

        public void reactOnDatabaseEvent(DatabaseStateEvent e) {
            ApplicationWindowTitleUpdater.updateProjectNameInTitlebar();
        }

        public void handleProjectLoaded() {
            ApplicationWindowTitleUpdater.updateProjectNameInTitlebar();
        }

        public void handleDataChanged(DataChangedEvent ... events) {
            DataChangedEvent[] dataChangedEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DataChangedEvent e = dataChangedEventArray[n2];
                this.handleDataChanged(e.getPo(), e.getDataState());
                ++n2;
            }
        }

        public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState) {
            if (po instanceof IProjectPO && (dataState == DataEventDispatcher.DataState.Renamed || dataState == DataEventDispatcher.DataState.Deleted)) {
                ApplicationWindowTitleUpdater.updateProjectNameInTitlebar();
            }
        }

        public static void updateProjectNameInTitlebar() {
            Plugin.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IProjectPO currentProject;
                    String user;
                    StringBuilder sb = new StringBuilder(Plugin.getDefault().getRunningApplicationTitle());
                    Persistor persistor = Persistor.instance();
                    if (persistor != null && (user = persistor.getCurrentDBUser()) != null && user.length() != 0) {
                        sb.append(" ").append("-").append(" ").append(user);
                    }
                    if ((currentProject = GeneralStorage.getInstance().getProject()) != null && currentProject.getName() != null && currentProject.getName().length() > 0) {
                        sb.append(" ").append("-").append(" ").append(currentProject.getName()).append(" ").append(currentProject.getMajorProjectVersion()).append(".").append(currentProject.getMinorProjectVersion());
                    }
                    Plugin.getActiveWorkbenchWindowShell().setText(sb.toString());
                }
            });
        }
    }
}

