/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.core.bp;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.alm.mylyn.core.i18n.Messages;
import org.eclipse.jubula.client.alm.mylyn.core.utils.ALMAccess;
import org.eclipse.jubula.client.core.businessprocess.TestResultBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.TestResult;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.client.core.propertytester.NodePropertyTester;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TestResultNodeTraverser;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentReporter
implements DataEventDispatcher.ITestresultSummaryEventListener {
    private static CommentReporter instance;
    private IProgressConsole m_console;
    private IProjectPropertiesPO m_projProps = null;

    private CommentReporter() {
        DataEventDispatcher.getInstance().addTestresultSummaryEventListener((DataEventDispatcher.ITestresultSummaryEventListener)this);
    }

    public static CommentReporter getInstance() {
        if (instance == null) {
            instance = new CommentReporter();
        }
        return instance;
    }

    private IStatus processResultTree(IProgressMonitor monitor, boolean reportSuccess, boolean reportFailure, ITestResultSummaryPO summary) {
        HashMap<String, String> taskIdToComment = new HashMap<String, String>();
        TestResult resultTestModel = TestResultBP.getInstance().getResultTestModel();
        TestResultNode rootResultNode = resultTestModel.getRootResultNode();
        ReportOperation operation = new ReportOperation(taskIdToComment, reportFailure, reportSuccess, this.m_projProps.getDashboardURL(), summary.getId().toString());
        TestResultNodeTraverser traverser = new TestResultNodeTraverser(rootResultNode, (ITreeNodeOperation)operation);
        traverser.traverse();
        return this.reportToALM(monitor, taskIdToComment);
    }

    private IStatus reportToALM(IProgressMonitor monitor, Map<String, String> taskIdToComment) {
        String repoLabel = this.m_projProps.getALMRepositoryName();
        Set<String> taskIds = taskIdToComment.keySet();
        int taskAmount = taskIds.size();
        String out = NLS.bind((String)Messages.ReportToALMJob, (Object)repoLabel);
        monitor.beginTask(out, taskAmount);
        IProgressConsole c = this.getConsole();
        c.writeLine(out);
        for (String taskId : taskIds) {
            c.writeLine(NLS.bind((String)Messages.ReportingTask, (Object)taskId));
            boolean succeeded = ALMAccess.createComment(repoLabel, taskId, taskIdToComment.get(taskId), monitor);
            if (!succeeded) {
                c.writeErrorLine(NLS.bind((String)Messages.ReportingTaskFailed, (Object)taskId));
            }
            monitor.worked(1);
        }
        c.writeLine(Messages.ReportToALMJobDone);
        monitor.done();
        return Status.OK_STATUS;
    }

    private IProgressConsole getConsole() {
        return this.m_console;
    }

    public void setConsole(IProgressConsole console) {
        this.m_console = console;
    }

    public void handleTestresultSummaryChanged(final ITestResultSummaryPO summary, DataEventDispatcher.DataState state) {
        if (state != DataEventDispatcher.DataState.Added) {
            return;
        }
        IProjectPO project = GeneralStorage.getInstance().getProject();
        this.m_projProps = project.getProjectProperties();
        final boolean reportSuccess = this.m_projProps.getIsReportOnSuccess();
        final boolean reportFailure = this.m_projProps.getIsReportOnFailure();
        final String almRepositoryName = this.m_projProps.getALMRepositoryName();
        if (!StringUtils.isBlank((String)almRepositoryName) && (reportSuccess || reportFailure)) {
            Job reportToALMOperation = new Job(NLS.bind((String)Messages.ReportToALMJob, (Object)almRepositoryName)){

                protected IStatus run(IProgressMonitor monitor) {
                    CommentReporter.this.getConsole().writeLine(NLS.bind((String)Messages.TaskRepositoryConnectionTest, (Object)almRepositoryName));
                    IStatus connectionStatus = ALMAccess.testConnection(almRepositoryName);
                    if (connectionStatus.isOK()) {
                        CommentReporter.this.getConsole().writeLine(NLS.bind((String)Messages.TaskRepositoryConnectionTestSucceeded, (Object)almRepositoryName));
                        return CommentReporter.this.processResultTree(monitor, reportSuccess, reportFailure, summary);
                    }
                    CommentReporter.this.getConsole().writeErrorLine(NLS.bind((String)Messages.TaskRepositoryConnectionTestFailed, (Object)connectionStatus.getMessage()));
                    return connectionStatus;
                }
            };
            reportToALMOperation.schedule();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReportOperation
    implements ITreeNodeOperation<TestResultNode> {
        private static final int MAX_DATA_STRING_LENGTH = 200;
        private Map<String, String> m_taskIdToComment;
        private final boolean m_reportFailure;
        private final boolean m_reportSuccess;
        private String m_dashboardURL;
        private String m_summaryIdString;
        private long m_nodeCount = 0L;

        public ReportOperation(Map<String, String> taskIdToComment, boolean reportFailure, boolean reportSuccess, String dashboardURL, String summaryId) {
            this.m_taskIdToComment = taskIdToComment;
            this.m_reportFailure = reportFailure;
            this.m_reportSuccess = reportSuccess;
            this.m_dashboardURL = dashboardURL;
            this.m_summaryIdString = summaryId;
        }

        public boolean operate(ITreeTraverserContext<TestResultNode> ctx, TestResultNode parent, TestResultNode resultNode, boolean alreadyVisited) {
            boolean writeCommentForNode;
            ++this.m_nodeCount;
            boolean didNodePass = this.hasPassed(resultNode.getStatus());
            INodePO node = resultNode.getNode();
            String taskIdforNode = NodePropertyTester.getTaskIdforNode((INodePO)node);
            boolean hasTaskId = taskIdforNode != null;
            boolean bl = writeCommentForNode = this.m_reportSuccess && didNodePass && hasTaskId || this.m_reportFailure && !didNodePass && hasTaskId;
            if (writeCommentForNode) {
                String comment = this.m_taskIdToComment.get(taskIdforNode);
                if (comment != null) {
                    this.m_taskIdToComment.put(taskIdforNode, String.valueOf(comment) + "\n" + this.buildCommentString(resultNode));
                } else {
                    this.m_taskIdToComment.put(taskIdforNode, this.buildCommentString(resultNode));
                }
            }
            return true;
        }

        private String buildCommentString(TestResultNode resultNode) {
            Date executionTime = resultNode.getTimeStamp();
            String timestamp = executionTime != null ? executionTime.toString() : Messages.NotAvailable;
            String nodeType = resultNode.getTypeOfNode();
            String nodeNameAndParams = String.valueOf(this.getName(resultNode)) + " " + StringUtils.abbreviate((String)resultNode.getParameterDescription(), (int)200);
            String status = this.hasPassed(resultNode.getStatus()) ? Messages.StatusPassed : Messages.StatusFailed;
            String url = String.valueOf(this.m_dashboardURL) + "?" + "summaryId" + "=" + this.m_summaryIdString + "&" + "resultNode" + "=" + String.valueOf(this.m_nodeCount);
            return NLS.bind((String)Messages.NodeComment, (Object[])new String[]{timestamp, nodeType, nodeNameAndParams, status, url});
        }

        private String getName(TestResultNode resultNode) {
            StringBuilder nameBuilder = new StringBuilder();
            INodePO node = resultNode.getNode();
            if (node != null) {
                if (node instanceof IExecTestCasePO) {
                    String testCaseName;
                    IExecTestCasePO testCaseRef = (IExecTestCasePO)node;
                    String realName = testCaseRef.getRealName();
                    ISpecTestCasePO testCase = testCaseRef.getSpecTestCase();
                    String string = testCaseName = testCase != null ? testCase.getName() : "";
                    if (!StringUtils.isBlank((String)realName)) {
                        nameBuilder.append(realName);
                        nameBuilder.append(" ").append("(").append(testCaseName).append(")");
                    } else {
                        nameBuilder.append("<").append(testCaseName).append(">");
                    }
                } else {
                    nameBuilder.append(node.getName());
                }
            }
            return nameBuilder.toString();
        }

        private boolean hasPassed(int statusCode) {
            return statusCode == 1 || statusCode == 8;
        }

        public void postOperate(ITreeTraverserContext<TestResultNode> ctx, TestResultNode parent, TestResultNode node, boolean alreadyVisited) {
        }
    }
}

