/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.ui.mapping;

import java.util.Date;
import org.eclipse.jubula.client.alm.mylyn.ui.i18n.Messages;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.ui.controllers.propertysources.TestResultNodePropertySource;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class TestResultNodeTaskMapping
extends TaskMapping {
    private final TestResultNode m_node;

    public TestResultNodeTaskMapping(TestResultNode node) {
        this.m_node = node;
    }

    public Date getCreationDate() {
        return new Date();
    }

    public String getDescription() {
        TestResultNodePropertySource propSource = new TestResultNodePropertySource(this.m_node);
        StringBuilder sb = new StringBuilder();
        int count = 1;
        String oldCat = null;
        IPropertyDescriptor[] iPropertyDescriptorArray = propSource.getPropertyDescriptors();
        int n = iPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor pd = iPropertyDescriptorArray[n2];
            String newCat = pd.getCategory().toUpperCase();
            if (!newCat.equals(oldCat)) {
                sb.append(newCat);
                sb.append("\n");
                oldCat = newCat;
            }
            sb.append(" ");
            sb.append("-");
            sb.append(" ");
            sb.append(pd.getDisplayName());
            sb.append(": ");
            sb.append(propSource.getPropertyValue(pd.getId()));
            if (count != propSource.getPropertyDescriptors().length) {
                sb.append("\n");
            }
            ++count;
            ++n2;
        }
        Object[] params = new Object[]{this.m_node.getTypeOfNode(), sb.toString()};
        return NLS.bind((String)Messages.TaskDescription, (Object[])params);
    }

    public String getSummary() {
        Object[] params = new Object[]{this.m_node.getTypeOfNode(), this.m_node.getName(), this.m_node.getStatusString()};
        return NLS.bind((String)Messages.TaskTitle, (Object[])params);
    }
}

