/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.handlers.AbstractTestResultViewHandler;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

public class ToggleRelevanceHandler
extends AbstractTestResultViewHandler {
    public Object executeImpl(ExecutionEvent event) {
        ITestResultSummaryPO selectedSummary = this.getSelectedSummary(event);
        if (selectedSummary != null) {
            Persistor persistor = Persistor.instance();
            EntityManager sess = persistor.openSession();
            try {
                try {
                    EntityTransaction tx = persistor.getTransaction(sess);
                    ITestResultSummaryPO summary = (ITestResultSummaryPO)sess.merge((Object)selectedSummary);
                    summary.setTestsuiteRelevant(!summary.isTestsuiteRelevant());
                    persistor.commitTransaction(sess, tx);
                    DataEventDispatcher.getInstance().fireTestresultSummaryChanged(summary, DataEventDispatcher.DataState.StructureModified);
                }
                catch (PMException e) {
                    throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)e, MessageIDs.E_DATABASE_GENERAL);
                }
                catch (ProjectDeletedException e) {
                    throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
                }
            }
            finally {
                persistor.dropSession(sess);
            }
        }
        return null;
    }
}

