/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.properties;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jubula.client.alm.mylyn.core.utils.ALMAccess;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.factory.ControlFactory;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.properties.AbstractProjectPropertyPage;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedText;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedURLText;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ProjectALMPropertyPage
extends AbstractProjectPropertyPage {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_2 = 2;
    private DirectCombo<String> m_almRepoCombo;
    private Button m_connectionTest;
    private Button m_reportOnSuccess = null;
    private ModifyListener m_dataUpdater = new DataUpdateListener();
    private Button m_reportOnFailure = null;
    private CheckedText m_dashboardURL;
    private IProjectPropertiesPO m_origProjectProps;

    public ProjectALMPropertyPage(EditSupport es) {
        super(es);
        this.m_origProjectProps = (IProjectPropertiesPO)es.getOriginal();
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent, 1, 4, false);
        this.createALMPageDescription(composite);
        Composite main = this.createComposite(composite, 2, 4, false);
        this.noDefaultAndApplyButton();
        this.createEmptyLabel(main);
        this.createEmptyLabel(main);
        this.createALMrepositoryChooser(main);
        this.createReportOnSuccess(main);
        this.createReportOnFailure(main);
        this.createDashboardURL(main);
        Event event = new Event();
        event.type = 13;
        event.widget = this.m_almRepoCombo;
        this.m_almRepoCombo.notifyListeners(13, event);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.projectAlmSettingsPageContextId");
        return composite;
    }

    private void createDashboardURL(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 1, false);
        Composite rightComposite = this.createComposite(parent, 1, 4, true);
        this.createLabel(leftComposite, Messages.ProjectPropertyPageDasboardURLLabel);
        this.m_dashboardURL = new CheckedURLText(rightComposite, 2048);
        this.m_dashboardURL.setText(StringUtils.defaultString((String)this.m_origProjectProps.getDashboardURL()));
        this.m_dashboardURL.validate();
        GridData textGridData = new GridData(768);
        textGridData.grabExcessHorizontalSpace = true;
        this.m_dashboardURL.setLayoutData(textGridData);
        LayoutUtil.setMaxChar((Text)this.m_dashboardURL, (int)4000);
        this.m_dashboardURL.addModifyListener(this.m_dataUpdater);
    }

    private void createReportOnFailure(Composite parent) {
        this.createEmptyLabel(parent);
        this.m_reportOnFailure = new Button(parent, 32);
        this.m_reportOnFailure.setText(Messages.ProjectPropertyPageReportOnFailureLabel);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = false;
        this.m_reportOnFailure.setLayoutData((Object)gridData);
        boolean reportOnFailure = this.m_origProjectProps.getIsReportOnFailure();
        this.m_reportOnFailure.setSelection(reportOnFailure);
        this.m_reportOnFailure.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectALMPropertyPage.this.updateALMData();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createReportOnSuccess(Composite parent) {
        Label infoLabel = this.createLabel(parent, Messages.ProjectPropertyPageReportOptionsLabel);
        ControlDecorator.createInfo((Control)infoLabel, Messages.ProjectPropertyPageReportOptionsDecoration, false);
        this.m_reportOnSuccess = new Button(parent, 32);
        this.m_reportOnSuccess.setText(Messages.ProjectPropertyPageReportOnSuccessLabel);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = false;
        this.m_reportOnSuccess.setLayoutData((Object)gridData);
        boolean reportOnSuccess = this.m_origProjectProps.getIsReportOnSuccess();
        this.m_reportOnSuccess.setSelection(reportOnSuccess);
        this.m_reportOnSuccess.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectALMPropertyPage.this.updateALMData();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createALMPageDescription(Composite parent) {
        this.createEmptyLabel(parent);
        Composite composite = this.createComposite(parent, 1, 4, true);
        this.createLabel(composite, Messages.ProjectPropertyPageALMLabel);
    }

    private void createALMrepositoryChooser(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 1, false);
        Composite rightComposite = this.createComposite(parent, 3, 4, true);
        this.createLabel(leftComposite, Messages.ProjectPropertyPageALMRepositoryLabel);
        String configuredRepo = this.m_origProjectProps.getALMRepositoryName();
        this.m_almRepoCombo = ControlFactory.createALMRepositoryCombo(rightComposite, configuredRepo);
        this.m_almRepoCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectALMPropertyPage.this.m_connectionTest.setImage(IconConstants.STEP_TESTING_IMAGE);
                if (ProjectALMPropertyPage.this.m_almRepoCombo.getSelectedObject() == null) {
                    ProjectALMPropertyPage.this.m_reportOnFailure.setEnabled(false);
                    ProjectALMPropertyPage.this.m_reportOnSuccess.setEnabled(false);
                    ProjectALMPropertyPage.this.m_dashboardURL.setEnabled(false);
                } else {
                    ProjectALMPropertyPage.this.m_reportOnFailure.setEnabled(true);
                    ProjectALMPropertyPage.this.m_reportOnSuccess.setEnabled(true);
                    ProjectALMPropertyPage.this.m_dashboardURL.setEnabled(true);
                }
                ProjectALMPropertyPage.this.setErrorMessage(null);
                ProjectALMPropertyPage.this.updateALMData();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.m_almRepoCombo.setSelectedObject((Object)configuredRepo);
        GridData textGridData = new GridData();
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.horizontalAlignment = 4;
        this.m_almRepoCombo.setLayoutData((Object)textGridData);
        this.m_connectionTest = new Button(rightComposite, 8);
        this.m_connectionTest.setText(Messages.ProjectPropertyPageALMConnectionTest);
        this.m_connectionTest.setImage(IconConstants.STEP_TESTING_IMAGE);
        this.m_connectionTest.addSelectionListener((SelectionListener)new ConnectionTestListener());
    }

    private void updateALMData() {
        IProjectPropertiesPO props = this.getProject().getProjectProperties();
        if (this.m_almRepoCombo != null) {
            props.setALMRepositoryName(this.m_almRepoCombo.getText());
        }
        if (this.m_reportOnFailure != null) {
            props.setIsReportOnFailure(this.m_reportOnFailure.getSelection());
        }
        if (this.m_reportOnSuccess != null) {
            props.setIsReportOnSuccess(this.m_reportOnSuccess.getSelection());
        }
        if (this.m_dashboardURL != null) {
            props.setDashboardURL(this.m_dashboardURL.getText().trim());
        }
    }

    private class ConnectionTestListener
    implements SelectionListener {
        private ConnectionTestListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String selectedObject = (String)ProjectALMPropertyPage.this.m_almRepoCombo.getSelectedObject();
            IStatus connectionStatus = ALMAccess.testConnection((String)selectedObject);
            if (connectionStatus.isOK()) {
                ProjectALMPropertyPage.this.m_connectionTest.setImage(IconConstants.STEP_OK_IMAGE);
                ProjectALMPropertyPage.this.setErrorMessage(null);
            } else {
                ProjectALMPropertyPage.this.m_connectionTest.setImage(IconConstants.ERROR_IMAGE);
                ProjectALMPropertyPage.this.setErrorMessage(connectionStatus.getMessage());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class DataUpdateListener
    implements ModifyListener {
        private DataUpdateListener() {
        }

        public void modifyText(ModifyEvent e) {
            ProjectALMPropertyPage.this.updateALMData();
        }
    }
}

