/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import java.util.List;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.client.ui.widgets.I18nEnumCombo;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIComponentHelper {
    private static final String LABEL_TERMINATOR = ":";

    private UIComponentHelper() {
    }

    public static Label createSeparator(Composite parent, int hSpan) {
        Label sep = new Label(parent, 258);
        GridData sepData = new GridData();
        sepData.horizontalAlignment = 4;
        sepData.horizontalSpan = hSpan;
        sep.setLayoutData((Object)sepData);
        return sep;
    }

    public static Label createLabel(Composite parent, String i18nKey) {
        return UIComponentHelper.createLabelWithText(parent, I18n.getString((String)i18nKey, (boolean)true));
    }

    public static Label createLabelWithText(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData labelGrid = new GridData(1, 2, false, false, 1, 1);
        label.setLayoutData((Object)labelGrid);
        return label;
    }

    public static Text createTextField(Composite parent, int hSpan) {
        Text textField = new Text(parent, 2048);
        GridData textGrid = new GridData(4, 2, true, false, hSpan, 1);
        LayoutUtil.addToolTipAndMaxWidth(textGrid, (Control)textField);
        textField.setLayoutData((Object)textGrid);
        return textField;
    }

    public static Composite createLayoutComposite(Composite parent) {
        return UIComponentHelper.createLayoutComposite(parent, 1);
    }

    public static Composite createLayoutComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = numColumns;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        GridData data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Button createToggleButton(Composite parent, int hSpan) {
        Button toggle = new Button(parent, 32);
        GridData labelGrid = new GridData(1, 2, false, false, hSpan, 1);
        toggle.setLayoutData((Object)labelGrid);
        return toggle;
    }

    public static DirectCombo<String> createCombo(Composite parent, int hSpan, List<String> comboObjects, List<String> comboDispObjects, boolean nullSelectionIsAllowed) {
        DirectCombo<String> combo = new DirectCombo<String>(parent, 2060, comboObjects, comboDispObjects, nullSelectionIsAllowed, false);
        GridData comboGrid = new GridData(4, 2, true, false, hSpan, 1);
        LayoutUtil.addToolTipAndMaxWidth(comboGrid, combo);
        combo.setLayoutData(comboGrid);
        return combo;
    }

    public static <E extends Enum> I18nEnumCombo<E> createEnumCombo(Composite parent, int hSpan, String baseKey, Class<E> enumClass) {
        I18nEnumCombo<E> combo = new I18nEnumCombo<E>(parent, 2056, baseKey, enumClass, false, false);
        GridData comboGrid = new GridData(4, 2, true, false, hSpan, 1);
        LayoutUtil.addToolTipAndMaxWidth(comboGrid, combo);
        combo.setLayoutData(comboGrid);
        return combo;
    }

    public static void createLabel(Composite parent, String fieldName, int style) {
        Label label = new Label(parent, style);
        label.setText(String.valueOf(fieldName) + LABEL_TERMINATOR);
    }

    public static void setEnabledRecursive(Control control, boolean enabled) {
        control.setEnabled(enabled);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                UIComponentHelper.setEnabledRecursive(child, enabled);
                ++n2;
            }
        }
    }
}

