/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.listener;

import java.awt.Container;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.NameValidator;
import org.eclipse.jubula.rc.swing.tester.util.TesterUtil;
import org.eclipse.jubula.tools.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.utils.StringParsing;
import org.eclipse.jubula.tools.xml.businessmodell.Action;
import org.eclipse.jubula.tools.xml.businessmodell.Component;

public class RecordHelper {
    private static AutServerLogger log;
    private static final Map KEYCODE_MAP;
    private static final Map MODIFIER_MAP;
    private String m_menupath = "";
    private int m_logNameNumber = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.listener.RecordHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
        KEYCODE_MAP = new HashMap();
        KEYCODE_MAP.put(new Integer(10), new String("ENTER"));
        KEYCODE_MAP.put(new Integer(32), new String("SPACE"));
        KEYCODE_MAP.put(new Integer(8), new String("BACK_SPACE"));
        KEYCODE_MAP.put(new Integer(9), new String("TAB"));
        KEYCODE_MAP.put(new Integer(27), new String("ESCAPE"));
        KEYCODE_MAP.put(new Integer(19), new String("PAUSE"));
        KEYCODE_MAP.put(new Integer(35), new String("END"));
        KEYCODE_MAP.put(new Integer(36), new String("HOME"));
        KEYCODE_MAP.put(new Integer(155), new String("INSERT"));
        KEYCODE_MAP.put(new Integer(127), new String("DELETE"));
        KEYCODE_MAP.put(new Integer(38), new String("UP"));
        KEYCODE_MAP.put(new Integer(40), new String("DOWN"));
        KEYCODE_MAP.put(new Integer(37), new String("LEFT"));
        KEYCODE_MAP.put(new Integer(39), new String("RIGHT"));
        KEYCODE_MAP.put(new Integer(33), new String("PAGE_UP"));
        KEYCODE_MAP.put(new Integer(34), new String("PAGE_DOWN"));
        KEYCODE_MAP.put(new Integer(112), new String("F1"));
        KEYCODE_MAP.put(new Integer(113), new String("F2"));
        KEYCODE_MAP.put(new Integer(114), new String("F3"));
        KEYCODE_MAP.put(new Integer(115), new String("F4"));
        KEYCODE_MAP.put(new Integer(116), new String("F5"));
        KEYCODE_MAP.put(new Integer(117), new String("F6"));
        KEYCODE_MAP.put(new Integer(118), new String("F7"));
        KEYCODE_MAP.put(new Integer(119), new String("F8"));
        KEYCODE_MAP.put(new Integer(120), new String("F9"));
        KEYCODE_MAP.put(new Integer(121), new String("F10"));
        KEYCODE_MAP.put(new Integer(122), new String("F11"));
        KEYCODE_MAP.put(new Integer(123), new String("F12"));
        KEYCODE_MAP.put(new Integer(96), new String("NUMPAD0"));
        KEYCODE_MAP.put(new Integer(97), new String("NUMPAD1"));
        KEYCODE_MAP.put(new Integer(98), new String("NUMPAD2"));
        KEYCODE_MAP.put(new Integer(99), new String("NUMPAD3"));
        KEYCODE_MAP.put(new Integer(100), new String("NUMPAD4"));
        KEYCODE_MAP.put(new Integer(101), new String("NUMPAD5"));
        KEYCODE_MAP.put(new Integer(102), new String("NUMPAD6"));
        KEYCODE_MAP.put(new Integer(103), new String("NUMPAD7"));
        KEYCODE_MAP.put(new Integer(104), new String("NUMPAD8"));
        KEYCODE_MAP.put(new Integer(105), new String("NUMPAD9"));
        KEYCODE_MAP.put(new Integer(107), new String("ADD"));
        KEYCODE_MAP.put(new Integer(106), new String("MULTIPLY"));
        KEYCODE_MAP.put(new Integer(111), new String("DIVIDE"));
        KEYCODE_MAP.put(new Integer(109), new String("SUBTRACT"));
        KEYCODE_MAP.put(new Integer(108), new String("SEPARATOR"));
        KEYCODE_MAP.put(new Integer(110), new String("DECIMAL"));
        KEYCODE_MAP.put(new Integer(521), new String("PLUS"));
        KEYCODE_MAP.put(new Integer(46), new String("PERIOD"));
        KEYCODE_MAP.put(new Integer(44), new String("COMMA"));
        KEYCODE_MAP.put(new Integer(45), new String("MINUS"));
        KEYCODE_MAP.put(new Integer(520), new String("NUMBER_SIGN"));
        KEYCODE_MAP.put(new Integer(514), new String("CIRCUMFLEX"));
        KEYCODE_MAP.put(new Integer(153), new String("LESS"));
        KEYCODE_MAP.put(new Integer(144), new String("NUM_LOCK"));
        KEYCODE_MAP.put(new Integer(145), new String("SCROLL_LOCK"));
        KEYCODE_MAP.put(new Integer(154), new String("PRINTSCREEN"));
        KEYCODE_MAP.put(new Integer(20), new String("CAPS_LOCK"));
        MODIFIER_MAP = new HashMap();
        MODIFIER_MAP.put(new Integer(1), new String("shift"));
        MODIFIER_MAP.put(new Integer(2), new String("control"));
        MODIFIER_MAP.put(new Integer(8), new String("alt"));
        MODIFIER_MAP.put(new Integer(10), new String("control alt"));
        MODIFIER_MAP.put(new Integer(3), new String("control shift"));
    }

    protected IComponentIdentifier getMenuCompID() {
        ComponentIdentifier id = new ComponentIdentifier();
        id.setComponentClassName("javax.swing.JMenuBar");
        id.setSupportedClassName("javax.swing.JMenuBar");
        return id;
    }

    protected IComponentIdentifier getApplicationCompID() {
        ComponentIdentifier id = new ComponentIdentifier();
        id.setComponentClassName("com.bredexsw.guidancer.server.implclasses.GraphicApplication");
        id.setSupportedClassName("com.bredexsw.guidancer.server.implclasses.GraphicApplication");
        return id;
    }

    public static String getKeyName(int keycode) throws StepExecutionException {
        String keyname;
        String string = keyname = KEYCODE_MAP.containsKey(new Integer(keycode)) ? (String)KEYCODE_MAP.get(new Integer(keycode)) : null;
        if (keyname == null && log.isInfoEnabled()) {
            log.info((Object)("The keycode '" + keycode + "' is not a key expression. Returning null."));
        }
        return keyname;
    }

    public static String getModifierName(int modifier) throws StepExecutionException {
        String modname;
        String string = modname = MODIFIER_MAP.containsKey(new Integer(modifier)) ? (String)MODIFIER_MAP.get(new Integer(modifier)) : null;
        if (modname == null && log.isInfoEnabled()) {
            log.info((Object)("The modifier '" + modifier + "' is not a key expression. Returning null."));
        }
        return modname;
    }

    public String getTextOfComponent(java.awt.Component c) {
        String text = null;
        if (c instanceof AbstractButton) {
            AbstractButton jb = (AbstractButton)c;
            text = jb.getText();
        }
        if (c instanceof JLabel) {
            JLabel jl = (JLabel)c;
            text = jl.getText();
        }
        if (c instanceof JTabbedPane) {
            JTabbedPane tp = (JTabbedPane)c;
            text = tp.getTitleAt(tp.getSelectedIndex());
        }
        if (c instanceof JFrame) {
            JFrame jf = (JFrame)c;
            text = jf.getTitle();
        }
        if (c instanceof JInternalFrame) {
            JInternalFrame jif = (JInternalFrame)c;
            text = jif.getTitle();
        }
        if (c instanceof JDialog) {
            JDialog jd = (JDialog)c;
            text = jd.getTitle();
        }
        if (c instanceof JPanel) {
            JPanel jp = (JPanel)c;
            text = this.getTitleOfBorder(jp.getBorder());
        }
        if (text != null && text.length() > 30) {
            text = String.valueOf(text.substring(0, 29)) + this.m_logNameNumber++;
        }
        return text;
    }

    public Action compSysToAction(IComponentIdentifier id, String actionStr) {
        Action a = null;
        List compsList = new LinkedList();
        compsList = id.getSupportedClassName().equals("com.bredexsw.guidancer.autserver.swing.implclasses.GraphicApplication") || id.getSupportedClassName().equals("com.bredexsw.guidancer.server.implclasses.GraphicApplication") ? AUTServerConfiguration.getInstance().findComponents("com.bredexsw.guidancer.autserver.swing.implclasses.GraphicApplication") : (id.getSupportedClassName().equals("javax.swing.JMenuBar") ? AUTServerConfiguration.getInstance().findComponents("com.bredexsw.guidancer.autserver.swing.implclasses.JMenuBarDefaultMapping") : AUTServerConfiguration.getInstance().findComponents(id.getSupportedClassName()));
        Iterator compsIt = compsList.iterator();
        while (compsIt.hasNext()) {
            Component comp = (Component)compsIt.next();
            List actionList = comp.getActions();
            Iterator it = actionList.iterator();
            while (it.hasNext()) {
                Action action = (Action)it.next();
                if (!action.getName().equals(actionStr)) continue;
                a = action;
            }
        }
        return a;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAbbreviations(java.awt.Component c, IComponentIdentifier id) {
        String append = null;
        String suppClassName = id.getSupportedClassName();
        if (c instanceof AbstractButton) return "_btn";
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.swing.AbstractButton");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (suppClassName.equals(clazz.getName())) {
            return "_btn";
        }
        if (c instanceof JLabel) return "_lbl";
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("javax.swing.JLabel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (suppClassName.equals(clazz2.getName())) {
            return "_lbl";
        }
        if (c instanceof JTabbedPane) return "_tpn";
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("javax.swing.JTabbedPane");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (suppClassName.equals(clazz3.getName())) {
            return "_tpn";
        }
        if (c instanceof JTree) return "_tre";
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("javax.swing.JTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (suppClassName.equals(clazz4.getName())) {
            return "_tre";
        }
        if (c instanceof JList) return "_lst";
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("javax.swing.JList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (suppClassName.equals(clazz5.getName())) {
            return "_lst";
        }
        if (c instanceof JComboBox) return "_cbx";
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("javax.swing.JComboBox");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (suppClassName.equals(clazz6.getName())) {
            return "_cbx";
        }
        if (c instanceof JTextComponent) return "_txf";
        Class<?> clazz7 = class$7;
        if (clazz7 == null) {
            try {
                clazz7 = class$7 = Class.forName("javax.swing.text.JTextComponent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (suppClassName.equals(clazz7.getName())) {
            return "_txf";
        }
        if (c instanceof JTable) return "_tbl";
        Class<?> clazz8 = class$8;
        if (clazz8 == null) {
            try {
                clazz8 = class$8 = Class.forName("javax.swing.JTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!suppClassName.equals(clazz8.getName())) return "_xyz";
        return "_tbl";
    }

    protected String generateLogicalName(java.awt.Component c, IComponentIdentifier id) {
        java.awt.Component comp = c;
        String logName = null;
        String logicalName = null;
        if (comp.getName() == null) {
            if (!(c instanceof JTabbedPane)) {
                logName = this.getTextOfComponent(c);
            }
            if (logName == null || logName.equals("")) {
                logName = this.minimizeCapName(id.getComponentName());
            }
        } else {
            logName = c.getName();
        }
        logicalName = String.valueOf(logName) + this.getAbbreviations(c, id);
        Container parent = c.getParent();
        while (parent != null) {
            if (parent.getName() == null || parent instanceof JFrame || parent instanceof JDialog || parent instanceof JInternalFrame || parent instanceof JPanel) {
                logName = this.getTextOfComponent(parent);
                if (logName == null) {
                    logName = this.minimizeCapName(parent.getClass().getName());
                }
            } else {
                logName = parent.getName();
            }
            if (parent instanceof JFrame || parent instanceof JDialog || parent instanceof JTabbedPane || parent instanceof JInternalFrame || parent instanceof JPanel && this.getTextOfComponent(parent) != null) {
                logicalName = String.valueOf(logName) + "_" + logicalName;
            }
            parent = parent.getParent();
        }
        return NameValidator.convertToValidLogicalName((String)logicalName);
    }

    private String minimizeCapName(String capName) {
        String minCapName = capName;
        if (minCapName.lastIndexOf(".") > -1 && minCapName.length() > minCapName.lastIndexOf(".") + 1) {
            minCapName = minCapName.substring(minCapName.lastIndexOf(".") + 1);
        }
        return minCapName;
    }

    public String getPath(java.awt.Component c) {
        JPopupMenu pop;
        String menupath = "";
        if (c instanceof JMenuItem) {
            JMenuItem src = (JMenuItem)c;
            Container srcParent = src.getParent();
            String itemText = StringParsing.maskAndSingleQuoteText((String)src.getText(), (int)2);
            if (srcParent != null && srcParent instanceof JPopupMenu) {
                this.getPath(srcParent);
            }
            menupath = this.m_menupath = this.m_menupath.concat(itemText);
            this.m_menupath = "";
        }
        if (c instanceof JPopupMenu && (pop = (JPopupMenu)c).getInvoker() instanceof JMenu) {
            JMenu jm = (JMenu)pop.getInvoker();
            Container parent = jm.getParent();
            String parentText = StringParsing.maskAndSingleQuoteText((String)jm.getText(), (int)2);
            if (parent != null && parent instanceof JPopupMenu) {
                this.getPath(parent);
                this.m_menupath = this.m_menupath.concat(String.valueOf(parentText) + "/");
            } else {
                this.m_menupath = String.valueOf(parentText) + "/";
            }
        }
        return menupath;
    }

    protected String treepathToTextpath(JTree tre, TreePath tp) {
        String textpath = "";
        int i = 0;
        while (i < tp.getPathCount()) {
            Object current = tp.getPathComponent(i);
            String node = StringParsing.maskAndSingleQuoteText((String)this.getRenderedTreeNodeText(tre, current), (int)2);
            textpath = textpath.concat(node);
            if (i < tp.getPathCount() - 1) {
                textpath = textpath.concat("/");
            }
            ++i;
        }
        return textpath;
    }

    protected boolean isSupportedComponent(java.awt.Component c) {
        boolean supported = false;
        if (c instanceof AbstractButton || c instanceof JLabel || c instanceof JTabbedPane || c instanceof JTree || c instanceof JList || c instanceof JComboBox || c instanceof JTextArea || c instanceof JTextField || c instanceof JTextPane || c instanceof JEditorPane || c instanceof JTable || c instanceof JFrame || c instanceof JDialog) {
            supported = true;
        }
        return supported;
    }

    public boolean isCiEqual(IComponentIdentifier a1, IComponentIdentifier a2) {
        List hierarchy = a1.getHierarchyNames();
        List iterHierarchy = a2.getHierarchyNames();
        if (hierarchy.size() == iterHierarchy.size()) {
            boolean match = true;
            int i = 0;
            while (i < hierarchy.size()) {
                if (hierarchy.get(i) == null && iterHierarchy.get(i) != null) {
                    match = false;
                } else if (hierarchy.get(i) != null && iterHierarchy.get(i) == null) {
                    match = false;
                } else if (hierarchy.get(i) == null && iterHierarchy.get(i) == null) {
                    iterHierarchy.get(i);
                } else if (!((String)hierarchy.get(i)).equals(iterHierarchy.get(i))) {
                    match = false;
                }
                ++i;
            }
            if (match) {
                return true;
            }
        }
        return false;
    }

    public String[] getRenderedListValues(JList list) {
        int[] indices = list.getSelectedIndices();
        Object[] values = list.getSelectedValues();
        String[] selected = new String[values.length];
        ListCellRenderer<Object> renderer = list.getCellRenderer();
        int i = 0;
        while (i < values.length) {
            Object value = values[i];
            java.awt.Component c = renderer.getListCellRendererComponent(list, value, indices[i], true, false);
            selected[i] = this.getRenderedText(c);
            ++i;
        }
        return selected;
    }

    public String getRenderedComboText(JComboBox cbx) {
        int selIndex = cbx.getSelectedIndex();
        if (selIndex == -1) {
            return null;
        }
        JList jlist = new JList(cbx.getModel());
        java.awt.Component disp = cbx.getRenderer().getListCellRendererComponent(jlist, jlist.getModel().getElementAt(selIndex), selIndex, true, cbx.hasFocus());
        return this.getRenderedText(disp);
    }

    public String[] getRenderedComboItems(JComboBox cbx) {
        String[] comboItemsText = new String[cbx.getItemCount()];
        int index = 0;
        while (index < cbx.getItemCount()) {
            JList jlist = new JList(cbx.getModel());
            java.awt.Component disp = cbx.getRenderer().getListCellRendererComponent(jlist, jlist.getModel().getElementAt(index), index, true, cbx.hasFocus());
            comboItemsText[index] = this.getRenderedText(disp);
            ++index;
        }
        return comboItemsText;
    }

    public String getRenderedTableCellText(JTable tbl, int row, int col) {
        Object value = tbl.getValueAt(row, col);
        boolean selected = tbl.isCellSelected(row, col);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Getting cell text:");
            log.debug((Object)("Row, col: " + row + ", " + col));
            log.debug((Object)("Value: " + value));
        }
        TableCellRenderer renderer = tbl.getCellRenderer(row, col);
        java.awt.Component c = renderer.getTableCellRendererComponent(tbl, value, selected, true, row, col);
        return this.getRenderedText(c);
    }

    public String getRenderedTreeNodeText(JTree tre, Object value) {
        TreePath path = tre.getSelectionPath();
        boolean selected = true;
        boolean expanded = tre.isExpanded(path);
        boolean hasFocus = tre.hasFocus();
        boolean leaf = tre.getModel().isLeaf(value);
        int row = tre.getRowForPath(path);
        TreeCellRenderer renderer = tre.getCellRenderer();
        java.awt.Component c = renderer.getTreeCellRendererComponent(tre, value, selected, expanded, leaf, row, hasFocus);
        return this.getRenderedText(c);
    }

    private String getRenderedText(java.awt.Component renderer) throws StepExecutionException {
        return TesterUtil.getRenderedText(renderer);
    }

    private String getTitleOfBorder(Border border) {
        String title = null;
        if (border instanceof TitledBorder) {
            TitledBorder titBorder = (TitledBorder)border;
            title = titBorder.getTitle();
        } else if (border instanceof CompoundBorder) {
            CompoundBorder compoundBorder = (CompoundBorder)border;
            Border insideBorder = compoundBorder.getInsideBorder();
            Border outsideBorder = compoundBorder.getOutsideBorder();
            if (insideBorder instanceof TitledBorder) {
                TitledBorder titBorderInside = (TitledBorder)insideBorder;
                title = titBorderInside.getTitle();
            }
            if (outsideBorder instanceof TitledBorder) {
                TitledBorder titBorderOutside = (TitledBorder)outsideBorder;
                title = titBorderOutside.getTitle();
            }
        }
        return title;
    }
}

