/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.tester;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Field;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.AbstractApplicationTester;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.swing.components.SwingComponent;
import org.eclipse.jubula.rc.swing.listener.ComponentHandler;
import org.eclipse.jubula.rc.swing.listener.FocusTracker;
import org.eclipse.jubula.rc.swing.tester.util.EventListener;
import org.eclipse.jubula.rc.swing.tester.util.WindowHelper;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.TimeUtil;

public class SwingApplicationTester
extends AbstractApplicationTester {
    private static AutServerLogger log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.tester.SwingApplicationTester");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rcWaitForWindow(String title, String operator, int pTimeout, int delay) {
        WindowOpenedCondition cond = new WindowOpenedCondition(title, operator);
        EventLock lock = new EventLock();
        EventListener listener = new EventListener(lock, cond);
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 65L);
        if (this.isWindowOpen(title, operator)) {
            lock.release();
        }
        try {
            EventLock eventLock = lock;
            synchronized (eventLock) {
                long timeout = pTimeout;
                long done = System.currentTimeMillis() + timeout;
                while (true) {
                    block11: {
                        if (!lock.isReleased() && timeout > 0L) break block11;
                        break;
                    }
                    try {
                        lock.wait(timeout);
                        long now = System.currentTimeMillis();
                        timeout = done - now;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (Throwable throwable) {
            Object var15_13 = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
            throw throwable;
        }
        {
            Object var15_14 = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
        }
        if (!lock.isReleased() && !this.isWindowOpen(title, operator)) {
            throw new StepExecutionException("window did not open", EventFactory.createActionError((String)"TestErrorEvent.TimeoutExpired"));
        }
        TimeUtil.delay((long)delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rcWaitForWindowActivation(String title, String operator, int pTimeout, int delay) {
        WindowActivatedCondition cond = new WindowActivatedCondition(title, operator);
        EventLock lock = new EventLock();
        EventListener listener = new EventListener(lock, cond);
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 64L);
        if (this.isWindowActive(title, operator)) {
            lock.release();
        }
        try {
            EventLock eventLock = lock;
            synchronized (eventLock) {
                long timeout = pTimeout;
                long done = System.currentTimeMillis() + timeout;
                while (true) {
                    block11: {
                        if (!lock.isReleased() && timeout > 0L) break block11;
                        break;
                    }
                    try {
                        lock.wait(timeout);
                        long now = System.currentTimeMillis();
                        timeout = done - now;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (Throwable throwable) {
            Object var15_13 = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
            throw throwable;
        }
        {
            Object var15_14 = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
        }
        if (!lock.isReleased() && !this.isWindowActive(title, operator)) {
            throw new StepExecutionException("window was not activated", EventFactory.createActionError((String)"TestErrorEvent.TimeoutExpired"));
        }
        TimeUtil.delay((long)delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rcWaitForWindowToClose(String title, String operator, int pTimeout, int delay) {
        WindowClosedCondition cond = new WindowClosedCondition(title, operator);
        EventLock lock = new EventLock();
        EventListener listener = new EventListener(lock, cond);
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 64L);
        if (!this.isWindowOpen(title, operator)) {
            lock.release();
        }
        try {
            EventLock eventLock = lock;
            synchronized (eventLock) {
                long timeout = pTimeout;
                long done = System.currentTimeMillis() + timeout;
                while (true) {
                    block11: {
                        if (!lock.isReleased() && timeout > 0L) break block11;
                        break;
                    }
                    try {
                        lock.wait(timeout);
                        long now = System.currentTimeMillis();
                        timeout = done - now;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (Throwable throwable) {
            Object var15_13 = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
            throw throwable;
        }
        {
            Object var15_14 = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
        }
        if (!lock.isReleased() && this.isWindowOpen(title, operator)) {
            throw new StepExecutionException("window did not close", EventFactory.createActionError((String)"TestErrorEvent.TimeoutExpired"));
        }
        TimeUtil.delay((long)delay);
    }

    public void rcCheckExistenceOfWindow(String title, String operator, boolean exists) {
        Verifier.equals((boolean)exists, (boolean)this.isWindowOpen(title, operator));
    }

    public Rectangle getActiveWindowBounds() {
        Window activeWindow = WindowHelper.getActiveWindow();
        if (activeWindow != null) {
            Rectangle activeWindowBounds = new Rectangle(activeWindow.getBounds());
            activeWindowBounds.setLocation(activeWindow.getLocationOnScreen());
            return activeWindowBounds;
        }
        return null;
    }

    protected IRobot getRobot() {
        return AUTServer.getInstance().getRobot();
    }

    public void rcKeyStroke(String modifierSpec, String keySpec) {
        if (keySpec == null || keySpec.trim().length() == 0) {
            throw new StepExecutionException("The base key of the key stroke must not be null or empty", EventFactory.createActionError());
        }
        String key = keySpec.trim().toUpperCase();
        String mod = KeyStrokeUtil.getModifierString((String)modifierSpec);
        if (mod.length() > 0) {
            this.getRobot().keyStroke(String.valueOf(mod.toString()) + " " + key);
        } else {
            int code = this.getKeyCode(key);
            if (code != -1) {
                this.rcKeyType(code);
            } else {
                this.getRobot().keyStroke(key);
            }
        }
    }

    protected Object getFocusOwner() {
        return FocusTracker.getFocusOwner();
    }

    protected int getEventCode(int key) {
        int event = 0;
        switch (key) {
            case 1: {
                event = 144;
                break;
            }
            case 2: {
                event = 20;
                break;
            }
            case 3: {
                event = 145;
                break;
            }
        }
        return event;
    }

    protected Object getActiveWindow() {
        return WindowHelper.getActiveWindow();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isWindowOpen(String title, String operator) {
        boolean wasInterrupted;
        do {
            try {
                wasInterrupted = false;
                Set components = ComponentHandler.getAutHierarchy().getHierarchyMap().keySet();
                Iterator it = components.iterator();
                while (it.hasNext()) {
                    Component c = ((SwingComponent)((Object)it.next())).getRealComponent();
                    if (!c.isShowing()) continue;
                    if (c instanceof Frame) {
                        Frame frame = (Frame)c;
                        if (MatchUtil.getInstance().match(frame.getTitle(), title, operator)) {
                            return true;
                        }
                    }
                    if (!(c instanceof Dialog)) continue;
                    Dialog dialog = (Dialog)c;
                    if (!MatchUtil.getInstance().match(dialog.getTitle(), title, operator)) continue;
                    return true;
                }
            }
            catch (ConcurrentModificationException e) {
                log.debug((Object)"hierarchy modified while traversing", (Throwable)e);
                wasInterrupted = true;
            }
        } while (wasInterrupted);
        return false;
    }

    private boolean isWindowActive(String title, String operator) {
        Window activeWindow = WindowHelper.getActiveWindow();
        if (activeWindow != null) {
            String windowTitle = null;
            if (activeWindow instanceof Dialog) {
                windowTitle = ((Dialog)activeWindow).getTitle();
            } else if (activeWindow instanceof Frame) {
                windowTitle = ((Frame)activeWindow).getTitle();
            }
            if (MatchUtil.getInstance().match(windowTitle, title, operator)) {
                return true;
            }
        }
        return false;
    }

    public int getKeyCode(String keyCodeName) throws StepExecutionException {
        int code;
        block13: {
            code = -1;
            String codeName = "VK_" + keyCodeName;
            try {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.awt.event.KeyEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Field field = clazz.getField(codeName);
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.awt.event.KeyEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                code = field.getInt(clazz2);
            }
            catch (IllegalArgumentException e) {
                throw new StepExecutionException(e.getMessage(), EventFactory.createActionError());
            }
            catch (SecurityException e) {
                throw new StepExecutionException(e.getMessage(), EventFactory.createActionError());
            }
            catch (IllegalAccessException e) {
                throw new StepExecutionException(e.getMessage(), EventFactory.createActionError());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!log.isInfoEnabled()) break block13;
                log.info((Object)("The key expression '" + keyCodeName + "' is not a key code, typed as key stroke instead"));
            }
        }
        return code;
    }

    private static class WindowActivatedCondition
    implements EventListener.Condition {
        private final String m_title;
        private final String m_operator;

        public WindowActivatedCondition(String title, String operator) {
            this.m_title = title;
            this.m_operator = operator;
        }

        public boolean isTrue(AWTEvent event) {
            if (event.getID() != 205) {
                return false;
            }
            if (event.getSource() instanceof Frame) {
                Frame frame = (Frame)event.getSource();
                return MatchUtil.getInstance().match(frame.getTitle(), this.m_title, this.m_operator);
            }
            if (event.getSource() instanceof Dialog) {
                Dialog dialog = (Dialog)event.getSource();
                return MatchUtil.getInstance().match(dialog.getTitle(), this.m_title, this.m_operator);
            }
            return false;
        }
    }

    private static class WindowClosedCondition
    implements EventListener.Condition {
        private final String m_title;
        private final String m_operator;

        public WindowClosedCondition(String title, String operator) {
            this.m_title = title;
            this.m_operator = operator;
        }

        public boolean isTrue(AWTEvent event) {
            Window window;
            if (event.getID() == 208 && event.getSource() instanceof Window && !(window = (Window)event.getSource()).isVisible()) {
                String name = null;
                if (window instanceof Frame) {
                    Frame frame = (Frame)window;
                    name = frame.getTitle();
                } else if (window instanceof Dialog) {
                    Dialog dialog = (Dialog)window;
                    name = dialog.getTitle();
                } else {
                    return false;
                }
                return MatchUtil.getInstance().match(name, this.m_title, this.m_operator);
            }
            return false;
        }
    }

    private static class WindowOpenedCondition
    implements EventListener.Condition {
        private final String m_title;
        private final String m_operator;

        public WindowOpenedCondition(String title, String operator) {
            this.m_title = title;
            this.m_operator = operator;
        }

        public boolean isTrue(AWTEvent event) {
            if (event.getID() != 200 && event.getID() != 102) {
                return false;
            }
            if (event.getSource() instanceof Frame) {
                Frame frame = (Frame)event.getSource();
                return MatchUtil.getInstance().match(frame.getTitle(), this.m_title, this.m_operator);
            }
            if (event.getSource() instanceof Dialog) {
                Dialog dialog = (Dialog)event.getSource();
                return MatchUtil.getInstance().match(dialog.getTitle(), this.m_title, this.m_operator);
            }
            return false;
        }
    }
}

