/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.driver;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.driver.DefaultSwtEventMatcher;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.jubula.rc.swt.listener.ComponentHandler;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ClickSwtEventMatcher
extends DefaultSwtEventMatcher {
    private static final AutServerLogger LOG;
    private ClickOptions m_clickOptions;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.driver.ClickSwtEventMatcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = new AutServerLogger((Class)clazz);
    }

    public ClickSwtEventMatcher(ClickOptions clickOptions) {
        super(ClickSwtEventMatcher.getMouseEventId(clickOptions));
        this.m_clickOptions = clickOptions;
    }

    private static int getMouseEventId(ClickOptions clickOptions) {
        return clickOptions.getClickType() == ClickOptions.ClickType.CLICKED ? 3 : 4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFallBackEventMatching(List eventObjects, Object graphicsComponent) {
        Iterator mouseUpIt = eventObjects.iterator();
        while (mouseUpIt.hasNext()) {
            Event event = (Event)mouseUpIt.next();
            if (event.widget != graphicsComponent || event.type != 4) continue;
            return true;
        }
        if (this.isEventlessWidget(graphicsComponent)) {
            return true;
        }
        try {
            Event event;
            Iterator eventIt = eventObjects.iterator();
            do {
                if (!eventIt.hasNext()) {
                    if (ComponentHandler.getAutHierarchy().getHierarchyContainer((Widget)graphicsComponent) != null || this.m_clickOptions.getClickType() != ClickOptions.ClickType.RELEASED && this.m_clickOptions.getClickCount() != 0) return graphicsComponent instanceof Widget && !((Widget)graphicsComponent).isDisposed() && this.isOnBorder((Widget)graphicsComponent);
                    return true;
                }
                event = (Event)eventIt.next();
            } while (event.widget != graphicsComponent || event.button != 3 || event.type != 3);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.m_clickOptions.getClickType() != ClickOptions.ClickType.RELEASED && this.m_clickOptions.getClickCount() != 0) return graphicsComponent instanceof Widget && !((Widget)graphicsComponent).isDisposed() && this.isOnBorder((Widget)graphicsComponent);
            return true;
        }
    }

    private boolean isEventlessWidget(Object graphicsComponent) {
        if (graphicsComponent instanceof MenuItem) {
            return true;
        }
        if (graphicsComponent instanceof ToolItem) {
            return true;
        }
        if (graphicsComponent instanceof Combo) {
            return true;
        }
        return graphicsComponent instanceof Table && SwtUtils.isMouseCursorInWidget((Widget)graphicsComponent);
    }

    private boolean isOnBorder(final Widget graphicsComponent) {
        try {
            Boolean isOnBorder = (Boolean)new EventThreadQueuerSwtImpl().invokeAndWait("CheckBorderFallbackMatching", new IRunnable(){

                public Object run() throws StepExecutionException {
                    Point cursorLocation;
                    int fuzz = 3;
                    Display d = graphicsComponent.getDisplay();
                    Rectangle widgetBounds = SwtUtils.getWidgetBounds(graphicsComponent);
                    if (widgetBounds.contains(cursorLocation = d.getCursorLocation())) {
                        widgetBounds.x += fuzz;
                        widgetBounds.y += fuzz;
                        widgetBounds.width -= fuzz * 2;
                        widgetBounds.height -= fuzz * 2;
                        if (!widgetBounds.contains(cursorLocation)) {
                            return Boolean.TRUE;
                        }
                    }
                    return Boolean.FALSE;
                }
            });
            return isOnBorder;
        }
        catch (Throwable t) {
            LOG.warn((Object)"An error occurred during an event-confirmation workaround. The results of the workaround will be ignored.", t);
            return false;
        }
    }
}

