/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.listener;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jubula.communication.message.CAPRecordedMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.MessageCap;
import org.eclipse.jubula.communication.message.MessageParam;
import org.eclipse.jubula.communication.message.RecordActionMessage;
import org.eclipse.jubula.communication.message.ShowObservInfoMessage;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.exception.NoIdentifierForComponentException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.listener.ComponentHandler;
import org.eclipse.jubula.rc.swt.listener.RecordHelperSWT;
import org.eclipse.jubula.rc.swt.listener.TableSelectionTracker;
import org.eclipse.jubula.rc.swt.utils.SwtKeyCodeConverter;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.utils.StringParsing;
import org.eclipse.jubula.tools.xml.businessmodell.Action;
import org.eclipse.jubula.tools.xml.businessmodell.Param;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class RecordActionsSWT {
    private static AutServerLogger log;
    private Map m_map = new HashMap();
    private Map m_logNameMap = new HashMap();
    private Map m_techNameMap = new HashMap();
    private int m_popupMouseBtn = 0x200000;
    private RecordHelperSWT m_recordHelperSWT = new RecordHelperSWT();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.listener.RecordListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public Map getTextCompContent() {
        return this.m_map;
    }

    public void setTextCompContent(Map map) {
        this.m_map = map;
    }

    public void addTextCompContent(Widget source, String content) {
        this.m_map.put(source, content);
    }

    public int getPopupMouseButton() {
        return this.m_popupMouseBtn;
    }

    public void setPopupMouseButton(int popupMouseBtn) {
        this.m_popupMouseBtn = popupMouseBtn;
    }

    protected void selectListValues(org.eclipse.swt.widgets.List lst, IComponentIdentifier id, Action a) {
        String[] entries = lst.getSelection();
        String entr = "";
        int i = 0;
        while (i < entries.length) {
            String item = StringParsing.maskAndSingleQuoteText((String)entries[i].toString(), (int)1);
            entr = entr.concat(item);
            if (i < entries.length - 1) {
                entr = entr.concat(",");
            }
            ++i;
        }
        LinkedList<String> lstValues = new LinkedList<String>();
        lstValues.add(entr);
        lstValues.add("equals");
        lstValues.add("absolute");
        lstValues.add("no");
        String logName = this.createLogicalName((Widget)lst, id);
        this.createCAP(a, id, lstValues, logName, "");
    }

    protected void selectNode(Tree tre, IComponentIdentifier id, Action a, int clickcount) {
        TreeItem[] entries = tre.getSelection();
        String nodepath = this.m_recordHelperSWT.getTreePath((Widget)entries[0]);
        this.m_recordHelperSWT.setTreePath("");
        int count = clickcount;
        String extraMsg = "";
        if (count < 1) {
            count = 1;
            extraMsg = "ClickCount of observed Action set from 0 to 1";
        }
        String clCount = String.valueOf(count);
        LinkedList<String> treValues = new LinkedList<String>();
        treValues.add("absolute");
        treValues.add("0");
        treValues.add(nodepath);
        treValues.add("equals");
        treValues.add(clCount);
        treValues.add(String.valueOf(1));
        treValues.add("no");
        String logName = this.createLogicalName((Widget)tre, id);
        this.createCAP(a, id, treValues, logName, extraMsg);
    }

    protected void selectTableTreeCell(Tree tre, IComponentIdentifier id, Action a, int clickcount) {
        TreeItem node = tre.getSelection()[0];
        String nodepath = this.m_recordHelperSWT.getTreePath((Widget)node);
        this.m_recordHelperSWT.setTreePath("");
        int col = this.m_recordHelperSWT.getSelectedTreeColumn(tre);
        String column = new Integer(col).toString();
        int count = clickcount;
        String extraMsg = "";
        if (count < 1) {
            count = 1;
            extraMsg = "ClickCount of observed Action set from 0 to 1";
        }
        String clCount = String.valueOf(count);
        LinkedList<String> treValues = new LinkedList<String>();
        treValues.add("absolute");
        treValues.add("0");
        treValues.add(nodepath);
        treValues.add("equals");
        treValues.add(clCount);
        treValues.add(column);
        treValues.add(String.valueOf(1));
        String logName = this.createLogicalName((Widget)tre, id);
        this.createCAP(a, id, treValues, logName, extraMsg);
    }

    protected void selectTab(TabFolder tf, IComponentIdentifier id, Action a) {
        LinkedList<String> tpnValues = new LinkedList<String>();
        String tpnTitle = StringParsing.singleQuoteText((String)tf.getItem(tf.getSelectionIndex()).getText());
        tpnTitle = SwtUtils.removeMnemonics(tpnTitle);
        tpnValues.add(tpnTitle);
        tpnValues.add("equals");
        String logName = this.createLogicalName((Widget)tf, id);
        this.createCAP(a, id, tpnValues, logName, "");
    }

    protected void selectCTab(CTabFolder ctf, IComponentIdentifier id, Action a) {
        LinkedList<String> tpnValues = new LinkedList<String>();
        String tpnTitle = StringParsing.singleQuoteText((String)ctf.getSelection().getText());
        tpnTitle = SwtUtils.removeMnemonics(tpnTitle);
        tpnValues.add(tpnTitle);
        tpnValues.add("equals");
        String logName = this.createLogicalName((Widget)ctf, id);
        this.createCAP(a, id, tpnValues, logName, "");
    }

    protected void selectCbxValue(Combo cbx, IComponentIdentifier id, Action a) {
        String cbxText = StringParsing.singleQuoteText((String)cbx.getItem(cbx.getSelectionIndex()).toString());
        if (cbxText.equals("") || cbxText == null) {
            cbxText = "'^$'";
        }
        LinkedList<String> cbxValues = new LinkedList<String>();
        cbxValues.add(cbxText);
        cbxValues.add("equals");
        cbxValues.add("absolute");
        String logName = this.createLogicalName((Widget)cbx, id);
        this.createCAP(a, id, cbxValues, logName, "");
    }

    protected void selectCCbxValue(CCombo ccbx, IComponentIdentifier id, Action a) {
        String ccbxText = StringParsing.singleQuoteText((String)ccbx.getItem(ccbx.getSelectionIndex()).toString());
        if (ccbxText.equals("") || ccbxText == null) {
            ccbxText = "'^$'";
        }
        LinkedList<String> ccbxValues = new LinkedList<String>();
        ccbxValues.add(ccbxText);
        ccbxValues.add("equals");
        ccbxValues.add("absolute");
        String logName = this.createLogicalName((Widget)ccbx, id);
        this.createCAP(a, id, ccbxValues, logName, "");
    }

    protected void selectTableCell(Table tbl, IComponentIdentifier id, int clickcount, Action a, int[] cell) {
        String rowStr = new Integer(cell[0]).toString();
        String columnStr = new Integer(cell[1]).toString();
        int count = clickcount;
        String extraMsg = "";
        if (count < 1) {
            count = 1;
            extraMsg = "ClickCount of observed Action set from 0 to 1";
        }
        String clCount = new Integer(count).toString();
        LinkedList<String> tblValues = new LinkedList<String>();
        tblValues.add(rowStr);
        tblValues.add("equals");
        tblValues.add(columnStr);
        tblValues.add("equals");
        tblValues.add(clCount);
        tblValues.add("50");
        tblValues.add("percent");
        tblValues.add("50");
        tblValues.add("percent");
        tblValues.add("no");
        String logName = this.createLogicalName((Widget)tbl, id);
        this.createCAP(a, id, tblValues, logName, extraMsg);
    }

    protected void selectMenuItem(MenuItem mni, IComponentIdentifier id, Action a, String logName) {
        String pth = this.m_recordHelperSWT.getMenuPath((Widget)mni);
        pth = SwtUtils.removeMnemonics(pth);
        LinkedList<String> parValues = new LinkedList<String>();
        parValues.add(pth);
        parValues.add("equals");
        if (a.getName().equals("CompSystem.PopupSelectByTextPathNew")) {
            parValues.add(new Integer(this.m_popupMouseBtn).toString());
        }
        if (logName != null) {
            this.createCAP(a, id, parValues, logName, "");
        } else {
            this.createCAP(a, id, parValues);
        }
    }

    protected void collExpTree(String collOrExp, Event event) {
        IComponentIdentifier id = null;
        Widget widget = SwtUtils.getWidgetAtCursorLocation();
        try {
            id = ComponentHandler.getIdentifier(widget);
            String nodepath = null;
            nodepath = this.m_recordHelperSWT.getTreePath(event.item);
            this.m_recordHelperSWT.setTreePath("");
            Action a = this.m_recordHelperSWT.compSysToAction(id, collOrExp);
            LinkedList<String> treValues = new LinkedList<String>();
            treValues.add("absolute");
            treValues.add("0");
            treValues.add(nodepath);
            treValues.add("equals");
            String logName = this.createLogicalName(widget, id);
            this.createCAP(a, id, treValues, logName, "");
        }
        catch (NoIdentifierForComponentException noIdentifierForComponentException) {
            log.error((Object)("no identifier for '" + widget));
        }
    }

    protected void clickGraphComp(IComponentIdentifier id, Event event, Widget src) {
        if (src instanceof Table || src instanceof org.eclipse.swt.widgets.List || src instanceof Tree) {
            this.clickInComponent(id, event, src);
        } else {
            int count = event.count;
            String extraMsg = "";
            if (count < 1) {
                count = 1;
                extraMsg = "ClickCount of observed Action set from 0 to 1";
            }
            String clickcount = new Integer(count).toString();
            String mbutton = new Integer(event.button).toString();
            Action a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.Click");
            LinkedList<String> parValues = new LinkedList<String>();
            parValues.add(clickcount);
            parValues.add(mbutton);
            String logName = this.createLogicalName(src, id);
            this.createCAP(a, id, parValues, logName, extraMsg);
        }
    }

    protected void clickInComponent(IComponentIdentifier id, Event event, Widget src) {
        int count = event.count;
        String extraMsg = "";
        if (count < 1) {
            count = 1;
            extraMsg = "ClickCount of observed Action set from 0 to 1";
        }
        String clickcount = new Integer(count).toString();
        String mbutton = new Integer(event.button).toString();
        Rectangle bounds = SwtUtils.getWidgetBounds(src);
        double x = event.x;
        double y = event.y;
        double width = bounds.width;
        double height = bounds.height;
        double percentX = x / width * 100.0;
        int percentXInt = (int)percentX;
        String percentXString = new Integer(percentXInt).toString();
        double percentY = y / height * 100.0;
        int percentYInt = (int)percentY;
        String percentYString = new Integer(percentYInt).toString();
        Action a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.ClickDirect");
        String units = "percent";
        LinkedList<String> parValues = new LinkedList<String>();
        parValues.add(clickcount);
        parValues.add(mbutton);
        parValues.add(percentXString);
        parValues.add(units);
        parValues.add(percentYString);
        parValues.add(units);
        String logName = this.createLogicalName(src, id);
        this.createCAP(a, id, parValues, logName, extraMsg);
    }

    protected void keyComboApp(IComponentIdentifier id, Event e, int keycode) {
        char character;
        Action a = new Action();
        a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.KeyStroke");
        LinkedList<String> parameterValues = new LinkedList<String>();
        String modifierKey = null;
        if (e.stateMask == 0) {
            modifierKey = "none";
        } else {
            modifierKey = SwtKeyCodeConverter.getModifierName(e.stateMask);
            if (modifierKey == null) {
                return;
            }
        }
        String baseKey = null;
        baseKey = SwtKeyCodeConverter.getKeyName(keycode);
        if (baseKey == null && (baseKey = Character.toString(character = RecordHelperSWT.topKey(e)).toUpperCase()) == null) {
            return;
        }
        parameterValues.add(modifierKey);
        parameterValues.add(baseKey);
        this.createCAP(a, id, parameterValues);
    }

    protected void replaceText(Widget source) {
        String text = null;
        boolean isEditable = false;
        boolean isCbxValue = false;
        boolean isCCbxChild = false;
        boolean isSupported = true;
        if (source instanceof Text) {
            Text txt = (Text)source;
            text = txt.getText();
            isEditable = txt.getEditable();
            if ((txt.getStyle() & 2) != 0 && (text.indexOf(13) != -1 || text.indexOf(10) != -1)) {
                isSupported = false;
                ShowObservInfoMessage infoMsg = new ShowObservInfoMessage("Multi-line text is not supported for Replace Text");
                try {
                    AUTServer.getInstance().getServerCommunicator().send((Message)infoMsg);
                }
                catch (CommunicationException communicationException) {}
            }
            if (txt.getParent() instanceof CCombo) {
                isCCbxChild = true;
            }
            if (txt.getParent() instanceof Table) {
                Table tbl = (Table)txt.getParent();
                this.replaceTableText(source, tbl, text);
                return;
            }
        }
        if (source instanceof Combo) {
            Combo cbx = (Combo)source;
            text = cbx.getText();
            isEditable = (cbx.getStyle() & 8) == 0;
            isCbxValue = this.m_recordHelperSWT.containsValue((Widget)cbx, text);
        }
        if (source instanceof CCombo) {
            CCombo ccbx = (CCombo)source;
            text = ccbx.getText();
            isEditable = ccbx.getEditable();
            isCbxValue = this.m_recordHelperSWT.containsValue((Widget)ccbx, text);
        }
        if (this.m_map.get(source) != null && !text.equals(this.m_map.get(source).toString()) && isSupported && isEditable && !isCbxValue && !isCCbxChild) {
            this.m_map.put(source, text);
            IComponentIdentifier id = null;
            try {
                id = ComponentHandler.getIdentifier(source);
                Action a = new Action();
                a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.InputText");
                text = StringParsing.singleQuoteText((String)text);
                LinkedList<String> parameterValues = new LinkedList<String>();
                parameterValues.add(text);
                String logName = this.createLogicalName(source, id);
                this.createCAP(a, id, parameterValues, logName, "");
            }
            catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                log.error((Object)("no identifier for '" + source));
            }
        }
    }

    private void replaceTableText(Widget src, Table tbl, String text) {
        String txt = StringParsing.singleQuoteText((String)text);
        if (!txt.equals(this.m_map.get(src).toString())) {
            IComponentIdentifier id = null;
            try {
                id = ComponentHandler.getIdentifier((Widget)tbl);
                Action a = new Action();
                a = this.m_recordHelperSWT.compSysToAction(id, "CompSystem.ReplaceTextInTableCellNew");
                Cell cell = TableSelectionTracker.getInstance().getSelectedCell(tbl);
                int row = cell.getRow();
                int column = cell.getCol();
                String rowStr = new Integer(row + 1).toString();
                String columnStr = new Integer(column + 1).toString();
                LinkedList<String> parameterValues = new LinkedList<String>();
                parameterValues.add(txt);
                parameterValues.add(rowStr);
                parameterValues.add(columnStr);
                String logName = this.createLogicalName((Widget)tbl, id);
                this.createCAP(a, id, parameterValues, logName, "");
                this.m_map.put(src, txt);
            }
            catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                log.error((Object)("no identifier for '" + tbl));
            }
        }
    }

    protected void waitForWindow(Shell shl, IComponentIdentifier id, Action a) {
        String title = StringParsing.singleQuoteText((String)shl.getText());
        String operator = "equals";
        String delay = new Integer(500).toString();
        String timeout = null;
        long timestamp = AUTServer.getInstance().getObservTimestamp();
        if (timestamp == 0L) {
            timeout = new Integer(30000).toString();
        } else {
            long timeoutLong = System.currentTimeMillis() - timestamp + 10000L;
            double timeoutDouble = Math.ceil((double)timeoutLong / 5000.0) * 5000.0;
            int timeoutInt = (int)timeoutDouble;
            timeout = new Integer(timeoutInt).toString();
        }
        LinkedList<String> shlValues = new LinkedList<String>();
        shlValues.add(title);
        shlValues.add(operator);
        shlValues.add(timeout);
        shlValues.add(delay);
        this.createCAP(a, id, shlValues);
    }

    private void createCAP(Action a, IComponentIdentifier id, List parValues) {
        String defaultName = "default";
        String defaultMsg = "";
        this.createCAP(a, id, parValues, defaultName, defaultMsg);
    }

    private void createCAP(Action a, IComponentIdentifier id, List parValues, String logName, String extraMsg) {
        MessageCap messageCap = new MessageCap();
        messageCap.setMethod(a.getMethod());
        messageCap.setAction(a);
        messageCap.setCi(id);
        List parameterValues = parValues;
        List params = a.getParams();
        int i = 0;
        while (i < params.size()) {
            Param param = (Param)params.get(i);
            MessageParam messageParam = new MessageParam();
            messageParam.setType(param.getType());
            String emptyString = "";
            String value = emptyString.equals(parameterValues.get(i)) ? null : (String)parameterValues.get(i);
            messageParam.setValue(value);
            messageCap.addMessageParam(messageParam);
            if (!logName.equals("default")) {
                messageCap.setLogicalName(logName);
            } else {
                messageCap.sethasDefaultMapping(true);
            }
            messageCap.setExtraMessage(extraMsg);
            ++i;
        }
        CAPRecordedMessage capRecMessage = new CAPRecordedMessage(messageCap);
        try {
            RecordActionMessage message = new RecordActionMessage(capRecMessage);
            AUTServer.getInstance().getServerCommunicator().send((Message)message);
        }
        catch (CommunicationException communicationException) {}
        AUTServer.getInstance().setObservTimestamp(System.currentTimeMillis());
    }

    private String createLogicalName(Widget w, IComponentIdentifier id) {
        String logName = (String)this.m_techNameMap.get(w);
        if (logName == null && (logName = this.m_recordHelperSWT.generateLogicalName(w, id)) != null) {
            IComponentIdentifier id2 = (IComponentIdentifier)this.m_logNameMap.get(logName);
            if (this.m_logNameMap.containsKey(logName) && !this.m_recordHelperSWT.isCiEqual(id, id2)) {
                Collection col = this.m_techNameMap.values();
                Iterator it = col.iterator();
                int counter = 0;
                while (it.hasNext()) {
                    String name = (String)it.next();
                    if (!name.equals(logName) && !name.equals(String.valueOf(logName) + "_" + (counter + 1))) continue;
                    ++counter;
                }
                logName = String.valueOf(logName) + "_" + counter;
            }
            this.m_logNameMap.put(logName, id);
            this.m_techNameMap.put(w, logName);
        }
        return logName;
    }
}

