/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IListComponent;
import org.eclipse.jubula.rc.common.util.SelectionUtil;
import org.eclipse.jubula.rc.swt.tester.adapter.ControlAdapter;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Widget;

public class ListAdapter
extends ControlAdapter
implements IListComponent {
    private List m_list;

    public ListAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_list = (List)objectToAdapt;
    }

    public String getText() {
        Object[] selected = this.getSelectedValues();
        SelectionUtil.validateSelection((Object[])selected);
        return selected[0];
    }

    public int[] getSelectedIndices() {
        return (int[])this.getEventThreadQueuer().invokeAndWait("getSelectedIndices", new IRunnable(){

            public Object run() {
                return ListAdapter.this.m_list.getSelectionIndices();
            }
        });
    }

    public void clickOnIndex(Integer i, ClickOptions co) {
        final int iVal = i;
        this.scrollIndexToVisible(iVal);
        Rectangle clickConstraints = (Rectangle)this.getEventThreadQueuer().invokeAndWait("setClickConstraints", new IRunnable(){

            public Object run() throws StepExecutionException {
                Rectangle constraints = new Rectangle(0, 0, 0, 0);
                int displayedItemCount = ListAdapter.this.getDisplayedItemCount();
                int numberBelowTop = 0;
                numberBelowTop = displayedItemCount >= ListAdapter.this.m_list.getItemCount() ? iVal : Math.max(0, iVal - ListAdapter.this.m_list.getItemCount() + displayedItemCount);
                constraints.height = ListAdapter.this.m_list.getItemHeight();
                constraints.width = ((ListAdapter)ListAdapter.this).m_list.getBounds().width;
                constraints.y += numberBelowTop * constraints.height;
                Rectangle actualListBounds = new Rectangle(0, 0, ((ListAdapter)ListAdapter.this).m_list.getClientArea().width, ((ListAdapter)ListAdapter.this).m_list.getClientArea().height);
                return constraints.intersection(actualListBounds);
            }
        });
        this.getRobot().click((Object)this.m_list, (Object)clickConstraints, co.setScrollToVisible(false));
    }

    public String[] getSelectedValues() {
        return (String[])this.getEventThreadQueuer().invokeAndWait("getSelectedValues", new IRunnable(){

            public Object run() {
                return ListAdapter.this.m_list.getSelection();
            }
        });
    }

    private int getDisplayedItemCount() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getDisplayedItemCount", new IRunnable(){

            public Object run() throws StepExecutionException {
                int listHeight = SwtUtils.getWidgetBounds((Widget)((ListAdapter)ListAdapter.this).m_list).height;
                int itemHeight = ListAdapter.this.m_list.getItemHeight();
                return new Integer(listHeight / itemHeight);
            }
        });
    }

    private void scrollIndexToVisible(final int index) {
        this.getEventThreadQueuer().invokeAndWait("scrollIndexToVisible", new IRunnable(){

            public Object run() throws StepExecutionException {
                ListAdapter.this.m_list.setTopIndex(index);
                return null;
            }
        });
    }

    public String[] getValues() {
        return (String[])this.getEventThreadQueuer().invokeAndWait("findIndices", new IRunnable(){

            public Object run() {
                int listItemCount = ListAdapter.this.m_list.getItemCount();
                String[] values = new String[ListAdapter.this.m_list.getItemCount()];
                int i = 0;
                while (i < listItemCount) {
                    values[i] = ListAdapter.this.m_list.getItem(i);
                    ++i;
                }
                return values;
            }
        });
    }
}

