/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.xml.businessmodell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.jubula.tools.exception.ConfigXmlException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.xml.businessmodell.AbstractComponent;
import org.eclipse.jubula.tools.xml.businessmodell.Action;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.xml.businessmodell.InvalidComponent;
import org.eclipse.jubula.tools.xml.businessmodell.Param;
import org.eclipse.jubula.tools.xml.businessmodell.ToolkitPluginDescriptor;
import org.eclipse.jubula.tools.xml.businessprocess.ConfigVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompSystem {
    private static Logger log;
    private List m_components;
    private Map m_componentsByType;
    private Map m_componentsByTypeLowerCase;
    private List m_abstractComponents;
    private List m_concreteComponents;
    private Map m_eventTypes;
    private Component m_mostAbstractComponent;
    private Map m_toolkitDescriptors;
    private boolean m_initialized = false;
    private ConfigVersion m_configVersion = null;
    private Set m_dataTypes = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.tools.xml.businessmodell.CompSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public CompSystem() {
        this.init();
    }

    private void init() {
        if (this.m_components == null) {
            this.m_components = new ArrayList();
        }
        if (this.m_componentsByType == null) {
            this.m_componentsByType = new HashMap(1001);
        }
        if (this.m_componentsByTypeLowerCase == null) {
            this.m_componentsByTypeLowerCase = new HashMap(1001);
        }
        if (this.m_abstractComponents == null) {
            this.m_abstractComponents = new ArrayList();
        }
        if (this.m_concreteComponents == null) {
            this.m_concreteComponents = new ArrayList();
        }
        if (this.m_eventTypes == null) {
            this.m_eventTypes = new HashMap(4);
        }
        if (this.m_toolkitDescriptors == null) {
            this.m_toolkitDescriptors = new HashMap();
        }
        this.m_eventTypes.put("TestErrorEvent.Action", new Integer(7));
        this.m_eventTypes.put("TestErrorEvent.CompNotFound", new Integer(7));
        this.m_eventTypes.put("TestErrorEvent.Config", new Integer(1));
        this.m_eventTypes.put("TestErrorEvent.VerifyFailed", new Integer(1));
        this.m_initialized = true;
    }

    public List getComponents() {
        return this.m_components;
    }

    public List getComponents(String toolkitId, boolean addReferencedToolkits) {
        ArrayList<Component> toolkitComponents = new ArrayList<Component>();
        ToolkitPluginDescriptor currDescriptor = this.getToolkitPluginDescriptor(toolkitId);
        String includesToolkit = currDescriptor.getIncludes();
        ToolkitPluginDescriptor includesDescriptor = this.getToolkitPluginDescriptor(includesToolkit);
        if (includesDescriptor != null) {
            String includesLevel = includesDescriptor.getLevel();
            if (!"toolkit".equals(includesLevel)) {
                includesToolkit = "NoValidIncludeToolkit";
            }
        } else {
            includesToolkit = "NoValidIncludeToolkit";
        }
        List dependsToolkits = this.getDependsToolkitIds(toolkitId);
        Iterator compIter = this.getComponents().iterator();
        while (compIter.hasNext()) {
            Component component = (Component)compIter.next();
            String compToolkitId = component.getToolkitDesriptor().getToolkitID();
            if (!toolkitId.equals(compToolkitId) && (!includesToolkit.equals(compToolkitId) || !addReferencedToolkits) && (!dependsToolkits.contains(compToolkitId) || !addReferencedToolkits)) continue;
            toolkitComponents.add(component);
        }
        return toolkitComponents;
    }

    public List getAbstractComponents() {
        return this.m_abstractComponents;
    }

    public List getConcreteComponents() {
        return this.m_concreteComponents;
    }

    private List getIncludesToolkits(String toolkitId, List toolkits) {
        String includes;
        toolkits.add(toolkitId);
        ToolkitPluginDescriptor toolkitPluginDescriptor = this.getToolkitPluginDescriptor(toolkitId);
        if (toolkitPluginDescriptor != null && !"null".equals(includes = toolkitPluginDescriptor.getIncludes())) {
            this.getIncludesToolkits(includes, toolkits);
        }
        return toolkits;
    }

    private List getDependsToolkitIds(String toolkitId) {
        ArrayList<String> dependsToolkits = new ArrayList<String>();
        Iterator toolkitIdsIt = this.m_toolkitDescriptors.keySet().iterator();
        while (toolkitIdsIt.hasNext()) {
            String tkId = (String)toolkitIdsIt.next();
            ToolkitPluginDescriptor tkDescr = (ToolkitPluginDescriptor)this.m_toolkitDescriptors.get(tkId);
            if (!toolkitId.equals(tkDescr.getDepends())) continue;
            dependsToolkits.add(tkId);
        }
        return dependsToolkits;
    }

    public String[] getComponentTypes(String toolkitId) {
        ArrayList<String> compTypes = new ArrayList<String>();
        List toolkits = new ArrayList();
        toolkits = this.getIncludesToolkits(toolkitId, toolkits);
        toolkits.addAll(this.getDependsToolkitIds(toolkitId));
        Iterator compIter = this.getComponents().iterator();
        while (compIter.hasNext()) {
            Component comp = (Component)compIter.next();
            String compToolkitId = comp.getToolkitDesriptor().getToolkitID();
            if (comp.isExtender() || !toolkits.contains(compToolkitId)) continue;
            compTypes.add(comp.getType());
        }
        return compTypes.toArray(new String[compTypes.size()]);
    }

    public Map getEventTypes() {
        return this.m_eventTypes;
    }

    private void check(Component component) {
        Iterator it = this.getComponents().iterator();
        while (it.hasNext()) {
            Component current = (Component)it.next();
            if (!current.getType().equals(component.getType())) continue;
            String msg = "multiple definition of component type " + component.getType();
            log.error(msg);
            throw new ConfigXmlException(msg, MessageIDs.E_MULTIPLE_COMPONENT);
        }
    }

    private void addAll(List components) {
        Iterator it = components.iterator();
        while (it.hasNext()) {
            Component component = (Component)it.next();
            this.check(component);
            this.getComponents().add(component);
            this.m_componentsByType.put(component.getType(), component);
            this.m_componentsByTypeLowerCase.put(component.getType().toLowerCase(), component);
        }
    }

    public void addEventType(String eventType, Integer reentryProp) {
        this.m_eventTypes.put(eventType, reentryProp);
    }

    public void addToolkitPluginDescriptor(String toolkitId, ToolkitPluginDescriptor descriptor) {
        if (this.m_toolkitDescriptors == null) {
            this.m_toolkitDescriptors = new HashMap();
        }
        this.m_toolkitDescriptors.put(toolkitId, descriptor);
    }

    public ToolkitPluginDescriptor getToolkitPluginDescriptor(String toolkitId) {
        if (this.m_toolkitDescriptors == null) {
            this.m_toolkitDescriptors = new HashMap();
        }
        return (ToolkitPluginDescriptor)this.m_toolkitDescriptors.get(toolkitId);
    }

    public List getAllToolkitPluginDescriptors() {
        if (this.m_toolkitDescriptors == null) {
            this.m_toolkitDescriptors = new HashMap();
        }
        return new ArrayList(this.m_toolkitDescriptors.values());
    }

    public List getIndependentToolkitPluginDescriptors(String level) {
        List toolkitDesriptors = this.getAllToolkitPluginDescriptors();
        Collections.sort(toolkitDesriptors);
        Iterator descIt = toolkitDesriptors.iterator();
        while (descIt.hasNext()) {
            boolean removeDueToToolkitLevel;
            ToolkitPluginDescriptor desc = (ToolkitPluginDescriptor)descIt.next();
            String includes = desc.getIncludes();
            String toolkitID = desc.getToolkitID();
            boolean bl = removeDueToToolkitLevel = level != null && !level.equals(desc.getLevel());
            if (!removeDueToToolkitLevel && ("abstract".equals(level) || !"".equals(includes) && !"null".equals(includes.toLowerCase()) && !"".equals(toolkitID) && !"null".equals(toolkitID.toLowerCase()))) continue;
            descIt.remove();
        }
        return toolkitDesriptors;
    }

    public Set getDataTypes() {
        if (this.m_dataTypes != null && !this.m_dataTypes.isEmpty()) {
            return this.m_dataTypes;
        }
        this.m_dataTypes = new HashSet();
        List components = this.getComponents();
        Iterator compIt = components.iterator();
        while (compIt.hasNext()) {
            Component component = (Component)compIt.next();
            List actions = component.getActions();
            Iterator actIt = actions.iterator();
            while (actIt.hasNext()) {
                Action action = (Action)actIt.next();
                List params = action.getParams();
                Iterator paramIt = params.iterator();
                while (paramIt.hasNext()) {
                    Param param = (Param)paramIt.next();
                    String type = param.getType();
                    this.m_dataTypes.add(type);
                }
            }
        }
        return this.m_dataTypes;
    }

    public Component findComponent(String typeName) {
        Validate.notNull((Object)typeName);
        if ("".equals(typeName)) {
            if (log.isDebugEnabled()) {
                log.debug("CompSystem.findComponent(...) called with empty String. Returning InvalidComponent.");
            }
            return new InvalidComponent();
        }
        Component comp = (Component)this.m_componentsByType.get(typeName);
        if (comp != null) {
            return comp;
        }
        if (log.isDebugEnabled()) {
            String translatedName = CompSystemI18n.getString(typeName, true);
            String message = "Component " + translatedName + " does not exist";
            log.debug(message);
        }
        return new InvalidComponent();
    }

    public List findComponents(String typeName) {
        Validate.notNull((Object)typeName);
        LinkedList<Component> comps = new LinkedList<Component>();
        if ("".equals(typeName)) {
            if (log.isDebugEnabled()) {
                log.debug("CompSystem.findComponent(...) called with empty String. Returning InvalidComponent.");
            }
            comps.add(new InvalidComponent());
            return comps;
        }
        Iterator it = this.getComponents().iterator();
        while (it.hasNext()) {
            ConcreteComponent ccomp;
            Component comp = (Component)it.next();
            if (!(comp instanceof ConcreteComponent) || !typeName.equals((ccomp = (ConcreteComponent)comp).getComponentClass())) continue;
            comps.add(ccomp);
        }
        if (!comps.isEmpty()) {
            return comps;
        }
        if (log.isDebugEnabled()) {
            String translatedName = CompSystemI18n.getString(typeName, true);
            String message = "Component " + translatedName + " does not exist";
            log.debug(message);
        }
        comps.add(new InvalidComponent());
        return comps;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Abstract comps", (Object)this.m_abstractComponents).append("Concrete comps", (Object)this.m_concreteComponents).toString();
    }

    public void merge(CompSystem compSystem) {
        if (!this.m_initialized) {
            this.init();
        }
        if (compSystem.m_abstractComponents != null) {
            this.m_abstractComponents.addAll(compSystem.m_abstractComponents);
        }
        if (compSystem.m_concreteComponents != null) {
            this.m_concreteComponents.addAll(compSystem.m_concreteComponents);
        }
        if (compSystem.m_toolkitDescriptors != null) {
            this.m_toolkitDescriptors.putAll(compSystem.m_toolkitDescriptors);
        }
    }

    public void postProcess() {
        Component component;
        if (!this.m_initialized) {
            this.init();
        }
        this.addAll(this.m_concreteComponents);
        this.addAll(this.m_abstractComponents);
        Iterator it = this.getComponents().iterator();
        while (it.hasNext()) {
            component = (Component)it.next();
            component.completeActions(this);
            this.handleRealizer(component);
            this.handleExtender(component);
            this.handleDepender(component);
        }
        this.validateComponents();
        it = this.getAbstractComponents().iterator();
        while (it.hasNext()) {
            component = (Component)it.next();
            if (!component.getRealized().isEmpty()) continue;
            this.m_mostAbstractComponent = component;
            break;
        }
    }

    private void handleDepender(Component component) {
        ToolkitPluginDescriptor dependsDescr;
        ToolkitPluginDescriptor toolkitDesriptor = component.getToolkitDesriptor();
        String depends = toolkitDesriptor.getDepends();
        if (!component.isExtender() && !component.isRealizer() && !"null".equals(depends) && toolkitDesriptor.isUserToolkit() && (dependsDescr = (ToolkitPluginDescriptor)this.m_toolkitDescriptors.get(depends)) != null) {
            component.setToolkitDesriptor(dependsDescr);
        }
    }

    private void validateComponents() {
        Iterator it = this.m_abstractComponents.iterator();
        while (it.hasNext()) {
            AbstractComponent ac = (AbstractComponent)it.next();
            if (!ac.getRealizers().isEmpty()) continue;
            String message = "AbstractComponent " + ac.getType() + " has no realizing concreteComponents";
            if (ac.isVisible()) {
                log.error("visible " + message);
                throw new ConfigXmlException("visible " + message, MessageIDs.E_NO_ABSTRACT_COMPONENT);
            }
            log.warn(message);
        }
        it = this.m_concreteComponents.iterator();
        while (it.hasNext()) {
            ConcreteComponent cc = (ConcreteComponent)it.next();
            if (!cc.isExtender() || StringUtils.isBlank((String)cc.getComponentClass())) continue;
            String msg = "Extending ConcreteComponent '" + cc.getType() + "' must not have a componentClass!";
            log.error(msg);
            throw new ConfigXmlException(msg, MessageIDs.E_GENERAL_COMPONENT_ERROR);
        }
    }

    private void handleRealizer(Component component) {
        boolean isConcrete = component.isConcrete();
        Set realizedSet = component.getAllRealized();
        Iterator realIt = realizedSet.iterator();
        while (realIt.hasNext()) {
            Component realized = (Component)realIt.next();
            if (isConcrete) {
                realized.addRealizer((ConcreteComponent)component);
            }
            realized.addAllRealizer(component);
        }
        if (isConcrete) {
            component.addRealizer((ConcreteComponent)component);
        }
        component.addAllRealizer(component);
    }

    private void handleExtender(Component component) {
        if (component.isExtender()) {
            List extenderActions = component.getActions();
            List extendedTypes = component.getExtendedTypes();
            boolean isExtenderVisible = component.isVisible();
            Iterator extTypesIt = extendedTypes.iterator();
            while (extTypesIt.hasNext()) {
                String extendedType = (String)extTypesIt.next();
                Component extendedComponent = this.findComponent(extendedType);
                if (!extendedComponent.isVisible()) {
                    extendedComponent.setVisible(isExtenderVisible);
                }
                Iterator extActionsIt = extenderActions.iterator();
                while (extActionsIt.hasNext()) {
                    Action extenderAction = (Action)extActionsIt.next();
                    extendedComponent.addAction(extenderAction);
                    if (!(component instanceof ConcreteComponent) || !(extendedComponent instanceof ConcreteComponent)) continue;
                    ConcreteComponent extender = (ConcreteComponent)component;
                    ConcreteComponent extended = (ConcreteComponent)extendedComponent;
                    extended.setTesterClass(extender.getTesterClass());
                }
            }
        }
    }

    public ConfigVersion getConfigVersion() {
        return this.m_configVersion;
    }

    private Component getComponentForType(String type) {
        return (Component)this.m_componentsByTypeLowerCase.get(type.toLowerCase());
    }

    public final Component getMostAbstractComponent() {
        return this.m_mostAbstractComponent;
    }

    public final String getMoreConcreteType(String type1, String type2) {
        Component comp2;
        Component comp1 = this.getComponentForType(type1);
        Component moreConcreteComp = this.getMoreConcreteComponent(comp1, comp2 = this.getComponentForType(type2));
        return moreConcreteComp != null ? moreConcreteComp.getType() : null;
    }

    public final Component getMostConcrete(Component[] components) {
        Component mostConcrete = null;
        if (components.length > 0) {
            mostConcrete = components[0];
        }
        int i = 1;
        while (i < components.length && mostConcrete != null) {
            mostConcrete = this.getMoreConcreteComponent(mostConcrete, components[i]);
            ++i;
        }
        return mostConcrete;
    }

    private Component getMoreConcreteComponent(Component comp1, Component comp2) {
        return this.getMoreConcreteComponentImpl(comp1, comp2, true);
    }

    private Component getMoreConcreteComponentImpl(Component comp1, Component comp2, boolean isFirstCall) {
        if (comp1 == null || comp2 == null) {
            return null;
        }
        if (comp1.equals(comp2)) {
            return comp1;
        }
        String comp2Type = comp2.getType();
        Iterator realizerIt = comp1.getAllRealizers().iterator();
        while (realizerIt.hasNext()) {
            Component realizer = (Component)realizerIt.next();
            if (!realizer.getType().equals(comp2Type)) continue;
            return realizer;
        }
        return isFirstCall ? this.getMoreConcreteComponentImpl(comp2, comp1, false) : null;
    }

    public final boolean isRealizing(String realizingType, String realizedType) {
        if (realizingType.equals(realizedType)) {
            return true;
        }
        Component realizer = this.findComponent(realizingType);
        return realizer.isRealizing(realizedType);
    }

    public List getIndependentToolkitPluginDescriptors(boolean toolkitLevel) {
        String level = toolkitLevel ? "toolkit" : null;
        return this.getIndependentToolkitPluginDescriptors(level);
    }

    public static String getComponentType(String componentClassName, Collection availableComponents) {
        Validate.notNull((Object)componentClassName);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jubula.tools.xml.businessmodell.Component");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Validate.allElementsOfType((Collection)availableComponents, (Class)clazz);
        Iterator compIter = availableComponents.iterator();
        while (compIter.hasNext()) {
            Component currentComp = (Component)compIter.next();
            if (!(currentComp instanceof ConcreteComponent) || !componentClassName.equals(((ConcreteComponent)currentComp).getComponentClass())) continue;
            return currentComp.getType();
        }
        return null;
    }
}

