/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmptyCollectionComparisonExpression
extends AbstractExpression {
    private AbstractExpression expression;
    private boolean hasIs;
    private boolean hasNot;
    private boolean hasSpaceAfterIs;

    EmptyCollectionComparisonExpression(AbstractExpression parent, AbstractExpression expression) {
        super(parent);
        this.updateExpression(expression);
    }

    EmptyCollectionComparisonExpression(AbstractExpression parent, String identifier, AbstractExpression expression) {
        super(parent, identifier);
        this.updateExpression(expression);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        if (this.expression != null) {
            children.add(this.expression);
        }
        if (this.hasExpression()) {
            children.add(this.buildStringExpression(' '));
        }
        children.add(this.buildStringExpression("IS"));
        if (this.hasSpaceAfterIs) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasNot) {
            children.add(this.buildStringExpression("NOT"));
        }
        children.add(this.buildStringExpression(' '));
        children.add(this.buildStringExpression("EMPTY"));
    }

    private StateFieldPathToCollectionValuedPathConverter buildConverter(AbstractExpression expression) {
        return new StateFieldPathToCollectionValuedPathConverter(this, expression);
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    public String getIdentifier() {
        if (this.hasIs && this.hasNot) {
            return "IS NOT EMPTY";
        }
        if (!this.hasIs && this.hasNot) {
            return "NOT_EMPTY";
        }
        if (this.hasIs) {
            return "IS EMPTY";
        }
        return "EMPTY";
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return EmptyCollectionComparisonExpression.queryBNF("empty_collection_comparison_expression");
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasNot() {
        return this.hasNot;
    }

    public boolean hasSpaceAfterIs() {
        return this.hasSpaceAfterIs;
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        String identifier = this.getText();
        if (identifier != null) {
            wordParser.moveForward(identifier);
            this.hasIs = true;
            this.hasSpaceAfterIs = true;
            this.hasNot = identifier == "IS NOT EMPTY";
        } else {
            if (wordParser.startsWithIdentifier("IS")) {
                this.hasIs = true;
                wordParser.moveForward("IS");
                this.hasSpaceAfterIs = wordParser.skipLeadingWhitespace() > 0;
            }
            this.hasNot = wordParser.startsWithIdentifier("NOT");
            if (this.hasNot) {
                wordParser.moveForward("NOT");
                wordParser.skipLeadingWhitespace();
            }
            wordParser.moveForward("EMPTY");
        }
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        if (this.expression != null) {
            this.expression.toParsedText(writer, includeVirtual);
            writer.append(' ');
        }
        writer.append(this.getIdentifier().toString());
    }

    private void updateExpression(AbstractExpression expression) {
        if (expression != null) {
            StateFieldPathToCollectionValuedPathConverter converter = this.buildConverter(expression);
            expression.accept(converter);
            this.expression = converter.expression;
            this.expression.setParent(this);
            expression.setParent(this);
        }
    }

    private static class StateFieldPathToCollectionValuedPathConverter
    extends AbstractExpressionVisitor {
        private AbstractExpression expression;
        private AbstractExpression parent;

        StateFieldPathToCollectionValuedPathConverter(AbstractExpression parent, AbstractExpression expression) {
            this.parent = parent;
            this.expression = expression;
        }

        public void visit(StateFieldPathExpression expression) {
            this.expression = new CollectionValuedPathExpression(this.parent, expression.getText());
        }
    }
}

