/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive.converter;

import java.util.List;
import org.eclipse.jubula.client.archive.converter.AbstractXmlConverter;
import org.eclipse.jubula.client.archive.schema.Aut;
import org.eclipse.jubula.client.archive.schema.OmCategory;
import org.eclipse.jubula.client.archive.schema.OmEntry;
import org.eclipse.jubula.client.archive.schema.Project;
import org.eclipse.jubula.client.archive.schema.TechnicalName;

public class HTMLTechnicalComponentIndexConverter
extends AbstractXmlConverter {
    private static final int REQUIRED_METADATA_VERSION_NUMBER = 6;
    private static final String OLD_HTML_TOOLKIT_ID = "com.bredexsw.guidancer.HtmlToolkitPlugin";

    protected boolean conversionIsNecessary(Project xml) {
        return xml.getMetaDataVersion() < 6;
    }

    protected void convertImpl(Project xml) {
        for (Aut autXml : xml.getAutList()) {
            if (!autXml.getAutToolkit().equals(OLD_HTML_TOOLKIT_ID)) continue;
            OmCategory mappedCat = autXml.getObjectMapping().getMapped();
            this.convertCategory(mappedCat);
        }
    }

    private void convertCategory(OmCategory cat) {
        List<OmCategory> childCat = cat.getCategoryList();
        for (OmCategory omCat : childCat) {
            this.convertCategory(omCat);
        }
        List<OmEntry> listOfMappings = cat.getAssociationList();
        for (OmEntry oe : listOfMappings) {
            this.fixTechnicalName(oe.getTechnicalName());
        }
    }

    private void fixTechnicalName(TechnicalName technicalName) {
        List<String> hierarchyNames = technicalName.getHierarchyNameList();
        String[] hNameArray = hierarchyNames.toArray(new String[hierarchyNames.size()]);
        int i = 0;
        while (i < hNameArray.length - 1) {
            String chierarchyName = hNameArray[i];
            if (!chierarchyName.matches("^.*\\[[0-9]+\\]$")) {
                hNameArray[i] = chierarchyName.concat("[1]");
            }
            ++i;
        }
        technicalName.setHierarchyNameArray(hNameArray);
    }
}

