/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.businessprocess.TestDataBP;
import org.eclipse.jubula.client.core.businessprocess.progress.ElementLoadedProgressListener;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.DataSetPO;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.annotations.Index;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="TD_MANAGER")
@EntityListeners(value={ElementLoadedProgressListener.class})
class TDManagerPO
implements ITDManager,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
PersistenceWeavedRest {
    private transient Long m_id;
    private List<IDataSetPO> m_dataTable;
    private List<String> m_uniqueIds;
    private Long m_parentProjectId;
    private transient Integer m_version;
    static final long serialVersionUID = 9104708917322612915L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;

    TDManagerPO(IParameterInterfacePO node) {
        this.m_id = null;
        this.m_dataTable = new ArrayList<IDataSetPO>();
        this.m_uniqueIds = new ArrayList<String>();
        this.m_parentProjectId = null;
        this.m_version = null;
        Validate.notNull((Object)node);
        this.createUniqueIds(node);
    }

    TDManagerPO(IParameterInterfacePO node, List<String> uniqueIds) {
        this.m_id = null;
        this.m_dataTable = new ArrayList<IDataSetPO>();
        this.m_uniqueIds = new ArrayList<String>();
        this.m_parentProjectId = null;
        this.m_version = null;
        Validate.notNull((Object)node);
        this.setUniqueIds(uniqueIds);
    }

    TDManagerPO() {
        this.m_id = null;
        this.m_dataTable = new ArrayList<IDataSetPO>();
        this.m_uniqueIds = new ArrayList<String>();
        this.m_parentProjectId = null;
        this.m_version = null;
    }

    private void createUniqueIds(IParameterInterfacePO node) {
        List<IParamDescriptionPO> params = node.getParameterList();
        for (IParamDescriptionPO param : params) {
            this.getUniqueIds().add(param.getUniqueId());
        }
    }

    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    private void setId(Long id) {
        this.m_id = id;
    }

    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
        for (IDataSetPO lWrapperPO : this.getDataTable()) {
            lWrapperPO.setParentProjectId(projectId);
        }
    }

    @Basic
    @Column(name="PARENT_PROJ")
    @Index(name="PI_TD_MANAGER_PARENT_PROJ")
    private Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    private void setHbmParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=DataSetPO.class, fetch=FetchType.EAGER)
    @OrderColumn(name="IDX")
    @BatchFetch(value=BatchFetchType.JOIN)
    public List<IDataSetPO> getDataTable() {
        return this.m_dataTable;
    }

    private void setDataTable(List<IDataSetPO> dataTable) {
        this.m_dataTable = dataTable;
    }

    @Override
    public void removeDataSet(int number) {
        this.getDataTable().remove(number);
    }

    @Override
    public void removeColumn(String uniqueId) {
        int index = this.findColumnForParam(uniqueId);
        if (index >= 0) {
            for (IDataSetPO dataSet : this.getDataSets()) {
                dataSet.removeColumn(index);
            }
            if (this.getColumnCount() == 0) {
                this.getDataTable().clear();
            }
        }
    }

    private void expandRows(int row) {
        int colCount = this.getColumnCount();
        while (row >= this.getDataTable().size()) {
            ArrayList<ITestDataPO> columns = new ArrayList<ITestDataPO>(colCount);
            int i = 0;
            while (i < colCount) {
                columns.add(TestDataBP.instance().createEmptyTestData());
                ++i;
            }
            IDataSetPO listW = PoMaker.createListWrapperPO(columns);
            this.getDataTable().add(listW);
            listW.setParentProjectId(this.getParentProjectId());
        }
    }

    @Override
    public void insertDataSet(int position) {
        int colCount = this.getColumnCount();
        ArrayList<ITestDataPO> columns = new ArrayList<ITestDataPO>(colCount);
        int i = 0;
        while (i < colCount) {
            columns.add(TestDataBP.instance().createEmptyTestData());
            ++i;
        }
        this.insertDataSet(PoMaker.createListWrapperPO(columns), position);
    }

    @Override
    public void insertDataSet(IDataSetPO dataSet, int position) {
        Validate.notNull((Object)dataSet);
        dataSet.setParentProjectId(this.getParentProjectId());
        if (position > this.getDataTable().size()) {
            this.expandRows(position - 1);
        }
        this.getDataTable().add(position, dataSet);
    }

    private void expandColumns(int column) {
        while (column >= this.getColumnCount()) {
            for (IDataSetPO dataSet : this.getDataSets()) {
                dataSet.addColumn(TestDataBP.instance().createEmptyTestData());
            }
        }
    }

    private ITestDataPO getCell(int dataSetRow, String uniqueId) throws IllegalArgumentException {
        int index = this.getUniqueIds().indexOf(uniqueId);
        if (index == -1) {
            throw new IndexOutOfBoundsException(String.valueOf(Messages.ParameterWithUniqueId) + " " + uniqueId + " " + Messages.IsNotAvailable + ".");
        }
        return this.getCell(dataSetRow, index);
    }

    private ITestDataPO getCell(int row, int column) {
        return this.getDataSet(row).getColumn(column);
    }

    @Override
    public ITestDataPO getCell(int dataSetRow, IParamDescriptionPO parameter) throws IllegalArgumentException {
        return this.getCell(dataSetRow, parameter.getUniqueId());
    }

    @Override
    public IDataSetPO getDataSet(int dataSetRow) {
        return this.getDataTable().get(dataSetRow);
    }

    @Override
    @Transient
    public List<IDataSetPO> getDataSets() {
        return Collections.unmodifiableList(this.getDataTable());
    }

    @Override
    public void updateCell(ITestDataPO testData, int row, int column) {
        this.expandRows(row);
        this.expandColumns(column);
        ITestDataPO td = this.getCell(row, column);
        if (testData != null) {
            td.setData(testData);
        } else {
            td.clear();
        }
    }

    @Override
    public void updateCell(ITestDataPO testData, int row, String uniqueId) {
        int index = this.getUniqueIds().indexOf(uniqueId);
        if (index > -1) {
            this.updateCell(testData, row, index);
        }
    }

    @Override
    @Transient
    public int getDataSetCount() {
        return this.getDataTable().size();
    }

    @Override
    @Transient
    public int getColumnCount() {
        int columns = 0;
        try {
            List<IDataSetPO> dataTable = this.getDataTable();
            if (dataTable.size() > 0) {
                IDataSetPO listW = dataTable.get(0);
                columns = listW.getList().size();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return columns;
    }

    @Override
    public ITDManager deepCopy(ITDManager tdMan) {
        for (String uniqueId : this.getUniqueIds()) {
            tdMan.addUniqueId(uniqueId);
        }
        tdMan.clear();
        for (IDataSetPO dataSet : this.getDataSets()) {
            ArrayList<ITestDataPO> newRow = new ArrayList<ITestDataPO>(dataSet.getColumnCount());
            for (ITestDataPO testData : dataSet.getList()) {
                newRow.add(testData.deepCopy());
            }
            tdMan.insertDataSet(PoMaker.createListWrapperPO(newRow), tdMan.getDataSetCount());
        }
        return tdMan;
    }

    @Override
    public void clear() {
        this.getDataTable().clear();
    }

    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Transient
    public String getName() {
        return this.toString();
    }

    @Override
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="TD_MANAGER_PARAM_ID")
    @Column(name="UNIQUE_ID")
    @OrderColumn(name="IDX")
    @JoinColumn(name="FK_TD_MANAGER")
    @BatchFetch(value=BatchFetchType.JOIN)
    public List<String> getUniqueIds() {
        return this.m_uniqueIds;
    }

    @Override
    public int findColumnForParam(String uniqueId) {
        return this.getUniqueIds().indexOf(uniqueId);
    }

    private void setUniqueIds(List<String> uniqueIds) {
        this.m_uniqueIds = uniqueIds;
    }

    @Override
    public void addUniqueId(String uniqueId) {
        this.getUniqueIds().add(uniqueId);
    }

    @Override
    public void clearUniqueIds() {
        this.getUniqueIds().clear();
    }

    @Override
    public void removeUniqueId(String uniqueId) {
        if (this.getUniqueIds().contains(uniqueId)) {
            this.removeColumn(uniqueId);
            this.getUniqueIds().remove(uniqueId);
        }
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TDManagerPO(persistenceObject);
    }

    public TDManagerPO(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "id") {
            return this.id;
        }
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        if (string == "uniqueIds") {
            return this.uniqueIds;
        }
        if (string == "dataTable") {
            return this.dataTable;
        }
        if (string == "version") {
            return this.version;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
        if (string == "uniqueIds") {
            this.uniqueIds = (List)object;
            return;
        }
        if (string == "dataTable") {
            this.dataTable = (List)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }
}

