/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.INameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.businessprocess.progress.OperationCanceledUtil;
import org.eclipse.jubula.client.core.businessprocess.progress.ProgressMonitorTracker;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectNamePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMExtProjDeletedException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.ParamNamePM;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.utils.ToolkitUtils;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.JBFatalAbortException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.jarutils.IVersion;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectPM
extends PersistenceManager
implements DataEventDispatcher.IProjectLoadedListener {
    private static final int NUM_HBM_ADD_PROGRESS_EVENT_TYPES = 4;
    private static Logger log = LoggerFactory.getLogger(ProjectPM.class);
    private static Map<Long, String> guidCache = new HashMap<Long, String>(17);
    private static Map<Long, List<IReusedProjectPO>> rpCache = new HashMap<Long, List<IReusedProjectPO>>(17);

    static {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ProjectPM anchor = new ProjectPM();
        ded.addProjectLoadedListener(anchor, true);
    }

    private ProjectPM() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addProjectLoadedListener(this, true);
    }

    @Override
    public void handleProjectLoaded() {
        ProjectPM.clearCaches();
    }

    public static void clearCaches() {
        rpCache.clear();
        guidCache.clear();
    }

    public static synchronized List<IProjectPO> findAllProjects() throws JBException {
        ProjectNameBP.getInstance().clearCache();
        EntityManager session = null;
        try {
            session = Persistor.instance().openSession();
            List<IProjectPO> list = ProjectPM.findAllProjects(session);
            return list;
        }
        catch (PersistenceException e) {
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static synchronized List<IProjectPO> findAllProjects(EntityManager sess) throws PersistenceException {
        Query query = sess.createQuery("select project from ProjectPO as project where project.clientMetaDataVersion = :majorversion");
        query.setParameter("majorversion", (Object)IVersion.JB_CLIENT_METADATA_VERSION);
        return query.getResultList();
    }

    public static synchronized IProjectPO loadProjectByGuidAndVersion(String guid, int majorVersion, int minorVersion) throws JBException {
        EntityManager session = null;
        try {
            session = Persistor.instance().openSession();
            Query query = session.createQuery("select project from ProjectPO as project inner join fetch project.properties where project.guid = :guid and project.properties.majorNumber = :majorNumber and project.properties.minorNumber = :minorNumber");
            query.setParameter("guid", (Object)guid);
            query.setParameter("majorNumber", (Object)majorVersion);
            query.setParameter("minorNumber", (Object)minorVersion);
            try {
                IProjectPO project = (IProjectPO)query.getSingleResult();
                UsedToolkitBP.getInstance().readUsedToolkitsFromDB(project);
                IProjectPO iProjectPO = project;
                return iProjectPO;
            }
            catch (NoResultException noResultException) {
                try {
                    Persistor.instance().dropSessionWithoutLockRelease(session);
                    return null;
                }
                catch (PersistenceException e) {
                    OperationCanceledException oce = ProjectPM.checkForCancel(e);
                    if (oce != null) {
                        throw oce;
                    }
                    log.error(Messages.PersistenceLoadFailed, (Throwable)e);
                    throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static synchronized Long findProjectIDByGuidAndVersion(String guid, int majorVersion, int minorVersion) throws JBException {
        EntityManager session = null;
        try {
            session = Persistor.instance().openSession();
            Query query = session.createQuery("select project.id from ProjectPO as project inner join fetch project.properties where project.guid = :guid and project.properties.majorNumber = :majorNumber and project.properties.minorNumber = :minorNumber");
            query.setParameter("guid", (Object)guid);
            query.setParameter("majorNumber", (Object)majorVersion);
            query.setParameter("minorNumber", (Object)minorVersion);
            try {
                Long projectID;
                Long l = projectID = (Long)query.getSingleResult();
                return l;
            }
            catch (NoResultException noResultException) {
                try {
                    Persistor.instance().dropSessionWithoutLockRelease(session);
                    return null;
                }
                catch (PersistenceException e) {
                    OperationCanceledException oce = ProjectPM.checkForCancel(e);
                    if (oce != null) {
                        throw oce;
                    }
                    log.error(Messages.PersistenceLoadFailed, (Throwable)e);
                    throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static synchronized IProjectPO loadProjectByNameAndVersion(String name, int majorVersion, int minorVersion) throws JBException {
        EntityManager session = null;
        String guid = "";
        try {
            session = Persistor.instance().openSession();
            Query query = session.createQuery("select name.hbmGuid from ProjectNamePO as name where name.hbmName = :name");
            query.setParameter("name", (Object)name);
            try {
                guid = (String)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                Persistor.instance().dropSessionWithoutLockRelease(session);
                return null;
            }
        }
        catch (PersistenceException e) {
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
        return ProjectPM.loadProjectByGuidAndVersion(guid, majorVersion, minorVersion);
    }

    public static synchronized IProjectPO loadLatestVersionOfProjectByName(String name) throws JBException {
        EntityManager session = null;
        String guid = "";
        int majorVersion = 0;
        int minorVersion = 0;
        try {
            session = Persistor.instance().openSession();
            Query query = session.createQuery("select project.hbmGuid from ProjectNamePO as project where project.hbmName = :name");
            query.setParameter("name", (Object)name);
            try {
                guid = (String)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                Persistor.instance().dropSessionWithoutLockRelease(session);
                return null;
            }
            try {
                String versionNumber = ProjectPM.findHighestVersionNumber(guid);
                int index = versionNumber.indexOf(46);
                majorVersion = Integer.parseInt(versionNumber.substring(0, index));
                minorVersion = Integer.parseInt(versionNumber.substring(index + 1));
            }
            catch (NumberFormatException nfe) {
                log.error(Messages.InvalidProjectVersionNumber, (Throwable)nfe);
                throw new JBException(nfe.getMessage(), MessageIDs.E_INVALID_PROJECT_VERSION);
            }
            catch (PersistenceException e) {
                log.error(Messages.PersistenceLoadFailed, (Throwable)e);
                throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
            }
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
        return ProjectPM.loadProjectByGuidAndVersion(guid, majorVersion, minorVersion);
    }

    public static synchronized IProjectPO loadProject(IReusedProjectPO reused) throws JBException {
        EntityManager session = Persistor.instance().openSession();
        try {
            IProjectPO iProjectPO = ProjectPM.loadProjectInSession(reused, session);
            return iProjectPO;
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static synchronized IProjectPO loadProjectFromMaster(IReusedProjectPO reused) throws JBException {
        EntityManager session = GeneralStorage.getInstance().getMasterSession();
        return ProjectPM.loadProjectInSession(reused, session);
    }

    private static IProjectPO loadProjectInSession(IReusedProjectPO reused, EntityManager session) throws JBFatalAbortException, OperationCanceledException, JBException {
        try {
            Query query = session.createQuery("select project from ProjectPO as project inner join fetch project.properties where project.guid = :guid and project.properties.majorNumber = :majorNumber and project.properties.minorNumber = :minorNumber");
            query.setParameter("guid", (Object)reused.getProjectGuid());
            query.setParameter("majorNumber", (Object)reused.getMajorNumber());
            query.setParameter("minorNumber", (Object)reused.getMinorNumber());
            try {
                return (IProjectPO)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                return null;
            }
        }
        catch (PersistenceException e) {
            OperationCanceledUtil.checkForOperationCanceled((RuntimeException)((Object)e));
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
    }

    public static synchronized IProjectPO loadReusedProjectInMasterSession(IReusedProjectPO reused) throws JBException {
        EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
        try {
            Query query = masterSession.createQuery("select project from ProjectPO project inner join fetch project.properties where project.guid = :guid and project.properties.majorNumber = :majorNumber and project.properties.minorNumber = :minorNumber");
            query.setParameter("guid", (Object)reused.getProjectGuid());
            query.setParameter("majorNumber", (Object)reused.getMajorNumber());
            query.setParameter("minorNumber", (Object)reused.getMinorNumber());
            IProjectPO project = null;
            try {
                project = (IProjectPO)query.getSingleResult();
            }
            catch (NoResultException noResultException) {}
            ParamNameBP.getInstance().initParamNamesOfReusedProject(reused);
            UsedToolkitBP.getInstance().readUsedToolkitsFromDB(project);
            return project;
        }
        catch (PersistenceException e) {
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
    }

    public static synchronized IProjectPO loadReusedProject(IReusedProjectPO reusedProjectInfo) throws JBException {
        EntityManager session = null;
        try {
            session = Persistor.instance().openSession();
            IProjectPO iProjectPO = ProjectPM.loadReusedProject(reusedProjectInfo, session);
            return iProjectPO;
        }
        catch (PersistenceException e) {
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static synchronized IProjectPO loadReusedProject(IReusedProjectPO reusedProjectInfo, EntityManager session) throws JBException {
        try {
            Query query = session.createQuery("select project from ProjectPO project inner join fetch project.properties where project.guid = :guid and project.properties.majorNumber = :major and project.properties.minorNumber = :minor");
            query.setParameter("guid", (Object)reusedProjectInfo.getProjectGuid());
            query.setParameter("major", (Object)reusedProjectInfo.getMajorNumber());
            query.setParameter("minor", (Object)reusedProjectInfo.getMinorNumber());
            try {
                return (IProjectPO)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                return null;
            }
        }
        catch (PersistenceException e) {
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
    }

    public static final synchronized Long findProjectId(String projGuid, Integer projMajVers, Integer projMinVers) throws JBException {
        EntityManager session = null;
        try {
            session = Persistor.instance().openSession();
            Query query = session.createQuery("select project.id from ProjectPO project inner join fetch project.properties where project.guid = :guid and project.properties.majorNumber = :major and project.properties.minorNumber = :minor");
            query.setParameter("guid", (Object)projGuid);
            query.setParameter("major", (Object)projMajVers);
            query.setParameter("minor", (Object)projMinVers);
            try {
                Long l = (Long)query.getSingleResult();
                return l;
            }
            catch (NoResultException noResultException) {
                try {
                    Persistor.instance().dropSessionWithoutLockRelease(session);
                    return null;
                }
                catch (PersistenceException e) {
                    log.error(Messages.PersistenceLoadFailed, (Throwable)e);
                    throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static final synchronized List<IReusedProjectPO> loadReusedProjectsRO(String projGuid, Integer projMajVers, Integer projMinVers) throws JBException {
        return ProjectPM.loadReusedProjectsRO(ProjectPM.findProjectId(projGuid, projMajVers, projMinVers));
    }

    public static final List<IReusedProjectPO> loadReusedProjectsRO(Long projectId) throws JBException {
        List<IReusedProjectPO> cachedList = rpCache.get(projectId);
        if (cachedList != null && !cachedList.isEmpty()) {
            return cachedList;
        }
        EntityManager session = GeneralStorage.getInstance().getMasterSession();
        ArrayList<IReusedProjectPO> list = new ArrayList<IReusedProjectPO>();
        try {
            if (projectId != null) {
                Query query = session.createQuery("select reusedProj from ReusedProjectPO reusedProj where reusedProj.hbmParentProjectId = :parentProjId");
                query.setParameter("parentProjId", (Object)projectId);
                list.addAll(query.getResultList());
            }
        }
        catch (PersistenceException e) {
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
        rpCache.put(projectId, list);
        return list;
    }

    public static void loadProjectInROSession(IProjectPO project) throws PMReadException {
        GeneralStorage.getInstance().reset();
        EntityManager s = GeneralStorage.getInstance().getMasterSession();
        s.clear();
        try {
            ProjectPM.preloadData(s, project);
            IProjectPO p = (IProjectPO)s.find(NodeMaker.getProjectPOClass(), (Object)project.getId());
            GeneralStorage.getInstance().setProject(p);
            ParamNameBP.getInstance().initMap();
            ComponentNamesBP.getInstance().init();
        }
        catch (PersistenceException e) {
            GeneralStorage.getInstance().setProject(null);
            OperationCanceledException cancel = ProjectPM.checkForCancel(e);
            if (cancel != null) {
                throw cancel;
            }
            String msg = String.valueOf(Messages.CantReadProjectFromDatabase) + ".";
            log.error(String.valueOf(Messages.UnexpectedPersistenceErrorIgnored) + ".", (Throwable)e);
            throw new PMReadException(String.valueOf(msg) + e.getMessage(), MessageIDs.E_CANT_READ_PROJECT);
        }
        catch (PMException e) {
            String msg = String.valueOf(Messages.CouldNotReadParamNamesFromDB) + ".";
            log.error(msg, (Throwable)((Object)e));
            throw new PMReadException(String.valueOf(msg) + e.getMessage(), MessageIDs.E_CANT_READ_PROJECT);
        }
        catch (JBException e) {
            GeneralStorage.getInstance().setProject(null);
            String msg = String.valueOf(Messages.CantReadProjectFromDatabase) + ".";
            log.error(Messages.UnexpectedPersistenceErrorIgnored, (Throwable)e);
            throw new PMReadException(String.valueOf(msg) + e.getMessage(), MessageIDs.E_CANT_READ_PROJECT);
        }
    }

    private static OperationCanceledException checkForCancel(PersistenceException e) {
        Throwable cause = e.getCause();
        while (cause != null) {
            if (cause instanceof OperationCanceledException) {
                return (OperationCanceledException)cause;
            }
            cause = cause.getCause();
        }
        return null;
    }

    private static void findReusedProjects(Set<Long> reused, Set<IReusedProjectPO> check) throws JBException {
        for (IReusedProjectPO ru : check) {
            IProjectPO ruP = ProjectPM.loadProjectFromMaster(ru);
            if (ruP == null || !reused.add(ruP.getId())) continue;
            ProjectPM.findReusedProjects(reused, ruP.getProjectProperties().getUsedProjects());
        }
    }

    public static List<IReusedProjectPO> getReusedProjectsForProject(long projectID) throws PMException {
        EntityManager session = null;
        try {
            session = Persistor.instance().openSession();
            List<IReusedProjectPO> list = ProjectPM.getReusedProjectsForProject(session, projectID);
            return list;
        }
        catch (PersistenceException e) {
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new PMException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static List<IReusedProjectPO> getReusedProjectsForProjectRO(long projectID) throws PMException {
        EntityManager session = GeneralStorage.getInstance().getMasterSession();
        try {
            return ProjectPM.getReusedProjectsForProject(session, projectID);
        }
        catch (PersistenceException e) {
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new PMException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
    }

    public static List<IReusedProjectPO> getReusedProjectsForProject(EntityManager s, long projectID) {
        Query q = s.createQuery("select project from ReusedProjectPO project where project.hbmParentProjectId = :projectID");
        q.setParameter("projectID", (Object)projectID);
        List result = q.getResultList();
        return result;
    }

    private static void preloadData(EntityManager s, IProjectPO key) throws JBException {
        HashSet<Long> projectIds = new HashSet<Long>(17);
        projectIds.add(key.getId());
        ProjectPM.findReusedProjects(projectIds, key.getProjectProperties().getUsedProjects());
        ProjectPM.preloadDataForClass(s, projectIds, "CompNamesPairPO");
        ProjectPM.preloadDataForClass(s, projectIds, "CompIdentifierPO");
        ProjectPM.preloadDataForClass(s, projectIds, "AUTConfigPO");
        ProjectPM.preloadDataForClass(s, projectIds, "AUTMainPO");
        ProjectPM.preloadDataForClass(s, projectIds, "ReusedProjectPO");
        ProjectPM.preloadDataForClass(s, projectIds, "UsedToolkitPO");
        ProjectPM.preloadDataForClass(s, projectIds, "AUTContPO");
        ProjectPM.preloadDataForClass(s, projectIds, "ParamDescriptionPO");
        ProjectPM.preloadDataForClass(s, projectIds, "TDManagerPO");
        ProjectPM.preloadDataForClass(s, projectIds, "TestDataCubePO");
        ProjectPM.preloadDataForClass(s, projectIds, "CapPO");
        List testCases = ProjectPM.preloadDataForClass(s, projectIds, "SpecTestCasePO");
        ProjectPM.preloadDataForClass(s, projectIds, "EventExecTestCasePO");
        ProjectPM.preloadDataForClass(s, projectIds, "TestSuitePO");
        List testCaseRefs = ProjectPM.preloadDataForClass(s, projectIds, "ExecTestCasePO");
        ProjectPM.preloadDataForClass(s, projectIds, "CategoryPO");
        HashMap<String, ISpecTestCasePO> sTc = new HashMap<String, ISpecTestCasePO>();
        for (ISpecTestCasePO testCase : testCases) {
            sTc.put(testCase.getGuid(), testCase);
        }
        for (IExecTestCasePO testCaseRef : testCaseRefs) {
            ISpecTestCasePO spec = (ISpecTestCasePO)sTc.get(testCaseRef.getSpecTestCaseGuid());
            if (spec == null) continue;
            testCaseRef.setCachedSpecTestCase(spec);
        }
    }

    private static List preloadDataForClass(EntityManager s, Set projectIds, String simpleClassName) {
        StringBuilder qString = new StringBuilder(100);
        qString.append("select e from ");
        qString.append(simpleClassName);
        qString.append(" as e where e.hbmParentProjectId in :ids");
        Query q = s.createQuery(qString.toString());
        q.setParameter("ids", (Object)projectIds);
        return q.getResultList();
    }

    /*
     * Exception decompiling
     */
    public static void attachProjectToROSession(IProjectPO proj, String newProjectName, List<INameMapper> mapperList, List<IWritableComponentNameMapper> compNameBindingList, IProgressMonitor monitor) throws PMException, ProjectDeletedException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void handleAlreadyLockedException(List<INameMapper> mapperList, EntityManager s, EntityTransaction tx) throws PMException {
        if (tx != null) {
            Persistor.instance().rollbackTransaction(s, tx);
        }
        GeneralStorage.getInstance().reset();
        for (INameMapper mapper : mapperList) {
            mapper.clearAllNames();
        }
        String msg = String.valueOf(Messages.CantAttachProject) + ".";
        throw new PMSaveException(msg, MessageIDs.E_OBJECT_IN_USE);
    }

    private static void handleIncompatibleTypeException(List<INameMapper> mapperList, EntityManager s, EntityTransaction tx, IncompatibleTypeException ite) throws PMException, PMSaveException {
        if (tx != null) {
            Persistor.instance().rollbackTransaction(s, tx);
        }
        GeneralStorage.getInstance().reset();
        for (INameMapper mapper : mapperList) {
            mapper.clearAllNames();
        }
        String msg = "Can't attach project. ";
        throw new PMSaveException(String.valueOf(msg) + ite.getMessage(), MessageIDs.E_ATTACH_PROJECT);
    }

    private static void handlePersistenceException(List<INameMapper> mapperList, EntityManager s, EntityTransaction tx, PersistenceException e) throws PMException, InterruptedException, PMSaveException {
        if (tx != null) {
            Persistor.instance().rollbackTransaction(s, tx);
        }
        if (e.getCause() instanceof InterruptedException) {
            GeneralStorage.getInstance().reset();
            for (INameMapper mapper : mapperList) {
                mapper.clearAllNames();
            }
            throw new InterruptedException();
        }
        String msg = String.valueOf(Messages.CantAttachProject) + ".";
        throw new PMSaveException(String.valueOf(msg) + e.getMessage(), MessageIDs.E_ATTACH_PROJECT);
    }

    private static void handleOperationCanceled(List<INameMapper> mapperList, EntityManager s, EntityTransaction tx) throws PMException, InterruptedException {
        if (tx != null) {
            Persistor.instance().rollbackTransaction(s, tx);
        }
        GeneralStorage.getInstance().reset();
        for (INameMapper mapper : mapperList) {
            mapper.clearAllNames();
        }
        throw new InterruptedException();
    }

    private static void initBPs(IProjectPO proj) throws PMException, ProjectDeletedException, PMSaveException {
        try {
            ComponentNamesBP.getInstance().init();
            ParamNameBP.getInstance().initMap();
        }
        catch (PMException e) {
            throw new PMException(String.valueOf(Messages.ReadingOfProjectNameOrParamNamesFailed) + ":" + " " + e.toString(), MessageIDs.E_ATTACH_PROJECT);
        }
        try {
            UsedToolkitBP.getInstance().refreshToolkitInfo(proj);
        }
        catch (PMException e) {
            throw new PMSaveException(String.valueOf(Messages.PMExceptionWhileWritingUsedToolkitsInDB) + ":" + " " + e.toString(), MessageIDs.E_ATTACH_PROJECT);
        }
    }

    private static void setHbmProgressMonitor(IProgressMonitor monitor) {
        ProgressMonitorTracker.getInstance().setProgressMonitor(monitor);
    }

    public static void saveProject(IProjectPO proj, String newProjectName, List<INameMapper> mapperList, List<IWritableComponentNameMapper> compNameBindingList) throws PMException, ProjectDeletedException, InterruptedException {
        EntityManager saveSession = Persistor.instance().openSession();
        EntityTransaction tx = null;
        try {
            try {
                tx = Persistor.instance().getTransaction(saveSession);
                saveSession.persist((Object)proj);
                proj.setParentProjectId(proj.getId());
                saveSession.flush();
                if (newProjectName != null) {
                    ProjectNameBP.getInstance().setName(saveSession, proj.getGuid(), newProjectName);
                }
                ProjectNameBP.getInstance().storeTransientNames(saveSession);
                for (INameMapper iNameMapper : mapperList) {
                    iNameMapper.persist(saveSession, proj.getId());
                }
                for (IWritableComponentNameMapper iWritableComponentNameMapper : compNameBindingList) {
                    CompNamePM.flushCompNames(saveSession, proj.getId(), iWritableComponentNameMapper);
                }
                Persistor.instance().commitTransaction(saveSession, tx);
                for (INameMapper iNameMapper : mapperList) {
                    iNameMapper.updateStandardMapperAndCleanup(proj.getId());
                }
                for (IComponentNameMapper iComponentNameMapper : compNameBindingList) {
                    iComponentNameMapper.getCompNameCache().updateStandardMapperAndCleanup(proj.getId());
                }
            }
            catch (PersistenceException persistenceException) {
                if (tx != null) {
                    Persistor.instance().rollbackTransaction(saveSession, tx);
                }
                if (persistenceException.getCause() instanceof InterruptedException) {
                    throw new InterruptedException();
                }
                String msg = String.valueOf(Messages.CantSaveProject) + ".";
                throw new PMSaveException(String.valueOf(msg) + persistenceException.getMessage(), MessageIDs.E_ATTACH_PROJECT);
            }
            catch (IncompatibleTypeException incompatibleTypeException) {
                if (tx != null) {
                    Persistor.instance().rollbackTransaction(saveSession, tx);
                }
                String msg = String.valueOf(Messages.CantSaveProject) + ".";
                throw new PMSaveException(String.valueOf(msg) + incompatibleTypeException.getMessage(), MessageIDs.E_ATTACH_PROJECT);
            }
        }
        finally {
            Persistor.instance().dropSession(saveSession);
        }
    }

    public static synchronized boolean doesProjectNameExist(String name) {
        Long hits;
        block8: {
            EntityManager session = null;
            hits = null;
            try {
                session = Persistor.instance().openSession();
                Query q = session.createQuery("select name from ProjectNamePO as name where name.hbmName = :name");
                q.setParameter("name", (Object)name);
                IProjectNamePO namePO = (IProjectNamePO)q.getSingleResult();
                if (namePO != null) {
                    q = session.createQuery("select count(project.id) from ProjectPO project where project.guid = :guid");
                    q.setParameter("guid", (Object)namePO.getGuid());
                    hits = (Long)q.getSingleResult();
                }
            }
            catch (NoResultException noResultException) {
                Persistor.instance().dropSessionWithoutLockRelease(session);
                return false;
            }
            catch (PersistenceException e) {
                try {
                    log.error(Messages.PersistenceLoadFailed, (Throwable)e);
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Persistor.instance().dropSessionWithoutLockRelease(session);
                }
            }
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
        return hits != null && hits.intValue() > 0;
    }

    public static synchronized boolean doesProjectVersionExist(String guid, Integer majorNumber, Integer minorNumber) {
        Long hits;
        block5: {
            EntityManager session = null;
            hits = null;
            try {
                try {
                    session = Persistor.instance().openSession();
                    Query q = session.createQuery("select count(project) from ProjectPO as project inner join project.properties properties where project.guid = :guid and properties.majorNumber = :majorNumber and properties.minorNumber = :minorNumber");
                    q.setParameter("guid", (Object)guid);
                    q.setParameter("majorNumber", (Object)majorNumber);
                    q.setParameter("minorNumber", (Object)minorNumber);
                    hits = (Long)q.getSingleResult();
                }
                catch (PersistenceException e) {
                    log.error(Messages.PersistenceLoadFailed, (Throwable)e);
                    Persistor.instance().dropSessionWithoutLockRelease(session);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Persistor.instance().dropSessionWithoutLockRelease(session);
                throw throwable;
            }
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
        return hits != null && hits.intValue() > 0;
    }

    public static synchronized boolean doesTestSuiteExists(Long projectId, String name) {
        List hits;
        block5: {
            EntityManager session = null;
            hits = null;
            try {
                try {
                    session = Persistor.instance().openSession();
                    Query q = session.createQuery("select node from TestSuitePO as node where node.hbmName = ?1 and node.hbmParentProjectId = ?2");
                    q.setParameter(1, (Object)name);
                    q.setParameter(2, (Object)projectId);
                    hits = q.getResultList();
                }
                catch (PersistenceException e) {
                    log.error(Messages.PersistenceLoadFailed, (Throwable)e);
                    Persistor.instance().dropSessionWithoutLockRelease(session);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Persistor.instance().dropSessionWithoutLockRelease(session);
                throw throwable;
            }
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
        return hits != null && hits.size() > 0;
    }

    public static synchronized boolean doesTestJobExists(Long projectId, String name) {
        List hits;
        block5: {
            EntityManager session = null;
            hits = null;
            try {
                try {
                    session = Persistor.instance().openSession();
                    Query q = session.createQuery("select node from TestJobPO as node where node.hbmName = ?1 and node.hbmParentProjectId = ?2");
                    q.setParameter(1, (Object)name);
                    q.setParameter(2, (Object)projectId);
                    hits = q.getResultList();
                }
                catch (PersistenceException e) {
                    log.error(Messages.PersistenceLoadFailed, (Throwable)e);
                    Persistor.instance().dropSessionWithoutLockRelease(session);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Persistor.instance().dropSessionWithoutLockRelease(session);
                throw throwable;
            }
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
        return hits != null && hits.size() > 0;
    }

    public static void deleteProject(IProjectPO proj, boolean isActProject) throws PMDirtyVersionException, PMAlreadyLockedException, PMExtProjDeletedException, ProjectDeletedException, JBException, InterruptedException {
        block12: {
            Validate.notNull((Object)proj, (String)"Project to delete is null");
            EntityManager deleteSess = null;
            IProjectPO p = null;
            Long projId = proj.getId();
            try {
                EntityManager s;
                IProjectPO currProj;
                if (isActProject && (currProj = (IProjectPO)(s = GeneralStorage.getInstance().getMasterSession()).find(NodeMaker.getProjectPOClass(), (Object)projId)) == null) {
                    throw new ProjectDeletedException(Messages.ProjectWasDeleted, MessageIDs.E_CURRENT_PROJ_DEL);
                }
            }
            catch (PersistenceException e) {
                ProjectPM.handleDBExceptionForMasterSession(proj, e);
            }
            Persistor persistor = Persistor.instance();
            try {
                try {
                    deleteSess = persistor.openSession();
                    EntityTransaction tx = persistor.getTransaction(deleteSess);
                    p = (IProjectPO)deleteSess.find(NodeMaker.getProjectPOClass(), (Object)projId);
                    if (p == null) {
                        if (isActProject) {
                            throw new ProjectDeletedException("Current Project was deleted", MessageIDs.E_CURRENT_PROJ_DEL);
                        }
                        throw new PMExtProjDeletedException(String.valueOf(Messages.ProjectWasDeleted) + ".", MessageIDs.E_DELETED_OBJECT);
                    }
                    persistor.lockPO(deleteSess, p);
                    ProjectPM.deleteProjectIndependentDBObjects(deleteSess, p);
                    ArrayList<ISpecPersistable> specObjList = new ArrayList<ISpecPersistable>(p.getSpecObjCont().getSpecObjList());
                    ArrayList<IExecPersistable> execObjList = new ArrayList<IExecPersistable>(p.getExecObjCont().getExecObjList());
                    for (ISpecPersistable iSpecPersistable : specObjList) {
                        PersistenceUtil.removeChildNodes(iSpecPersistable, deleteSess);
                        p.getSpecObjCont().removeSpecObject(iSpecPersistable);
                        persistor.deletePO(deleteSess, iSpecPersistable);
                    }
                    for (IExecPersistable iExecPersistable : execObjList) {
                        PersistenceUtil.removeChildNodes(iExecPersistable, deleteSess);
                        p.getExecObjCont().removeExecObject(iExecPersistable);
                        persistor.deletePO(deleteSess, iExecPersistable);
                    }
                    deleteSess.flush();
                    persistor.deletePO(deleteSess, p);
                    CompNamePM.deleteCompNames(deleteSess, projId);
                    persistor.commitTransaction(deleteSess, tx);
                    tx = null;
                }
                catch (PersistenceException e) {
                    ProjectPM.handleDBExceptionForAnySession(p, e, deleteSess);
                    persistor.dropSession(deleteSess);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                persistor.dropSession(deleteSess);
                throw throwable;
            }
            persistor.dropSession(deleteSess);
        }
        ProjectNameBP.getInstance().checkAndDeleteName(proj.getGuid());
    }

    private static void deleteProjectIndependentDBObjects(EntityManager s, IProjectPO p) throws PMException, ProjectDeletedException {
        UsedToolkitBP.getInstance().deleteToolkitsFromDB(s, p.getId(), false);
        ParamNamePM.deleteParamNames(s, p.getId(), false);
    }

    private static int getTotalWorkForSave(IProjectPO proj) {
        int totalWork = 1;
        for (IExecPersistable exec : proj.getExecObjCont().getExecObjList()) {
            totalWork += ProjectPM.getWorkForNode(exec);
        }
        for (ISpecPersistable spec : proj.getSpecObjCont().getSpecObjList()) {
            totalWork += ProjectPM.getWorkForNode(spec);
        }
        return totalWork *= 4;
    }

    private static int getWorkForNode(INodePO node) {
        int work = 1;
        if (!(node instanceof IExecTestCasePO)) {
            Iterator<INodePO> childIter = node.getNodeListIterator();
            while (childIter.hasNext()) {
                work += ProjectPM.getWorkForNode(childIter.next());
            }
        }
        if (node instanceof ISpecTestCasePO) {
            work += ((ISpecTestCasePO)node).getAllEventEventExecTC().size();
        }
        return work;
    }

    private static void rollbackTransaction(EntityManager s, String msg, EntityTransaction tx) throws PMException {
        try {
            Persistor.instance().rollbackTransaction(s, tx);
        }
        catch (PersistenceException e) {
            log.error(msg, (Throwable)e);
            GeneralStorage.getInstance().recoverSession();
        }
    }

    public static synchronized String findHighestVersionNumber(String guid) throws JBException {
        EntityManager session = null;
        try {
            session = Persistor.instance().openSession();
            Query query = session.createQuery("select project from ProjectPO project inner join fetch project.properties where project.guid = :guid order by project.properties.majorNumber desc, project.properties.minorNumber desc");
            query.setParameter("guid", (Object)guid);
            query.setMaxResults(1);
            List projList = query.getResultList();
            if (projList.isEmpty()) {
                return "";
            }
            IProjectPO project = (IProjectPO)projList.get(0);
            String string = project.getMajorProjectVersion() + "." + project.getMinorProjectVersion();
            return string;
        }
        catch (PersistenceException e) {
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static synchronized List<IProjectPO> findReusableProjects(String guid, int majorVersionNumber, int minorVersionNumber, String toolkit, String toolkitLevel) throws JBException {
        EntityManager session = null;
        try {
            session = Persistor.instance().openSession();
            Query query = session.createQuery("select project from ProjectPO project inner join fetch project.properties where project.properties.isReusable = :isReusable and project.guid != :guid");
            query.setParameter("isReusable", (Object)true);
            query.setParameter("guid", (Object)guid);
            List projects = query.getResultList();
            Iterator iter = projects.iterator();
            while (iter.hasNext()) {
                IProjectPO project = (IProjectPO)iter.next();
                String reusedToolkit = project.getToolkit();
                try {
                    String reusedToolkitLevel = ToolkitSupportBP.getToolkitLevel((String)reusedToolkit);
                    if (reusedToolkit.equals(toolkit) || ToolkitUtils.doesToolkitInclude((String)toolkit, (String)reusedToolkit) || ToolkitUtils.isToolkitMoreConcrete((String)toolkitLevel, (String)reusedToolkitLevel)) continue;
                    iter.remove();
                }
                catch (ToolkitPluginException toolkitPluginException) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(Messages.Project);
                    msg.append(" ");
                    msg.append(project.getName());
                    msg.append(" ");
                    msg.append(Messages.CouldNotBeLoadedAnUnavailableToolkitPlugin);
                    msg.append(".");
                    log.error(msg.toString());
                    iter.remove();
                }
            }
            HashSet<IProjectPO> checkedProjects = new HashSet<IProjectPO>();
            HashSet<IProjectPO> illegalProjects = new HashSet<IProjectPO>();
            IProjectPO givenProject = ProjectPM.loadProjectByGuidAndVersion(guid, majorVersionNumber, minorVersionNumber);
            if (givenProject == null) {
                log.debug(Messages.TriedFindProjectsForNonExistantProject);
                ArrayList<IProjectPO> arrayList = new ArrayList<IProjectPO>();
                return arrayList;
            }
            illegalProjects.add(givenProject);
            checkedProjects.add(givenProject);
            for (IProjectPO proj : projects) {
                ProjectPM.findIllegalProjects(proj, checkedProjects, illegalProjects, null);
            }
            projects.removeAll(illegalProjects);
            List list = projects;
            return list;
        }
        catch (PersistenceException e) {
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static void findIllegalProjects(IProjectPO projectToCheck, Set<IProjectPO> checkedProjects, Set<IProjectPO> illegalProjects, Set<IProjectPO> projectsToImport) {
        if (!checkedProjects.contains(projectToCheck)) {
            checkedProjects.add(projectToCheck);
            block2: for (IReusedProjectPO reused : projectToCheck.getUsedProjects()) {
                try {
                    String reusedGuid = reused.getProjectGuid();
                    Integer reusedMajorVersion = reused.getMajorNumber();
                    Integer reusedMinorVersion = reused.getMinorNumber();
                    IProjectPO reusedProject = null;
                    if (projectsToImport != null) {
                        for (IProjectPO importedProject : projectsToImport) {
                            if (!reusedGuid.equals(importedProject.getGuid()) || !reusedMajorVersion.equals(importedProject.getMajorProjectVersion()) || !reusedMinorVersion.equals(importedProject.getMinorProjectVersion())) continue;
                            reusedProject = importedProject;
                            break;
                        }
                    }
                    if (reusedProject == null) {
                        reusedProject = ProjectPM.loadProjectByGuidAndVersion(reused.getProjectGuid(), reused.getMajorNumber(), reused.getMinorNumber());
                    }
                    if (reusedProject != null) {
                        ProjectPM.findIllegalProjects(reusedProject, checkedProjects, illegalProjects, projectsToImport);
                    }
                }
                catch (JBException jBException) {
                    illegalProjects.add(projectToCheck);
                }
                for (IProjectPO project : illegalProjects) {
                    if (!project.getGuid().equals(reused.getProjectGuid()) || !project.getMajorProjectVersion().equals(reused.getMajorNumber()) || !project.getMinorProjectVersion().equals(reused.getMinorNumber())) continue;
                    illegalProjects.add(projectToCheck);
                    continue block2;
                }
            }
        }
    }

    public static synchronized IProjectPO loadProjectById(Long projectId, EntityManager session) throws JBException {
        if (projectId == null) {
            return null;
        }
        try {
            Query query = session.createQuery("select project from ProjectPO project where project.id = :id");
            query.setParameter("id", (Object)projectId);
            try {
                return (IProjectPO)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                return null;
            }
        }
        catch (PersistenceException e) {
            OperationCanceledException oce = ProjectPM.checkForCancel(e);
            if (oce != null) {
                throw oce;
            }
            log.error(Messages.PersistenceLoadFailed, (Throwable)e);
            throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
        }
    }

    public static IProjectPO loadProjectById(Long projectId) throws JBException {
        EntityManager session = null;
        try {
            session = Persistor.instance().openSession();
            IProjectPO iProjectPO = ProjectPM.loadProjectById(projectId, session);
            return iProjectPO;
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
    }

    public static synchronized List<Long> findIdsThatReuse(String guid, int majorVersion, int minorVersion) throws JBException {
        List hits;
        EntityManager session = null;
        try {
            try {
                session = Persistor.instance().openSession();
                Query query = session.createQuery("select reusedProject.hbmParentProjectId from ReusedProjectPO as reusedProject where reusedProject.projectGuid = :projectGuid and reusedProject.majorNumber = :majorNumber and reusedProject.minorNumber = :minorNumber");
                query.setParameter("projectGuid", (Object)guid);
                query.setParameter("majorNumber", (Object)majorVersion);
                query.setParameter("minorNumber", (Object)minorVersion);
                hits = query.getResultList();
            }
            catch (PersistenceException e) {
                log.error(Messages.PersistenceLoadFailed, (Throwable)e);
                throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
            }
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
        return hits;
    }

    public static final synchronized String getGuidOfProjectId(Long projId) throws JBException {
        String projGuid;
        block7: {
            String cachedGuid = guidCache.get(projId);
            if (cachedGuid != null) {
                return cachedGuid;
            }
            EntityManager session = null;
            projGuid = null;
            Persistor persistor = Persistor.instance();
            try {
                session = persistor.openSession();
                Query query = session.createQuery("select project.guid from ProjectPO project where project.id = :projectID");
                query.setParameter("projectID", (Object)projId);
                projGuid = (String)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                persistor.dropSessionWithoutLockRelease(session);
                break block7;
            }
            catch (PersistenceException e) {
                try {
                    throw new JBException(e.getMessage(), MessageIDs.E_PERSISTENCE_LOAD_FAILED);
                }
                catch (Throwable throwable) {
                    persistor.dropSessionWithoutLockRelease(session);
                    throw throwable;
                }
            }
            persistor.dropSessionWithoutLockRelease(session);
        }
        guidCache.put(projId, projGuid);
        return projGuid;
    }

    public static boolean doesProjectExist(Long projectId) {
        List hits;
        block5: {
            EntityManager session = null;
            hits = null;
            Persistor persistor = Persistor.instance();
            try {
                try {
                    session = persistor.openSession();
                    Query q = session.createQuery("select node from ProjectPO as node where node.id = ?1");
                    q.setParameter(1, (Object)projectId);
                    hits = q.getResultList();
                }
                catch (PersistenceException e) {
                    log.error(Messages.PersistenceLoadFailed, (Throwable)e);
                    persistor.dropSessionWithoutLockRelease(session);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                persistor.dropSessionWithoutLockRelease(session);
                throw throwable;
            }
            persistor.dropSessionWithoutLockRelease(session);
        }
        return hits != null && hits.size() > 0;
    }
}

