/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.core.businessprocess.compcheck.CompletenessGuard;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.views.TestSuiteBrowser;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletenessBP
implements DataEventDispatcher.IProjectStateListener,
DataEventDispatcher.ILanguageChangedListener,
DataEventDispatcher.IProblemPropagationListener {
    private static Logger log = LoggerFactory.getLogger(CompletenessBP.class);
    private static CompletenessBP instance;

    private CompletenessBP() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addLanguageChangedListener((DataEventDispatcher.ILanguageChangedListener)this, false);
        ded.addProjectStateListener((DataEventDispatcher.IProjectStateListener)this);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        IExecutionListener saveListener = new IExecutionListener(){

            public void preExecute(String commandId, ExecutionEvent event) {
            }

            public void postExecuteSuccess(String commandId, Object returnValue) {
                if (this.isInteresting(commandId)) {
                    CompletenessBP.this.completeProjectCheck();
                }
            }

            public void postExecuteFailure(String commandId, ExecutionException exception) {
                if (this.isInteresting(commandId)) {
                    CompletenessBP.this.completeProjectCheck();
                }
            }

            public void notHandled(String commandId, NotHandledException exception) {
            }

            private boolean isInteresting(String commandId) {
                boolean isInteresting = false;
                if ("org.eclipse.ui.file.save".equals(commandId) || "org.eclipse.ui.file.saveAll".equals(commandId)) {
                    isInteresting = true;
                }
                return isInteresting;
            }
        };
        commandService.addExecutionListener(saveListener);
    }

    public static CompletenessBP getInstance() {
        if (instance == null) {
            instance = new CompletenessBP();
        }
        return instance;
    }

    public void handleProjectStateChanged(DataEventDispatcher.ProjectState state) {
        if (DataEventDispatcher.ProjectState.opened.equals((Object)state)) {
            this.completeProjectCheck();
        }
    }

    /*
     * Loose catch block
     */
    public void completeProjectCheck() {
        IProjectPO root = GeneralStorage.getInstance().getProject();
        if (root != null) {
            Plugin.startLongRunning(Messages.CompletenessCheckRunningOperation);
            try {
                try {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    workbench.getDecoratorManager().setEnabled("org.eclipse.jubula.client.ui.rcp.decorators.completenessCheckDecorator", false);
                    workbench.getProgressService().run(true, false, (IRunnableWithProgress)new UICompletenessCheckOperation());
                }
                catch (InvocationTargetException e) {
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                    Plugin.stopLongRunning();
                }
                catch (InterruptedException e) {
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                    Plugin.stopLongRunning();
                }
                catch (CoreException e) {
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    Plugin.stopLongRunning();
                }
            }
            finally {
                Plugin.stopLongRunning();
            }
        }
    }

    public void handleLanguageChanged(Locale locale) {
        IProjectPO root = GeneralStorage.getInstance().getProject();
        Locale wl = WorkingLanguageBP.getInstance().getWorkingLanguage();
        CompletenessGuard.checkTestData((Locale)wl, (INodePO)root);
        CompletenessBP.fireCompletenessCheckFinished();
    }

    private static void fireCompletenessCheckFinished() {
        DataEventDispatcher.getInstance().fireCompletenessCheckFinished();
    }

    public void problemPropagationFinished() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    TestSuiteBrowser tsb = TestSuiteBrowser.getInstance();
                    if (tsb != null) {
                        tsb.getTreeViewer().refresh();
                    }
                    IDecoratorManager dm = workbench.getDecoratorManager();
                    dm.setEnabled("org.eclipse.jubula.client.ui.rcp.decorators.completenessCheckDecorator", true);
                    dm.update("org.eclipse.jubula.client.ui.rcp.decorators.completenessCheckDecorator");
                }
                catch (CoreException e) {
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        });
    }

    public static class UICompletenessCheckOperation
    implements IRunnableWithProgress {
        public void run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.CompletenessCheckRunningOperation, -1);
            try {
                IProjectPO project = GeneralStorage.getInstance().getProject();
                Locale wl = WorkingLanguageBP.getInstance().getWorkingLanguage();
                CompletenessGuard.checkAll((Locale)wl, (INodePO)project);
            }
            finally {
                CompletenessBP.fireCompletenessCheckFinished();
                monitor.done();
            }
        }
    }
}

