/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.ui.rcp.handlers.open.AbstractOpenHandler;

public abstract class AbstractClipboardHandler
extends AbstractOpenHandler
implements ClipboardOwner {
    protected static final String OBJECT_TYPE_TESTCASE = "tc";
    protected static final String OBJECT_TYPE_TESTSUITE = "ts";
    protected static final String OBJECT_TYPE_TESTJOB = "tj";
    protected static final String SPLIT_TOKEN = "=";

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    protected void copyIDToClipboard(INodePO node) {
        StringBuilder sb = new StringBuilder();
        if (node instanceof ISpecTestCasePO) {
            sb.append(OBJECT_TYPE_TESTCASE);
        } else if (node instanceof ITestSuitePO) {
            sb.append(OBJECT_TYPE_TESTSUITE);
        } else if (node instanceof ITestJobPO) {
            sb.append(OBJECT_TYPE_TESTJOB);
        }
        sb.append(SPLIT_TOKEN);
        sb.append(node.getGuid());
        this.copyStringToClipboard(sb.toString());
    }

    private void copyStringToClipboard(String s) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(s);
        clipboard.setContents(ss, this);
    }

    public String getClipboardContents() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {}
        }
        return result;
    }
}

