/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.utils.Languages;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.databinding.validators.AutIdValidator;
import org.eclipse.jubula.client.ui.rcp.dialogs.NagDialog;
import org.eclipse.jubula.client.ui.rcp.factory.ControlFactory;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.widgets.AutIdListComposite;
import org.eclipse.jubula.client.ui.rcp.widgets.ListElementChooserComposite;
import org.eclipse.jubula.client.ui.rcp.wizards.ProjectWizard;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.xml.businessmodell.ToolkitPluginDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AUTSettingWizardPage
extends WizardPage {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_2 = 2;
    private org.eclipse.swt.widgets.List m_availableLangListField;
    private org.eclipse.swt.widgets.List m_autLangListField;
    private Button m_rightButton;
    private Button m_leftButton;
    private Text m_autNameText;
    private DirectCombo<String> m_autToolKitComboBox;
    private IAUTMainPO m_autMain;
    private IProjectPO m_project;
    private final WidgetSelectionListener m_selectionListener = new WidgetSelectionListener();
    private final WidgetModifyListener m_modifyListener = new WidgetModifyListener();
    private ListElementChooserComposite m_chooseLists;
    private Button m_allRightButton;
    private Button m_allLeftButton;
    private ScrolledComposite m_scroll;
    private boolean m_initFirstTime = true;
    private Button m_generateNames;

    public AUTSettingWizardPage(String pageName, IProjectPO newProject, IAUTMainPO autMain) {
        super(pageName);
        this.setPageComplete(false);
        this.m_project = newProject;
        this.m_autMain = autMain;
    }

    public DirectCombo<String> getToolkitComboBox() {
        return this.m_autToolKitComboBox;
    }

    public void createControl(Composite parent) {
        this.m_scroll = new ScrolledComposite(parent, 768);
        Composite composite = this.createComposite((Composite)this.m_scroll, 1, 4, false);
        Composite autNameComposite = this.createComposite(composite, 2, 4, false);
        this.newLabel(autNameComposite, "");
        this.newLabel(autNameComposite, "");
        this.createAUTNameEditor(autNameComposite);
        this.separator(composite);
        this.createAutIdList(composite);
        this.separator(composite);
        Composite innerComposite = new Composite(composite, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        innerComposite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData();
        compositeData.horizontalSpan = 2;
        compositeData.horizontalAlignment = 2;
        compositeData.grabExcessHorizontalSpace = true;
        innerComposite.setLayoutData((Object)compositeData);
        ArrayList<String> leftList = new ArrayList<String>();
        Iterator iter = this.m_project.getLangHelper().getLangListIterator();
        while (iter.hasNext()) {
            leftList.add(Languages.getInstance().getDisplayString((Locale)iter.next()));
        }
        Label descriptionLabel = new Label(innerComposite, 0);
        descriptionLabel.setText(Messages.AUTSettingWizardPageSelectLanguagesOfTD);
        ControlDecorator.decorateInfo((Control)descriptionLabel, "ControlDecorator.NewProjectAUTLanguage", false);
        this.m_chooseLists = new ListElementChooserComposite(innerComposite, Messages.AUTSettingWizardPageUpperLabel, leftList, Messages.AUTSettingWizardPageBottomLabel, new ArrayList(), 15, new Image[]{IconConstants.RIGHT_ARROW_IMAGE, IconConstants.DOUBLE_RIGHT_ARROW_IMAGE, IconConstants.LEFT_ARROW_IMAGE, IconConstants.DOUBLE_LEFT_ARROW_IMAGE}, new Image[]{IconConstants.RIGHT_ARROW_DIS_IMAGE, IconConstants.DOUBLE_RIGHT_ARROW_DIS_IMAGE, IconConstants.LEFT_ARROW_DIS_IMAGE, IconConstants.DOUBLE_LEFT_ARROW_DIS_IMAGE}, new String[]{Messages.AUTSettingWizardPageDownToolTip, Messages.AUTSettingWizardPageAllDownToolTip, Messages.AUTSettingWizardPageUpToolTip, Messages.AUTSettingWizardPageAllUpToolTip}, 1);
        this.getObjects();
        this.addListener();
        this.resizeLists();
        Plugin.getHelpSystem().setHelp((Control)composite, "org.eclipse.jubula.client.ua.help.autSettingWizardPagePageContextId");
        this.checkLanguageButtons();
        this.createNextLabel(composite);
        this.m_scroll.setContent((Control)composite);
        this.m_scroll.setMinSize(composite.computeSize(-1, -1));
        this.m_scroll.setExpandHorizontal(true);
        this.m_scroll.setExpandVertical(true);
        this.setControl((Control)this.m_scroll);
    }

    private void resizeLists() {
        ((GridData)this.m_availableLangListField.getLayoutData()).widthHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_availableLangListField), (int)15);
        ((GridData)this.m_autLangListField.getLayoutData()).widthHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_autLangListField), (int)15);
    }

    private void createNextLabel(Composite composite) {
        Label nextLabel = new Label(composite, 0);
        nextLabel.setText(Messages.AUTSettingWizardPageClickNext);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 3;
        nextLabel.setLayoutData((Object)data);
    }

    private Composite createComposite(Composite parent, int numColumns, int alignment, boolean horizontalSpace) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = numColumns;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData();
        compositeData.horizontalAlignment = alignment;
        compositeData.grabExcessHorizontalSpace = horizontalSpace;
        composite.setLayoutData((Object)compositeData);
        return composite;
    }

    private void getObjects() {
        this.m_availableLangListField = this.m_chooseLists.getListOne();
        this.m_autLangListField = this.m_chooseLists.getListTwo();
        this.m_leftButton = this.m_chooseLists.getSelectionTwoToOneButton();
        this.m_rightButton = this.m_chooseLists.getSelectionOneToTwoButton();
        this.m_allLeftButton = this.m_chooseLists.getAllTwoToOneButton();
        this.m_allRightButton = this.m_chooseLists.getAllOneToTwoButton();
    }

    private void createAUTNameEditor(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 4, false);
        Composite rightComposite = this.createComposite(parent, 1, 4, true);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftComposite.setLayout((Layout)gridLayout);
        rightComposite.setLayout((Layout)gridLayout);
        this.newLabel(leftComposite, Messages.AUTSettingWizardPageAutName);
        this.m_autNameText = new Text(rightComposite, 2048);
        this.m_autNameText.setFocus();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.m_autNameText.setLayoutData((Object)gridData);
        LayoutUtil.setMaxChar((Text)this.m_autNameText);
        this.createAutToolkitCombo(leftComposite, rightComposite, gridData);
        this.createGenerateNamesCheckBox(parent);
    }

    private void createAutIdList(Composite parent) {
        AutIdListComposite autIdListComposite = new AutIdListComposite(parent, this.m_autMain, new AutIdValidator(this.m_project));
        GridData compositeData = new GridData();
        compositeData.horizontalAlignment = 4;
        compositeData.grabExcessHorizontalSpace = true;
        autIdListComposite.setLayoutData(compositeData);
    }

    private void createGenerateNamesCheckBox(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 3, 16384, false);
        Composite rightComposite = this.createComposite(parent, 1, 4, true);
        Label infoLabel = this.newLabel(leftComposite, Messages.AUTPropertiesDialogGenerateNames);
        ControlDecorator.decorateInfo((Control)infoLabel, "AUTPropertiesDialog.generateNamesDescription", false);
        this.m_generateNames = new Button(rightComposite, 32);
        this.m_generateNames.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (AUTSettingWizardPage.this.m_autMain.isGenerateNames() != AUTSettingWizardPage.this.m_generateNames.getSelection()) {
                    AUTSettingWizardPage.this.m_autMain.setGenerateNames(AUTSettingWizardPage.this.m_generateNames.getSelection());
                }
            }
        });
        if (this.m_autMain.getToolkit() != null && this.m_autMain.getToolkit().equals("com.bredexsw.guidancer.RcpToolkitPlugin")) {
            this.m_generateNames.setEnabled(true);
        } else {
            this.m_generateNames.setEnabled(false);
            this.m_generateNames.setSelection(false);
        }
        this.m_generateNames.setSelection(this.m_autMain.isGenerateNames());
    }

    private void createAutToolkitCombo(Composite leftComposite, Composite rightComposite, GridData gridData) {
        this.newLabel(leftComposite, "");
        this.newLabel(rightComposite, "");
        ControlDecorator.decorateInfo((Control)this.newLabel(leftComposite, Messages.AUTSettingWizardPageToolkit), "ControlDecorator.NewProjectAUTToolkit", false);
        try {
            this.m_autToolKitComboBox = ControlFactory.createAutToolkitCombo(rightComposite, this.m_project, this.m_autMain.getToolkit());
            this.m_autToolKitComboBox.deselectAll();
            this.m_autToolKitComboBox.clearSelection();
            String autToolkit = this.m_autMain.getToolkit();
            if (autToolkit != null && autToolkit.trim().length() != 0) {
                this.m_autToolKitComboBox.setSelectedObject((Object)autToolkit);
            }
        }
        catch (ToolkitPluginException toolkitPluginException) {
            this.m_autToolKitComboBox = ControlFactory.createAutToolkitCombo(rightComposite, this.m_autMain);
        }
        this.m_autToolKitComboBox.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_autToolKitComboBox.setLayoutData((Object)gridData);
    }

    private Label newLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData labelGrid = new GridData(1, 2, false, false, 1, 1);
        label.setLayoutData((Object)labelGrid);
        return label;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.jubula.client.ua.help.autSettingWizardPagePageContextId");
    }

    private void checkLanguageButtons() {
        this.m_rightButton.setEnabled(true);
        this.m_leftButton.setEnabled(false);
    }

    public void fillLanguageLists() {
        List<String> projectLanguages;
        if (this.m_initFirstTime) {
            this.m_autLangListField.removeAll();
            for (Locale lang : this.m_project.getLangHelper().getLanguageList()) {
                this.m_autLangListField.add(Languages.getInstance().getDisplayString(lang));
            }
            this.m_initFirstTime = false;
        }
        this.m_availableLangListField.removeAll();
        if (this.m_project != null) {
            Iterator iter = this.m_project.getLangHelper().getLangListIterator();
            while (iter.hasNext()) {
                Locale language = (Locale)iter.next();
                String lang = Languages.getInstance().getDisplayString(language);
                this.m_availableLangListField.add(lang);
            }
        }
        int i = 0;
        while (i < this.m_autLangListField.getItemCount()) {
            projectLanguages = Arrays.asList(this.m_availableLangListField.getItems());
            if (!projectLanguages.contains(this.m_autLangListField.getItem(i))) {
                this.m_autLangListField.remove(this.m_autLangListField.getItem(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.m_autLangListField.getItemCount()) {
            projectLanguages = Arrays.asList(this.m_availableLangListField.getItems());
            if (projectLanguages.contains(this.m_autLangListField.getItem(i))) {
                this.m_availableLangListField.remove(this.m_autLangListField.getItem(i));
            }
            ++i;
        }
        this.confirmNextButton();
    }

    public void clearLanguageLists() {
        this.m_availableLangListField.removeAll();
        this.m_autLangListField.removeAll();
    }

    public void removeAUTLanguages(String selection) {
        int i = 0;
        while (i < this.m_autLangListField.getItemCount()) {
            if (this.m_autLangListField.getItem(i).equals(selection)) {
                this.m_autLangListField.remove(selection);
            }
            ++i;
        }
    }

    private void addListener() {
        this.m_rightButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_leftButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allRightButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allLeftButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_autNameText.addModifyListener((ModifyListener)this.m_modifyListener);
        this.m_autLangListField.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_availableLangListField.addSelectionListener((SelectionListener)this.m_selectionListener);
    }

    private void removeListener() {
        this.m_rightButton.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_leftButton.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allRightButton.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allLeftButton.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_autNameText.removeModifyListener((ModifyListener)this.m_modifyListener);
        this.m_autLangListField.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_availableLangListField.removeSelectionListener((SelectionListener)this.m_selectionListener);
    }

    private void updateLanguages() {
        this.m_autMain.getLangHelper().clearLangList();
        String[] stringArray = this.m_autLangListField.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String lang = stringArray[n2];
            this.m_autMain.getLangHelper().addLanguageToList(Languages.getInstance().getLocale(lang));
            ++n2;
        }
    }

    private void confirmNextButton() {
        String oldToolkit = this.m_autMain.getToolkit();
        this.m_autMain.setName(this.m_autNameText.getText());
        this.m_autMain.setToolkit((String)this.m_autToolKitComboBox.getSelectedObject());
        this.m_autMain.setGenerateNames(this.m_generateNames.getSelection());
        AUTSettingWizardPage.checkToolkit(this.getShell(), this.m_autMain, oldToolkit);
        this.updateLanguages();
    }

    public static void checkToolkit(Shell shell, IAUTMainPO autMain, String oldToolkit) {
        String newToolkit = autMain.getToolkit();
        if (newToolkit != null && (oldToolkit == null || !newToolkit.equals(oldToolkit)) && newToolkit.equals("com.bredexsw.guidancer.RcpToolkitPlugin")) {
            NagDialog.runNagDialog(shell, "InfoNagger.DefineRcpAut", "org.eclipse.jubula.client.ua.help.autConfigSettingWizardPagePageContextId");
        }
    }

    private void separator(Composite composite) {
        this.newLabel(composite, "");
        Label sep = new Label(composite, 258);
        GridData sepData = new GridData();
        sepData.horizontalAlignment = 4;
        sepData.horizontalSpan = 2;
        sep.setLayoutData((Object)sepData);
        this.newLabel(composite, "");
    }

    public void setVisible(boolean visible) {
        this.fillLanguageLists();
        super.setVisible(visible);
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> displayValues = new ArrayList<String>();
        try {
            List<ToolkitPluginDescriptor> toolkits = ControlFactory.getAutToolkits(this.m_project);
            for (ToolkitPluginDescriptor desc : toolkits) {
                values.add(desc.getToolkitID());
                displayValues.add(desc.getName());
            }
        }
        catch (ToolkitPluginException toolkitPluginException) {
            ToolkitPluginDescriptor autToolkit = ComponentBuilder.getInstance().getCompSystem().getToolkitPluginDescriptor(this.m_autMain.getToolkit());
            if (autToolkit != null) {
                values.add(autToolkit.getToolkitID());
                displayValues.add(autToolkit.getName());
            }
            values.add(this.m_autMain.getToolkit());
            displayValues.add(this.m_autMain.getToolkit());
        }
        String selectedObject = (String)this.m_autToolKitComboBox.getSelectedObject();
        this.m_autToolKitComboBox.setItems(values, displayValues);
        if (selectedObject == null || selectedObject.length() < 1) {
            this.m_autToolKitComboBox.deselectAll();
        } else {
            this.m_autToolKitComboBox.setSelectedObject((Object)selectedObject);
        }
        if (visible) {
            this.m_autNameText.setFocus();
            this.checkCompleteness();
            this.m_chooseLists.checkButtons();
        }
    }

    public void dispose() {
        this.m_autMain = null;
        this.removeListener();
        super.dispose();
    }

    private void checkCompleteness() {
        if (this.modifyAUTNameFieldAction() && this.modifyAutToolkitComboAction()) {
            this.setMessage(Messages.ProjectWizardNewAUT, 0);
            this.setPageComplete(true);
            this.confirmNextButton();
        } else {
            this.setPageComplete(false);
        }
    }

    private boolean modifyAutToolkitComboAction() {
        boolean isToolkitSelected;
        boolean bl = isToolkitSelected = this.m_autToolKitComboBox.getSelectedObject() != null;
        if (isToolkitSelected) {
            String oldToolkit = this.m_autMain.getToolkit();
            this.m_autMain.setToolkit((String)this.m_autToolKitComboBox.getSelectedObject());
            AUTSettingWizardPage.checkToolkit(this.getShell(), this.m_autMain, oldToolkit);
        } else {
            this.setMessage(Messages.ProjectWizardNoToolkitSelected, 3);
        }
        return isToolkitSelected;
    }

    private boolean modifyAUTNameFieldAction() {
        boolean isError = false;
        int autNameLength = this.m_autNameText.getText().length();
        if (autNameLength == 0 || this.m_autNameText.getText().startsWith(" ") || this.m_autNameText.getText().charAt(autNameLength - 1) == ' ') {
            isError = true;
        }
        if (isError) {
            if (autNameLength == 0) {
                this.setMessage(Messages.AUTSettingWizardPageEmptyAUTName, 3);
                this.setPageComplete(false);
            } else {
                this.setMessage(Messages.ProjectWizardNotValidAUT, 3);
                this.setPageComplete(false);
            }
        }
        return !isError;
    }

    public ProjectWizard getWizard() {
        return (ProjectWizard)super.getWizard();
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object o = e.getSource();
            if (o.equals(AUTSettingWizardPage.this.m_autNameText)) {
                AUTSettingWizardPage.this.m_autMain.setName(AUTSettingWizardPage.this.m_autNameText.getText());
                AUTSettingWizardPage.this.checkCompleteness();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + "."));
        }
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleEvent(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.handleEvent(e);
        }

        private void handleEvent(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(AUTSettingWizardPage.this.m_rightButton) || o.equals(AUTSettingWizardPage.this.m_leftButton) || o.equals(AUTSettingWizardPage.this.m_allLeftButton) || o.equals(AUTSettingWizardPage.this.m_allRightButton)) {
                AUTSettingWizardPage.this.updateLanguages();
                AUTSettingWizardPage.this.checkCompleteness();
                return;
            }
            if (o.equals(AUTSettingWizardPage.this.m_autLangListField) || o.equals(AUTSettingWizardPage.this.m_availableLangListField)) {
                return;
            }
            if (o.equals(AUTSettingWizardPage.this.m_autToolKitComboBox)) {
                if ("com.bredexsw.guidancer.RcpToolkitPlugin".equals(AUTSettingWizardPage.this.m_autToolKitComboBox.getSelectedObject())) {
                    AUTSettingWizardPage.this.m_generateNames.setEnabled(true);
                    AUTSettingWizardPage.this.m_generateNames.setSelection(true);
                } else {
                    AUTSettingWizardPage.this.m_generateNames.setEnabled(false);
                    AUTSettingWizardPage.this.m_generateNames.setSelection(false);
                }
                AUTSettingWizardPage.this.checkCompleteness();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + ":" + " " + "'" + String.valueOf(o) + "'"));
        }
    }
}

