/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.pages;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ImportFileBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportProjectsWizardPage
extends WizardPage
implements ImportFileBP.IProjectImportInfoProvider {
    private static Logger log = LoggerFactory.getLogger(ImportProjectsWizardPage.class);
    private static final int NUM_COLUMS = 6;
    private Text m_fileToAdd;
    private org.eclipse.swt.widgets.List m_filesToImport;
    private Button m_browseButton;
    private Button m_addButton;
    private Button m_removeButton;
    private Button m_moveUpButton;
    private Button m_moveDownButton;
    private Button m_openProjectCheckbox;
    private boolean m_isOpenProject;
    private List<URL> m_fileURLs;

    public ImportProjectsWizardPage(String pageName) {
        super(pageName);
    }

    protected void handleFile(String fileName) {
        if (fileName != null && fileName.length() > 0) {
            File file = new File(fileName);
            if (file.exists() && file.isFile() && file.canRead()) {
                this.m_addButton.setEnabled(true);
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(NLS.bind((String)Messages.ImportProjectDialogInvalidFile, (Object[])new Object[]{fileName}));
                this.m_addButton.setEnabled(false);
            }
        } else {
            this.setErrorMessage(null);
            this.m_addButton.setEnabled(false);
        }
    }

    private void addFileButtonComposite(Composite parent) {
        Composite fileButtonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        fileButtonComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        fileButtonComposite.setLayoutData((Object)gridData);
        this.addBrowseButton(fileButtonComposite);
        this.addAddButton(fileButtonComposite);
    }

    private void addButtons(Composite parent) {
        this.m_openProjectCheckbox = new Button(parent, 32);
        this.m_openProjectCheckbox.setSelection(true);
        this.m_isOpenProject = true;
        this.m_openProjectCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ImportProjectsWizardPage.this.m_isOpenProject = ImportProjectsWizardPage.this.m_openProjectCheckbox.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                ImportProjectsWizardPage.this.m_isOpenProject = ImportProjectsWizardPage.this.m_openProjectCheckbox.getSelection();
            }
        });
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.grabExcessHorizontalSpace = true;
        this.m_openProjectCheckbox.setLayoutData((Object)gridData);
        this.m_openProjectCheckbox.setText(Messages.ImportProjectDialogOpenProjectCheckbox);
        DialogUtils.setWidgetName((Widget)this.m_openProjectCheckbox, (String)"openProjectCheckbox");
    }

    private void addImportList(Composite parent) {
        this.m_filesToImport = new org.eclipse.swt.widgets.List(parent, 2818);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_filesToImport), (int)6);
        this.m_filesToImport.setLayoutData((Object)gridData);
        this.m_filesToImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectsWizardPage.this.checkListButtonEnablement();
            }
        });
        this.m_filesToImport.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f') {
                    ImportProjectsWizardPage.this.removeIndicesFromList(ImportProjectsWizardPage.this.m_filesToImport.getSelectionIndices());
                }
            }
        });
        this.m_filesToImport.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                ImportProjectsWizardPage.this.checkCompletness();
            }
        });
        DialogUtils.setWidgetName((Widget)this.m_filesToImport, (String)"filesToImport");
    }

    private void addListButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        this.addUpButton(composite);
        this.addDownButton(composite);
        this.addRemoveButton(composite);
    }

    private void addRemoveButton(Composite parent) {
        this.m_removeButton = new Button(parent, 8);
        this.m_removeButton.setImage(IconConstants.DELETE_IMAGE_DISABLED);
        this.m_removeButton.setToolTipText(Messages.ImportProjectDialogRemoveToolTip);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        this.m_removeButton.setLayoutData((Object)gridData);
        this.m_removeButton.setEnabled(false);
        this.m_removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectsWizardPage.this.removeIndicesFromList(ImportProjectsWizardPage.this.m_filesToImport.getSelectionIndices());
            }
        });
        DialogUtils.setWidgetName((Widget)this.m_removeButton, (String)"removeButton");
    }

    private void addDownButton(Composite parent) {
        this.m_moveDownButton = new Button(parent, 8);
        this.m_moveDownButton.setImage(IconConstants.DOWN_ARROW_DIS_IMAGE);
        this.m_moveDownButton.setToolTipText(Messages.ImportProjectDialogMoveDownToolTip);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        this.m_moveDownButton.setLayoutData((Object)gridData);
        this.m_moveDownButton.setEnabled(false);
        this.m_moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectedIndices = ImportProjectsWizardPage.this.m_filesToImport.getSelectionIndices();
                Arrays.sort(selectedIndices);
                int[] newSelectedIndices = new int[selectedIndices.length];
                int greatestIndex = ImportProjectsWizardPage.this.m_filesToImport.getItemCount() - 1;
                if (selectedIndices.length > 0 && selectedIndices[selectedIndices.length - 1] < greatestIndex) {
                    int i = 0;
                    while (i < selectedIndices.length) {
                        int index = selectedIndices[i];
                        int newIndex = index + 1;
                        String item = ImportProjectsWizardPage.this.m_filesToImport.getItem(index);
                        ImportProjectsWizardPage.this.m_filesToImport.remove(index);
                        ImportProjectsWizardPage.this.m_filesToImport.add(item, newIndex);
                        newSelectedIndices[i] = newIndex;
                        ++i;
                    }
                    ImportProjectsWizardPage.this.m_filesToImport.setSelection(newSelectedIndices);
                }
                ImportProjectsWizardPage.this.updateModel();
            }
        });
        DialogUtils.setWidgetName((Widget)this.m_moveDownButton, (String)"moveDownButton");
    }

    private void addUpButton(Composite parent) {
        this.m_moveUpButton = new Button(parent, 8);
        this.m_moveUpButton.setImage(IconConstants.UP_ARROW_DIS_IMAGE);
        this.m_moveUpButton.setToolTipText(Messages.ImportProjectDialogMoveUpToolTip);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        this.m_moveUpButton.setLayoutData((Object)gridData);
        this.m_moveUpButton.setEnabled(false);
        this.m_moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectedIndices = ImportProjectsWizardPage.this.m_filesToImport.getSelectionIndices();
                Arrays.sort(selectedIndices);
                int[] newSelectedIndices = new int[selectedIndices.length];
                if (selectedIndices.length > 0 && selectedIndices[0] > 0) {
                    int i = 0;
                    while (i < selectedIndices.length) {
                        int index = selectedIndices[i];
                        int newIndex = index - 1;
                        String item = ImportProjectsWizardPage.this.m_filesToImport.getItem(index);
                        ImportProjectsWizardPage.this.m_filesToImport.remove(index);
                        ImportProjectsWizardPage.this.m_filesToImport.add(item, newIndex);
                        newSelectedIndices[i] = newIndex;
                        ++i;
                    }
                    ImportProjectsWizardPage.this.m_filesToImport.setSelection(newSelectedIndices);
                }
                ImportProjectsWizardPage.this.updateModel();
            }
        });
        DialogUtils.setWidgetName((Widget)this.m_moveUpButton, (String)"moveUpButton");
    }

    private void addFilesToList(String[] fileNames) {
        String[] items = this.m_filesToImport.getItems();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String selectedFile = stringArray[n2];
            boolean isAlreadyInList = false;
            String[] stringArray2 = items;
            int n3 = items.length;
            int n4 = 0;
            while (n4 < n3) {
                String curItem = stringArray2[n4];
                if (curItem.equals(selectedFile)) {
                    isAlreadyInList = true;
                    break;
                }
                ++n4;
            }
            if (!isAlreadyInList) {
                this.m_filesToImport.add(selectedFile);
            }
            ++n2;
        }
        this.checkCompletness();
    }

    private void removeIndicesFromList(int[] indices) {
        this.m_filesToImport.remove(indices);
        Event selectionEvent = new Event();
        selectionEvent.type = 13;
        selectionEvent.widget = this.m_filesToImport;
        selectionEvent.display = this.m_filesToImport.getDisplay();
        this.m_filesToImport.notifyListeners(13, selectionEvent);
        this.checkCompletness();
    }

    void checkCompletness() {
        this.updateModel();
        this.m_isOpenProject = this.m_openProjectCheckbox.getSelection();
        if (this.m_fileURLs.size() < 1) {
            this.setErrorMessage(Messages.ImportProjectDialogNoFilesToImport);
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
        this.m_openProjectCheckbox.setEnabled(this.m_filesToImport.getItemCount() <= 1);
        if (!this.m_openProjectCheckbox.isEnabled()) {
            this.m_openProjectCheckbox.setSelection(false);
            this.m_isOpenProject = false;
        }
        this.handleFile(this.m_fileToAdd.getText());
    }

    private void addBrowseButton(Composite composite) {
        this.m_browseButton = new Button(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        this.m_browseButton.setLayoutData((Object)gridData);
        this.m_browseButton.setText(Messages.ImportProjectDialogBrowse);
        this.m_browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(Plugin.getShell(), 69634);
                fileDialog.setText(Messages.ImportProjectDialogFileSelector);
                String[] extension = new String[]{"*.xml"};
                fileDialog.setFilterExtensions(extension);
                fileDialog.setFilterPath(Utils.getLastDirPath());
                String file = fileDialog.open();
                ImportProjectsWizardPage.this.getShell().setFocus();
                if (file != null) {
                    String path = fileDialog.getFilterPath();
                    String[] fileNames = fileDialog.getFileNames();
                    String[] absFileNames = new String[fileNames.length];
                    int i = 0;
                    while (i < fileNames.length) {
                        try {
                            absFileNames[i] = new File(path, fileNames[i]).getCanonicalPath();
                        }
                        catch (IOException ioe) {
                            log.error(String.valueOf(Messages.FailedToFindFile) + ":" + " " + path + File.pathSeparator + fileNames[i], (Throwable)ioe);
                        }
                        ++i;
                    }
                    ImportProjectsWizardPage.this.addFilesToList(absFileNames);
                    Utils.storeLastDirPath(path);
                }
            }
        });
        DialogUtils.setWidgetName((Widget)this.m_browseButton, (String)"browseButton");
    }

    private void addAddButton(Composite parent) {
        this.m_addButton = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        this.m_addButton.setLayoutData((Object)gridData);
        this.m_addButton.setText(Messages.ImportProjectDialogAdd);
        this.m_addButton.setEnabled(false);
        this.m_addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ImportProjectsWizardPage.this.addFilesToList(new String[]{new File(ImportProjectsWizardPage.this.m_fileToAdd.getText()).getCanonicalPath()});
                }
                catch (IOException ioe) {
                    log.error(String.valueOf(Messages.FailedToFindFile) + ":" + " " + ImportProjectsWizardPage.this.m_fileToAdd.getText(), (Throwable)ioe);
                }
            }
        });
        DialogUtils.setWidgetName((Widget)this.m_addButton, (String)"addButton");
    }

    private void addBlankLine(Composite composite) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.grabExcessHorizontalSpace = true;
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)gridData);
    }

    @Override
    public List<URL> getFileURLs() {
        return this.m_fileURLs;
    }

    @Override
    public boolean getIsOpenProject() {
        return this.m_isOpenProject;
    }

    private void enableUpButton(boolean enabled) {
        this.m_moveUpButton.setEnabled(enabled);
        if (enabled) {
            this.m_moveUpButton.setImage(IconConstants.UP_ARROW_IMAGE);
        } else {
            this.m_moveUpButton.setImage(IconConstants.UP_ARROW_DIS_IMAGE);
        }
    }

    private void enableDownButton(boolean enabled) {
        this.m_moveDownButton.setEnabled(enabled);
        if (enabled) {
            this.m_moveDownButton.setImage(IconConstants.DOWN_ARROW_IMAGE);
        } else {
            this.m_moveDownButton.setImage(IconConstants.DOWN_ARROW_DIS_IMAGE);
        }
    }

    private void enableRemoveButton(boolean enabled) {
        this.m_removeButton.setEnabled(enabled);
        if (enabled) {
            this.m_removeButton.setImage(IconConstants.DELETE_IMAGE);
        } else {
            this.m_removeButton.setImage(IconConstants.DELETE_IMAGE_DISABLED);
        }
    }

    private void checkListButtonEnablement() {
        if (this.m_filesToImport.getSelectionCount() > 0) {
            this.enableUpButton(true);
            this.enableDownButton(true);
            this.enableRemoveButton(true);
        } else {
            this.enableUpButton(false);
            this.enableDownButton(false);
            this.enableRemoveButton(false);
        }
    }

    public void createControl(Composite parent) {
        String title = Messages.ImportProjectDialogTitle;
        this.setTitle(title);
        this.setImageDescriptor(IconConstants.IMPORT_DIALOG_IMAGE_DESCRIPTOR);
        this.setMessage(Messages.ImportProjectDialogMessage);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.ImportProjectDialogFileLabel);
        this.m_fileToAdd = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_fileToAdd.setLayoutData((Object)gridData);
        this.m_fileToAdd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String fileName = ImportProjectsWizardPage.this.m_fileToAdd.getText();
                ImportProjectsWizardPage.this.handleFile(fileName);
            }
        });
        DialogUtils.setWidgetName((Widget)this.m_fileToAdd, (String)"fileToAdd");
        this.addFileButtonComposite(composite);
        this.addBlankLine(composite);
        Label listLabel = new Label(composite, 0);
        listLabel.setText(Messages.ImportProjectDialogListLabel);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 16384;
        listLabel.setLayoutData((Object)gridData);
        ControlDecorator.decorateInfo((Control)listLabel, "ControlDecorator.Import", false);
        this.addImportList(composite);
        this.addListButtons(composite);
        this.addBlankLine(composite);
        this.addButtons(composite);
        Plugin.getHelpSystem().setHelp((Control)composite, "org.eclipse.jubula.client.ua.help.importProjectDialogContextId");
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    private void updateModel() {
        String[] fileNames = this.m_filesToImport.getItems();
        this.m_fileURLs = new ArrayList<URL>(fileNames.length);
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            try {
                this.m_fileURLs.add(new File(fileName).toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
            ++n2;
        }
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.jubula.client.ua.help.importProjectDialogContextId");
    }
}

